/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.qm.qc.client;

import com.kingdee.bos.appframework.syncUI.ThreadPool;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTPropertyChangeEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTPropertyChangeListener;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectListener;
import com.kingdee.bos.ctrl.kdf.util.render.CellCheckBoxRenderer;
import com.kingdee.bos.ctrl.kdf.util.render.IBasicRender;
import com.kingdee.bos.ctrl.swing.KDLayout;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.ctrl.swing.util.CtrlFormatUtilities;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIException;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.eas.base.commonquery.client.CommonQueryDialog;
import com.kingdee.eas.base.commonquery.client.CustomerQueryPanel;
import com.kingdee.eas.base.commonquery.client.IPromptBoxFactory;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.qm.basedata.SampleSolutionEnum;
import com.kingdee.eas.qm.common.QMBillBaseStatusEnum;
import com.kingdee.eas.qm.common.util.KDTableUtils;
import com.kingdee.eas.qm.qc.BalanceCalPatternEnum;
import com.kingdee.eas.qm.qc.CheckResultEnum;
import com.kingdee.eas.qm.qc.HQHPCalBillFactory;
import com.kingdee.eas.qm.qc.QuanSettlePatternEnum;
import com.kingdee.eas.qm.qc.client.AbstractHQHPCalBillCreateListUI;
import com.kingdee.eas.qm.qc.client.HQHPCalBillCreateFilterUI;
import com.kingdee.eas.qm.qc.client.HQHPCustomDialog;
import com.kingdee.eas.qm.qc.client.HQHPPickWBListUI;
import com.kingdee.eas.qm.qc.util.HQHPUtil;
import com.kingdee.eas.scm.sm.pur.client.PurContractEditUI;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class HQHPCalBillCreateListUI
extends AbstractHQHPCalBillCreateListUI {
    private static final Logger logger = CoreUIObject.getLogger(HQHPCalBillCreateListUI.class);
    private HQHPCalBillCreateFilterUI filterUI = null;
    private Map filterParams = null;
    public static final String COL_Pur_selected = "selected";
    public static final String COL_Pur_qcRecDateBegin = "qcRecDateBegin";
    public static final String COL_Pur_qcRecDateEnd = "qcRecDateEnd";
    public static final String COL_Pur_balanceCalPattern = "balanceCalPattern";
    public static final String COL_Pur_balNumCalPattern = "balNumCalPattern";
    public static final String COL_Pur_pricingPattern = "pricingPattern";
    public static final String COL_Pur_deductCalFomula = "deductCalFomula";
    public static final String COL_Pur_price = "price";
    public static final String COL_Pur_protectivePrice = "protectivePrice";
    public static final String Col_Rec_isSelected = "isSelected";
    public static final String Col_Rec_recBillDesc = "recBillDesc";
    public static final String Col_Rec_deliverQty = "deliverQty";
    public static final String Col_Rec_passQty = "passQty";
    public static final String Col_Rec_unPassQty = "unPassQty";
    public static final String Col_Rec_calQuantity = "calQuantity";
    public static final String Col_Rec_calUnitPrice = "calUnitPrice";
    public static final String Col_Rec_calMoney = "calMoney";
    private boolean isFilledData = false;
    private List createFromList = null;
    private List purConList = null;
    private KDTSelectListener tblMainSelectListener = null;
    private KDTPropertyChangeListener recRowSelectStatusListener = null;
    private boolean isLoadingRecRows = false;
    private Boolean oldIsWeigh = null;
    private Map reportLists = null;
    private int beginRow;
    private Map unSelectWeighBills = new HashMap();
    public static final String CTX_CUR_PURENTRY = "CTX_CUR_PURENTRY";

    public Map getFilterParams() {
        return this.filterParams;
    }

    public void onLoad() throws Exception {
        this.removeListener();
        super.onLoad();
        this.setBtns();
        this.configTable();
        this.addListener();
    }

    private void setBtns() {
        this.actionSelectAll.setEnabled(true);
        this.actionSelectNone.setEnabled(true);
        this.actionConfirm.setEnabled(true);
    }

    private void removeListener() {
        if (this.tblMainSelectListener != null) {
            this.tblMain.removeKDTSelectListener(this.tblMainSelectListener);
            this.tblMainSelectListener = null;
        }
        if (this.recRowSelectStatusListener != null) {
            this.tblQCReport.removeKDTPropertyChangeListener(this.recRowSelectStatusListener);
            this.recRowSelectStatusListener = null;
        }
    }

    private void addListener() {
        this.tblMainSelectListener = new KDTSelectListener(){

            public void tableSelectChanged(KDTSelectEvent e) {
                HQHPCalBillCreateListUI.this.tblMainSelectChanged(e);
            }
        };
        this.tblMain.addKDTSelectListener(this.tblMainSelectListener);
        final int col = this.tblQCReport.getColumnIndex(Col_Rec_isSelected);
        this.recRowSelectStatusListener = new KDTPropertyChangeListener(){

            public void propertyChange(KDTPropertyChangeEvent evt) {
                if (evt.getColIndex() == col) {
                    HQHPCalBillCreateListUI.this.recRowSelectStatusChanged(evt);
                }
            }
        };
        this.tblQCReport.addKDTPropertyChangeListener(this.recRowSelectStatusListener);
    }

    private void recRowSelectStatusChanged(KDTPropertyChangeEvent evt) {
        if (this.isLoadingRecRows) {
            return;
        }
        Object newValue = evt.getNewValue();
        int rowIndex = evt.getRowIndex();
        IRow row = this.tblMain.getRow(this.beginRow);
        String recRowsKey = row.getCell("id").getValue().toString() + row.getCell("entryId").getValue().toString();
        List recRows = (List)this.reportLists.get(recRowsKey);
        Map recRow = (Map)recRows.get(rowIndex);
        recRow.put(Col_Rec_isSelected, newValue);
    }

    private void configTable() {
        this.tblMain.checkParsed();
        this.tblQCReport.checkParsed();
        this.tblMain.getSelectManager().setSelectMode(10);
        this.tblQCReport.getSelectManager().setSelectMode(10);
        this.tblMain.getDataRequestManager().setDataRequestMode(0);
        this.tblQCReport.getDataRequestManager().setDataRequestMode(0);
        this.tblMain.getStyleAttributes().setLocked(true);
        this.tblQCReport.getStyleAttributes().setLocked(true);
        this.tblMain.getColumn(COL_Pur_selected).getStyleAttributes().setLocked(false);
        this.tblMain.getColumn(COL_Pur_selected).setRenderer((IBasicRender)new CellCheckBoxRenderer());
        this.tblQCReport.getColumn(Col_Rec_isSelected).getStyleAttributes().setLocked(false);
        this.tblQCReport.getColumn(Col_Rec_isSelected).setRenderer((IBasicRender)new CellCheckBoxRenderer());
        this.tblMain.getColumn(COL_Pur_qcRecDateBegin).getStyleAttributes().setHided(false);
        this.tblMain.getColumn(COL_Pur_qcRecDateBegin).getStyleAttributes().setHided(false);
        this.tblMain.getColumn(COL_Pur_price).getStyleAttributes().setNumberFormat(CtrlFormatUtilities.getDecimalFormatString());
        this.tblMain.getColumn(COL_Pur_protectivePrice).getStyleAttributes().setNumberFormat(CtrlFormatUtilities.getDecimalFormatString());
        this.tblQCReport.getColumn(Col_Rec_deliverQty).getStyleAttributes().setNumberFormat(CtrlFormatUtilities.getDecimalFormatString());
        this.tblQCReport.getColumn(Col_Rec_passQty).getStyleAttributes().setNumberFormat(CtrlFormatUtilities.getDecimalFormatString());
        this.tblQCReport.getColumn(Col_Rec_unPassQty).getStyleAttributes().setNumberFormat(CtrlFormatUtilities.getDecimalFormatString());
        this.tblQCReport.getColumn(Col_Rec_calQuantity).getStyleAttributes().setNumberFormat(CtrlFormatUtilities.getDecimalFormatString());
        this.tblQCReport.getColumn(Col_Rec_calUnitPrice).getStyleAttributes().setNumberFormat(CtrlFormatUtilities.getDecimalFormatString());
        this.tblQCReport.getColumn(Col_Rec_calMoney).getStyleAttributes().setNumberFormat(CtrlFormatUtilities.getDecimalFormatString());
    }

    protected boolean isOrderForClickTableHead() {
        return false;
    }

    protected boolean initDefaultFilter() {
        return true;
    }

    protected CommonQueryDialog initCommonQueryDialog() {
        CommonQueryDialog queryDialog = this.getCustomDiaglog();
        try {
            if (this.filterUI == null) {
                this.filterUI = new HQHPCalBillCreateFilterUI();
            }
            queryDialog.addUserPanel((KDPanel)this.filterUI);
            queryDialog.setShowFilter(false);
            queryDialog.setShowSorter(false);
            queryDialog.setUiObject(null);
            queryDialog.setWidth(570);
            queryDialog.setHeight(300);
        }
        catch (Exception e) {
            this.handleException(e);
        }
        return queryDialog;
    }

    private CommonQueryDialog getCustomDiaglog() {
        IPromptBoxFactory promptBoxFactory;
        HQHPCustomDialog queryDialog = new HQHPCustomDialog();
        if (this.getUIWindow() == null) {
            queryDialog.setOwner((Component)this.getUIContext().get("OwnerWindow"));
        } else {
            queryDialog.setOwner((Component)((Object)this));
        }
        queryDialog.setUiObject((IUIObject)this);
        queryDialog.setParentUIClassName(this.getMetaDataPK().getFullName());
        queryDialog.setQueryObjectPK(this.mainQueryPK);
        queryDialog.setTitle(this.getUITitle() + " - " + EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Query_Filter"));
        if (this.orgContextManager != null) {
            if (this.orgContextManager.getOwner() != null && this.orgContextManager.getOwner() instanceof CustomerQueryPanel) {
                queryDialog.addUserPanel((KDPanel)((CustomerQueryPanel)this.orgContextManager.getOwner()));
            }
            this.orgContextManager.init(this.getUIContext());
        }
        if ((promptBoxFactory = this.getPromptBoxFactory()) != null) {
            queryDialog.setPromptBoxFactory(promptBoxFactory);
        }
        queryDialog.setMaxReturnCountVisible(true);
        queryDialog.setVisibleTableCols(this.getQueryShowField());
        return queryDialog;
    }

    public void actionQuery_actionPerformed(ActionEvent e) throws Exception {
        if (this.getDialog(true).show()) {
            this.filterParams = this.filterUI.getParams();
            this.reConfigUI();
            this.fillData();
        } else if (!this.isFilledData) {
            SysUtil.abort();
        }
    }

    private void reConfigUI() {
        int recTableHeight;
        int purConTableHeight;
        Boolean paramIsWeigh = (Boolean)this.filterParams.get("Para_IsWeigh");
        if (this.oldIsWeigh != null && paramIsWeigh != null && this.oldIsWeigh.equals(paramIsWeigh)) {
            return;
        }
        this.oldIsWeigh = paramIsWeigh;
        if (paramIsWeigh == null) {
            return;
        }
        if (paramIsWeigh.booleanValue()) {
            this.actionPickWB.setEnabled(true);
            this.separator1.setVisible(true);
            this.separator2.setVisible(true);
            this.actionPickWB.setVisible(true);
            purConTableHeight = 580;
            recTableHeight = 0;
        } else {
            this.actionPickWB.setEnabled(false);
            this.separator1.setVisible(false);
            this.separator2.setVisible(false);
            this.actionPickWB.setVisible(false);
            purConTableHeight = 290;
            recTableHeight = 280;
        }
        this.repaintUI(purConTableHeight, recTableHeight);
    }

    private void repaintUI(int purConTableHeight, int recTableHeight) {
        this.pnlMain.remove((Component)this.tblMain);
        this.kDContainer1.getContentPane().remove((Component)this.pnlMain);
        this.remove((Component)this.kDContainer1);
        this.pnlQcReport.remove((Component)this.tblQCReport);
        this.kDContainer2.getContentPane().remove((Component)this.pnlQcReport);
        this.remove((Component)this.kDContainer2);
        this.setLayout((LayoutManager)new KDLayout());
        this.putClientProperty("OriginalBounds", new Rectangle(10, 10, 950, 600));
        this.kDContainer1.setBounds(new Rectangle(10, 10, 930, purConTableHeight));
        this.add((Component)this.kDContainer1, new KDLayout.Constraints(10, 10, 930, purConTableHeight, 77));
        this.kDContainer2.setBounds(new Rectangle(10, 310, 930, recTableHeight));
        this.add((Component)this.kDContainer2, new KDLayout.Constraints(10, 310, 930, recTableHeight, 46));
        this.kDContainer1.getContentPane().setLayout(new BorderLayout(0, 0));
        this.kDContainer1.getContentPane().add((Component)this.pnlMain, "Center");
        this.pnlMain.setLayout((LayoutManager)new BorderLayout(0, 0));
        this.pnlMain.add((Component)this.tblMain, (Object)"Center");
        this.kDContainer2.getContentPane().setLayout(new BorderLayout(0, 0));
        this.kDContainer2.getContentPane().add((Component)this.pnlQcReport, "Center");
        this.pnlQcReport.setLayout((LayoutManager)new BorderLayout(0, 0));
        this.pnlQcReport.add((Component)this.tblQCReport, (Object)"Center");
        this.validate();
    }

    public CommonQueryDialog getDialog(boolean isUserShow) {
        CommonQueryDialog dialog = null;
        if (isUserShow) {
            dialog = this.getDialog();
            if (dialog == null) {
                dialog = this.initCommonQueryDialog();
            } else if (this.getUIWindow() == null) {
                dialog.setOwner((Component)this.getUIContext().get("OwnerWindow"));
            } else {
                dialog.setOwner((Component)((Object)this));
            }
            if (this.actionQuery.isDaemonRun()) {
                ThreadPool.destroyMonitor();
            }
        } else {
            dialog = this.getDialog();
        }
        return dialog;
    }

    private void fillData() throws Exception {
        this.createFromList = HQHPCalBillFactory.getRemoteInstance().getCreateFromList(this.filterParams);
        this.reportLists = (Map)this.createFromList.get(1);
        this.addSelectStatusToReportRows();
        if (HQHPUtil.isNullList(this.createFromList)) {
            this.tblMain.removeRows();
            this.tblQCReport.removeRows();
            return;
        }
        this.purConList = (List)this.createFromList.get(0);
        if (HQHPUtil.isNullList(this.purConList)) {
            this.tblMain.removeRows();
            this.tblQCReport.removeRows();
            return;
        }
        this.fillPurTable();
        Map purFirstRowMap = (Map)this.purConList.get(0);
        if (purFirstRowMap == null) {
            this.tblMain.removeRows();
            this.tblQCReport.removeRows();
            return;
        }
        this.fillReportTable(purFirstRowMap);
        KDTableUtils.selectFirstRow((KDTable)this.tblMain);
        this.isFilledData = true;
    }

    private void addSelectStatusToReportRows() {
        Iterator iterator = this.reportLists.keySet().iterator();
        while (iterator.hasNext()) {
            List rows = (List)this.reportLists.get(iterator.next());
            for (int i = 0; i < rows.size(); ++i) {
                Map row = (Map)rows.get(i);
                row.put(Col_Rec_isSelected, Boolean.TRUE);
            }
        }
    }

    private void fillReportTable(Map purRowMap) {
        String purID = (String)purRowMap.get("id");
        String purEntryID = (String)purRowMap.get("entryId");
        this.fillReportTable(purID + purEntryID);
    }

    private void fillReportTable(String purRowID) {
        List reportList = (List)this.reportLists.get(purRowID);
        if (HQHPUtil.isNullList(reportList)) {
            return;
        }
        this.fillQCReportTable(reportList);
    }

    private void fillPurTable() {
        this.tblMain.removeRows();
        for (int i = 0; i < this.purConList.size(); ++i) {
            Map map = (Map)this.purConList.get(i);
            IRow row = this.tblMain.addRow();
            for (int j = 0; j < this.tblMain.getColumnCount(); ++j) {
                String key = this.tblMain.getColumnKey(j);
                if (COL_Pur_qcRecDateBegin.equals(key) && this.filterParams.get("recBillDateBegin") != null) {
                    row.getCell(key).setValue((Object)HQHPUtil.simpleDateFormatter.format((Date)this.filterParams.get("recBillDateBegin")));
                    continue;
                }
                if (COL_Pur_qcRecDateEnd.equals(key) && this.filterParams.get("recBillDateEnd") != null) {
                    row.getCell(key).setValue((Object)HQHPUtil.simpleDateFormatter.format((Date)this.filterParams.get("recBillDateEnd")));
                    continue;
                }
                if (map.get(key) == null) continue;
                if (("contractDate".equals(key) || "conExpireDate".equals(key)) && map.get(key) != null) {
                    row.getCell(key).setValue((Object)HQHPUtil.simpleDateFormatter.format(map.get(key)));
                    continue;
                }
                if (COL_Pur_balanceCalPattern.equals(key)) {
                    BalanceCalPatternEnum calPatternEnum = BalanceCalPatternEnum.getEnum((Integer)map.get(key));
                    row.getCell(key).setValue((Object)calPatternEnum);
                    continue;
                }
                if (COL_Pur_balNumCalPattern.equals(key)) {
                    QuanSettlePatternEnum quanSettlePattern = QuanSettlePatternEnum.getEnum((Integer)map.get(key));
                    row.getCell(key).setValue((Object)quanSettlePattern);
                    continue;
                }
                row.getCell(key).setValue(map.get(key));
            }
            row.getCell(COL_Pur_selected).setValue((Object)Boolean.FALSE);
        }
    }

    private void fillQCReportTable(List reportList) {
        this.isLoadingRecRows = true;
        this.tblQCReport.removeRows();
        for (int i = 0; i < reportList.size(); ++i) {
            Map map = (Map)reportList.get(i);
            IRow row = this.tblQCReport.addRow();
            for (int j = 0; j < this.tblQCReport.getColumnCount(); ++j) {
                String key = this.tblQCReport.getColumnKey(j);
                if (map.get(key) == null) continue;
                if ("recBillBizDate".equals(key)) {
                    row.getCell(key).setValue((Object)CtrlFormatUtilities.getDateFormat().format((Date)map.get(key)));
                    continue;
                }
                if ("billStatus".equals(key)) {
                    row.getCell(key).setValue((Object)QMBillBaseStatusEnum.getEnum((int)HQHPUtil.getInt(map.get(key))));
                    continue;
                }
                if ("sampleSolution".equals(key)) {
                    row.getCell(key).setValue((Object)SampleSolutionEnum.getEnum((int)HQHPUtil.getInt(map.get(key))));
                    continue;
                }
                if ("checkResult".equals(key)) {
                    row.getCell(key).setValue((Object)CheckResultEnum.getEnum(HQHPUtil.getInt(map.get(key))));
                    continue;
                }
                if ("isCalBalPrice".equals(key) || "isSubmitBalPrice".equals(key) || "isMRB".equals(key) || "submitResult".equals(key)) {
                    row.getCell(key).setValue((Object)HQHPUtil.getBoolean(map.get(key)));
                    continue;
                }
                row.getCell(key).setValue(map.get(key));
            }
        }
        this.isLoadingRecRows = false;
    }

    protected void tblMainSelectChanged(KDTSelectEvent e) {
        this.isLoadingRecRows = true;
        KDTSelectBlock selectBlock = e.getSelectBlock();
        if (selectBlock == null || selectBlock.equals((Object)e.getPrevSelectBlock())) {
            return;
        }
        this.beginRow = selectBlock.getBeginRow();
        if (this.beginRow < 0 || this.beginRow >= this.tblMain.getRowCount()) {
            return;
        }
        IRow row = this.tblMain.getRow(this.beginRow);
        this.fillReportTable(row);
        this.isLoadingRecRows = false;
    }

    private void fillReportTable(IRow row) {
        String purID = (String)row.getCell("id").getValue();
        String purEntryID = (String)row.getCell("entryId").getValue();
        this.fillReportTable(purID + purEntryID);
    }

    @Override
    public void actionConfirm_actionPerformed(ActionEvent e) throws Exception {
        ArrayList purIdList = new ArrayList();
        ArrayList purEntryIdList = new ArrayList();
        HashMap purInfos = new HashMap();
        this.getSelectedCreateInfoList(purIdList, purEntryIdList, purInfos);
        if (purIdList.size() == 0) {
            MsgBox.showInfo((String)HQHPUtil.getMsg("Check_PurContractSelected"));
            SysUtil.abort();
        }
        if (0 != MsgBox.showConfirm2((Component)((Object)this), (String)HQHPUtil.getMsg("Confirm_Gen"))) {
            SysUtil.abort();
        }
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("purIDs", purIdList);
        params.put("purEntryIDs", purEntryIdList);
        params.put("Choose_PurInfos", purInfos);
        params.put("filterParas", this.filterParams);
        params.put("selectedReports", this.getSelectReportsMap(purIdList, purEntryIdList));
        params.put("Choose_UnSelectedWBs", this.unSelectWeighBills);
        Map genResult = HQHPCalBillFactory.getRemoteInstance().genCalBills(params);
        HQHPCalBillFactory.getRemoteInstance().createFrom();
        IObjectPK[] genBillPks = (IObjectPK[])genResult.get("resultBillIDs");
        Integer calSuccessCount = (Integer)genResult.get("resultCalCount");
        String title = HQHPUtil.getMsg("Msg_Gen", new Object[]{new Integer(genBillPks.length), calSuccessCount});
        String errorDetail = HQHPUtil.getVerifyAndCalMsg(genResult);
        if (errorDetail.length() == 0) {
            MsgBox.showInfo((String)title);
        } else {
            MsgBox.showDetailAndOK((Component)((Object)this), (String)title, (String)errorDetail, (int)0);
        }
        Map owenerUICtx = (Map)this.getUIContext().get("OwnerUICtx");
        owenerUICtx.put("UICTX_HQHPBills", genBillPks);
        this.uiWindow.close();
    }

    private Map getSelectReportsMap(List purIdList, List purEntryIdList) {
        LinkedHashMap selectReportsMap = new LinkedHashMap();
        for (int i = 0; i < purIdList.size(); ++i) {
            String purID = (String)purIdList.get(i);
            String entryID = (String)purEntryIdList.get(i);
            String id = purID + entryID;
            List recRows = (List)this.reportLists.get(id);
            ArrayList<Map> selectedRecRows = new ArrayList<Map>();
            for (int j = 0; j < recRows.size(); ++j) {
                Map recRow = (Map)recRows.get(j);
                Object isSelected = recRow.get(Col_Rec_isSelected);
                if (isSelected == null || !Boolean.TRUE.equals(isSelected)) continue;
                selectedRecRows.add(recRow);
            }
            selectReportsMap.put(id, selectedRecRows);
        }
        return selectReportsMap;
    }

    protected void getSelectedCreateInfoList(List purIdList, List purEntryIdList, Map purInfos) {
        for (int i = 0; i < this.tblMain.getRowCount(); ++i) {
            IRow row = this.tblMain.getRow(i);
            Boolean selected = (Boolean)row.getCell(COL_Pur_selected).getValue();
            if (!selected.booleanValue()) continue;
            String id = (String)row.getCell("id").getValue();
            String entryId = (String)row.getCell("entryId").getValue();
            purIdList.add(id);
            purEntryIdList.add(entryId);
            List purInfoList = this.getPurInfoList(id, entryId);
            purInfos.put(id + entryId, purInfoList);
        }
    }

    private List getPurInfoList(String id, String entryId) {
        ArrayList purInfoList = new ArrayList();
        for (int i = 0; i < this.purConList.size(); ++i) {
            Map purRowMap = (Map)this.purConList.get(i);
            if (!id.equals(purRowMap.get("id")) || !entryId.equals(purRowMap.get("entryId"))) continue;
            purInfoList.add(purRowMap.get(COL_Pur_balNumCalPattern));
            purInfoList.add(purRowMap.get(COL_Pur_balanceCalPattern));
            purInfoList.add(purRowMap.get(COL_Pur_pricingPattern));
            purInfoList.add(purRowMap.get(COL_Pur_deductCalFomula));
            purInfoList.add(purRowMap.get("purConNumber"));
        }
        return purInfoList;
    }

    public void actionView_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        int idx = this.tblMain.getSelectManager().getActiveRowIndex();
        String purID = (String)((Map)this.purConList.get(idx)).get("id");
        this.showPurContract(purID);
    }

    private void showPurContract(String purID) {
        UIContext uiContext = new UIContext((Object)this);
        uiContext.putAll(this.getUIContext());
        uiContext.put((Object)"ID", (Object)purID);
        try {
            IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(PurContractEditUI.class.getName(), (Map)uiContext, null, OprtState.VIEW);
            CoreUI editUI = (CoreUI)uiWindow.getUIObject();
            editUI.getUIMenuBar().setVisible(false);
            editUI.getUIToolBar().setVisible(false);
            uiWindow.show();
        }
        catch (UIException e1) {
            this.handleException((Exception)((Object)e1));
        }
    }

    @Override
    public void actionSelectAll_actionPerformed(ActionEvent e) throws Exception {
        for (int i = 0; i < this.tblMain.getRowCount(); ++i) {
            this.tblMain.getCell(i, COL_Pur_selected).setValue((Object)Boolean.TRUE);
        }
    }

    @Override
    public void actionSelectNone_actionPerformed(ActionEvent e) throws Exception {
        for (int i = 0; i < this.tblMain.getRowCount(); ++i) {
            this.tblMain.getCell(i, COL_Pur_selected).setValue((Object)Boolean.FALSE);
        }
    }

    public Map getUnSelectWeighBills() {
        return this.unSelectWeighBills;
    }

    public void setUnSelectWeighBills(Map unSelectWeighBills) {
        this.unSelectWeighBills = unSelectWeighBills;
    }

    @Override
    public void actionPickWB_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        int idx = this.tblMain.getSelectManager().getActiveRowIndex();
        String purEntryID = (String)((Map)this.purConList.get(idx)).get("entryId");
        UIContext ctx = new UIContext((Object)this);
        ctx.put((Object)CTX_CUR_PURENTRY, (Object)purEntryID);
        IUIWindow win = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(HQHPPickWBListUI.class.getName(), (Map)ctx);
        win.show();
    }

    protected OrgType getMainBizOrgType() {
        return OrgType.Purchase;
    }

    protected String getEditUIName() {
        return null;
    }

    protected ICoreBase getBizInterface() throws Exception {
        return null;
    }

    public boolean destroyWindow() {
        this.createFromList = null;
        return super.destroyWindow();
    }
}

