/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.qm.qc.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTEditManager;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.foot.KDTFootManager;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.ctrl.swing.KDCheckBox;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDFormattedTextField;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.ctrl.swing.KDTextField;
import com.kingdee.bos.ctrl.swing.util.CtrlFormatUtilities;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIException;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.master.material.MultiMeasureUnitFactory;
import com.kingdee.eas.basedata.master.material.MultiMeasureUnitInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.qm.basedata.QCItemInfo;
import com.kingdee.eas.qm.basedata.QCStandardInfo;
import com.kingdee.eas.qm.basedata.QCStandardItemEntryCollection;
import com.kingdee.eas.qm.basedata.QCStandardItemEntryInfo;
import com.kingdee.eas.qm.basedata.client.util.EntrysDetailPanelManager;
import com.kingdee.eas.qm.common.QMBillBaseStatusEnum;
import com.kingdee.eas.qm.common.client.action.IUIContextAction;
import com.kingdee.eas.qm.common.client.action.IUIContextManager;
import com.kingdee.eas.qm.common.client.util.QMClientVerifyUtils;
import com.kingdee.eas.qm.common.print.ITDPrintStrategy;
import com.kingdee.eas.qm.common.util.KDTableUtils;
import com.kingdee.eas.qm.common.util.NumericUtils;
import com.kingdee.eas.qm.qc.BalanceCalPatternEnum;
import com.kingdee.eas.qm.qc.HQHPCalBillFactory;
import com.kingdee.eas.qm.qc.HQHPCalBillInfo;
import com.kingdee.eas.qm.qc.HQHPCalBillQcReportEntryCollection;
import com.kingdee.eas.qm.qc.HQHPCalBillQcReportEntryInfo;
import com.kingdee.eas.qm.qc.HQHPCalBillSettleItemEntryInfo;
import com.kingdee.eas.qm.qc.HQHPCalBillSettleTermEntryInfo;
import com.kingdee.eas.qm.qc.IHQHPCalBill;
import com.kingdee.eas.qm.qc.PricingPatternEnum;
import com.kingdee.eas.qm.qc.QuanSettlePatternEnum;
import com.kingdee.eas.qm.qc.client.AbstractHQHPCalBillEditUI;
import com.kingdee.eas.qm.qc.client.HQHPCalBillAddQCReportUI;
import com.kingdee.eas.qm.qc.client.HQHPCalBillAdjustUI;
import com.kingdee.eas.qm.qc.client.HQHPCalBillCreateListUI;
import com.kingdee.eas.qm.qc.client.HQHPCalBillSettleViewUI;
import com.kingdee.eas.qm.qc.client.QCPurReportEditUI;
import com.kingdee.eas.qm.qc.client.action.hqhp.HQHPQcReportConPriceSAction;
import com.kingdee.eas.qm.qc.client.action.hqhp.HQHPQcReprotEntryAction;
import com.kingdee.eas.qm.qc.client.print.HQHPCalBillTDPrintStrategy;
import com.kingdee.eas.qm.qc.util.HQHPUtil;
import com.kingdee.eas.scm.sm.pur.PurContractEntryInfo;
import com.kingdee.eas.scm.sm.pur.client.PurContractEditUI;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.Action;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.apache.log4j.Logger;

public class HQHPCalBillEditUI
extends AbstractHQHPCalBillEditUI {
    private static final Logger logger = CoreUIObject.getLogger(HQHPCalBillEditUI.class);
    public static final String Entry_QC_conPriceRec = "conPriceRec";
    public static final String Entry_QC_settleQuanS = "settleQuanS";
    public static final String Entry_QC_percent = "percent";
    public static final String Entry_QC_conPriceAvg = "conPriceAvg";
    public static final String Entry_QC_moneyAvg = "moneyAvg";
    public static final String Entry_QC_deliverQty = "deliverQty";
    public static final String Entry_QC_passQty = "passQty";
    public static final String Entry_QC_unPassQty = "unPassQty";
    public static final String Entry_ST_qcAverageValue = "qcAverageValue";
    public static final String Entry_ST_lowRange = "lowRange";
    public static final String Entry_ST_upperRange = "upperRange";
    public static final String Entry_ST_baseValue = "baseValue";
    public static final String Entry_ST_addOrReducePrice = "addOrReducePrice";
    public static final String Entry_ST_floatValue = "floatValue";
    public static final String Entry_ST_floatPrice = "floatPrice";
    public static final String Entry_SI_conUnitPrice = "conUnitPrice";
    public static final String Entry_SI_conProPrice = "conProPrice";
    public static final String Entry_SI_settleUnitPrice = "settleUnitPrice";
    public static final String Entry_SI_proportionPrice = "proportionPrice";
    public static final String Entry_SI_addOrReducePrice = "addOrReducePrice";
    public static final String Entry_SI_totalDeductWeight = "totalDeductWeight";
    public static final String Entry_SI_totalNetWeight = "totalNetWeight";
    public static final String Entry_SI_qcAverageValue = "qcAverageValue";
    public static final String Entry_WM_grossWeight = "grossWeight";
    public static final String Entry_WM_tareWeight = "tareWeight";
    public static final String Entry_WM_incidental = "incidental";
    public static final String Entry_WM_netWeight = "netWeight";
    public static final String Entry_WM_deductWeight = "deductWeight";
    public static final String Entry_WM_dryWeight = "dryWeight";
    public static final String Entry_WM_supplierQty = "supplierQty";
    public static final String Entry_WM_supplierDryWeight = "supplierDryWeight";
    private static final String UICTX_ReportEntry_Changed = "UICTX_ReportEntry_Changed";
    private static final String UICTX_ReportEntryConPriceS_Changed = "UICTX_ReportEntryConPriceS_Changed";
    private static final String UICTX_ReportEntrySettleQuanS_Changed = "UICTX_ReportEntrySettleQuanS_Changed";
    private int qtyScale;
    private int priceScale;
    private Map qcStdScales;
    private int materialPriceScale;

    public void onLoad() throws Exception {
        super.onLoad();
        EntrysDetailPanelManager entrysPanelManager = EntrysDetailPanelManager.getInstance((JPanel[])new KDPanel[]{this.kdtQcReportPnl}, (Action)this.actionAddLine, null, (Action)this.actionRemoveLine);
        entrysPanelManager.regPanel();
        this.btnAuditResult.setVisible(false);
        this.menuItemAuditResult.setVisible(false);
        this.actionAuditResult.setVisible(false);
        this.btnAudit.setVisible(true);
        this.menuItemAudit.setVisible(true);
        this.actionAudit.setVisible(true);
        this.btnUnAudit.setVisible(true);
        this.menuItemUnAudit.setVisible(true);
        this.actionUnAudit.setVisible(true);
        if (OprtState.ADDNEW.equals(this.getOprtState())) {
            this.genBill();
        }
    }

    protected void checkTableParsed() {
        super.checkTableParsed();
        this.kdtSettleItemEntry.checkParsed();
        this.kdtSettleTermEntry.checkParsed();
        this.kdtWeighEntry.checkParsed();
    }

    public void initUIContextManager() {
        super.initUIContextManager();
        this.initUIContextManager(this.kdtQcReportEntry, UICTX_ReportEntry_Changed, 1);
        this.initUIContextManager(this.kdtQcReportEntry, UICTX_ReportEntryConPriceS_Changed, Entry_QC_conPriceRec);
        this.initUIContextManager(this.kdtQcReportEntry, UICTX_ReportEntrySettleQuanS_Changed, Entry_QC_settleQuanS);
    }

    public void registerUIManager(IUIContextManager manager) {
        super.registerUIManager(manager);
        if (UICTX_ReportEntry_Changed.equals(manager.getType())) {
            HQHPQcReprotEntryAction reportAction = new HQHPQcReprotEntryAction(this.kdtQcReportEntry, this.kdtWeighEntry);
            manager.registerAction((IUIContextAction)reportAction);
        } else if (UICTX_ReportEntryConPriceS_Changed.equals(manager.getType())) {
            HQHPQcReportConPriceSAction conPriceAction = new HQHPQcReportConPriceSAction(this.kdtQcReportEntry, this.chkIsCaled, false);
            manager.registerAction((IUIContextAction)conPriceAction);
        } else if (UICTX_ReportEntrySettleQuanS_Changed.equals(manager.getType())) {
            HQHPQcReportConPriceSAction conPriceAction = new HQHPQcReportConPriceSAction(this.kdtQcReportEntry, this.chkIsCaled, true);
            manager.registerAction((IUIContextAction)conPriceAction);
        }
    }

    protected void initDataStatus() {
        super.initDataStatus();
        this.setBtns();
        this.initReportStatus();
        this.initActionAddInsertRemoveLineEnabled();
    }

    private void setTextFormat(KDFormattedTextField[] qtys, KDFormattedTextField[] prices, KDFormattedTextField[] moneys) {
        int i;
        for (i = 0; i < qtys.length; ++i) {
            qtys[i].setHorizontalAlignment(4);
            qtys[i].setRemoveingZeroInDispaly(false);
            qtys[i].setPrecision(this.qtyScale);
        }
        for (i = 0; i < prices.length; ++i) {
            prices[i].setHorizontalAlignment(4);
            prices[i].setRemoveingZeroInDispaly(false);
            prices[i].setPrecision(this.priceScale);
        }
        for (i = 0; i < moneys.length; ++i) {
            moneys[i].setHorizontalAlignment(4);
            moneys[i].setRemoveingZeroInDispaly(false);
            moneys[i].setPrecision(2);
        }
        this.setPrecisionToQCEntry();
        this.setPrecisionToSTEntry();
        this.setPrecisionToSIEntry();
        this.setPrecisionToWMEntry();
    }

    private void setPrecisionToWMEntry() {
        KDTableUtils.setBigDecimalFieldsPrecision((int)this.qtyScale, (KDTable)this.kdtWeighEntry, (String[])new String[]{Entry_WM_deductWeight, Entry_WM_dryWeight, Entry_WM_grossWeight, Entry_WM_incidental, Entry_WM_netWeight, Entry_WM_supplierDryWeight, Entry_WM_supplierQty, Entry_WM_tareWeight});
    }

    private void setPrecisionToSTEntry() {
        int size = this.kdtSettleTermEntry.getRowCount();
        for (int i = 0; i < size; ++i) {
            HQHPCalBillSettleTermEntryInfo entry;
            QCItemInfo qcItem;
            Object obj = this.kdtSettleTermEntry.getRow(i).getUserObject();
            if (obj == null || !(obj instanceof HQHPCalBillSettleTermEntryInfo) || (qcItem = (entry = (HQHPCalBillSettleTermEntryInfo)obj).getQcItem()) == null) continue;
            int dataPrecision = qcItem.getDataPrecision();
            KDTableUtils.setBigDecimalFieldsPrecisionByCell((ICell)this.kdtSettleTermEntry.getRow(i).getCell("qcAverageValue"), (int)dataPrecision);
            Integer qcStdScale = (Integer)this.qcStdScales.get(qcItem.getId().toString());
            KDTableUtils.setBigDecimalFieldsPrecision((int)(qcStdScale == null ? 4 : qcStdScale), (KDTable)this.kdtSettleTermEntry, (int)i, (String[])new String[]{Entry_ST_lowRange, Entry_ST_upperRange, Entry_ST_floatValue, Entry_ST_baseValue});
        }
        KDTableUtils.setBigDecimalFieldsPrecision((int)this.materialPriceScale, (KDTable)this.kdtSettleTermEntry, (String[])new String[]{Entry_ST_floatPrice, "addOrReducePrice"});
    }

    private void setPrecisionToSIEntry() {
        KDTableUtils.setBigDecimalFieldsPrecision((int)this.qtyScale, (KDTable)this.kdtSettleItemEntry, (String[])new String[]{Entry_SI_totalDeductWeight, Entry_SI_totalNetWeight});
        KDTableUtils.setBigDecimalFieldsPrecision((int)this.priceScale, (KDTable)this.kdtSettleItemEntry, (String[])new String[]{"addOrReducePrice", Entry_SI_conProPrice, Entry_SI_conUnitPrice, Entry_SI_proportionPrice, Entry_SI_settleUnitPrice});
        int size = this.kdtSettleItemEntry.getRowCount();
        for (int i = 0; i < size; ++i) {
            HQHPCalBillSettleItemEntryInfo entry;
            Object obj = this.kdtSettleItemEntry.getRow(i).getUserObject();
            if (obj == null || !(obj instanceof HQHPCalBillSettleItemEntryInfo) || (entry = (HQHPCalBillSettleItemEntryInfo)obj).getQcItem() == null) continue;
            int dataPrecision = entry.getQcItem().getDataPrecision();
            KDTableUtils.setBigDecimalFieldsPrecisionByCell((ICell)this.kdtSettleItemEntry.getRow(i).getCell("qcAverageValue"), (int)dataPrecision);
        }
    }

    private void setPrecisionToQCEntry() {
        KDTableUtils.setBigDecimalFieldsPrecision((int)this.qtyScale, (KDTable)this.kdtQcReportEntry, (String[])new String[]{Entry_QC_settleQuanS, Entry_QC_deliverQty, Entry_QC_passQty, Entry_QC_unPassQty});
        KDTableUtils.setBigDecimalFieldsPrecision((int)this.priceScale, (KDTable)this.kdtQcReportEntry, (String[])new String[]{Entry_QC_conPriceAvg, Entry_QC_conPriceRec});
        KDTableUtils.setBigDecimalFieldsPrecision((int)2, (KDTable)this.kdtQcReportEntry, (String[])new String[]{Entry_QC_moneyAvg});
        this.kdtQcReportEntry.getColumn(Entry_QC_percent).getStyleAttributes().setNumberFormat(CtrlFormatUtilities.getDecimalFormatString());
    }

    @Override
    public void loadFields() {
        this.beforLoadFields();
        super.loadFields();
        this.afterLoadFields();
    }

    public void beforLoadFields() {
        super.beforLoadFields();
        this.clearWeighTable();
    }

    public void afterLoadFields() {
        super.afterLoadFields();
        if (OprtState.ADDNEW.equals(this.getOprtState())) {
            this.clearUIFields();
            return;
        }
        if (this.kdtSettleItemEntry.getRowCount() > 0) {
            this.kdtSettleItemEntry.getRow(0).getCell("isSum").setValue((Object)HQHPUtil.getMsg("TEXT_SUM"));
            this.kdtSettleItemEntry.getRow(0).getCell("isSum").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.CENTER);
            this.kdtSettleItemEntry.getRow(0).getCell("settlePriceType").setValue(null);
            this.kdtSettleItemEntry.getRow(0).getStyleAttributes().setBackground(HQHPUtil.SumRowBGColor);
        }
        this.kdtQcReportEntry.getSelectManager().setSelectMode(2);
        this.kdtQcReportEntry.getStyleAttributes().setLocked(true);
        this.kdtSettleTermEntry.getStyleAttributes().setLocked(true);
        this.kdtSettleItemEntry.getStyleAttributes().setLocked(true);
        this.kdtWeighEntry.getStyleAttributes().setLocked(true);
        this.bindRepeatComp();
        this.setSettleHint();
        this.initReportStatus();
        this.hideZeroRange();
        KDFormattedTextField[] qtyComps = new KDFormattedTextField[]{this.txtSettleQuantityS, this.txtSettleQuantityI, this.txtSettleQuantitySA, this.txtSettleQuantityI2};
        KDFormattedTextField[] priceComps = new KDFormattedTextField[]{this.txtSettleUnitPriceS, this.txtSettleUnitPriceI, this.txtSettleUnitPriceSA, this.txtSettleUnitPriceIA};
        KDFormattedTextField[] moneyComps = new KDFormattedTextField[]{this.txtSettleMoney, this.txtSettleMoneyA};
        try {
            this.initQtyScale();
            this.initPriceScale();
            this.initQcStdScales();
            this.initMaterialPriceScale();
        }
        catch (Exception e) {
            this.handUIException(e);
        }
        this.setTextFormat(qtyComps, priceComps, moneyComps);
        if (this.kdtQcReportEntry.getRowCount() > 0) {
            KDTableUtils.selectFirstRow((KDTable)this.kdtQcReportEntry);
        }
        if (this.editData.isIsWeigh() && this.editData.getQuanSettlePattern() != null && (QuanSettlePatternEnum.SUPPLIERDRYWEIGHT.equals((Object)this.editData.getQuanSettlePattern()) || QuanSettlePatternEnum.SUPPLIERQTY.equals((Object)this.editData.getQuanSettlePattern()))) {
            this.kdtQcReportEntry.getColumn(Entry_QC_settleQuanS).getStyleAttributes().setLocked(false);
            this.kdtQcReportEntry.getColumn(Entry_QC_settleQuanS).getStyleAttributes().setBackground(HQHPUtil.SumRowBGColor);
        } else {
            this.kdtQcReportEntry.getColumn(Entry_QC_settleQuanS).getStyleAttributes().setLocked(true);
        }
    }

    private void initMaterialPriceScale() {
        MaterialInfo material;
        HQHPCalBillInfo info;
        PurContractEntryInfo purContractEntry;
        this.materialPriceScale = 4;
        if (this.getDataObject() != null && (purContractEntry = (info = (HQHPCalBillInfo)this.getDataObject()).getPurContractEntry()) != null && (material = purContractEntry.getMaterial()) != null) {
            this.materialPriceScale = material.getPricePrecision();
        }
    }

    private void initQcStdScales() {
        QCStandardItemEntryCollection itemEntries;
        QCStandardInfo qcStandard;
        HQHPCalBillInfo info;
        PurContractEntryInfo purContractEntry;
        this.qcStdScales = new HashMap();
        if (this.getDataObject() != null && (purContractEntry = (info = (HQHPCalBillInfo)this.getDataObject()).getPurContractEntry()) != null && (qcStandard = purContractEntry.getQcStandard()) != null && (itemEntries = qcStandard.getItemEntries()) != null && itemEntries.size() > 0) {
            int size = itemEntries.size();
            for (int i = 0; i < size; ++i) {
                QCStandardItemEntryInfo standardItemEntryInfo = itemEntries.get(i);
                QCItemInfo item = standardItemEntryInfo.getQCItem();
                if (item == null) continue;
                this.qcStdScales.put(item.getId().toString(), new Integer(standardItemEntryInfo.getDataPrecision()));
            }
        }
    }

    private void initQtyScale() throws EASBizException, BOSException {
        this.qtyScale = 2;
        if (this.getDataObject() != null) {
            MultiMeasureUnitInfo multiUnitInfo;
            HQHPCalBillInfo info = (HQHPCalBillInfo)this.getDataObject();
            if (info.getPurOrgUnit() == null) {
                return;
            }
            String paramValue = HQHPUtil.getQtyParamValue(null, "HQHP001", info.getPurOrgUnit().getId().toString());
            if (!StringUtils.isEmpty((String)paramValue) && !"DEFAULT".equals(paramValue)) {
                this.qtyScale = Integer.parseInt(paramValue);
            } else if (info.getPurContractEntry() != null && info.getPurContractEntry().getUnit() != null && info.getPurContractEntry().getMaterial() != null && (multiUnitInfo = MultiMeasureUnitFactory.getRemoteInstance().getMultiUnit(info.getPurContractEntry().getMaterial().getId().toString(), info.getPurContractEntry().getUnit().getId().toString())) != null) {
                this.qtyScale = multiUnitInfo.getQtyPrecision();
            }
        }
    }

    private void initPriceScale() throws EASBizException, BOSException {
        this.priceScale = 4;
        if (this.getDataObject() != null) {
            HQHPCalBillInfo info = (HQHPCalBillInfo)this.getDataObject();
            if (info.getPurOrgUnit() == null) {
                return;
            }
            String paramValue = HQHPUtil.getPriceParamValue(null, "HQHP002", info.getPurOrgUnit().getId().toString());
            if (!StringUtils.isEmpty((String)paramValue) && !"DEFAULT".equals(paramValue)) {
                this.priceScale = Integer.parseInt(paramValue);
            }
        }
    }

    private void hideZeroRange() {
        int rowCount = this.kdtSettleTermEntry.getRowCount();
        for (int i = 0; i < rowCount; ++i) {
            IRow row = this.kdtSettleTermEntry.getRow(i);
            String[] cells = new String[]{"addOrReducePrice", Entry_ST_floatValue, Entry_ST_floatPrice};
            this.hideCells(row, cells);
        }
    }

    private void hideCells(IRow row, String[] cells) {
        for (int i = 0; i < cells.length; ++i) {
            ICell cell = row.getCell(cells[i]);
            Object value = cell.getValue();
            if (value != null && (!(value instanceof BigDecimal) || !HQHPUtil.isZero((BigDecimal)value))) continue;
            cell.getStyleAttributes().setFontColor(Color.WHITE);
        }
    }

    public void clearUIFields() {
        Set allComponents = QMClientVerifyUtils.getAllComponents((Container)this.kDTabbedPane1);
        for (Component component : allComponents) {
            if (component instanceof KDFormattedTextField) {
                ((KDFormattedTextField)component).setValue(null);
                continue;
            }
            if (component instanceof KDBizPromptBox) {
                ((KDBizPromptBox)component).setValue(null);
                continue;
            }
            if (component instanceof KDTextField) {
                ((KDTextField)component).setText("");
                continue;
            }
            if (component instanceof KDComboBox) {
                ((KDComboBox)component).setSelectedItem(null);
                continue;
            }
            if (!(component instanceof KDCheckBox)) continue;
            ((KDCheckBox)component).setSelected(false);
        }
        this.clearWeighTable();
        this.pkCreateDate.setValue((Object)new Date());
    }

    private void clearWeighTable() {
        this.kdtWeighEntry.removeRows();
        KDTFootManager footManager = this.kdtWeighEntry.getFootManager();
        if (footManager != null) {
            footManager.getFoot().removeRows();
        }
        this.kdtQcReportEntry.removeRows();
        KDTFootManager qcFootManager = this.kdtQcReportEntry.getFootManager();
        if (qcFootManager != null) {
            qcFootManager.getFoot().removeRows();
        }
    }

    private void setSettleHint() {
        if (this.editData == null) {
            return;
        }
        boolean isWeigh = this.editData.isIsWeigh();
        QuanSettlePatternEnum settlePattern = this.editData.getQuanSettlePattern();
        PricingPatternEnum pricingPattern = this.editData.getPricingPattern();
        String quanS = "";
        String supplierQty = HQHPUtil.getMsg("TEXT_HINT_SUPPLIERQTY");
        String netWeight = HQHPUtil.getMsg("TEXT_HINT_NETWEIGHT");
        String deliverQty = HQHPUtil.getMsg("TEXT_HINT_DELIVERQTY");
        if (!isWeigh) {
            quanS = deliverQty;
        } else if (QuanSettlePatternEnum.SUPPLIERQTY.equals((Object)settlePattern)) {
            quanS = supplierQty;
        } else if (QuanSettlePatternEnum.DRYWEIGHT.equals((Object)settlePattern)) {
            quanS = HQHPUtil.getMsg("TEXT_HINT_DRYWEIGHT");
        } else if (QuanSettlePatternEnum.NETWEIGHT.equals((Object)settlePattern)) {
            quanS = netWeight;
        } else if (QuanSettlePatternEnum.SUPPLIERDRYWEIGHT.equals((Object)settlePattern)) {
            quanS = HQHPUtil.getMsg("TEXT_HINT_SUPPLIERDRYQTY");
        }
        String price = "";
        if (PricingPatternEnum.CONPRICE.equals((Object)pricingPattern)) {
            price = HQHPUtil.getMsg("TEXT_HINT_CONTRACTPRICE");
        } else if (PricingPatternEnum.HQHP.equals((Object)pricingPattern)) {
            price = HQHPUtil.getMsg("TEXT_HINT_HQHP");
        }
        String quanI = "";
        quanI = isWeigh ? netWeight : deliverQty;
        this.txtSettleHint.setText(HQHPUtil.getMsg("TEXT_HINT", new String[]{quanS, price, quanI}));
    }

    private void bindRepeatComp() {
        if (this.editData == null || OprtState.ADDNEW.equals(this.getOprtState())) {
            return;
        }
        BigDecimal settleQuantityI = this.editData.getSettleQuantityI();
        this.txtSettleQuantityI2.setValue((Object)settleQuantityI);
    }

    private void setBtns() {
        this.prmtPurOrg.setEnabled(false);
        this.actionAddNew.setVisible(false);
        this.actionAddNew.setEnabled(false);
        HQHPCalBillInfo info = (HQHPCalBillInfo)this.getDataObject();
        if (info.getBillStatus().equals((Object)QMBillBaseStatusEnum.Audit)) {
            this.actionUnAudit.setEnabled(true);
        } else {
            this.actionUnAudit.setEnabled(false);
        }
        if (info.getBillStatus().equals((Object)QMBillBaseStatusEnum.Submit)) {
            this.actionAudit.setEnabled(true);
        } else {
            this.actionAudit.setEnabled(false);
        }
        this.actionGenCalBill.setEnabled(true);
        this.btnGenCalBill.setEnabled(true);
        this.menuItemGenCalBill.setEnabled(true);
        if (OprtState.EDIT.equals(this.getOprtState())) {
            this.actionCalPrice.setVisible(true);
            this.actionCalPrice.setEnabled(true);
        } else {
            this.actionCalPrice.setVisible(false);
        }
        if (!info.isIsSubmitted() && QMBillBaseStatusEnum.Audit.equals((Object)info.getBillStatus())) {
            this.actionSubmitCalPrice.setVisible(true);
            this.actionSubmitCalPrice.setEnabled(true);
        } else {
            this.actionSubmitCalPrice.setVisible(false);
        }
        if (OprtState.EDIT.equals(this.getOprtState()) && info.isIsCaled() && !QMBillBaseStatusEnum.Audit.equals((Object)info.getBillStatus())) {
            this.actionAdjust.setVisible(true);
            this.actionAdjust.setEnabled(true);
        } else {
            this.actionAdjust.setVisible(false);
        }
        if (OprtState.ADDNEW.equals(this.getOprtState())) {
            this.actionViewPurContract.setVisible(false);
            this.actionViewQCReport.setVisible(false);
            this.actionViewHQHPCalBillSettle.setVisible(false);
        } else {
            this.actionViewPurContract.setVisible(true);
            this.actionViewPurContract.setEnabled(true);
            this.actionViewQCReport.setVisible(true);
            this.actionViewQCReport.setEnabled(true);
            this.actionViewHQHPCalBillSettle.setVisible(true);
            this.actionViewHQHPCalBillSettle.setEnabled(true);
        }
        if (info.isIsSubmitted()) {
            this.actionCancelPrice.setVisible(true);
            this.actionCancelPrice.setEnabled(true);
        } else {
            this.actionCancelPrice.setVisible(false);
        }
    }

    private void initReportStatus() {
        if (OprtState.EDIT.equals(this.getOprtState())) {
            this.kdtQcReportEntry.getColumn(Entry_QC_conPriceRec).getStyleAttributes().setLocked(false);
            this.kdtQcReportEntry.getColumn(Entry_QC_conPriceRec).getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
            this.kdtQcReportEntry.getColumn(Entry_QC_conPriceRec).getStyleAttributes().setBackground(HQHPUtil.SumRowBGColor);
            this.actionAddLine.setEnabled(true);
            this.actionRemoveLine.setEnabled(true);
        } else {
            this.kdtQcReportEntry.getColumn(Entry_QC_conPriceRec).getStyleAttributes().setLocked(false);
            this.kdtQcReportEntry.getColumn(Entry_QC_conPriceRec).getStyleAttributes().setBackground(HQHPUtil.SumRowBGColor);
            this.actionAddLine.setEnabled(false);
            this.actionRemoveLine.setEnabled(false);
        }
        this.refreshReportFootRow();
    }

    private void refreshReportFootRow() {
        String[] reportSumFields = new String[]{Entry_QC_settleQuanS, Entry_QC_percent, Entry_QC_conPriceAvg, Entry_QC_moneyAvg};
        HQHPUtil.appendFootRow(this.kdtQcReportEntry, reportSumFields, null);
        this.kdtQcReportEntry.getFootManager().getFootRow(0).getCell(Entry_QC_percent).getStyleAttributes().setNumberFormat(CtrlFormatUtilities.getDecimalFormatString());
    }

    public void actionSave_actionPerformed(ActionEvent e) throws Exception {
        this.verifyBeforeSave();
        super.actionSave_actionPerformed(e);
    }

    private void verifyBeforeSave() {
        for (int i = 0; i < this.kdtQcReportEntry.getRowCount(); ++i) {
            Object cellMoneyAvgValue;
            ICell settleQuanSCell;
            BigDecimal settleQuanS;
            IRow row = this.kdtQcReportEntry.getRow(i);
            KDTEditManager kdtEditManager = this.kdtQcReportEntry.getEditManager();
            ICell conPriceRecCell = row.getCell(Entry_QC_conPriceRec);
            if (conPriceRecCell.getValue() == null || HQHPUtil.isZero((BigDecimal)conPriceRecCell.getValue())) {
                kdtEditManager.editCellAt(i, this.kdtQcReportEntry.getColumnIndex(Entry_QC_conPriceRec));
                MsgBox.showWarning((String)HQHPUtil.getMsg("Verify_SettleQuanSMustInput"));
                SysUtil.abort();
            }
            BigDecimal bigDecimal = settleQuanS = (settleQuanSCell = row.getCell(Entry_QC_settleQuanS)).getValue() == null ? null : (BigDecimal)settleQuanSCell.getValue();
            if (settleQuanS == null || HQHPUtil.BigDecimal_Zero.compareTo(settleQuanS) >= 0) {
                kdtEditManager.editCellAt(i, this.kdtQcReportEntry.getColumnIndex(Entry_QC_settleQuanS));
                MsgBox.showWarning((String)HQHPUtil.getMsg("Verify_SettleQuanSInReporEntry", new String[]{i + 1 + ""}));
                SysUtil.abort();
            }
            if ((cellMoneyAvgValue = row.getCell(Entry_QC_moneyAvg).getValue()) == null || HQHPUtil.BigDecimal_MaxValue.compareTo((BigDecimal)cellMoneyAvgValue) > 0) continue;
            kdtEditManager.editCellAt(i, this.kdtQcReportEntry.getColumnIndex(Entry_QC_conPriceRec));
            MsgBox.showWarning((String)HQHPUtil.getMsg("Verify_cellMoneyAvgValue", new String[]{i + 1 + ""}));
            SysUtil.abort();
        }
    }

    protected KDBizPromptBox getMainBizOrg() {
        return this.prmtPurOrg;
    }

    @Override
    protected OrgType getMainBizOrgType() {
        return OrgType.Purchase;
    }

    @Override
    protected ICoreBase getBizInterface() throws Exception {
        return HQHPCalBillFactory.getRemoteInstance();
    }

    @Override
    public void actionGenCalBill_actionPerformed(ActionEvent e) throws Exception {
        this.genBill();
    }

    private void genBill() throws Exception {
        UIContext uiCtx = new UIContext((Object)this);
        uiCtx.put((Object)"OwnerUICtx", (Object)this.getUIContext());
        IUIWindow win = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(HQHPCalBillCreateListUI.class.getName(), (Map)uiCtx);
        win.show();
        this.loadBill();
    }

    private void loadBill() throws Exception {
        IObjectPK[] genBillPks = (IObjectPK[])this.getUIContext().get("UICTX_HQHPBills");
        if (genBillPks == null || genBillPks.length == 0) {
            return;
        }
        for (int i = 0; i < genBillPks.length; ++i) {
            this.idList.add(genBillPks[i].toString());
        }
        this.idList.setCurrentID(genBillPks[0].toString());
        this.idList.setCurrentIndex(0);
        IObjectValue objValue = this.getValue(genBillPks[0]);
        this.unLockThisEditData();
        this.setOprtState("VIEW");
        this.setDataObject(objValue);
        this.loadFields();
        this.showMessageForStatus();
        if (this.getUIContext().containsKey("UICTX_HQHPBills")) {
            this.getUIContext().remove("UICTX_HQHPBills");
        }
    }

    protected void unLockThisEditData() {
        if (this.editData.getId() != null) {
            try {
                this.pubFireVOChangeListener(this.editData.getId().toString());
            }
            catch (Throwable e1) {
                logger.error((Object)e1);
            }
        }
    }

    @Override
    public void actionCalPrice_actionPerformed(ActionEvent e) throws Exception {
        Map resultMap;
        IObjectPK[] calBillPks;
        HQHPCalBillQcReportEntryCollection calBillReportEntrys;
        if (QMBillBaseStatusEnum.Audit.equals((Object)this.editData.getBillStatus())) {
            MsgBox.showInfo((String)HQHPUtil.getMsg("Check_OnlyUnAuditBillCanCal"));
            SysUtil.abort();
        }
        if (this.editData.isIsSubmitted()) {
            MsgBox.showInfo((String)HQHPUtil.getMsg("Check_SubmittedBillCannotCal"));
            SysUtil.abort();
        }
        if ((calBillReportEntrys = this.editData.getQcReportEntry()) == null || calBillReportEntrys.size() == 0) {
            MsgBox.showInfo((String)HQHPUtil.getMsg("Check_HasNoQcReportCannotCal"));
            SysUtil.abort();
        }
        this.verifyBeforeSave();
        if (MsgBox.showConfirm2((String)HQHPUtil.getMsg("Confirm_CalPrice")) != 0) {
            SysUtil.abort();
        }
        if ((calBillPks = (IObjectPK[])(resultMap = HQHPCalBillFactory.getRemoteInstance().calBillWhenEdit(this.editData)).get("resultBillIDs")).length != 0) {
            List clearAdjustBill = (List)resultMap.get("clearAdjustBills");
            if (HQHPUtil.isNullList(clearAdjustBill)) {
                MsgBox.showInfo((String)HQHPUtil.getMsg("Msg_Cal_BillOK"));
            } else {
                MsgBox.showInfo((String)HQHPUtil.getMsg("Msg_Cal_BillOK_ClearAdjust"));
            }
        } else {
            MsgBox.showDetailAndOK((Component)((Object)this), (String)HQHPUtil.getMsg("Msg_Cal_BillError"), (String)HQHPUtil.getVerifyAndCalMsg(resultMap), (int)0);
        }
        this.refreshEditUI();
    }

    private void refreshEditUI() throws Exception {
        if (this.editData.getId() != null) {
            ObjectUuidPK iObjectPk = new ObjectUuidPK(this.editData.getId());
            IObjectValue iObjectValue = this.getValue((IObjectPK)iObjectPk);
            this.setDataObject(iObjectValue);
            this.loadFields();
            this.setSave(true);
        }
    }

    @Override
    public void actionAdjust_actionPerformed(ActionEvent e) throws Exception {
        if (QMBillBaseStatusEnum.Audit.equals((Object)this.editData.getBillStatus())) {
            MsgBox.showInfo((String)HQHPUtil.getMsg("Check_OnlyUnAuditBillCanAdjust"));
            SysUtil.abort();
        }
        if (!this.editData.isIsCaled()) {
            MsgBox.showInfo((String)HQHPUtil.getMsg("Check_UnCalBillCannotAdjust"));
            SysUtil.abort();
        }
        if (this.editData.isIsSubmitted()) {
            MsgBox.showInfo((String)HQHPUtil.getMsg("Check_SubmittedBillCannotAdjust"));
            SysUtil.abort();
        }
        UIContext uiCtx = new UIContext((Object)this);
        uiCtx.put((Object)"UICTX_OwnerCtx", (Object)this.getUIContext());
        uiCtx.put((Object)"InitDataObject", (Object)this.getDataObject());
        uiCtx.put((Object)this.getMainType(), (Object)this.getMainOrgInfo());
        HQHPCalBillInfo bakInfo = (HQHPCalBillInfo)this.editData.clone();
        IUIWindow win = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(HQHPCalBillAdjustUI.class.getName(), (Map)uiCtx);
        win.show();
        Boolean isCancelAdjust = (Boolean)this.getUIContext().get("UICTX_Adjust_IsReturn");
        if (isCancelAdjust == null || isCancelAdjust != null && isCancelAdjust.booleanValue()) {
            return;
        }
        this.initOldData((IObjectValue)bakInfo);
        this.refreshEditUI();
        if (this.getUIContext().containsKey("UICTX_hqhpBillInfo_Adjust")) {
            this.getUIContext().remove("UICTX_hqhpBillInfo_Adjust");
        }
        if (this.getUIContext().containsKey("UICTX_Adjust_IsReturn")) {
            this.getUIContext().remove("UICTX_Adjust_IsReturn");
        }
        if (this.getUIContext().containsKey("AdjustDataObject")) {
            this.getUIContext().remove("AdjustDataObject");
        }
    }

    @Override
    public void actionSubmitCalPrice_actionPerformed(ActionEvent e) throws Exception {
        if (!QMBillBaseStatusEnum.Audit.equals((Object)this.editData.getBillStatus())) {
            MsgBox.showInfo((String)HQHPUtil.getMsg("Check_UnAuditedBillCannotSubmitCal"));
            SysUtil.abort();
        }
        if (!this.editData.isIsCaled()) {
            MsgBox.showInfo((String)HQHPUtil.getMsg("Check_UnCaledBillCannotSubmitCal"));
            SysUtil.abort();
        }
        if (this.editData.isIsSubmitted()) {
            MsgBox.showInfo((String)HQHPUtil.getMsg("Check_SubmittedBillCannotSubmitCal"));
            SysUtil.abort();
        }
        if (MsgBox.showConfirm2((String)HQHPUtil.getMsg("Confirm_SubmitPrice")) != 0) {
            SysUtil.abort();
        }
        IHQHPCalBill iBiz = HQHPCalBillFactory.getRemoteInstanceWithObjectContext(this.getMainOrgContext());
        if (!this.editData.isIsWeigh()) {
            Set recEntryIds = this.getRecEntryIds();
            HashMap<String, Set> param = new HashMap<String, Set>();
            param.put("recEntryIds", recEntryIds);
            Map recQty = iBiz.getRecQty(param);
            if (recQty != null) {
                HashMap<String, BigDecimal> noInWareBills = new HashMap<String, BigDecimal>();
                for (String recEntryId : recEntryIds) {
                    BigDecimal qtyDiff = (BigDecimal)recQty.get(recEntryId);
                    if (qtyDiff == null || qtyDiff.compareTo(HQHPUtil.BigDecimal_Zero) <= 0) continue;
                    noInWareBills.put(recEntryId, qtyDiff);
                }
                if (noInWareBills.size() > 0 && !this.confirmForceSubmit(noInWareBills)) {
                    SysUtil.abort();
                }
            }
        }
        HashMap params = new HashMap();
        ArrayList<String> ids = new ArrayList<String>();
        ids.add(this.editData.getId().toString());
        params.put("ids", ids);
        Map result = iBiz.submitPrice(new Map[]{params, null});
        String errorMsg = HQHPUtil.getVerifyAndCalMsg(result);
        if (errorMsg.length() == 0) {
            MsgBox.showInfo((String)HQHPUtil.getMsg("Submit_Successful"));
        } else {
            MsgBox.showDetailAndOK((Component)((Object)this), (String)HQHPUtil.getMsg("Submit_Failed"), (String)errorMsg, (int)0);
        }
        this.refreshEditUI();
    }

    private boolean confirmForceSubmit(Map recQty) {
        Iterator noInWareBills = recQty.keySet().iterator();
        StringBuffer detail = new StringBuffer();
        String materialName = this.editData.getPurContractEntry().getMaterial().getName();
        while (noInWareBills.hasNext()) {
            String recEntryId = (String)noInWareBills.next();
            String recNumber = this.findRecNumber(recEntryId);
            detail.append(HQHPUtil.getMsg("Confirm_ForceSubmitPrice", new String[]{recNumber, materialName, recQty.get(recEntryId).toString()}));
            detail.append("\n");
        }
        return 0 == MsgBox.showConfirm4a((String)HQHPUtil.getMsg("Confirm_ForceSubmitPriceTitle"), (String)detail.toString());
    }

    private String findRecNumber(String recEntryId) {
        String recNumber = "";
        HQHPCalBillQcReportEntryCollection qcReportEntry = this.editData.getQcReportEntry();
        for (int i = 0; i < qcReportEntry.size(); ++i) {
            HQHPCalBillQcReportEntryInfo calBillQcReportEntryInfo = qcReportEntry.get(i);
            if (!recEntryId.equals(calBillQcReportEntryInfo.getRecBillEntry().getId().toString())) continue;
            recNumber = calBillQcReportEntryInfo.getRecBill().getNumber();
        }
        return recNumber;
    }

    private Set getRecEntryIds() {
        HashSet<String> recEntryIds = new HashSet<String>();
        HQHPCalBillQcReportEntryCollection qcReportEntry = this.editData.getQcReportEntry();
        for (int i = 0; i < qcReportEntry.size(); ++i) {
            HQHPCalBillQcReportEntryInfo calBillQcReportEntryInfo = qcReportEntry.get(i);
            String recEntryId = calBillQcReportEntryInfo.getRecBillEntry().getId().toString();
            recEntryIds.add(recEntryId);
        }
        return recEntryIds;
    }

    @Override
    public void actionCancelPrice_actionPerformed(ActionEvent e) throws Exception {
        if (MsgBox.showConfirm2((String)HQHPUtil.getMsg("Confirm_CancelPrice")) != 0) {
            SysUtil.abort();
        }
        IHQHPCalBill iBiz = HQHPCalBillFactory.getRemoteInstanceWithObjectContext(this.getMainOrgContext());
        HashMap params = new HashMap();
        HashSet<String> ids = new HashSet<String>();
        ids.add(this.editData.getId().toString());
        params.put("Cancel_IDS", ids);
        Map result = iBiz.cancelPrice(params);
        String errorMsg = HQHPUtil.getVerifyAndCalMsg(result);
        if (errorMsg.length() == 0) {
            MsgBox.showInfo((String)HQHPUtil.getMsg("Msg_CancelSuccessful"));
        } else {
            MsgBox.showDetailAndOK((Component)((Object)this), (String)HQHPUtil.getMsg("Msg_CancelFailed"), (String)errorMsg, (int)0);
        }
        this.refreshEditUI();
    }

    @Override
    public SelectorItemCollection getSelectors() {
        return HQHPCalBillEditUI.getHqhpBillSelectors();
    }

    public static SelectorItemCollection getHqhpBillSelectors() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("creator.id"));
        sic.add(new SelectorItemInfo("creator.number"));
        sic.add(new SelectorItemInfo("creator.name"));
        sic.add(new SelectorItemInfo("createTime"));
        sic.add(new SelectorItemInfo("lastUpdateUser.id"));
        sic.add(new SelectorItemInfo("lastUpdateUser.number"));
        sic.add(new SelectorItemInfo("lastUpdateUser.name"));
        sic.add(new SelectorItemInfo("lastUpdateTime"));
        sic.add(new SelectorItemInfo("auditor.id"));
        sic.add(new SelectorItemInfo("auditor.name"));
        sic.add(new SelectorItemInfo("auditor.number"));
        sic.add(new SelectorItemInfo("isSubmitted"));
        sic.add(new SelectorItemInfo("isCaled"));
        sic.add(new SelectorItemInfo("unitPrice"));
        sic.add(new SelectorItemInfo("protectivePrice"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("calBillDate"));
        sic.add(new SelectorItemInfo("billStatus"));
        sic.add(new SelectorItemInfo("purOrgUnit.id"));
        sic.add(new SelectorItemInfo("purOrgUnit.number"));
        sic.add(new SelectorItemInfo("purOrgUnit.name"));
        sic.add(new SelectorItemInfo("purContract.supplier.id"));
        sic.add(new SelectorItemInfo("purContract.supplier.number"));
        sic.add(new SelectorItemInfo("purContract.supplier.name"));
        sic.add(new SelectorItemInfo("purContractEntry.material.id"));
        sic.add(new SelectorItemInfo("purContractEntry.material.number"));
        sic.add(new SelectorItemInfo("purContractEntry.material.name"));
        sic.add(new SelectorItemInfo("purContractEntry.material.isWeighted"));
        sic.add(new SelectorItemInfo("purContractEntry.material.baseUnit.coefficient"));
        sic.add(new SelectorItemInfo("purContractEntry.qcStandard.id"));
        sic.add(new SelectorItemInfo("purContractEntry.qcStandard.itemEntries.id"));
        sic.add(new SelectorItemInfo("purContractEntry.qcStandard.itemEntries.qCItem.id"));
        sic.add(new SelectorItemInfo("purContractEntry.qcStandard.itemEntries.dataPrecision"));
        sic.add(new SelectorItemInfo("purContractEntry.material.pricePrecision"));
        sic.add(new SelectorItemInfo("isWeigh"));
        sic.add(new SelectorItemInfo("purContractEntry.unit.id"));
        sic.add(new SelectorItemInfo("purContractEntry.unit.number"));
        sic.add(new SelectorItemInfo("purContractEntry.unit.name"));
        sic.add(new SelectorItemInfo("purContractEntry.unit.coefficient"));
        sic.add(new SelectorItemInfo("purContractEntry.unit.qtyPrecision"));
        sic.add(new SelectorItemInfo("purContractEntry.taxPrice"));
        sic.add(new SelectorItemInfo("qcReportDateBegin"));
        sic.add(new SelectorItemInfo("qcReportDateEnd"));
        sic.add(new SelectorItemInfo("recBizDateBegin"));
        sic.add(new SelectorItemInfo("recBizDateEnd"));
        sic.add(new SelectorItemInfo("settleQuantityS"));
        sic.add(new SelectorItemInfo("purContract.number"));
        sic.add(new SelectorItemInfo("purContract.currency.id"));
        sic.add(new SelectorItemInfo("purContract.currency.number"));
        sic.add(new SelectorItemInfo("purContract.currency.name"));
        sic.add(new SelectorItemInfo("settleUnitPriceS"));
        sic.add(new SelectorItemInfo("description"));
        sic.add(new SelectorItemInfo("settleMoney"));
        sic.add(new SelectorItemInfo("settleQuantityI"));
        sic.add(new SelectorItemInfo("settleUnitPriceI"));
        sic.add(new SelectorItemInfo("settleQuantitySA"));
        sic.add(new SelectorItemInfo("settleUnitPriceSA"));
        sic.add(new SelectorItemInfo("settleUnitPriceIA"));
        sic.add(new SelectorItemInfo("settleMoneyA"));
        sic.add(new SelectorItemInfo("settleInfo"));
        sic.add(new SelectorItemInfo("netWeightAmount"));
        sic.add(new SelectorItemInfo("dryWeightAmount"));
        sic.add(new SelectorItemInfo("totalDeductVar"));
        sic.add(new SelectorItemInfo(Entry_SI_totalDeductWeight));
        sic.add(new SelectorItemInfo("supplierAmount"));
        sic.add(new SelectorItemInfo("purMoneyRef"));
        sic.add(new SelectorItemInfo("uniPriceDiffS"));
        sic.add(new SelectorItemInfo("quantityDiffS"));
        sic.add(new SelectorItemInfo("moneyDiff"));
        sic.add(new SelectorItemInfo("uniPriceDiffI"));
        sic.add(new SelectorItemInfo("adjustPerson"));
        sic.add(new SelectorItemInfo("adjustReason"));
        sic.add(new SelectorItemInfo("adjustDate"));
        sic.add(new SelectorItemInfo("auditTime"));
        sic.add(new SelectorItemInfo("settleTermEntry.qcAverageValue"));
        sic.add(new SelectorItemInfo("settleTermEntry.qcItem.id"));
        sic.add(new SelectorItemInfo("settleTermEntry.qcItem.number"));
        sic.add(new SelectorItemInfo("settleTermEntry.qcItem.name"));
        sic.add(new SelectorItemInfo("settleTermEntry.qcItem.dataPrecision"));
        sic.add(new SelectorItemInfo("settleTermEntry.comparator1"));
        sic.add(new SelectorItemInfo("settleTermEntry.comparator2"));
        sic.add(new SelectorItemInfo("settleTermEntry.lowRange"));
        sic.add(new SelectorItemInfo("settleTermEntry.upperRange"));
        sic.add(new SelectorItemInfo("settleTermEntry.settlementPriceType"));
        sic.add(new SelectorItemInfo("settleTermEntry.baseValue"));
        sic.add(new SelectorItemInfo("settleTermEntry.basePrice"));
        sic.add(new SelectorItemInfo("settleTermEntry.floatValue"));
        sic.add(new SelectorItemInfo("settleTermEntry.floatPrice"));
        sic.add(new SelectorItemInfo("settleTermEntry.id"));
        sic.add(new SelectorItemInfo("settleItemEntry.settleUnitPrice"));
        sic.add(new SelectorItemInfo("settleItemEntry.proportionPrice"));
        sic.add(new SelectorItemInfo("settleItemEntry.addOrReducePrice"));
        sic.add(new SelectorItemInfo("settleItemEntry.totalDeductWeight"));
        sic.add(new SelectorItemInfo("settleItemEntry.qcAverageValue"));
        sic.add(new SelectorItemInfo("settleItemEntry.totalNetWeight"));
        sic.add(new SelectorItemInfo("settleItemEntry.conUnitPrice"));
        sic.add(new SelectorItemInfo("settleItemEntry.conProPrice"));
        sic.add(new SelectorItemInfo("settleItemEntry.settlementPriceType"));
        sic.add(new SelectorItemInfo("settleItemEntry.qcItem.name"));
        sic.add(new SelectorItemInfo("settleItemEntry.qcItem.number"));
        sic.add(new SelectorItemInfo("settleItemEntry.qcItem.dataPrecision"));
        sic.add(new SelectorItemInfo("settleItemEntry.id"));
        sic.add(new SelectorItemInfo("qcReportEntry.recBill.id"));
        sic.add(new SelectorItemInfo("qcReportEntry.recBill.number"));
        sic.add(new SelectorItemInfo("qcReportEntry.recBill.bizDate"));
        sic.add(new SelectorItemInfo("qcReportEntry.recBill.description"));
        sic.add(new SelectorItemInfo("qcReportEntry.recBillEntry.id"));
        sic.add(new SelectorItemInfo("qcReportEntry.qcPurReport.qualityOrgUnit.name"));
        sic.add(new SelectorItemInfo("qcReportEntry.qcPurReport.number"));
        sic.add(new SelectorItemInfo("qcReportEntry.qcPurReport.billStatus"));
        sic.add(new SelectorItemInfo("qcReportEntry.qcPurReport.qCStandard.name"));
        sic.add(new SelectorItemInfo("qcReportEntry.qcPurReport.sampleSolution"));
        sic.add(new SelectorItemInfo("qcReportEntry.qcPurReport.reportDate"));
        sic.add(new SelectorItemInfo("qcReportEntry.qcPurReport.checkResult"));
        sic.add(new SelectorItemInfo("qcReportEntry.qcPurReport.deliverQty"));
        sic.add(new SelectorItemInfo("qcReportEntry.qcPurReport.passQty"));
        sic.add(new SelectorItemInfo("qcReportEntry.qcPurReport.unPassQty"));
        sic.add(new SelectorItemInfo("qcReportEntry.qcPurReport.unit.id"));
        sic.add(new SelectorItemInfo("qcReportEntry.qcPurReport.unit.name"));
        sic.add(new SelectorItemInfo("qcReportEntry.qcPurReport.unit.number"));
        sic.add(new SelectorItemInfo("qcReportEntry.qcPurReport.isMRB"));
        sic.add(new SelectorItemInfo("qcReportEntry.qcPurReport.submitResult"));
        sic.add(new SelectorItemInfo("qcReportEntry.qcPurReport.isCalBalPrice"));
        sic.add(new SelectorItemInfo("qcReportEntry.qcPurReport.isSubmitBalPrice"));
        sic.add(new SelectorItemInfo("qcReportEntry.qcPurReport.description"));
        sic.add(new SelectorItemInfo("qcReportEntry.qcPurReport.requestID"));
        sic.add(new SelectorItemInfo("qcReportEntry.qcPurReport.requestEntryID"));
        sic.add(new SelectorItemInfo("qcReportEntry.qcPurReport.sumBillNumber.id"));
        sic.add(new SelectorItemInfo("qcReportEntry.qcPurReport.sumBillNumber.number"));
        sic.add(new SelectorItemInfo("qcReportEntry.qcPurReport.sumBillNumber.settleQuantityS"));
        sic.add(new SelectorItemInfo("qcReportEntry.qcPurReport.sumBillNumber.settleUnitPriceS"));
        sic.add(new SelectorItemInfo("qcReportEntry.qcPurReport.sumBillNumber.settleMoney"));
        sic.add(new SelectorItemInfo("qcReportEntry.qcPurReport.balancePrice"));
        sic.add(new SelectorItemInfo("qcReportEntry.qcPurReport.entrys.id"));
        sic.add(new SelectorItemInfo("qcReportEntry.qcPurReport.entrys.qCItem.id"));
        sic.add(new SelectorItemInfo("qcReportEntry.qcPurReport.entrys.qCItem.dataPrecision"));
        sic.add(new SelectorItemInfo("qcReportEntry.qcPurReport.entrys.checkValue"));
        sic.add(new SelectorItemInfo("qcReportEntry.conPriceRec"));
        sic.add(new SelectorItemInfo("qcReportEntry.settleQuanS"));
        sic.add(new SelectorItemInfo("qcReportEntry.percent"));
        sic.add(new SelectorItemInfo("qcReportEntry.conPriceAvg"));
        sic.add(new SelectorItemInfo("qcReportEntry.moneyAvg"));
        sic.add(new SelectorItemInfo("qcReportEntry.id"));
        return sic;
    }

    public void actionAddLine_actionPerformed(ActionEvent e) throws Exception {
        this.doBeforeAddOrRemoveQcReport();
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("Add_Para_ReportDateBegin", this.editData.getQcReportDateBegin());
        params.put("Add_Para_ReportDateEnd", this.editData.getQcReportDateEnd());
        params.put("Add_Para_RecDateBegin", this.editData.getRecBizDateBegin());
        params.put("Add_Para_RecDateEnd", this.editData.getRecBizDateEnd());
        params.put("Add_Para_PurEntryID", this.editData.getPurContractEntry().getId().toString());
        HashSet<String> excludeReports = new HashSet<String>();
        HQHPCalBillQcReportEntryCollection qcReportEntry = this.editData.getQcReportEntry();
        for (int i = 0; i < qcReportEntry.size(); ++i) {
            excludeReports.add(qcReportEntry.get(i).getQcPurReport().getId().toString());
        }
        params.put("Add_Para_ExcludeReports", excludeReports);
        UIContext uiCtx = new UIContext((Object)this);
        uiCtx.put((Object)"Add_Paras", params);
        uiCtx.put((Object)"UICTX_OwnerCtx", (Object)this.getUIContext());
        uiCtx.put((Object)"Add_Para_Info", this.editData.clone());
        IUIWindow win = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(HQHPCalBillAddQCReportUI.class.getName(), (Map)uiCtx);
        win.show();
        this.doAfterAddQcReport();
    }

    private void doBeforeAddOrRemoveQcReport() {
        BalanceCalPatternEnum settlePriceCalPattern;
        if (this.chkIsWeighed.isSelected()) {
            MsgBox.showInfo((String)HQHPUtil.getMsg("Verify_weightedMaterialCanNotChangeReport"));
            SysUtil.abort();
        }
        if (QMBillBaseStatusEnum.Audit.equals((Object)this.editData.getBillStatus())) {
            MsgBox.showWarning((String)HQHPUtil.getMsg("Verify_OnlyUnAuditBillCanChangeReport"));
            SysUtil.abort();
        }
        if (!BalanceCalPatternEnum.ByAverage.equals((Object)(settlePriceCalPattern = this.editData.getBalanceCalPattern()))) {
            MsgBox.showWarning((String)HQHPUtil.getMsg("Verify_BillByCaseCannotChangeReport"));
            SysUtil.abort();
        }
    }

    private void doAfterAddQcReport() throws Exception {
        Boolean isCancelAdjust = (Boolean)this.getUIContext().get("UICTX_AddReport_IsCancel");
        if (isCancelAdjust == null || isCancelAdjust.booleanValue()) {
            return;
        }
        this.refreshEditUI();
    }

    public void actionRemoveLine_actionPerformed(ActionEvent e) throws Exception {
        this.doBeforeAddOrRemoveQcReport();
        if (this.kdtQcReportEntry.getSelectManager().size() == 0) {
            MsgBox.showWarning((String)HQHPUtil.getMsg("Verify_MustChooseReport"));
            SysUtil.abort();
        }
        int index = this.kdtQcReportEntry.getSelectManager().getActiveRowIndex();
        String reportID = this.kdtQcReportEntry.getCell(index, "reportID").getValue().toString();
        if (MsgBox.showConfirm2((String)HQHPUtil.getMsg("Verify_WillSave")) != 0) {
            SysUtil.abort();
        }
        this.removeLine(this.kdtQcReportEntry);
        HashSet<String> qcReports = new HashSet<String>();
        qcReports.add(reportID);
        HQHPCalBillFactory.getRemoteInstanceWithObjectContext(this.getMainOrgContext()).removeReportsRel(qcReports);
        this.editData.setIsCaled(false);
        HQHPUtil.calcPercentWeight(null, this.editData);
        HQHPCalBillFactory.getRemoteInstanceWithObjectContext(this.getMainOrgContext()).save((CoreBaseInfo)this.editData);
        this.refreshEditUI();
        this.initOldData((IObjectValue)this.editData);
        MsgBox.showInfo((String)HQHPUtil.getMsg("Info_RemoveQCReportSucess"));
    }

    protected boolean confirmRemove() {
        return true;
    }

    @Override
    public void actionViewPurContract_actionPerformed(ActionEvent e) throws Exception {
        HQHPCalBillInfo info = (HQHPCalBillInfo)this.getDataObject();
        String purConID = info.getPurContract().getId().toString();
        this.showUI(PurContractEditUI.class.getName(), purConID);
    }

    @Override
    public void actionViewQCReport_actionPerformed(ActionEvent e) throws Exception {
        if (this.kdtQcReportEntry.getRowCount() == 0 || this.kdtQcReportEntry.getSelectManager().size() == 0) {
            MsgBox.showWarning((String)HQHPUtil.getMsg("Confirm_MustSelectReport"));
            SysUtil.abort();
        }
        int activeRowIndex = this.kdtQcReportEntry.getSelectManager().getActiveRowIndex();
        String qcReportID = this.kdtQcReportEntry.getCell(activeRowIndex, "reportID").getValue().toString();
        this.showUI(QCPurReportEditUI.class.getName(), qcReportID);
    }

    private void showUI(String uiName, String id) {
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"ID", (Object)id);
        try {
            IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UINewTabFactory").create(uiName, (Map)uiContext, null, OprtState.VIEW);
            uiWindow.show();
        }
        catch (UIException e1) {
            this.handleException((Exception)((Object)e1));
        }
    }

    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        if (!this.editData.isIsCaled()) {
            MsgBox.showWarning((String)HQHPUtil.getMsg("Verify_UnCaledBillCannotSubmit"));
            SysUtil.abort();
        }
        this.verifyBeforeSave();
        super.actionSubmit_actionPerformed(e);
    }

    protected boolean isContinueAddNew() {
        return false;
    }

    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        if (QMBillBaseStatusEnum.Audit.equals((Object)this.editData.getBillStatus())) {
            MsgBox.showWarning((String)HQHPUtil.getMsg("Verify_AuditedBillCannotRemove"));
            SysUtil.abort();
        }
        if (!MsgBox.isYes((int)MsgBox.showConfirm2((Component)((Object)this), (String)HQHPUtil.getMsg("Confirm_Delete")))) {
            return;
        }
        ObjectUuidPK pk = new ObjectUuidPK(this.editData.getId());
        super.actionRemove_actionPerformed(e);
        try {
            String tmpState = this.getOprtState();
            this.setOprtState("RELEASEALL");
            this.pubFireVOChangeListener(pk.toString());
            this.setOprtState(tmpState);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (this.editData.getId() == null) {
            this.actionAddLine.setEnabled(false);
            this.actionRemoveLine.setEnabled(false);
        }
    }

    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        if (QMBillBaseStatusEnum.Audit.equals((Object)this.editData.getBillStatus())) {
            MsgBox.showWarning((String)HQHPUtil.getMsg("Verify_AuditedBillCannotEdit"));
            SysUtil.abort();
        }
        super.actionEdit_actionPerformed(e);
    }

    public void actionAudit_actionPerformed(ActionEvent e) throws Exception {
        if (QMBillBaseStatusEnum.Audit.equals((Object)this.editData.getBillStatus())) {
            MsgBox.showWarning((String)HQHPUtil.getMsg("Verify_AuditedBillCannotAudit"));
            SysUtil.abort();
        }
        if (!this.editData.isIsCaled()) {
            MsgBox.showWarning((String)HQHPUtil.getMsg("Verify_NoCaledBillCannotAudit"));
            SysUtil.abort();
        }
        super.actionAudit_actionPerformed(e);
        BigDecimal submitPrice = null;
        BigDecimal settleUnitPriceSA = this.editData.getSettleUnitPriceSA();
        submitPrice = NumericUtils.equalsZero((BigDecimal)settleUnitPriceSA) ? this.editData.getSettleUnitPriceS() : settleUnitPriceSA;
        Set reportIds = this.getReportIDs();
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("Update_Report_Action", "Update_Report_Action_Audit");
        params.put("Update_Report_IDs", reportIds);
        params.put("Update_Report_CalPrice", submitPrice);
        HQHPCalBillFactory.getRemoteInstance().updateReportCalPrice(params);
        this.refreshEditUI();
    }

    private Set getReportIDs() {
        HashSet<String> ids = new HashSet<String>();
        HQHPCalBillQcReportEntryCollection qcReportEntry = this.editData.getQcReportEntry();
        for (int i = 0; i < qcReportEntry.size(); ++i) {
            HQHPCalBillQcReportEntryInfo calBillQcReportEntryInfo = qcReportEntry.get(i);
            ids.add(calBillQcReportEntryInfo.getQcPurReport().getId().toString());
        }
        return ids;
    }

    public void actionUnAudit_actionPerformed(ActionEvent e) throws Exception {
        if (!QMBillBaseStatusEnum.Audit.equals((Object)this.editData.getBillStatus())) {
            MsgBox.showWarning((String)HQHPUtil.getMsg("Verify_OnlyAuditedBillCanUnAudit"));
            SysUtil.abort();
        }
        if (this.editData.isIsSubmitted()) {
            MsgBox.showWarning((String)HQHPUtil.getMsg("Verify_SubmittedBillCannotUnAudit"));
            SysUtil.abort();
        }
        super.actionUnAudit_actionPerformed(e);
        Set reportIds = this.getReportIDs();
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("Update_Report_Action", "Update_Report_Action_UnAudit");
        params.put("Update_Report_IDs", reportIds);
        HQHPCalBillFactory.getRemoteInstance().updateReportCalPrice(params);
        this.refreshEditUI();
    }

    protected IObjectValue createNewDetailData(KDTable table, IRow srcrow) {
        return null;
    }

    public KDTextField getNumTextField() {
        return this.txtNumber;
    }

    protected IObjectValue newInstanceData() throws EASBizException, BOSException {
        HQHPCalBillInfo info = new HQHPCalBillInfo();
        return info;
    }

    @Override
    protected KDTable getDetailTable() {
        return this.kdtQcReportEntry;
    }

    public ITDPrintStrategy getTDPrintStrategy() throws Exception {
        return new HQHPCalBillTDPrintStrategy();
    }

    protected String getAddNewPermItemName() {
        return "qm_HQHPCalBill_addnew";
    }

    @Override
    public void actionViewHQHPCalBillSettle_actionPerformed(ActionEvent e) throws Exception {
        String uiName = HQHPCalBillSettleViewUI.class.getName();
        IUIWindow uiWin = null;
        try {
            HashMap<String, Object> uiContext = new HashMap<String, Object>();
            uiContext.put("Owner", (Object)this);
            uiContext.put("HQHPCalBillInfo", this.editData);
            uiWin = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(uiName, uiContext, null, OprtState.VIEW);
            uiWin.show();
        }
        catch (UIException exp) {
            this.handleException((Exception)((Object)exp));
        }
    }

    protected void initListener() {
        super.initListener();
        this.kDTabbedPane2.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                HQHPCalBillEditUI.this.initActionAddInsertRemoveLineEnabled();
            }
        });
    }

    protected void initActionAddInsertRemoveLineEnabled() {
        if ("EDIT".equals(this.getOprtState()) || "ADDNEW".equals(this.getOprtState())) {
            if (this.isReportEntry()) {
                this.actionAddLine.setEnabled(true);
                this.actionInsertLine.setEnabled(true);
                this.actionRemoveLine.setEnabled(true);
            } else {
                this.actionAddLine.setEnabled(false);
                this.actionInsertLine.setEnabled(false);
                this.actionRemoveLine.setEnabled(false);
            }
        }
    }

    protected boolean isReportEntry() {
        KDPanel p = (KDPanel)this.kDTabbedPane2.getSelectedComponent();
        KDTable t = (KDTable)p.getComponent(0);
        return this.kdtQcReportEntry.equals(t);
    }
}

