/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.qm.qc.client;

import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.qm.common.client.action.BillStatusAction;
import com.kingdee.eas.qm.common.filter.CompositeFilterElement;
import com.kingdee.eas.qm.common.filter.IFilterElement;
import com.kingdee.eas.qm.common.filter.IQueryFilterManager;
import com.kingdee.eas.qm.common.filter.RangeFilterElement;
import com.kingdee.eas.qm.common.filter.SingleFilterElement;
import com.kingdee.eas.qm.common.verify.IVerifyItem;
import com.kingdee.eas.qm.qc.client.AbstractHQHPCalBillFilterUI;
import com.kingdee.eas.qm.qc.client.action.hqhp.CalStatusAction;
import com.kingdee.eas.qm.qc.client.action.hqhp.PricingPatternAction;
import com.kingdee.eas.qm.qc.client.action.hqhp.QuanSettlePatternAction;
import com.kingdee.eas.qm.qc.client.action.hqhp.SettlePriceCalPatternAction;
import com.kingdee.eas.qm.qc.client.action.hqhp.SubmitStatusAction;
import com.kingdee.eas.qm.qc.client.action.hqhp.WeighStatusAction;
import com.kingdee.eas.qm.qc.client.verify.HQHPCalBillFilterNotNullVerifyItem;
import com.kingdee.eas.qm.qc.util.HQHPUtil;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.util.Calendar;
import java.util.Date;
import java.util.HashSet;
import org.apache.log4j.Logger;

public class HQHPCalBillFilterUI
extends AbstractHQHPCalBillFilterUI {
    private static final Logger logger = CoreUIObject.getLogger(HQHPCalBillFilterUI.class);
    public static final String PkBizDateBegin_Name = "pkBizDateBegin";
    public static final String PkBizDateEnd_Name = "pkBizDateEnd";

    public OrgType getMainBizOrgType() {
        return OrgType.Purchase;
    }

    public KDBizPromptBox getMainBizOrg() {
        return this.prmtPurOrgUnit;
    }

    public String getMainBizOrgField() {
        return "purOrgUnit.id";
    }

    public void onLoad() throws Exception {
        super.onLoad();
    }

    protected void setDefaultValue() {
        Calendar c = Calendar.getInstance();
        this.pkBizDateEnd.setValue((Object)c.getTime());
        c.add(2, -1);
        this.pkBizDateBegin.setValue((Object)c.getTime());
    }

    protected void purOrgUnitChanged(DataChangeEvent e) {
        Object[] value = (Object[])e.getNewValue();
        if (value == null || value.equals(e.getOldValue())) {
            return;
        }
        this.changeOrgF7(value);
    }

    protected void afterMainOrgChanged(OrgUnitInfo oldOrg, OrgUnitInfo[] orgs) {
        super.afterMainOrgChanged(oldOrg, orgs);
        this.changeOrgF7(orgs);
    }

    protected void afterMainOrgChanged(OrgUnitInfo oldOrg, OrgUnitInfo org) {
        super.afterMainOrgChanged(oldOrg, org);
        this.changeOrgF7(new Object[]{org});
    }

    private void changeOrgF7(Object[] mainOrgs) {
        this.prmtMaterial.setValue(null);
        this.prmtSupplier.setValue(null);
        HashSet<String> purOrgs = new HashSet<String>();
        HashSet<String> materialCuFilter = new HashSet<String>();
        for (int i = 0; i < mainOrgs.length; ++i) {
            OrgUnitInfo info = (OrgUnitInfo)mainOrgs[i];
            purOrgs.add(info.getId().toString());
            materialCuFilter.add(info.getCU().getId().toString());
        }
        EntityViewInfo supplierEV = new EntityViewInfo();
        FilterInfo supplierFilter = new FilterInfo();
        StringBuffer sql = new StringBuffer();
        sql.append("select FSupplierID from T_BD_SupplierPurchaseInfo where FPurchaseOrgID in ");
        String inSQLFromSet = HQHPUtil.getInSQLFromSet(purOrgs);
        String inner = inSQLFromSet.length() >= 0 ? inSQLFromSet : "";
        sql.append(" (").append(inner).append(")");
        supplierFilter.getFilterItems().add(new FilterItemInfo("id", (Object)sql.toString(), CompareType.INNER));
        supplierEV.setFilter(supplierFilter);
        this.prmtSupplier.setEntityViewInfo(supplierEV);
        this.prmtSupplier.setCurrentCtrlUnit(this.getMainOrgInfo().getCU());
        EntityViewInfo ev = this.prmtMaterial.getEntityViewInfo();
        if (ev == null) {
            ev = new EntityViewInfo();
        }
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("CU.id", materialCuFilter, CompareType.INCLUDE));
        ev.setFilter(filter);
        this.prmtMaterial.setEntityViewInfo(ev);
        this.prmtMaterial.setCurrentCtrlUnit(this.getMainOrgInfo().getCU());
    }

    public void registerQueryFilterManager(IQueryFilterManager manager) {
        this.getFilterManager().getRootElement().getVerifyManager().addVerifyItem((IVerifyItem)new HQHPCalBillFilterNotNullVerifyItem((CoreUIObject)this));
        super.registerQueryFilterManager(manager);
        new BillStatusAction((CoreUIObject)this, this.cmbBillStatus);
        new CalStatusAction((CoreUIObject)this, this.cmbCalStatus);
        new SubmitStatusAction((CoreUIObject)this, this.cmbSubmitStatus);
        new WeighStatusAction((CoreUIObject)this, this.cmbWeighStatus);
        new SettlePriceCalPatternAction((CoreUIObject)this, this.cmbCalPattern);
        new PricingPatternAction((CoreUIObject)this, this.cmbPricingPattern);
        new QuanSettlePatternAction((CoreUIObject)this, this.cmbQuanSettlePattern);
        CompositeFilterElement rootElement = this.getFilterManager().getRootElement();
        SingleFilterElement supplierFilter = new SingleFilterElement("supplier.id", (Component)this.prmtSupplier);
        rootElement.add((IFilterElement)supplierFilter);
        RangeFilterElement bizDateFilter = new RangeFilterElement("calBillDate", (Component)this.pkBizDateBegin, (Component)this.pkBizDateEnd);
        rootElement.add((IFilterElement)bizDateFilter);
        RangeFilterElement numberFilter = new RangeFilterElement("number", (Component)this.txtNumberBegin, (Component)this.txtNumberEnd);
        rootElement.add((IFilterElement)numberFilter);
        SingleFilterElement materialFilter = new SingleFilterElement("material.id", (Component)this.prmtMaterial);
        rootElement.add((IFilterElement)materialFilter);
        SingleFilterElement purConNumFilter = new SingleFilterElement("purContract.number", (Component)this.txtPurConNumber);
        purConNumFilter.setCompareType(CompareType.LIKE);
        rootElement.add((IFilterElement)purConNumFilter);
        SingleFilterElement qcReportNumFilter = new SingleFilterElement("qcPurReport.number", (Component)this.txtQCReportNumber);
        qcReportNumFilter.setCompareType(CompareType.LIKE);
        rootElement.add((IFilterElement)qcReportNumFilter);
        SingleFilterElement calPatternlFilter = new SingleFilterElement("balanceCalPattern", (Component)this.cmbCalPattern);
        rootElement.add((IFilterElement)calPatternlFilter);
        SingleFilterElement pricingPatternFilter = new SingleFilterElement("pricingPattern", (Component)this.cmbPricingPattern);
        rootElement.add((IFilterElement)pricingPatternFilter);
        SingleFilterElement quanSettlePatternFilter = new SingleFilterElement("quanSettlePattern", (Component)this.cmbQuanSettlePattern);
        rootElement.add((IFilterElement)quanSettlePatternFilter);
        SingleFilterElement weighStatusFilter = new SingleFilterElement("isWeigh", (Component)this.cmbWeighStatus);
        rootElement.add((IFilterElement)weighStatusFilter);
        SingleFilterElement calPatternFilter = new SingleFilterElement("isCaled", (Component)this.cmbCalStatus);
        rootElement.add((IFilterElement)calPatternFilter);
        SingleFilterElement submitStatusFilter = new SingleFilterElement("isSubmitted", (Component)this.cmbSubmitStatus);
        rootElement.add((IFilterElement)submitStatusFilter);
        SingleFilterElement billStatusFilter = new SingleFilterElement("billStatus", (Component)this.cmbBillStatus);
        rootElement.add((IFilterElement)billStatusFilter);
    }

    public boolean verify() {
        boolean verifyResult = super.verify();
        Date begin = (Date)this.pkBizDateBegin.getValue();
        Date end = (Date)this.pkBizDateEnd.getValue();
        if (begin != null && end != null && begin.after(end)) {
            this.pkBizDateBegin.requestFocus();
            MsgBox.showInfo((String)HQHPUtil.getMsg("Verify_CalBillDateError"));
            SysUtil.abort();
        }
        return verifyResult;
    }
}

