/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.qm.qc.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.swing.KDFormattedTextField;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.basedata.master.material.MultiMeasureUnitFactory;
import com.kingdee.eas.basedata.master.material.MultiMeasureUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.qm.qc.HQHPCalBillInfo;
import com.kingdee.eas.qm.qc.client.AbstractHQHPCalBillSettleViewUI;
import com.kingdee.eas.qm.qc.util.HQHPUtil;
import com.kingdee.util.StringUtils;
import java.math.BigDecimal;
import java.util.Map;
import org.apache.log4j.Logger;

public class HQHPCalBillSettleViewUI
extends AbstractHQHPCalBillSettleViewUI {
    private static final Logger logger = CoreUIObject.getLogger(HQHPCalBillSettleViewUI.class);
    private HQHPCalBillInfo editData;
    private int qtyScale;
    private int priceScale;

    @Override
    public void storeFields() {
        super.storeFields();
    }

    public void onLoad() throws Exception {
        super.onLoad();
        try {
            Map context = this.getUIContext();
            if (context.get("HQHPCalBillInfo") != null) {
                this.editData = (HQHPCalBillInfo)context.get("HQHPCalBillInfo");
                this.loadFields();
            }
        }
        catch (Exception exp) {
            this.handUIException(exp);
        }
    }

    @Override
    public void loadFields() {
        super.loadFields();
        this.bindComps();
        KDFormattedTextField[] qtyComps = new KDFormattedTextField[]{this.txtNetWeightAmount, this.txtTotalDeductWeight, this.txtDryWeightAmount, this.txtTotalDeductVar, this.txtSupplierDryWeight, this.txtSupplierQuanSum, this.txtSettleQuantityS2, this.txtSettleQuantityI3, this.txtSettleQuantitySA2, this.txtSettleQuantityI4, this.txtSettleQuantitySA3, this.txtSettleQuantityS3, this.txtQuantityDiffS, this.txtSettleQuantityI5};
        KDFormattedTextField[] priceComps = new KDFormattedTextField[]{this.txtConProPrice, this.txtConUnitPrice, this.txtSettleUnitPriceS2, this.txtSettleUnitPriceI2, this.txtSettleUnitPriceSA2, this.txtSettleUnitPriceIA2, this.txtSettleUnitPriceSA3, this.txtSettleUnitPriceS3, this.txtUniPriceDiffS, this.txtSettleUnitPriceIA3, this.txtSettleUnitPriceI3, this.txtUniPriceDiffI};
        KDFormattedTextField[] moneyComps = new KDFormattedTextField[]{this.txtPurMoneyRef, this.txtSettleMoney2, this.txtSettleMoneyA2, this.txtSettleMoneyA3, this.txtSettleMoney3, this.txtMoneyDiff};
        try {
            this.initQtyScale();
            this.initPriceScale();
        }
        catch (Exception e) {
            this.handUIException(e);
        }
        this.setTextFormat(qtyComps, priceComps, moneyComps);
    }

    private void bindComps() {
        if (this.editData == null) {
            return;
        }
        BigDecimal netWeightAmount = this.editData.getNetWeightAmount();
        this.txtNetWeightAmount.setValue((Object)netWeightAmount);
        BigDecimal totalDeductWeight = this.editData.getTotalDeductWeight();
        this.txtTotalDeductWeight.setValue((Object)totalDeductWeight);
        BigDecimal dryWeightAmount = this.editData.getDryWeightAmount();
        this.txtDryWeightAmount.setValue((Object)dryWeightAmount);
        BigDecimal totalDeductVar = this.editData.getTotalDeductVar();
        this.txtTotalDeductVar.setValue((Object)totalDeductVar);
        BigDecimal protectivePrice = this.editData.getProtectivePrice();
        this.txtConProPrice.setValue((Object)protectivePrice);
        BigDecimal supplierDryWeight = this.editData.getSupplierDryWeight();
        this.txtSupplierDryWeight.setValue((Object)supplierDryWeight);
        BigDecimal unitPrice = this.editData.getUnitPrice();
        this.txtConUnitPrice.setValue((Object)unitPrice);
        BigDecimal supplierQuanSum = this.editData.getSupplierAmount();
        this.txtSupplierQuanSum.setValue((Object)supplierQuanSum);
        BigDecimal purMoneyRef = this.editData.getPurMoneyRef();
        this.txtPurMoneyRef.setValue((Object)purMoneyRef);
        BigDecimal uniPriceDiffS = this.editData.getUniPriceDiffS();
        this.txtUniPriceDiffS.setValue((Object)uniPriceDiffS);
        BigDecimal quantityDiffS = this.editData.getQuantityDiffS();
        this.txtQuantityDiffS.setValue((Object)quantityDiffS);
        BigDecimal moneyDiff = this.editData.getMoneyDiff();
        this.txtMoneyDiff.setValue((Object)moneyDiff);
        BigDecimal uniPriceDiffI = this.editData.getUniPriceDiffI();
        this.txtUniPriceDiffI.setValue((Object)uniPriceDiffI);
        this.prmtUnit2.setValue((Object)this.editData.getPurContractEntry().getUnit());
        this.prmtCurrency2.setValue((Object)this.editData.getPurContract().getCurrency());
        this.cmbPricingPattern2.setSelectedItem((Object)this.editData.getPricingPattern());
        this.cmbQuanSettlePattern2.setSelectedItem((Object)this.editData.getQuanSettlePattern());
        this.cmbStPriceCalPattern2.setSelectedItem((Object)this.editData.getBalanceCalPattern());
        this.txtAdjustPerson.setText(this.editData.getAdjustPerson());
        this.txtAdjustReason.setText(this.editData.getAdjustReason());
        this.pkAdjustDate.setValue((Object)this.editData.getAdjustDate());
        BigDecimal settleUnitPriceSA = this.editData.getSettleUnitPriceSA();
        this.txtSettleUnitPriceSA2.setValue((Object)settleUnitPriceSA);
        this.txtSettleUnitPriceSA3.setValue((Object)settleUnitPriceSA);
        BigDecimal settleUnitPriceS = this.editData.getSettleUnitPriceS();
        this.txtSettleUnitPriceS2.setValue((Object)settleUnitPriceS);
        this.txtSettleUnitPriceS3.setValue((Object)settleUnitPriceS);
        BigDecimal settleQuantitySA = this.editData.getSettleQuantitySA();
        this.txtSettleQuantitySA2.setValue((Object)settleQuantitySA);
        this.txtSettleQuantitySA3.setValue((Object)settleQuantitySA);
        BigDecimal settleQuantityS = this.editData.getSettleQuantityS();
        this.txtSettleQuantityS2.setValue((Object)settleQuantityS);
        this.txtSettleQuantityS3.setValue((Object)settleQuantityS);
        BigDecimal settleMoneyA = this.editData.getSettleMoneyA();
        this.txtSettleMoneyA2.setValue((Object)settleMoneyA);
        this.txtSettleMoneyA3.setValue((Object)settleMoneyA);
        BigDecimal settleMoney = this.editData.getSettleMoney();
        this.txtSettleMoney2.setValue((Object)settleMoney);
        this.txtSettleMoney3.setValue((Object)settleMoney);
        BigDecimal settleUnitPriceIA = this.editData.getSettleUnitPriceIA();
        this.txtSettleUnitPriceIA2.setValue((Object)settleUnitPriceIA);
        this.txtSettleUnitPriceIA3.setValue((Object)settleUnitPriceIA);
        BigDecimal settleUnitPriceI = this.editData.getSettleUnitPriceI();
        this.txtSettleUnitPriceI2.setValue((Object)settleUnitPriceI);
        this.txtSettleUnitPriceI3.setValue((Object)settleUnitPriceI);
        BigDecimal settleQuantityI = this.editData.getSettleQuantityI();
        this.txtSettleQuantityI3.setValue((Object)settleQuantityI);
        this.txtSettleQuantityI4.setValue((Object)settleQuantityI);
        this.txtSettleQuantityI5.setValue((Object)settleQuantityI);
    }

    private void initQtyScale() throws EASBizException, BOSException {
        this.qtyScale = 2;
        if (this.editData != null) {
            MultiMeasureUnitInfo multiUnitInfo;
            HQHPCalBillInfo info = this.editData;
            if (info.getPurOrgUnit() == null) {
                return;
            }
            String paramValue = HQHPUtil.getQtyParamValue(null, "HQHP001", info.getPurOrgUnit().getId().toString());
            if (!StringUtils.isEmpty((String)paramValue) && !"DEFAULT".equals(paramValue)) {
                this.qtyScale = Integer.parseInt(paramValue);
            } else if (info.getPurContractEntry() != null && info.getPurContractEntry().getUnit() != null && info.getPurContractEntry().getMaterial() != null && (multiUnitInfo = MultiMeasureUnitFactory.getRemoteInstance().getMultiUnit(info.getPurContractEntry().getMaterial().getId().toString(), info.getPurContractEntry().getUnit().getId().toString())) != null) {
                this.qtyScale = multiUnitInfo.getQtyPrecision();
            }
        }
    }

    private void initPriceScale() throws EASBizException, BOSException {
        this.priceScale = 4;
        if (this.editData != null) {
            HQHPCalBillInfo info = this.editData;
            if (info.getPurOrgUnit() == null) {
                return;
            }
            String paramValue = HQHPUtil.getPriceParamValue(null, "HQHP002", info.getPurOrgUnit().getId().toString());
            if (!StringUtils.isEmpty((String)paramValue) && !"DEFAULT".equals(paramValue)) {
                this.priceScale = Integer.parseInt(paramValue);
            }
        }
    }

    private void setTextFormat(KDFormattedTextField[] qtys, KDFormattedTextField[] prices, KDFormattedTextField[] moneys) {
        int i;
        for (i = 0; i < qtys.length; ++i) {
            qtys[i].setHorizontalAlignment(4);
            qtys[i].setRemoveingZeroInDispaly(false);
            qtys[i].setPrecision(this.qtyScale);
        }
        for (i = 0; i < prices.length; ++i) {
            prices[i].setHorizontalAlignment(4);
            prices[i].setRemoveingZeroInDispaly(false);
            prices[i].setPrecision(this.priceScale);
        }
        for (i = 0; i < moneys.length; ++i) {
            moneys[i].setHorizontalAlignment(4);
            moneys[i].setRemoveingZeroInDispaly(false);
            moneys[i].setPrecision(2);
        }
    }
}

