/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.qm.qc.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataRequestEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditListener;
import com.kingdee.bos.ctrl.kdf.util.render.CellCheckBoxRenderer;
import com.kingdee.bos.ctrl.kdf.util.render.IBasicRender;
import com.kingdee.bos.ctrl.swing.util.CtrlFormatUtilities;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIException;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.qm.common.util.KDTableUtils;
import com.kingdee.eas.qm.qc.client.AbstractHQHPPickWBListUI;
import com.kingdee.eas.qm.qc.client.HQHPCalBillCreateListUI;
import com.kingdee.eas.qm.qc.util.HQHPUtil;
import java.awt.event.ActionEvent;
import java.text.DateFormat;
import java.util.Date;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.swing.AbstractButton;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class HQHPPickWBListUI
extends AbstractHQHPPickWBListUI {
    private static final long serialVersionUID = 1L;
    public static final String COL_selected = "isSelected";
    public static final String Col_WB_ID = "id";
    private Set unSelectWBs = new HashSet();
    private String purEntryId;
    private Map ownerUnSelectWeighBills;
    private Map ownerFilterParams;
    private boolean isWbFinishQC = true;
    private KDTEditListener cellInEdittingListener = null;
    private ChangeListener radioOKWbListener = null;
    private ChangeListener radioErrorWbListener = null;
    private boolean hasCellInEditting;
    private int edittingCellRowIndex;
    private int edittingCellColIndex;
    private Object edittingCellNewValue;
    private FilterItemInfo weighProcessFilter = null;
    private FilterInfo hasFinishQCFilter = null;
    private FilterInfo hasNotFinishQCFilter = null;

    public void onLoad() throws Exception {
        this.beforeOnLoad();
        super.onLoad();
        this.addListener();
        this.configUI();
    }

    private void beforeOnLoad() {
        this.purEntryId = (String)this.getUIContext().get("CTX_CUR_PURENTRY");
        HQHPCalBillCreateListUI owner = (HQHPCalBillCreateListUI)((Object)this.getUIContext().get("Owner"));
        this.ownerUnSelectWeighBills = owner.getUnSelectWeighBills();
        if (this.ownerUnSelectWeighBills.get(this.purEntryId) != null) {
            this.unSelectWBs = (Set)this.ownerUnSelectWeighBills.get(this.purEntryId);
        }
        this.ownerFilterParams = owner.getFilterParams();
        this.removeListener();
    }

    private void removeListener() {
        this.tblMain.removeKDTEditListener(this.cellInEdittingListener);
        this.radioOKWb.removeChangeListener(this.radioOKWbListener);
        this.radioErrorWb.removeChangeListener(this.radioErrorWbListener);
    }

    private void addListener() {
        this.radioOKWbListener = new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                HQHPPickWBListUI.this.isWBFinishQCChanged();
            }
        };
        this.radioOKWb.addChangeListener(this.radioOKWbListener);
        this.radioErrorWbListener = new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                HQHPPickWBListUI.this.isWBFinishQCChanged();
            }
        };
        this.radioErrorWb.addChangeListener(this.radioErrorWbListener);
        this.cellInEdittingListener = new KDTEditListener(){

            public void editCanceled(KDTEditEvent e) {
            }

            public void editStarted(KDTEditEvent e) {
                HQHPPickWBListUI.this.hasCellInEditting = true;
                HQHPPickWBListUI.this.edittingCellColIndex = e.getColIndex();
                HQHPPickWBListUI.this.edittingCellRowIndex = e.getRowIndex();
            }

            public void editStarting(KDTEditEvent e) {
            }

            public void editStopped(KDTEditEvent e) {
                HQHPPickWBListUI.this.hasCellInEditting = false;
            }

            public void editStopping(KDTEditEvent e) {
            }

            public void editValueChanged(KDTEditEvent e) {
                HQHPPickWBListUI.this.edittingCellNewValue = e.getValue();
            }
        };
        this.tblMain.addKDTEditListener(this.cellInEdittingListener);
    }

    protected void isWBFinishQCChanged() {
        boolean changed = this.radioOKWb.isSelected();
        if (changed == this.isWbFinishQC) {
            return;
        }
        this.isWbFinishQC = changed;
        if (!this.isWbFinishQC) {
            this.storeUnSelectWBs();
        }
        this.tblMain.getColumn(COL_selected).getStyleAttributes().setHided(!this.isWbFinishQC);
        this.reFillData();
    }

    private void reFillData() {
        EntityViewInfo mainQuery = super.getMainQuery();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(this.weighProcessFilter);
        mainQuery.setFilter(filter);
        try {
            mainQuery.getFilter().mergeFilter(this.isWbFinishQC ? this.hasFinishQCFilter : this.hasNotFinishQCFilter, "AND");
        }
        catch (BOSException e) {
            this.handUIException(e);
        }
        this.execQuery();
    }

    protected boolean checkBeforeWindowClosing() {
        return super.checkBeforeWindowClosing();
    }

    private void storeToOwnerContext() {
        if (this.unSelectWBs.size() > 0) {
            this.ownerUnSelectWeighBills.put(this.purEntryId, this.unSelectWBs);
        }
    }

    private void storeUnSelectWBs() {
        int rowCount = this.tblMain.getBody().size();
        for (int i = 0; i < rowCount; ++i) {
            Object id;
            IRow row = this.tblMain.getRow(i);
            if (row == null) continue;
            Boolean isSelected = (Boolean)row.getCell(COL_selected).getValue();
            if (isSelected != null && !isSelected.booleanValue() && (id = row.getCell(Col_WB_ID).getValue()) != null) {
                this.unSelectWBs.add(id.toString());
            }
            if (isSelected == null || !isSelected.booleanValue() || (id = row.getCell(Col_WB_ID).getValue()) == null) continue;
            this.unSelectWBs.remove(id.toString());
        }
    }

    private void submitCellEdit() {
        if (this.hasCellInEditting) {
            this.tblMain.getCell(this.edittingCellRowIndex, this.edittingCellColIndex).setValue(this.edittingCellNewValue);
        }
    }

    private void configUI() {
        this.actionSelectAll.setEnabled(true);
        this.actionSelectNone.setEnabled(true);
        this.actionConfirm.setEnabled(true);
        this.radioGroup.add((AbstractButton)this.radioOKWb);
        this.radioGroup.add((AbstractButton)this.radioErrorWb);
        this.radioOKWb.setSelected(true);
        this.tblMain.checkParsed();
        this.tblMain.getSelectManager().setSelectMode(2);
        this.tblMain.getDataRequestManager().setDataRequestMode(1);
        this.tblMain.getStyleAttributes().setLocked(true);
        this.tblMain.getColumn(COL_selected).setRenderer((IBasicRender)new CellCheckBoxRenderer());
        this.tblMain.getColumn(COL_selected).getStyleAttributes().setLocked(false);
        KDTableUtils.setNumberColumnsFormat((KDTable)this.tblMain, (String[])new String[]{"grossWeight", "tareWeight", "incidental", "netWeight", "report.deliverQty", "report.passQty", "report.unPassQty"});
        Date weighDateBegin = (Date)this.ownerFilterParams.get("Para_WeighDateBegin");
        Date weighDateEnd = (Date)this.ownerFilterParams.get("Para_WeighDateEnd");
        DateFormat sdf = CtrlFormatUtilities.getDateFormat();
        Object[] dates = new String[]{weighDateBegin != null ? sdf.format(weighDateBegin) : " ", weighDateEnd != null ? sdf.format(weighDateEnd) : " "};
        this.contTitle.setTitle(HQHPUtil.getMsg("TEXT_PickWBTitle", dates));
    }

    protected boolean isFootVisible() {
        return true;
    }

    protected void afterTableFillData(KDTDataRequestEvent e) {
        int firstRow = e.getFirstRow();
        int lastRow = e.getLastRow();
        this.afterFilldata(firstRow, lastRow);
    }

    private void afterFilldata(int firstRow, int lastRow) {
        if (this.unSelectWBs.size() == 0) {
            this.doSelectAll(firstRow, lastRow);
        } else {
            this.doSelectBySync(firstRow, lastRow);
        }
    }

    private void doSelectBySync(int firstRow, int lastRow) {
        for (int i = firstRow; i <= lastRow; ++i) {
            ICell cell;
            IRow row = this.tblMain.getRow(i);
            Object wbId = this.tblMain.getRow(i).getCell(Col_WB_ID).getValue();
            if (wbId != null && this.unSelectWBs.contains(wbId.toString())) {
                cell = row.getCell(COL_selected);
                if (cell == null) continue;
                cell.setValue((Object)Boolean.FALSE);
                continue;
            }
            cell = row.getCell(COL_selected);
            if (cell == null) continue;
            cell.setValue((Object)Boolean.TRUE);
        }
    }

    protected FilterInfo getDefaultFilterForQuery() {
        FilterInfo superFilter = super.getDefaultFilterForQuery();
        this.weighProcessFilter = new FilterItemInfo(Col_WB_ID, (Object)this.getFilterInWBProcess(), CompareType.INNER);
        superFilter.getFilterItems().add(this.weighProcessFilter);
        this.hasFinishQCFilter = new FilterInfo();
        this.hasFinishQCFilter.getFilterItems().add(new FilterItemInfo("report.billStatus", (Object)new Integer(30)));
        this.hasNotFinishQCFilter = new FilterInfo();
        this.hasNotFinishQCFilter.getFilterItems().add(new FilterItemInfo("report.billStatus", (Object)new Integer(30), CompareType.NOTEQUALS));
        this.hasNotFinishQCFilter.getFilterItems().add(new FilterItemInfo("report.id", null, CompareType.IS));
        this.hasNotFinishQCFilter.setMaskString("#0 or #1");
        try {
            superFilter.mergeFilter(this.isWbFinishQC ? this.hasFinishQCFilter : this.hasNotFinishQCFilter, "AND");
        }
        catch (BOSException e) {
            this.handUIException(e);
        }
        return superFilter;
    }

    private String getFilterInQCProcess() {
        StringBuffer sql = new StringBuffer();
        sql.append("select wb.fid from t_wm_weighbill as wb \n");
        sql.append("left outer join t_wm_weighnoticebillentry as wnbe \n");
        sql.append("on wnbe.fid = wb.fsourcebillentryid \n");
        sql.append("left outer join t_qm_qcrequestrelweighentry as relWeighEntry \n");
        sql.append("on relWeighEntry.frelnoticeentryid = wnbe.fid \n");
        sql.append("left outer join t_qm_qcreport as report \n");
        sql.append("on report.frequestentryid = relWeighEntry.FMaterialEntryID \n");
        sql.append("left outer join t_qm_qcrequestentry as requestEntry \n");
        sql.append("on requestEntry.fid = report.frequestentryid \n");
        sql.append("left outer join T_IM_PurReceivalentry as rece \n");
        sql.append("on rece.fid = requestEntry.fsourcebillentryid  \n");
        sql.append("left outer join T_SM_PurOrderEntry as orderEntry \n");
        sql.append("on orderEntry.fid = rece.FpurorderentryID \n");
        sql.append("left outer join t_qm_qcreportncpprentry as ncprentry \n");
        sql.append("on ncprentry.fparentid = report.fid \n");
        sql.append("left outer join t_qm_dpprocessmode as dpmode \n");
        sql.append("on dpmode.fid = ncprentry.fdpprocessmodeid \n");
        sql.append("where orderEntry.fsourcebillentryid = '").append(this.purEntryId).append("' \n");
        sql.append("and report.fbillstatus = 30 \n");
        return sql.toString();
    }

    private String getFilterInWBProcess() {
        StringBuffer sql = new StringBuffer();
        sql.append("select wb.fid from t_wm_weighbill as wb \n");
        sql.append("left outer join t_wm_weighnoticebillentry as wnbe \n");
        sql.append("on wnbe.fid = wb.fsourcebillentryid \n");
        sql.append("left outer join T_IM_PurReceivalentry as rece \n");
        sql.append("on wnbe.fsourcebillentryid = rece.fid \n");
        sql.append("left outer join T_SM_PurOrderEntry as orderEntry \n");
        sql.append("on orderEntry.fid = rece.FpurorderentryID \n");
        sql.append("where orderEntry.fsourcebillentryid = '").append(this.purEntryId).append("' \n");
        Date weighDateBegin = (Date)this.ownerFilterParams.get("Para_WeighDateBegin");
        Date weighDateEnd = (Date)this.ownerFilterParams.get("Para_WeighDateEnd");
        if (weighDateBegin != null) {
            sql.append("and wb.FLatestWeighTime > to_date('").append(HQHPUtil.formatStartDate(weighDateBegin)).append("') \n");
        }
        if (weighDateEnd != null) {
            sql.append("and wb.FLatestWeighTime < to_date('").append(HQHPUtil.formatEndDate(weighDateEnd)).append("') \n");
        }
        sql.append("and wb.FBillStatus = 30 and wb.FWeighStatus = 3 \n");
        sql.append("and wb.FHQHPCalBillID is null \n");
        return sql.toString();
    }

    @Override
    public void actionSelectAll_actionPerformed(ActionEvent e) throws Exception {
        int firstRow = 0;
        int lastRow = this.tblMain.getRowCount3() - 1;
        this.doSelectAll(firstRow, lastRow);
    }

    private void doSelectAll(int firstRow, int lastRow) {
        for (int i = firstRow; i <= lastRow; ++i) {
            ICell cell = this.tblMain.getCell(i, COL_selected);
            if (cell == null) continue;
            cell.setValue((Object)Boolean.TRUE);
        }
    }

    @Override
    public void actionSelectNone_actionPerformed(ActionEvent e) throws Exception {
        for (int i = 0; i < this.tblMain.getRowCount3(); ++i) {
            this.tblMain.getCell(i, COL_selected).setValue((Object)Boolean.FALSE);
        }
    }

    @Override
    public void actionConfirm_actionPerformed(ActionEvent e) throws Exception {
        this.submitCellEdit();
        this.storeUnSelectWBs();
        this.storeToOwnerContext();
        this.uiWindow.close();
    }

    public void actionView_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        UIContext uiContext = new UIContext((Object)this);
        uiContext.putAll(this.getUIContext());
        uiContext.put((Object)"ID", (Object)this.getSelectedKeyValue());
        try {
            IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(this.getEditUIName(), (Map)uiContext, null, OprtState.VIEW);
            CoreUI editUI = (CoreUI)uiWindow.getUIObject();
            editUI.getUIMenuBar().setVisible(false);
            editUI.getUIToolBar().setVisible(false);
            uiWindow.show();
        }
        catch (UIException e1) {
            this.handleException((Exception)((Object)e1));
        }
    }

    protected String getEditUIName() {
        return "com.kingdee.eas.wm.weigh.client.WeighBillEditUI";
    }

    public String getEditUIModal() {
        return "com.kingdee.eas.base.uiframe.client.UIModelDialogFactory";
    }

    protected ICoreBase getBizInterface() throws Exception {
        return null;
    }

    protected OrgType getMainBizOrgType() {
        return OrgType.Storage;
    }
}

