/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.qm.qc.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.appframework.client.servicebinding.ActionProxyFactory;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.ctrl.swing.KDMenuItem;
import com.kingdee.bos.ctrl.swing.util.CtrlFormatUtilities;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.query.BizEnumValueDTO;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IItemAction;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.eas.base.commonquery.client.CommonQueryDialog;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBillBaseCollection;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.mm.common.client.KDTableUtils;
import com.kingdee.eas.qm.basedata.QCBizTypeEnum;
import com.kingdee.eas.qm.common.client.QMCoreBaseFilterUI;
import com.kingdee.eas.qm.common.client.util.QMClientUtils;
import com.kingdee.eas.qm.common.print.ITDPrintStrategy;
import com.kingdee.eas.qm.common.verify.AbstractVerifyItem;
import com.kingdee.eas.qm.common.verify.IVerifyItem;
import com.kingdee.eas.qm.common.verify.IVerifyManager;
import com.kingdee.eas.qm.common.verify.VerifyManager;
import com.kingdee.eas.qm.qc.IQCBill;
import com.kingdee.eas.qm.qc.QCBillFactory;
import com.kingdee.eas.qm.qc.QCBillInfo;
import com.kingdee.eas.qm.qc.QCBillSampleEntryCollection;
import com.kingdee.eas.qm.qc.QCBillSampleEntryFactory;
import com.kingdee.eas.qm.qc.QCBillSampleEntryInfo;
import com.kingdee.eas.qm.qc.QCReinspectReqInfo;
import com.kingdee.eas.qm.qc.QCReportCreateResult;
import com.kingdee.eas.qm.qc.QCReportInfo;
import com.kingdee.eas.qm.qc.QCUITypeEnum;
import com.kingdee.eas.qm.qc.client.AbstractQCBillListUI;
import com.kingdee.eas.qm.qc.client.print.QCBillTDPrintStrategyFactory;
import com.kingdee.eas.qm.qc.client.util.QCUIBizTypeUtil;
import com.kingdee.eas.qm.qc.client.util.QMBotpInstanceUIHelper;
import com.kingdee.eas.qm.qc.client.util.qcreport.QCReportCreateResultHelper;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.Action;
import javax.swing.JMenuItem;
import org.apache.log4j.Logger;

public class QCBillListUI
extends AbstractQCBillListUI {
    private static final long serialVersionUID = 2529790712507512237L;
    public static final String COL_SAMPLEQTY = "sampleEntries.sampleQty";
    public static final String COL_EACHSAMPLEQTY = "sampleEntries.eachSampleQty";
    public static final String COL_SAMPLESHARES = "sampleEntries.sampleShares";
    private static final Logger logger = CoreUIObject.getLogger(QCBillListUI.class);

    public QCBillListUI() throws Exception {
        this.btnCreateTo.setAction((Action)((IItemAction)ActionProxyFactory.getProxy((Object)((Object)this.actionCreateToQCReport), (Class[])new Class[]{IItemAction.class}, (Map)this.getServiceContext())));
        this.btnCreateTo.setText(this.getMultiLangString("CreateTo"));
        KDMenuItem createToReportMenuItem = new KDMenuItem(this.btnCreateToQCReport.getText());
        createToReportMenuItem.setToolTipText(this.btnCreateToQCReport.getToolTipText());
        createToReportMenuItem.setAction((Action)((IItemAction)ActionProxyFactory.getProxy((Object)((Object)this.actionCreateToQCReport), (Class[])new Class[]{IItemAction.class}, (Map)this.getServiceContext())));
        this.btnCreateToQCReport.setVisible(false);
        this.btnCreateTo.addAssistMenuItem((JMenuItem)createToReportMenuItem);
        KDMenuItem createToReinspectReqMenuItem = new KDMenuItem(this.btnCreateToQCReinspectReq.getText());
        createToReinspectReqMenuItem.setToolTipText(this.btnCreateToQCReinspectReq.getToolTipText());
        createToReinspectReqMenuItem.setAction((Action)((IItemAction)ActionProxyFactory.getProxy((Object)((Object)this.actionCreateToQCReinspectReq), (Class[])new Class[]{IItemAction.class}, (Map)this.getServiceContext())));
        this.btnCreateToQCReinspectReq.setVisible(false);
        this.btnCreateTo.addAssistMenuItem((JMenuItem)createToReinspectReqMenuItem);
        this.btnWorkFlowG.setVisible(false);
        this.btnAuditResult.setVisible(false);
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.setColumnVisible();
        this.menuItemCreateTo.setVisible(false);
        this.actionAddNew.setVisible(false);
        this.tblMain.getColumn("auditDate").getStyleAttributes().setNumberFormat(CtrlFormatUtilities.getDateFormatString());
        this.tblMain.getColumn("sampleEntries.reqFinishDate").getStyleAttributes().setNumberFormat(CtrlFormatUtilities.getDateFormatString());
        this.tblMain.getColumn("sampleEntries.verifyDate").getStyleAttributes().setNumberFormat(CtrlFormatUtilities.getDateTimeFormatString());
        com.kingdee.eas.qm.common.util.KDTableUtils.setFieldsHorizontalAlignment((Styles.HorizontalAlignment)Styles.HorizontalAlignment.RIGHT, (KDTable)this.tblMain, (String[])new String[]{COL_SAMPLEQTY, COL_EACHSAMPLEQTY, COL_SAMPLESHARES});
        this.actionTDPrint.setEnabled(false);
        this.actionTDPrint.setVisible(false);
        this.actionTDPrintPreview.setEnabled(false);
        this.actionTDPrintPreview.setVisible(false);
    }

    protected void setColumnVisible() {
        String[] hiddenColl = this.getAllHiddenColl(this.getQCBizType());
        QMClientUtils.setHided((KDTable)this.tblMain, (String[])hiddenColl, (boolean)true);
        String[] visibleColl = this.getBizVisibleColl(this.getQCBizType());
        QMClientUtils.setHided((KDTable)this.tblMain, (String[])visibleColl, (boolean)false);
    }

    public String[] getAllHiddenColl(QCUITypeEnum bizType) {
        return new String[]{"billType.name", "sampleEntries.isResResult"};
    }

    public String[] getBizVisibleColl(QCUITypeEnum bizType) {
        if (bizType == QCUITypeEnum.purCheck) {
            return new String[0];
        }
        if (bizType == QCUITypeEnum.invCheck) {
            return new String[]{"billType.name", "sampleEntries.isResResult"};
        }
        if (bizType == QCUITypeEnum.pdtCheck) {
            return new String[]{"billType.name", "sampleEntries.isResResult"};
        }
        if (bizType == QCUITypeEnum.otherCheck) {
            return new String[]{"billType.name", "sampleEntries.isResResult"};
        }
        return new String[]{"billType.name", "sampleEntries.isResResult"};
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.menuCreateToFromQCBill.setIcon(QMClientUtils.getIcon((String)"imgTbtn_zoomdown"));
        this.btnCreateTo.setIcon(QMClientUtils.getIcon((String)"imgTbtn_zoomdown"));
    }

    @Override
    protected ICoreBase getBizInterface() throws Exception {
        return QCBillFactory.getRemoteInstanceWithObjectContext(this.getMainOrgContext());
    }

    protected Class getEntityModel() {
        return IQCBill.class;
    }

    @Override
    protected IObjectValue createNewData() {
        QCBillInfo objectValue = new QCBillInfo();
        return objectValue;
    }

    public List getDestBosTypeForBotp(CoreBillBaseCollection srcBillInfos, List destBosTypeList) {
        if (destBosTypeList != null && destBosTypeList.size() > 0) {
            Iterator it = destBosTypeList.iterator();
            while (it.hasNext()) {
                if (this.getUIContext().get("currentCreateTo").equals(it.next())) continue;
                it.remove();
            }
        }
        return destBosTypeList;
    }

    public void beforeTransform(IObjectCollection srcObjCols, String destBillBosType) {
        boolean isReport = this.getUIContext().get("currentCreateTo").equals(new QCReportInfo().getBOSType().toString());
        ArrayList l = this.getUIContext().get("sampleids") == null ? new ArrayList() : (List)this.getUIContext().get("sampleids");
        for (QCBillInfo info : srcObjCols) {
            if (info.getSampleEntries() == null || info.size() <= 0) {
                this.handleException(new Exception(this.getMultiLangString("qcBill") + info + this.getMultiLangString("notExistsSampleEntry")));
            }
            Iterator it = info.getSampleEntries().iterator();
            while (it.hasNext()) {
                QCBillSampleEntryInfo entryInfo = (QCBillSampleEntryInfo)it.next();
                if (isReport) {
                    if (entryInfo.isIsResResult() && !entryInfo.isIsReinspect() && !entryInfo.isIsQCReport()) continue;
                    it.remove();
                    continue;
                }
                if (!entryInfo.isIsResResult() && !entryInfo.isIsReinspect()) {
                    if (l.contains(entryInfo.getId().toString())) continue;
                    it.remove();
                    continue;
                }
                it.remove();
            }
        }
    }

    public String getEntriesName() {
        return "sampleEntries";
    }

    @Override
    public void actionCreateToQCReinspectReq_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        this.getUIContext().put("QCBizType", this.getQCBizType());
        this.getUIContext().put("currentCreateTo", new QCReinspectReqInfo().getBOSType().toString());
        List sampleids = KDTableUtils.getSelectedRows((KDTable)this.tblMain, (String)"sampleEntries.id");
        this.getUIContext().put("sampleids", sampleids);
        if (this.isCreateTo(false)) {
            super.actionCreateTo_actionPerformed(e);
            this.refresh(null);
        }
    }

    @Override
    public void actionCreateToQCReport_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        this.getUIContext().put("currentCreateTo", new QCReportInfo().getBOSType().toString());
        if (this.isCreateTo(true)) {
            if (0 != MsgBox.showConfirm2((Component)((Object)this), (String)this.getMultiLangString("qcConfimReport"))) {
                SysUtil.abort();
            }
            HashMap<Object, Object> idMap = new HashMap<Object, Object>();
            List requestEntryIDS = KDTableUtils.getSelectedRows((KDTable)this.tblMain, (String)"requestEntryID");
            List requestIDS = KDTableUtils.getSelectedRows((KDTable)this.tblMain, (String)"requestID");
            List requestEntrynumbers = KDTableUtils.getSelectedRows((KDTable)this.tblMain, (String)"requestEntryNum");
            List requestnumbers = KDTableUtils.getSelectedRows((KDTable)this.tblMain, (String)"requestNum");
            List numbers = KDTableUtils.getSelectedRows((KDTable)this.tblMain, (String)"number");
            List qualityOrgUnitIDS = KDTableUtils.getSelectedRows((KDTable)this.tblMain, (String)"qualityOrgUnit.id");
            List qcBillIDS = KDTableUtils.getSelectedRows((KDTable)this.tblMain, (String)"id");
            int n = requestEntryIDS.size();
            for (int i = 0; i < n; ++i) {
                String key;
                ArrayList<String> ids;
                ArrayList<String> arrayList = ids = idMap.get(qualityOrgUnitIDS.get(i)) == null ? null : (ArrayList<String>)idMap.get(qualityOrgUnitIDS.get(i));
                if (ids == null) {
                    ids = new ArrayList<String>();
                }
                if (!ids.contains(key = requestIDS.get(i) + "<#>" + requestEntryIDS.get(i) + "<#>" + qcBillIDS.get(i) + "<#>" + requestnumbers.get(i) + "<&>" + requestEntrynumbers.get(i) + "<#>" + numbers.get(i))) {
                    ids.add(key);
                }
                idMap.put(qualityOrgUnitIDS.get(i), ids);
            }
            QCUITypeEnum uiType = this.getQCBizType();
            QCBizTypeEnum[] bizTypes = QCUIBizTypeUtil.getQCBizTypes(uiType);
            idMap.put("QCBizType", bizTypes);
            List l = QCBillFactory.getRemoteInstance().createToQCReport(idMap);
            this.showCreateFromResultSet(l);
            this.refresh(null);
        }
    }

    protected void showCreateFromResultSet(List l) throws Exception {
        if (l == null || l.size() <= 0) {
            return;
        }
        QCReportCreateResultHelper.processResultInfoFromCreateReport((CoreUI)this, l);
    }

    private boolean isCreateTo(boolean isReport) {
        int i;
        List billStatus = KDTableUtils.getSelectedRows((KDTable)this.tblMain, (String)"billStatus");
        List isResResult = KDTableUtils.getSelectedRows((KDTable)this.tblMain, (String)"sampleEntries.isResResult");
        List isQCReport = KDTableUtils.getSelectedRows((KDTable)this.tblMain, (String)"sampleEntries.isQCReport");
        List isReinspect = KDTableUtils.getSelectedRows((KDTable)this.tblMain, (String)"sampleEntries.isReinspect");
        List samplenumber = KDTableUtils.getSelectedRows((KDTable)this.tblMain, (String)"sampleEntries.number");
        List number = KDTableUtils.getSelectedRows((KDTable)this.tblMain, (String)"number");
        if (billStatus == null || billStatus.size() <= 0) {
            return false;
        }
        boolean canCreateTo = true;
        int n = billStatus.size();
        for (i = 0; canCreateTo && i < n; ++i) {
            BizEnumValueDTO element;
            if (!(billStatus.get(i) instanceof BizEnumValueDTO) || (element = (BizEnumValueDTO)billStatus.get(i)).getInt() == 30) continue;
            canCreateTo = false;
            MsgBox.showWarning((String)(this.getMultiLangString("selectBill") + "[" + number.get(i) + "]" + this.getMultiLangString("pleaseSelect")));
        }
        if (canCreateTo) {
            n = isResResult.size();
            for (i = 0; canCreateTo && i < n; ++i) {
                Boolean isReinspectValue;
                Boolean isResResultValue = (Boolean)isResResult.get(i);
                if (isReport) {
                    isReinspectValue = (Boolean)isReinspect.get(i);
                    Boolean isQCReportValue = (Boolean)isQCReport.get(i);
                    if (isResResultValue.booleanValue() && !isReinspectValue.booleanValue() && !isQCReportValue.booleanValue()) continue;
                    MsgBox.showWarning((String)(this.getMultiLangString("qcbillIs") + "[" + number.get(i) + "]," + this.getMultiLangString("sampleNumberIs") + "[" + samplenumber.get(i) + "]" + this.getMultiLangString("notAllow")));
                    canCreateTo = false;
                    continue;
                }
                isReinspectValue = (Boolean)isReinspect.get(i);
                if (!isResResultValue.booleanValue() && !isReinspectValue.booleanValue()) continue;
                MsgBox.showWarning((String)(this.getMultiLangString("qcbillIs") + "[" + number.get(i) + "]," + this.getMultiLangString("sampleNumberIs") + "[" + samplenumber.get(i) + "]" + this.getMultiLangString("notAllowReinspect")));
                canCreateTo = false;
            }
        }
        return canCreateTo;
    }

    protected void processSucessData(QCReportCreateResult result) throws Exception {
        Map sucessMap = result.getSucessMap();
        if (sucessMap != null && sucessMap.size() > 0) {
            this.setOprtState("VIEW");
        }
    }

    protected IVerifyManager getCreateToQCReportVerifyManager() {
        VerifyManager manager = new VerifyManager();
        ArrayList ids = this.getSelectedFieldValues("sampleEntries.id");
        final ArrayList numbers = this.getSelectedFieldValues("sampleEntries.number");
        final HashSet set = new HashSet(ids);
        AbstractVerifyItem verifyItem = new AbstractVerifyItem(){

            public boolean verify() throws EASBizException, BOSException {
                EntityViewInfo viewInfo = new EntityViewInfo();
                FilterInfo info = new FilterInfo();
                info.getFilterItems().add(new FilterItemInfo("isResResult", (Object)Boolean.TRUE, CompareType.EQUALS));
                info.getFilterItems().add(new FilterItemInfo("isReinspect", (Object)Boolean.FALSE, CompareType.EQUALS));
                info.getFilterItems().add(new FilterItemInfo("isQCReport", (Object)Boolean.FALSE, CompareType.EQUALS));
                info.getFilterItems().add(new FilterItemInfo("parent.billStatus", (Object)new Integer(30), CompareType.EQUALS));
                info.getFilterItems().add(new FilterItemInfo("id", (Object)set, CompareType.INCLUDE));
                viewInfo.setFilter(info);
                QCBillSampleEntryCollection collection = QCBillSampleEntryFactory.getRemoteInstance().getQCBillSampleEntryCollection(viewInfo);
                if (collection.size() != set.size()) {
                    Iterator it = collection.iterator();
                    StringBuffer sb = new StringBuffer();
                    while (it.hasNext()) {
                        QCBillSampleEntryInfo entryInfo = (QCBillSampleEntryInfo)it.next();
                        if (numbers.contains(entryInfo.getNumber())) continue;
                        sb.append(entryInfo.getNumber() + ",");
                    }
                    MsgBox.showWarning((String)QCBillListUI.this.getMultiLangString("selectSampleCannotReport"));
                    return false;
                }
                return true;
            }
        };
        manager.addVerifyItem((IVerifyItem)verifyItem);
        return manager;
    }

    protected IVerifyManager getCreateToQCReinspectReqVerifyManager() {
        VerifyManager manager = new VerifyManager();
        ArrayList ids = this.getSelectedFieldValues("sampleEntries.id");
        final ArrayList numbers = this.getSelectedFieldValues("sampleEntries.number");
        final HashSet set = new HashSet(ids);
        AbstractVerifyItem verifyItem = new AbstractVerifyItem(){

            public boolean verify() throws EASBizException, BOSException {
                EntityViewInfo viewInfo = new EntityViewInfo();
                FilterInfo info = new FilterInfo();
                info.getFilterItems().add(new FilterItemInfo("isResResult", (Object)Boolean.FALSE, CompareType.EQUALS));
                info.getFilterItems().add(new FilterItemInfo("isReinspect", (Object)Boolean.FALSE, CompareType.EQUALS));
                info.getFilterItems().add(new FilterItemInfo("parent.billStatus", (Object)new Integer(30), CompareType.EQUALS));
                info.getFilterItems().add(new FilterItemInfo("id", (Object)set, CompareType.INCLUDE));
                viewInfo.setFilter(info);
                QCBillSampleEntryCollection collection = QCBillSampleEntryFactory.getRemoteInstance().getQCBillSampleEntryCollection(viewInfo);
                if (collection.size() != set.size()) {
                    Iterator it = collection.iterator();
                    StringBuffer sb = new StringBuffer();
                    while (it.hasNext()) {
                        QCBillSampleEntryInfo entryInfo = (QCBillSampleEntryInfo)it.next();
                        if (numbers.contains(entryInfo.getNumber())) continue;
                        sb.append(entryInfo.getNumber() + ",");
                    }
                    MsgBox.showWarning((String)QCBillListUI.this.getMultiLangString("selectSampleCannotReinspect"));
                    return false;
                }
                return true;
            }
        };
        manager.addVerifyItem((IVerifyItem)verifyItem);
        return manager;
    }

    public String getInstanceListUIClassName(Map uiContext, QCUITypeEnum qcBizType) {
        String listUIClassName = "";
        if (qcBizType == null) {
            return listUIClassName;
        }
        if (QCUITypeEnum.purCheck == qcBizType) {
            listUIClassName = "com.kingdee.eas.qm.qc.client.QCPurBillListUI";
        } else if (QCUITypeEnum.invCheck == qcBizType) {
            listUIClassName = "com.kingdee.eas.qm.qc.client.QCInvBillListUI";
        } else if (QCUITypeEnum.pdtCheck == qcBizType) {
            listUIClassName = "com.kingdee.eas.qm.qc.client.QCMMBillListUI";
        } else if (QCUITypeEnum.otherCheck == qcBizType) {
            listUIClassName = "com.kingdee.eas.qm.qc.client.QCOtherBillListUI";
        }
        return listUIClassName;
    }

    public QCUITypeEnum getQCBizType() {
        return null;
    }

    protected QMCoreBaseFilterUI newInstanceFilterUI() throws Exception {
        return null;
    }

    public IUIObject getInstance(Map uiContext) {
        QCUITypeEnum qcBizType = QMBotpInstanceUIHelper.getUITypeFromBotpCtxForListUI(uiContext);
        if (qcBizType == null) {
            return null;
        }
        String listUIClassName = this.getInstanceListUIClassName(uiContext, qcBizType);
        IUIObject uiObj = null;
        try {
            uiObj = (IUIObject)Class.forName(listUIClassName).newInstance();
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
        return uiObj;
    }

    protected CommonQueryDialog initCommonQueryDialog() {
        CommonQueryDialog dialog = super.initCommonQueryDialog();
        String title = "";
        if (this.getQCBizType() == null) {
            title = "";
        } else if (QCUITypeEnum.purCheck == this.getQCBizType()) {
            title = this.getMultiLangString("QCPURBILL");
        } else if (QCUITypeEnum.invCheck == this.getQCBizType()) {
            title = this.getMultiLangString("QCINVBILL");
        } else if (QCUITypeEnum.pdtCheck == this.getQCBizType()) {
            title = this.getMultiLangString("QCMMBILL");
        } else if (QCUITypeEnum.otherCheck == this.getQCBizType()) {
            title = this.getMultiLangString("QCOTHERBILL");
        }
        dialog.setTitle(title + " - " + EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Query_Filter"));
        return dialog;
    }

    public void actionTraceDown_actionPerformed(ActionEvent e) throws Exception {
        this.getUIContext().put("QCBizType", this.getQCBizType());
        super.actionTraceDown_actionPerformed(e);
    }

    public void actionTraceUp_actionPerformed(ActionEvent e) throws Exception {
        this.getUIContext().put("QCBizType", this.getQCBizType());
        super.actionTraceUp_actionPerformed(e);
    }

    @Override
    public void actionCreateTo_actionPerformed(ActionEvent e) throws Exception {
        this.getUIContext().put("QCBizType", this.getQCBizType());
        super.actionCreateTo_actionPerformed(e);
    }

    protected String getMultiLangString(String key) {
        return EASResource.getString((String)"com.kingdee.eas.qm.qc.QCBillResource", (String)key);
    }

    public ITDPrintStrategy getTDPrintStrategy() throws Exception {
        ITDPrintStrategy printStrategy = QCBillTDPrintStrategyFactory.buildTDPrintStrategy(this.getQCBizType());
        return printStrategy;
    }

    @Override
    public void actionTDPrint_actionPerformed(ActionEvent e) throws Exception {
        this.doInvokeTDPrint(true);
    }

    @Override
    public void actionTDPrintPreview_actionPerformed(ActionEvent e) throws Exception {
        this.doInvokeTDPrint(false);
    }

    @Override
    protected void recycleNumberByOrg(IObjectValue editData, String orgType, String number) {
    }

    protected String getPrintLogItem() {
        return "qm_QCPurBill_print";
    }
}

