/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.qm.qc.client;

import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTPropertyChangeEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTPropertyChangeListener;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDFormattedTextField;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.ctrl.swing.util.CtrlFormatUtilities;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.ItemAction;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.qm.basedata.EvaluateModeEnum;
import com.kingdee.eas.qm.basedata.JudgeTypeEnum;
import com.kingdee.eas.qm.basedata.QCAnalysisMethodEnum;
import com.kingdee.eas.qm.basedata.QCIdentityEnum;
import com.kingdee.eas.qm.basedata.QCItemInfo;
import com.kingdee.eas.qm.basedata.QCLowerLimitEnum;
import com.kingdee.eas.qm.basedata.QCSamplingProgramInfo;
import com.kingdee.eas.qm.basedata.QCUpperLimitEnum;
import com.kingdee.eas.qm.basedata.QCValueAcquisitionModeEnum;
import com.kingdee.eas.qm.basedata.QCValueTypeEnum;
import com.kingdee.eas.qm.basedata.client.util.EntrysDetailPanelManager;
import com.kingdee.eas.qm.basedata.client.util.QCStandardClientUtils;
import com.kingdee.eas.qm.common.util.KDTableUtils;
import com.kingdee.eas.qm.common.util.QMConstant;
import com.kingdee.eas.qm.common.util.QMPrecisionUtil;
import com.kingdee.eas.qm.common.util.backup.QMHelper;
import com.kingdee.eas.qm.qc.QCItemBaseInfo;
import com.kingdee.eas.qm.qc.QCItemSampleEntryCollection;
import com.kingdee.eas.qm.qc.QCItemSampleEntryInfo;
import com.kingdee.eas.qm.qc.QCResultJudgeEnum;
import com.kingdee.eas.qm.qc.client.AbstractQCItemDetailEditUI;
import com.kingdee.eas.qm.qc.client.QCBillEditUI;
import com.kingdee.eas.qm.qc.client.util.QCItemEntryEditUIHelper;
import com.kingdee.eas.qm.qc.client.util.QCUIUtil;
import com.kingdee.util.IllegalConversionException;
import com.kingdee.util.TypeConversionUtils;
import com.kingdee.util.enums.EnumUtils;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.math.BigDecimal;
import javax.swing.Action;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.apache.log4j.Logger;

public class QCItemDetailEditUI
extends AbstractQCItemDetailEditUI {
    private static final long serialVersionUID = -984710616989837210L;
    private static final Logger logger = CoreUIObject.getLogger(QCItemDetailEditUI.class);
    public static final int Default_Max_AddRowCount = 1000;
    public static final String Col_EachSampleResult = "eachSampleResult";
    public static final String Col_EachSampleValue = "eachSampleValue";
    public static final String Col_SampleNumber = "sampleNumber";
    public static final String Col_Desc = "desc";
    public static final String Col_SampleEntry_DefectQty = "defectQty";
    private static final String enumClassName = "com.kingdee.eas.qm.qc.QCResultJudgeEnum";
    protected boolean isFocusQCValue = false;
    private KDTPropertyChangeListener entryListener = null;
    private DataChangeListener checkValueListener = null;
    private DataChangeListener unPassSharesDataChangeListener = null;
    private DataChangeListener defectQtyDataChangeListener = null;
    private KeyListener entryDelKeyListener = null;
    private FocusListener checkValueFocusListener = null;
    private int defaultPrecision = 0;

    protected void afterOnLoad() {
        this.configControlsAfterLoad();
        super.afterOnLoad();
        this.initHead();
        this.regLineButtons();
        this.addListeners();
    }

    protected void beforeLoadFields() {
        super.beforeLoadFields();
        this.removeListeners();
    }

    private void removeListeners() {
        if (this.checkValueListener != null) {
            this.txtCheckValueNum.removeDataChangeListener(this.checkValueListener);
        }
        if (this.entryListener != null) {
            this.kdtSampleEntry.removeKDTPropertyChangeListener(this.entryListener);
        }
        if (this.unPassSharesDataChangeListener != null) {
            this.txtUnPassShares.addDataChangeListener(this.unPassSharesDataChangeListener);
        }
        if (this.defectQtyDataChangeListener != null) {
            this.txtDefectQty.addDataChangeListener(this.defectQtyDataChangeListener);
        }
        if (this.entryDelKeyListener != null) {
            this.kdtSampleEntry.removeKeyListener(this.entryDelKeyListener);
        }
        if (this.checkValueFocusListener != null) {
            this.txtCheckValueNum.removeFocusListener(this.checkValueFocusListener);
        }
    }

    protected void afterLoadFields() {
        super.afterLoadFields();
        this.addListeners();
    }

    private void addListeners() {
        if (this.entryListener == null) {
            this.entryListener = new KDTPropertyChangeListener(){

                public void propertyChange(KDTPropertyChangeEvent e) {
                    try {
                        if (e.getColIndex() == QCItemDetailEditUI.this.kdtSampleEntry.getColumnIndex(QCItemDetailEditUI.Col_EachSampleResult)) {
                            QCItemDetailEditUI.this.afterSampleResultChanged(e);
                        }
                        if (e.getColIndex() == QCItemDetailEditUI.this.kdtSampleEntry.getColumnIndex(QCItemDetailEditUI.Col_EachSampleValue)) {
                            QCItemDetailEditUI.this.afterSampleValueChanged(e);
                        }
                        if (e.getColIndex() == QCItemDetailEditUI.this.kdtSampleEntry.getColumnIndex(QCItemDetailEditUI.Col_SampleEntry_DefectQty)) {
                            QCItemDetailEditUI.this.afterDefectQtyChanged(e);
                        }
                    }
                    catch (Exception exc) {
                        QCItemDetailEditUI.this.handUIException(exc);
                    }
                }
            };
        }
        if (this.checkValueListener == null) {
            this.checkValueListener = new DataChangeListener(){

                public void dataChanged(DataChangeEvent e) {
                    if (e.getNewValue() == null || e.getNewValue().equals(e.getOldValue())) {
                        return;
                    }
                    QCItemDetailEditUI.this.afterCheckValueChanged(e);
                }
            };
        }
        if (this.unPassSharesDataChangeListener == null) {
            this.unPassSharesDataChangeListener = new DataChangeListener(){

                public void dataChanged(DataChangeEvent eventObj) {
                    QCItemDetailEditUI.this.doDataChanged(eventObj);
                }
            };
        }
        if (this.defectQtyDataChangeListener == null) {
            this.defectQtyDataChangeListener = new DataChangeListener(){

                public void dataChanged(DataChangeEvent eventObj) {
                    QCItemDetailEditUI.this.doDataChanged(eventObj);
                }
            };
        }
        if (this.entryDelKeyListener == null) {
            this.entryDelKeyListener = new KeyListener(){

                @Override
                public void keyPressed(KeyEvent e) {
                }

                @Override
                public void keyReleased(KeyEvent e) {
                    QCItemDetailEditUI.this.doWhenDelOnTable(e);
                }

                @Override
                public void keyTyped(KeyEvent e) {
                }
            };
        }
        if (this.checkValueFocusListener == null) {
            this.checkValueFocusListener = new FocusListener(){

                @Override
                public void focusGained(FocusEvent e) {
                    QCItemDetailEditUI.this.isFocusQCValue = true;
                }

                @Override
                public void focusLost(FocusEvent e) {
                    QCItemDetailEditUI.this.isFocusQCValue = false;
                }
            };
        }
        this.txtCheckValueNum.addDataChangeListener(this.checkValueListener);
        this.kdtSampleEntry.addKDTPropertyChangeListener(this.entryListener);
        this.txtUnPassShares.addDataChangeListener(this.unPassSharesDataChangeListener);
        this.txtDefectQty.addDataChangeListener(this.defectQtyDataChangeListener);
        this.kdtSampleEntry.addKeyListener(this.entryDelKeyListener);
        this.txtCheckValueNum.addFocusListener(this.checkValueFocusListener);
    }

    protected void doWhenDelOnTable(KeyEvent e) {
        if (127 == e.getKeyCode() || 8 == e.getKeyCode()) {
            this.calQCValue();
        }
    }

    protected void initListener() {
        super.initListener();
        this.prmtDelegOrgUnit.addDataChangeListener(new DataChangeListener(){

            public void dataChanged(DataChangeEvent e) {
                QCItemDetailEditUI.this.afterDelegOrgUnitChanged(e);
            }
        });
        this.prmtQCGroup.addDataChangeListener(new DataChangeListener(){

            public void dataChanged(DataChangeEvent e) {
                QCItemDetailEditUI.this.afterQCGroupChanged(e);
            }
        });
        this.prmtQCInstrumentGroup.addDataChangeListener(new DataChangeListener(){

            public void dataChanged(DataChangeEvent e) {
                QCItemDetailEditUI.this.afterQCInstrumentGroupChanged(e);
            }
        });
    }

    protected void doDataChanged(DataChangeEvent eventObj) {
        if (eventObj.getSource().equals(this.txtUnPassShares)) {
            this.doStmAfterToCheckResult();
        } else if (eventObj.getSource().equals(this.txtDefectQty)) {
            this.doStmAfterToCheckResult();
        }
    }

    protected void doStmAfterToCheckResult() {
        QCSamplingProgramInfo samProInfo = this.getCurrInfo().getSampleProgram();
        if (samProInfo != null) {
            EvaluateModeEnum eMode = samProInfo.getEvaluationMode();
            BigDecimal acValue = this.getCurrInfo().getAcValue();
            BigDecimal reValue = this.getCurrInfo().getReValue();
            BigDecimal unPassQty = this.txtUnPassShares.getBigDecimalValue();
            BigDecimal defectQty = this.txtDefectQty.getBigDecimalValue();
            if (eMode != null && (EvaluateModeEnum.countdeterminebymanual.equals((Object)eMode) || EvaluateModeEnum.countdeterminebysys.equals((Object)eMode))) {
                if (unPassQty != null && acValue != null && reValue != null) {
                    if (unPassQty.compareTo(acValue) != 1) {
                        this.comboCheckResult.setSelectedItem((Object)QCResultJudgeEnum.pass);
                        this.comboCheckResult.setEnabled(EvaluateModeEnum.countdeterminebymanual.equals((Object)eMode));
                    } else if (unPassQty.compareTo(reValue) != -1) {
                        this.comboCheckResult.setSelectedItem((Object)QCResultJudgeEnum.unPass);
                        this.comboCheckResult.setEnabled(EvaluateModeEnum.countdeterminebymanual.equals((Object)eMode));
                    } else {
                        this.comboCheckResult.setSelectedItem((Object)QCResultJudgeEnum.isNull);
                        this.comboCheckResult.setEnabled(true);
                    }
                }
            } else if (eMode != null && (EvaluateModeEnum.pointdeterminebymanual.equals((Object)eMode) || EvaluateModeEnum.pointdeterminebysys.equals((Object)eMode)) && defectQty != null && acValue != null && reValue != null) {
                if (defectQty.compareTo(acValue) != 1) {
                    this.comboCheckResult.setSelectedItem((Object)QCResultJudgeEnum.pass);
                    this.comboCheckResult.setEnabled(EvaluateModeEnum.pointdeterminebymanual.equals((Object)eMode));
                } else if (defectQty.compareTo(reValue) != -1) {
                    this.comboCheckResult.setSelectedItem((Object)QCResultJudgeEnum.unPass);
                    this.comboCheckResult.setEnabled(EvaluateModeEnum.pointdeterminebymanual.equals((Object)eMode));
                } else {
                    this.comboCheckResult.setSelectedItem((Object)QCResultJudgeEnum.isNull);
                    this.comboCheckResult.setEnabled(true);
                }
            }
        }
    }

    protected void afterDefectQtyChanged(IRow row) {
        int totalDefectQtyIn = 0;
        int size = this.kdtSampleEntry.getRowCount();
        for (int i = 0; i < size; ++i) {
            IRow rowIn = this.kdtSampleEntry.getRow(i);
            int defectQtyIntValue = 0;
            Object defectQtyIn = rowIn.getCell(Col_SampleEntry_DefectQty).getValue();
            if (defectQtyIn instanceof Integer) {
                defectQtyIntValue = (Integer)defectQtyIn;
            } else if (defectQtyIn instanceof BigDecimal) {
                defectQtyIntValue = ((BigDecimal)defectQtyIn).intValue();
            }
            if (defectQtyIn == null) continue;
            totalDefectQtyIn += defectQtyIntValue;
        }
        this.txtDefectQty.setValue((Object)new BigDecimal(totalDefectQtyIn));
        BigDecimal defectQty = QCUIUtil.getBigDecimalValueFromCell(row.getCell(Col_SampleEntry_DefectQty));
        if (defectQty == null) {
            return;
        }
        if (defectQty != null && defectQty.intValue() > 0) {
            row.getCell(Col_EachSampleResult).setValue((Object)QCResultJudgeEnum.unPass);
        } else {
            row.getCell(Col_EachSampleResult).setValue((Object)QCResultJudgeEnum.pass);
        }
    }

    protected void afterDefectQtyChanged(KDTPropertyChangeEvent e) {
        IRow row = this.kdtSampleEntry.getRow(e.getRowIndex());
        this.afterDefectQtyChanged(row);
    }

    protected void afterDelegOrgUnitChanged(DataChangeEvent e) {
    }

    protected void afterQCGroupChanged(DataChangeEvent e) {
    }

    protected void afterQCInstrumentGroupChanged(DataChangeEvent e) {
    }

    protected void afterCheckValueChanged(DataChangeEvent e) {
        QCItemBaseInfo info = this.getCurrInfo();
        if (info == null) {
            return;
        }
        Object checkValue = e.getNewValue();
        this.storeTempInfo(info);
        if (this.canModifyValue()) {
            checkValue = this.doModifyValue(info, checkValue);
            this.txtCheckValueNum.setValue(checkValue, false);
        }
        QCValueTypeEnum qcValueType = info.getQCValueType();
        if (this.getCurrInfo().getSampleProgram() != null) {
            return;
        }
        if (this.getCurrInfo().getSampleProgram() == null && qcValueType == QCValueTypeEnum.number && info.getQCItem().getQCIdentity() == QCIdentityEnum.tally) {
            return;
        }
        QCResultJudgeEnum autoJudgeResult = this.doAutoJudge(info, checkValue);
        if (this.comboCheckResult.isEnabled() && autoJudgeResult != null) {
            this.comboCheckResult.setSelectedItem((Object)autoJudgeResult);
        }
    }

    protected void afterSampleResultChanged(KDTPropertyChangeEvent e) {
        this.reCountPassUnPass();
    }

    private void reCountPassUnPass() {
        int pass = 0;
        int unPass = 0;
        int cnt = this.kdtSampleEntry.getRowCount();
        for (int i = 0; i < cnt; ++i) {
            IRow row = this.kdtSampleEntry.getRow(i);
            if (row == null) continue;
            QCResultJudgeEnum judgeResult = (QCResultJudgeEnum)((Object)row.getCell(Col_EachSampleResult).getValue());
            if (QCResultJudgeEnum.pass.equals((Object)judgeResult)) {
                ++pass;
                continue;
            }
            if (!QCResultJudgeEnum.unPass.equals((Object)judgeResult)) continue;
            ++unPass;
        }
        this.txtPassShares.setValue((Object)new BigDecimal(pass));
        this.txtUnPassShares.setValue((Object)new BigDecimal(unPass));
    }

    protected void afterSampleValueChanged(KDTPropertyChangeEvent e) {
        QCItemBaseInfo info = this.getCurrInfo();
        if (info == null) {
            return;
        }
        IRow row = this.kdtSampleEntry.getRow(e.getRowIndex());
        if (row == null) {
            return;
        }
        QCValueTypeEnum qcValueType = info.getQCValueType();
        if (qcValueType.getValue() == 20) {
            return;
        }
        Object qcResult = row.getCell(Col_EachSampleValue).getValue();
        this.storeTempInfo(info);
        if (this.canModifyValue()) {
            qcResult = this.doModifyValue(info, qcResult);
        }
        this.judgeResult(info, row, qcResult);
        this.calQCValue();
        if (this.canModifyValue()) {
            row.getCell(Col_EachSampleValue).setValue(qcResult);
        }
    }

    protected Object doModifyValue(QCItemBaseInfo info, Object qcResult) {
        return qcResult;
    }

    private void judgeResult(QCItemBaseInfo info, IRow row, Object checkValue) {
        QCResultJudgeEnum judgeResult = this.doAutoJudge(info, checkValue);
        row.getCell(Col_EachSampleResult).setValue((Object)judgeResult);
    }

    private void storeTempInfo(QCItemBaseInfo info) {
        QCValueTypeEnum qcValueType = info.getQCValueType();
        QCAnalysisMethodEnum analysisMethod = info.getAnalysisMethod();
        if (qcValueType != null && (qcValueType == QCValueTypeEnum.number || qcValueType == QCValueTypeEnum.formula && analysisMethod == QCAnalysisMethodEnum.quantitativeAnalysis)) {
            if (this.txtDefaultValueNum.getNumberValue() != null) {
                info.setDefaultValue(this.txtDefaultValueNum.getNumberValue().toString());
            }
            info.setJudgeType((JudgeTypeEnum)this.comboJudgeType.getSelectedItem());
            info.setLower(this.txtLower.getBigDecimalValue());
            info.setUpper(this.txtUpper.getBigDecimalValue());
            info.setLowerLimit((QCLowerLimitEnum)this.comboLowerLimit.getSelectedItem());
            info.setUpperLimit((QCUpperLimitEnum)this.comboUpperLimit.getSelectedItem());
        }
    }

    protected QCResultJudgeEnum doAutoJudge(QCItemBaseInfo info, Object checkValue) {
        QCValueTypeEnum qcValueType = info.getQCValueType();
        QCAnalysisMethodEnum analysisMethod = info.getAnalysisMethod();
        String defaultValue = info.getDefaultValue();
        if (info.getQCItem().getQCValueAcquisitionMode() == QCValueAcquisitionModeEnum.BYQCITEM && qcValueType == QCValueTypeEnum.number) {
            JudgeTypeEnum judgeTypes = info.getJudgeType();
            BigDecimal lower = info.getLower();
            BigDecimal upper = info.getUpper();
            QCLowerLimitEnum lowerLimit = info.getLowerLimit();
            QCUpperLimitEnum upperLimit = info.getUpperLimit();
            return QCBillEditUI.judgeResultWhenQuantitative(this.getUserContext(), checkValue, judgeTypes, lower, upper, lowerLimit, upperLimit);
        }
        if (info.getQCItem().getQCIdentity() == QCIdentityEnum.measure && analysisMethod == QCAnalysisMethodEnum.qualitativeAnalysis && qcValueType == QCValueTypeEnum.number) {
            JudgeTypeEnum judgeTypes = info.getJudgeType();
            BigDecimal lower = info.getLower();
            BigDecimal upper = info.getUpper();
            QCLowerLimitEnum lowerLimit = info.getLowerLimit();
            QCUpperLimitEnum upperLimit = info.getUpperLimit();
            return QCBillEditUI.judgeResultWhenQuantitative(this.getUserContext(), checkValue, judgeTypes, lower, upper, lowerLimit, upperLimit);
        }
        if (qcValueType != null && (qcValueType == QCValueTypeEnum.number || qcValueType == QCValueTypeEnum.formula && (analysisMethod == QCAnalysisMethodEnum.quantitativeAnalysis || analysisMethod == QCAnalysisMethodEnum.qualitativeAnalysis))) {
            JudgeTypeEnum judgeTypes = info.getJudgeType();
            BigDecimal lower = info.getLower();
            BigDecimal upper = info.getUpper();
            QCLowerLimitEnum lowerLimit = info.getLowerLimit();
            QCUpperLimitEnum upperLimit = info.getUpperLimit();
            return QCBillEditUI.judgeResultWhenQuantitative(this.getUserContext(), checkValue, judgeTypes, lower, upper, lowerLimit, upperLimit);
        }
        return QCResultJudgeEnum.isNull;
    }

    protected void afterRemoveLine(KDTable table, IObjectValue lineData) {
        super.afterRemoveLine(table, lineData);
        this.calQCValue();
        this.reCountPassUnPass();
    }

    private void calQCValue() {
        if (!QCValueTypeEnum.number.equals((Object)this.getCurrInfo().getQCValueType())) {
            return;
        }
        BigDecimal sum = QMConstant.ZERO;
        int cnt = 0;
        int rowCount = this.kdtSampleEntry.getRowCount();
        for (int i = 0; i < rowCount; ++i) {
            IRow row = this.kdtSampleEntry.getRow(i);
            Object value = row.getCell(Col_EachSampleValue).getValue();
            if (value == null) continue;
            BigDecimal qcValue = QMConstant.ZERO;
            try {
                qcValue = TypeConversionUtils.objToBigDecimal((Object)value);
            }
            catch (IllegalConversionException e) {
                logger.error((Object)e);
            }
            sum = sum.add(qcValue);
            ++cnt;
        }
        if (cnt > 0) {
            int defaultPrecision = this.getDefaultPrecision();
            if (this.canModifyValue()) {
                defaultPrecision = 8;
            }
            BigDecimal avg = sum.divide(new BigDecimal(new Integer(cnt).toString()), defaultPrecision, 4);
            this.txtCheckValueNum.setNumberValue((Number)avg);
        } else {
            this.txtCheckValueNum.setNumberValue((Number)sum);
        }
    }

    protected void configControlsAfterLoad() {
        this.pkVerifyFinishedDate.setDatePattern(CtrlFormatUtilities.getDateTimeFormatString());
        QCUIUtil.setInputPositiveInt(new KDFormattedTextField[]{this.txtSampleShares, this.txtPassShares, this.txtUnPassShares, this.txtAc, this.txtRe, this.txtDefectQty});
        QCUIUtil.setInputBigDecimal(new KDFormattedTextField[]{this.txtUpper, this.txtLower});
        KDComboBox cmb = new KDComboBox();
        cmb.addItems(EnumUtils.getEnumList((String)enumClassName).toArray());
        cmb.removeItem((Object)QCResultJudgeEnum.noDeterminant);
        cmb.removeItem((Object)QCResultJudgeEnum.cancel);
        this.kdtSampleEntry.getColumn(Col_EachSampleResult).setEditor((ICellEditor)new KDTDefaultCellEditor((JComboBox)cmb));
        this.txtAc.setEnabled(false);
        this.txtRe.setEnabled(false);
        KDTableUtils.setFieldsHorizontalAlignment((Styles.HorizontalAlignment)Styles.HorizontalAlignment.RIGHT, (KDTable)this.kdtSampleEntry, (String[])new String[]{Col_EachSampleValue, Col_SampleEntry_DefectQty});
        KDTableUtils.setKDTableColumnsMaxLength((KDTable)this.kdtSampleEntry, (String[])new String[]{Col_SampleNumber}, (int)80);
        KDTableUtils.setKDTableColumnsMaxLength((KDTable)this.kdtSampleEntry, (String[])new String[]{Col_Desc}, (int)255);
        QCUIUtil.setCommitBeforeClose(new KDFormattedTextField[]{this.txtPassShares, this.txtUnPassShares, this.txtLower, this.txtSampleShares, this.txtUpper, this.txtDefaultValueNum, this.txtDefectQty});
    }

    protected void doAfterLoadAndSwitch() {
        super.doAfterLoadAndSwitch();
        this.configTableAfterLoadAndSwitch();
        this.setControlStatusAfterLoadAndSwitch();
        this.addEntryDefaultCountRows();
        this.defaultPrecision = 0;
    }

    private void addEntryDefaultCountRows() {
        if (this.currInfo == null) {
            return;
        }
        QCValueAcquisitionModeEnum qcMode = ((QCItemBaseInfo)this.currInfo).getQCValueAcquisitionMode();
        if (qcMode == null || QCValueAcquisitionModeEnum.BYQCITEM.equals((Object)qcMode)) {
            return;
        }
        if (!this.getOprtState().equals("EDIT")) {
            return;
        }
        this.addEntryDefaultCountRowsByBill();
    }

    protected void addEntryDefaultCountRowsByBill() {
        QCItemSampleEntryCollection sampleEntry = this.getCurrEntryColl();
        if (sampleEntry.size() == 0 && this.getCurrInfo().getSampleShares() != null && this.getCurrInfo().getSampleShares().compareTo(QMConstant.ZERO) > 0) {
            int sampleShares = this.getCurrInfo().getSampleShares().intValue();
            this.kdtSampleEntry.addRows(sampleShares > 1000 ? 1000 : sampleShares);
            this.configKdtSampleEntry();
            this.storeFields();
        }
    }

    protected QCItemSampleEntryCollection getCurrEntryColl() {
        return null;
    }

    private void regLineButtons() {
        EntrysDetailPanelManager.getInstance((JPanel[])new KDPanel[]{this.pnlSampleEntry}, (Action)this.actionAddLine, (Action)this.actionInsertLine, (Action)this.actionRemoveLine).regPanel();
    }

    private void setControlStatusAfterLoadAndSwitch() {
        this.setControlStatusByCommon();
        this.setControlStatusByOwnerUI();
    }

    private void setControlStatusByCommon() {
        boolean isQCValueNeed;
        this.showDynaControls();
        QCValueTypeEnum valueType = this.getCurrInfo().getQCValueType();
        boolean bl = isQCValueNeed = QCValueTypeEnum.number.equals((Object)valueType) || QCValueTypeEnum.formula.equals((Object)valueType);
        if (isQCValueNeed) {
            this.kdtSampleEntry.getColumn(Col_EachSampleValue).getStyleAttributes().setBackground(QMConstant.Required_Color);
        } else {
            this.kdtSampleEntry.getColumn(Col_EachSampleValue).getStyleAttributes().setBackground(QMConstant.UnRequired_Color);
        }
        this.kdtSampleEntry.getColumn(Col_EachSampleResult).getStyleAttributes().setBackground(QMConstant.Required_Color);
        this.prmtUnit.setEnabled(false);
        boolean isByQCItem = this.getCurrInfo().getQCValueAcquisitionMode() == null || QCValueAcquisitionModeEnum.BYQCITEM.equals((Object)this.getCurrInfo().getQCValueAcquisitionMode());
        this.txtPassShares.setEnabled(isByQCItem);
        this.txtUnPassShares.setEnabled(isByQCItem);
        boolean canEdit = true;
        QCItemInfo item = this.getCurrInfo().getQCItem();
        if (item != null && !QCIdentityEnum.point.equals((Object)item.getQCIdentity()) || QCValueAcquisitionModeEnum.BYSAMPLEQTY.equals((Object)this.getCurrInfo().getQCValueAcquisitionMode())) {
            canEdit = false;
        }
        this.txtDefectQty.setEnabled(canEdit);
        int dataPrecision = this.getDefaultPrecision();
        QMPrecisionUtil.setNumberEditorFmt((int)dataPrecision, null, null, (KDFormattedTextField[])new KDFormattedTextField[]{this.txtDefaultValueNum, this.txtUpper, this.txtLower, this.txtCheckValueNum});
        this.txtCheckValueNum.setMaximumValue((Comparable)QCUIUtil.MAX_QCVALUE);
        this.txtCheckValueNum.setMinimumValue((Comparable)QCUIUtil.MIN_QCVALUE);
        if (this.canModifyValue()) {
            this.txtCheckValueNum.setPrecision(8);
        }
        this.txtCheckValueNum.setRemoveingZeroInDispaly(true);
        if (this.getCurrInfo() != null && this.getCurrInfo().getEnums() != null) {
            this.txtCheckValueCmb.addItems((Object[])QMHelper.parseEnumString((String)this.getCurrInfo().getEnums()));
            this.txtDefaultValueCmb.addItems((Object[])QMHelper.parseEnumString((String)this.getCurrInfo().getEnums()));
        }
        if (QCValueTypeEnum.number.equals((Object)valueType) || QCValueTypeEnum.formula.equals((Object)valueType)) {
            try {
                if (this.getCurrInfo().getCheckValue() != null) {
                    this.txtCheckValueNum.setNumberValue((Number)new BigDecimal(this.getCurrInfo().getCheckValue()));
                }
            }
            catch (Exception e) {
                this.txtCheckValueNum.setText(this.getCurrInfo().getCheckValue());
            }
            try {
                if (this.getCurrInfo().getDefaultValue() != null) {
                    this.txtDefaultValueNum.setNumberValue((Number)new BigDecimal(this.getCurrInfo().getDefaultValue()));
                }
            }
            catch (Exception e) {
                this.txtDefaultValueNum.setText(this.getCurrInfo().getDefaultValue());
            }
        } else if (QCValueTypeEnum.enumvalue.equals((Object)valueType)) {
            this.txtCheckValueCmb.setSelectedIndex(QCUIUtil.getIndexOfCmbList(this.txtCheckValueCmb, this.getCurrInfo().getCheckValue()));
            this.txtDefaultValueCmb.setSelectedIndex(QCUIUtil.getIndexOfCmbList(this.txtDefaultValueCmb, this.getCurrInfo().getDefaultValue()));
        }
    }

    private boolean canModifyValue() {
        return this.isNeedModifyValue() && this.getCurrInfo().getQCModifyMode() != null;
    }

    protected boolean isNeedModifyValue() {
        return false;
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    protected void beforeSwitchAction() {
        this.storeTempFields();
        super.beforeSwitchAction();
    }

    private void storeTempFields() {
        QCValueTypeEnum valueType = this.getCurrInfo().getQCValueType();
        if (QCValueTypeEnum.number.equals((Object)valueType) || QCValueTypeEnum.formula.equals((Object)valueType)) {
            if (this.txtCheckValueNum.getNumberValue() != null) {
                this.txtCheckValueText.setText(this.txtCheckValueNum.getNumberValue().toString());
            } else {
                this.txtCheckValueText.setText(null);
            }
            if (this.txtDefaultValueNum.getNumberValue() != null) {
                this.txtDefaultValueText.setText(this.txtDefaultValueNum.getNumberValue().toString());
            } else {
                this.txtDefaultValueText.setText(null);
            }
        } else if (QCValueTypeEnum.enumvalue.equals((Object)valueType)) {
            if (this.txtCheckValueCmb.getSelectedItem() != null) {
                this.txtCheckValueText.setText(this.txtCheckValueCmb.getSelectedItem().toString());
            } else {
                this.txtCheckValueText.setText(null);
            }
            if (this.txtDefaultValueCmb.getSelectedItem() != null) {
                this.txtDefaultValueText.setText(this.txtDefaultValueCmb.getSelectedItem().toString());
            } else {
                this.txtDefaultValueText.setText(null);
            }
        }
    }

    public boolean checkBeforeWindowClosing() {
        this.storeEntryValue();
        this.storeTempFields();
        return super.checkBeforeWindowClosing();
    }

    private void storeEntryValue() {
    }

    @Override
    public void loadFields() {
        super.loadFields();
    }

    private void showDynaControls() {
        QCValueTypeEnum valueType = this.getCurrInfo().getQCValueType();
        if (valueType == null) {
            this.showTextControls();
            return;
        }
        if (QCValueTypeEnum.text.equals((Object)valueType)) {
            this.showTextControls();
        }
        if (QCValueTypeEnum.number.equals((Object)valueType) || QCValueTypeEnum.formula.equals((Object)valueType)) {
            this.showNumControls();
        }
        if (QCValueTypeEnum.enumvalue.equals((Object)valueType)) {
            this.showCmbControls();
        }
    }

    private void showTextControls() {
        this.txtCheckValueNum.setVisible(false);
        this.txtCheckValueCmb.setVisible(false);
        this.txtCheckValueText.setVisible(true);
        this.txtDefaultValueNum.setVisible(false);
        this.txtDefaultValueCmb.setVisible(false);
        this.txtDefaultValueText.setVisible(true);
    }

    private void showNumControls() {
        this.txtCheckValueNum.setVisible(true);
        this.txtCheckValueCmb.setVisible(false);
        this.txtCheckValueText.setVisible(false);
        this.txtDefaultValueNum.setVisible(true);
        this.txtDefaultValueCmb.setVisible(false);
        this.txtDefaultValueText.setVisible(false);
    }

    private void showCmbControls() {
        this.txtCheckValueNum.setVisible(false);
        this.txtCheckValueCmb.setVisible(true);
        this.txtCheckValueText.setVisible(false);
        this.txtDefaultValueNum.setVisible(false);
        this.txtDefaultValueCmb.setVisible(true);
        this.txtDefaultValueText.setVisible(false);
    }

    protected void setControlStatusByOwnerUI() {
    }

    public QCItemBaseInfo getCurrInfo() {
        QCItemBaseInfo info = (QCItemBaseInfo)this.currInfo;
        return info;
    }

    private void configTableAfterLoadAndSwitch() {
        if (this.getCurrInfo() == null) {
            return;
        }
        ItemAction[] actionLines = new ItemAction[]{this.actionAddLine, this.actionInsertLine, this.actionRemoveLine};
        QCValueAcquisitionModeEnum qcMode = this.getCurrInfo().getQCValueAcquisitionMode();
        if (qcMode == null || QCValueAcquisitionModeEnum.BYQCITEM.equals((Object)qcMode)) {
            this.kdtSampleEntry.setEnabled(false);
            this.setActionDisabled(actionLines);
            this.txtPassShares.setEnabled(true);
            this.txtUnPassShares.setEnabled(true);
        } else {
            this.kdtSampleEntry.setEnabled(true);
            this.setActionEnabled(actionLines);
            this.txtPassShares.setEnabled(false);
            this.txtUnPassShares.setEnabled(false);
        }
        int cnt = this.kdtSampleEntry.getRowCount();
        for (int i = 0; i < cnt; ++i) {
            this.configEachRow(this.kdtSampleEntry.getRow(i));
        }
        if (!this.getOprtState().equals("EDIT")) {
            this.kdtSampleEntry.setEnabled(false);
            this.setActionDisabled(actionLines);
        }
        KDTableUtils.setNumberTypeForCols((KDTable)this.kdtSampleEntry, (int)0, (String[])new String[]{Col_SampleEntry_DefectQty});
    }

    protected void loadLineFields(KDTable table, IRow row, IObjectValue obj) {
        super.loadLineFields(table, row, obj);
        if (this.getCurrInfo() == null) {
            return;
        }
        this.configEachRow(row);
    }

    protected void configEachRow(IRow row) {
        QCBillEditUI.setCheckValueInputPattern(row.getCell(Col_EachSampleValue), this.getCurrInfo());
        QCValueTypeEnum valueType = this.getCurrInfo().getQCValueType();
        if (QCValueTypeEnum.number.equals((Object)valueType) || QCValueTypeEnum.formula.equals((Object)valueType)) {
            int dataPrecision = this.getDefaultPrecision();
            KDFormattedTextField field = QMPrecisionUtil.getNumberEditor((int)dataPrecision, null, null);
            field.setMaximumValue((Comparable)QCUIUtil.MAX_QCVALUE);
            field.setMinimumValue((Comparable)QCUIUtil.MIN_QCVALUE);
            String fmstr = QMPrecisionUtil.getFormatString((int)dataPrecision);
            row.getCell(Col_EachSampleValue).setEditor((ICellEditor)new KDTDefaultCellEditor((JTextField)field));
            row.getCell(Col_EachSampleValue).getStyleAttributes().setNumberFormat(fmstr);
            row.getCell(Col_EachSampleValue).getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        } else {
            row.getCell(Col_EachSampleValue).getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.LEFT);
        }
        QCItemInfo qcItem = this.getCurrInfo().getQCItem();
        if (qcItem != null && (QCIdentityEnum.tally.equals((Object)qcItem.getQCIdentity()) || QCIdentityEnum.measure.equals((Object)qcItem.getQCIdentity()))) {
            row.getCell(Col_SampleEntry_DefectQty).setValue(null);
            row.getCell(Col_SampleEntry_DefectQty).getStyleAttributes().setLocked(true);
            row.getCell(Col_EachSampleValue).getStyleAttributes().setLocked(false);
        } else if (qcItem != null && QCIdentityEnum.point.equals((Object)qcItem.getQCIdentity())) {
            row.getCell(Col_EachSampleValue).setValue(null);
            row.getCell(Col_EachSampleValue).getStyleAttributes().setLocked(true);
            row.getCell(Col_SampleEntry_DefectQty).getStyleAttributes().setLocked(false);
        }
    }

    protected void configKdtSampleEntry() {
        int size = this.kdtSampleEntry.getRowCount();
        for (int i = 0; i < size; ++i) {
            IRow row = this.kdtSampleEntry.getRow(i);
            this.configEachRow(row);
        }
    }

    protected int getDefaultPrecision() {
        if (this.defaultPrecision == 0) {
            this.defaultPrecision = QCStandardClientUtils.getRowObjCheckValuePrecision((QCItemBaseInfo)this.getCurrInfo());
            return this.defaultPrecision;
        }
        return this.defaultPrecision;
    }

    protected void initHead() {
        QCItemEntryEditUIHelper.initHead(this.getOwnerUI(), this.txtMaterialNumber, this.txtMaterialName, this.prmtQCStandard, this.txtSampleNumber, this.txtSampleDesc);
    }

    protected KDTable getDetailTable() {
        return this.kdtSampleEntry;
    }

    protected IObjectValue createNewDetailData(KDTable table) {
        return new QCItemSampleEntryInfo();
    }

    protected IObjectValue createNewData() {
        return null;
    }

    protected ICoreBase getBizInterface() throws Exception {
        return null;
    }
}

