/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.qm.qc.client;

import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.swing.KDTextField;
import com.kingdee.bos.ctrl.swing.StringUtils;
import com.kingdee.bos.ctrl.swing.util.CtrlFormatUtilities;
import com.kingdee.eas.base.btp.BTPTransformResult;
import com.kingdee.eas.basedata.master.material.IMultiMeasureUnit;
import com.kingdee.eas.basedata.master.material.MultiMeasureUnitFactory;
import com.kingdee.eas.basedata.master.material.MultiMeasureUnitInfo;
import com.kingdee.eas.basedata.org.QualityOrgUnitInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.mm.control.BizTypeEnum;
import com.kingdee.eas.qm.basedata.QCBizBillTypeInfo;
import com.kingdee.eas.qm.basedata.QCBizTypeEnum;
import com.kingdee.eas.qm.basedata.QCRoutingInspectionPlanInfo;
import com.kingdee.eas.qm.common.util.QMPrecisionUtil;
import com.kingdee.eas.qm.qc.IQCMMPatrolReport;
import com.kingdee.eas.qm.qc.IQCMMPatrolReportCreateFromListFacade;
import com.kingdee.eas.qm.qc.QCMMPatrolReportCollection;
import com.kingdee.eas.qm.qc.QCMMPatrolReportCreateFromListFacadeFactory;
import com.kingdee.eas.qm.qc.QCMMPatrolReportFactory;
import com.kingdee.eas.qm.qc.QCMMPatrolReportInfo;
import com.kingdee.eas.qm.qc.client.AbstractQCMMPatrolReportCreateFromListUI;
import com.kingdee.eas.qm.qc.client.QCMMPatrolReportEditUI;
import com.kingdee.eas.qm.qc.client.util.qcreport.QCMMPatrolReportEditUIHelper;
import com.kingdee.eas.qm.qc.util.HQHPUtil;
import com.kingdee.eas.scm.common.BillBaseStatusEnum;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.jdbc.rowset.IRowSet;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.math.BigDecimal;
import java.util.Date;
import java.util.HashMap;

public class QCMMPatrolReportCreateFromListUI
extends AbstractQCMMPatrolReportCreateFromListUI {
    private static final String Edit_ID = "id";
    private static final String Edit_BILL_STATUS = "BILL_STATUS";
    private static final String Edit_BIZ_DATE = "BIZ_DATE";
    private static final String Edit_PLAN_AMOUNT = "PLAN_AMOUNT";
    private static final String Edit_PLAN_OUTPUT_AMOUNT = "PLAN_OUTPUT_AMOUNT";
    private static final String Edit_BIZ_TYPE = "BIZ_TYPE";
    private static final String Edit_WP_NO = "WP_NO";
    private static final String Edit_WP = "WP";
    private static final String Edit_IS_KEYWP = "IS_KEYWP";
    private static final String Edit_WPid = "WPid";
    private static final String Edit_MATERIAL_ID = "MATERIAL_ID";
    private static final String Edit_UNIT_ID = "UNIT_ID";
    private QCBizBillTypeInfo billTypeInfo = null;
    private QualityOrgUnitInfo qualityOrgInfo = null;
    private QCRoutingInspectionPlanInfo planInfo = null;
    FocusListener orderNumberChangeListener;

    public void onLoad() throws Exception {
        super.onLoad();
        this.tableConfig();
        this.initParams();
        this.initTableBody();
    }

    @Override
    public void loadFields() {
        this.removeListener();
        super.loadFields();
        this.addListener();
    }

    protected void initListener() {
        super.initListener();
        this.orderNumberChangeListener = new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                QCMMPatrolReportCreateFromListUI.this.orderNumberChanged(e);
            }
        };
        this.addListener();
    }

    private void addListener() {
        this.txtNumberStart.addFocusListener(this.orderNumberChangeListener);
        this.txtNumberEnd.addFocusListener(this.orderNumberChangeListener);
    }

    private void removeListener() {
        this.txtNumberStart.removeFocusListener(this.orderNumberChangeListener);
        this.txtNumberEnd.removeFocusListener(this.orderNumberChangeListener);
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.actionConfirm.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_execute"));
    }

    protected void tblMain_tableClicked(KDTMouseEvent e) throws Exception {
        if (e.getClickCount() == 2) {
            this.actionConfirm_actionPerformed(this.getActionEvent());
        }
    }

    private void initParams() {
        this.billTypeInfo = (QCBizBillTypeInfo)this.getUIContext().get("BillType");
        this.qualityOrgInfo = (QualityOrgUnitInfo)this.getUIContext().get("MainOrgCtx");
        this.planInfo = (QCRoutingInspectionPlanInfo)this.getUIContext().get("PatrolPlan");
    }

    private void initTableBody() throws Exception {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("patrolPlan", this.planInfo);
        map.put("billType", this.billTypeInfo);
        map.put("qualityOrg", this.qualityOrgInfo);
        map.put("numberStart", this.txtNumberStart.getText());
        map.put("numberEnd", this.txtNumberEnd.getText());
        map.put("bizDateStart", this.dpBizDateStart.getValue());
        map.put("bizDateEnd", this.dpBizDateEnd.getValue());
        IQCMMPatrolReportCreateFromListFacade facade = QCMMPatrolReportCreateFromListFacadeFactory.getRemoteInstanceWithObjectContext(this.getMainOrgContext());
        IRowSet rs = facade.getListData(map);
        int r = 0;
        this.tblMain.removeRows();
        while (rs.next()) {
            this.tblMain.addRow();
            for (int i = 0; i < this.tblMain.getColumnCount(); ++i) {
                if (Edit_BILL_STATUS.equals(this.tblMain.getColumn(i).getKey())) {
                    this.tblMain.getRow(r).getCell(i).setValue((Object)BillBaseStatusEnum.getEnum((int)HQHPUtil.getInt(rs.getObject(i + 1))));
                    continue;
                }
                if (Edit_BIZ_TYPE.equals(this.tblMain.getColumn(i).getKey())) {
                    if (QCBizTypeEnum.pdtProcessCheck.equals((Object)this.billTypeInfo.getQCBizType())) {
                        this.tblMain.getRow(r).getCell(i).setValue((Object)BizTypeEnum.getEnum((int)HQHPUtil.getInt(rs.getObject(i + 1))));
                        continue;
                    }
                    this.tblMain.getRow(r).getCell(i).setValue(rs.getObject(i + 1));
                    continue;
                }
                this.tblMain.getRow(r).getCell(i).setValue(rs.getObject(i + 1));
            }
            int precision = QCMMPatrolReportCreateFromListUI.getMaterialUnitQtyPrecision((String)this.tblMain.getRow(r).getCell(Edit_MATERIAL_ID).getValue(), (String)this.tblMain.getRow(r).getCell(Edit_UNIT_ID).getValue());
            String fmstr = QMPrecisionUtil.getFormatString((int)precision);
            this.tblMain.getRow(r).getCell(Edit_PLAN_AMOUNT).getStyleAttributes().setNumberFormat(fmstr);
            this.tblMain.getRow(r).getCell(Edit_PLAN_OUTPUT_AMOUNT).getStyleAttributes().setNumberFormat(fmstr);
            ++r;
        }
    }

    public void tableConfig() {
        this.tblMain.getSelectManager().setSelectMode(2);
        this.tblMain.getDataRequestManager().setDataRequestMode(0);
        this.tblMain.getColumn(Edit_BIZ_DATE).getStyleAttributes().setNumberFormat(CtrlFormatUtilities.getDateFormatString());
    }

    @Override
    public void actionFilter_actionPerformed(ActionEvent e) throws Exception {
        Date from = (Date)this.dpBizDateStart.getValue();
        Date to = (Date)this.dpBizDateEnd.getValue();
        if (from == null) {
            MsgBox.showWarning((Component)((Object)this), (String)QCMMPatrolReportEditUIHelper.getMsg("CreateFromUI_Verify1", null));
            this.dpBizDateStart.requestFocus();
            SysUtil.abort();
        }
        if (to == null) {
            MsgBox.showWarning((Component)((Object)this), (String)QCMMPatrolReportEditUIHelper.getMsg("CreateFromUI_Verify2", null));
            this.dpBizDateEnd.requestFocus();
            SysUtil.abort();
        }
        if (from != null && to != null && from.after(to)) {
            MsgBox.showWarning((Component)((Object)this), (String)QCMMPatrolReportEditUIHelper.getMsg("CreateFromUI_Verify3", null));
            this.dpBizDateStart.requestFocus();
            SysUtil.abort();
        }
        if (!StringUtils.isEmpty((String)this.txtNumberStart.getText()) && StringUtils.isEmpty((String)this.txtNumberEnd.getText()) || StringUtils.isEmpty((String)this.txtNumberStart.getText()) && !StringUtils.isEmpty((String)this.txtNumberEnd.getText())) {
            MsgBox.showWarning((Component)((Object)this), (String)QCMMPatrolReportEditUIHelper.getMsg("CreateFromUI_Verify4", null));
            this.txtNumberStart.requestFocus();
            SysUtil.abort();
        }
        this.initTableBody();
    }

    @Override
    public void actionConfirm_actionPerformed(ActionEvent e) throws Exception {
        int i;
        int row = this.tblMain.getSelectManager().getActiveRowIndex();
        if (row < 0) {
            MsgBox.showWarning((Component)((Object)this), (String)QCMMPatrolReportEditUIHelper.getMsg("Must_Select", null));
            SysUtil.abort();
        }
        if ((i = MsgBox.showConfirm2((Component)((Object)this), (String)QCMMPatrolReportEditUIHelper.getMsg("CreateFromConfirm", null))) != 0) {
            SysUtil.abort();
        }
        String productOrderId = (String)this.tblMain.getCell(row, Edit_ID).getValue();
        Object wpNo = this.tblMain.getCell(row, Edit_WP_NO).getValue();
        String wp = (String)this.tblMain.getCell(row, Edit_WP).getValue();
        BigDecimal isKeyWP = new BigDecimal(0);
        Object obj = this.tblMain.getCell(row, Edit_IS_KEYWP).getValue();
        if (obj != null) {
            isKeyWP = obj instanceof BigDecimal ? (BigDecimal)obj : new BigDecimal(obj.toString());
        }
        String wpid = (String)this.tblMain.getCell(row, Edit_WPid).getValue();
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("MainOrgCtx", this.qualityOrgInfo);
        params.put("productOrderId", productOrderId);
        params.put("billTypeInfo", this.billTypeInfo);
        params.put("wpNo", wpNo);
        params.put("wp", wp);
        params.put("isKeyWP", isKeyWP);
        params.put(Edit_WPid, wpid);
        params.put("PatrolPlan", (QCRoutingInspectionPlanInfo)this.getUIContext().get("PatrolPlan"));
        IQCMMPatrolReport iReport = QCMMPatrolReportFactory.getRemoteInstanceWithObjectContext(this.getMainOrgContext());
        BTPTransformResult btpResult = iReport.getBotCreateFromBills(params);
        QCMMPatrolReportCollection qcPatrolReportColl = (QCMMPatrolReportCollection)btpResult.getBills();
        QCMMPatrolReportInfo prInfo = null;
        if (qcPatrolReportColl != null && qcPatrolReportColl.size() > 0) {
            prInfo = qcPatrolReportColl.get(0);
        }
        QCMMPatrolReportEditUI prEditUI = (QCMMPatrolReportEditUI)((Object)this.getUIContext().get("Owner"));
        prEditUI.getUIContext().put("reportInfo", prInfo);
        prEditUI.getUIContext().put("btpRelation", btpResult.getBOTRelationCollection());
        this.actionExitCurrent_actionPerformed(e);
    }

    protected ICoreBase getBizInterface() throws Exception {
        return null;
    }

    protected String getEditUIName() {
        return null;
    }

    public static int getMaterialUnitQtyPrecision(String materialInfoId, String measureUnitInfoId) throws Exception {
        IMultiMeasureUnit imultiUnit;
        MultiMeasureUnitInfo multiUnitInfo;
        int precision = 4;
        if (materialInfoId != null && measureUnitInfoId != null && (multiUnitInfo = (imultiUnit = MultiMeasureUnitFactory.getRemoteInstance()).getMultiUnit(materialInfoId, measureUnitInfoId)) != null) {
            precision = multiUnitInfo.getQtyPrecision();
        }
        return precision;
    }

    protected void orderNumberChanged(FocusEvent evt) {
        KDTextField txtSrc = (KDTextField)evt.getComponent();
        String newValue = txtSrc.getText();
        if (newValue != null && newValue.indexOf("'") >= 0) {
            String msg = EASResource.getString((String)"com.kingdee.eas.common.EASCommonResource.f7QueryContextInvalid");
            MsgBox.showInfo((String)msg);
            txtSrc.setText(null);
            txtSrc.requestFocus();
        }
    }
}

