/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.qm.qc.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.sql.util.StringUtil;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.qm.common.client.action.BillStatusAction;
import com.kingdee.eas.qm.common.client.action.BizTypeAction;
import com.kingdee.eas.qm.common.client.action.IUIContextAction;
import com.kingdee.eas.qm.common.client.action.IUIContextManager;
import com.kingdee.eas.qm.common.filter.CompositeFilterElement;
import com.kingdee.eas.qm.common.filter.IFilterElement;
import com.kingdee.eas.qm.common.filter.IQueryFilterManager;
import com.kingdee.eas.qm.common.filter.RangeFilterElement;
import com.kingdee.eas.qm.common.filter.SingleFilterElement;
import com.kingdee.eas.qm.common.util.QMDateUtils;
import com.kingdee.eas.qm.qc.QCReportFactory;
import com.kingdee.eas.qm.qc.client.AbstractQCMMPatrolReportFilterUI;
import com.kingdee.eas.qm.qc.client.action.report.QCMMPatrolReportBizTypeActionForFilterUI;
import com.kingdee.eas.qm.qc.client.action.report.QCMMPatrolReportMainOrgActionForFilterUI;
import com.kingdee.eas.qm.qc.client.action.report.QCMMPatrolReportMaterialActionForFilterUI;
import com.kingdee.eas.qm.qc.client.action.report.QCMMPatrolReportPatrolPlanActionForFilterUI;
import com.kingdee.eas.qm.qc.client.action.report.QCMMPatrolReportProductLineActionForFilterUI;
import com.kingdee.eas.qm.qc.client.action.report.QCMMPatrolReportQCGroupActionForFilterUI;
import com.kingdee.eas.qm.qc.client.action.report.QCMMPatrolReportTechLineActionForFilterUI;
import com.kingdee.eas.qm.qc.client.util.qcreport.QCMMPatrolReportEditUIHelper;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.util.Date;
import java.util.Map;
import java.util.Set;
import javax.swing.JComponent;

public class QCMMPatrolReportFilterUI
extends AbstractQCMMPatrolReportFilterUI {
    public static final String UICTX_PatrolPlan_Changed = "UICTX_PatrolPlan_Changed";
    public static final String UICTX_QCGroup_Changed = "UICTX_QCGroup_Changed";
    public static final String UICTX_BizType_Changed = "UICTX_BizType_Changed";
    public static final String UICTX_Material_Changed = "UICTX_Material_Changed";
    public static final String UICTX_ProductLine_Changed = "UICTX_ProductLine_Changed";
    public static final String UICTX_TechLine_Changed = "UICTX_TechLine_Changed";
    private Map materialFilterCacheMap = null;

    public void onLoad() throws Exception {
        this.setIsSupportMultiOrgs(false);
        OrgType mainBizOrgType = this.getMainBizOrgType();
        String viewPermission = this.getViewPermItemName();
        if (this.materialFilterCacheMap == null) {
            this.materialFilterCacheMap = QCReportFactory.getRemoteInstanceWithObjectContext(this.getMainOrgContext()).getMaterialCache(mainBizOrgType, viewPermission);
        }
        this.getUIContext().put("MaterialFilterCache", this.materialFilterCacheMap);
        super.onLoad();
        this.initF7Selector();
    }

    public void initUIContextManager() {
        super.initUIContextManager();
        this.initUIContextManager((JComponent)this.prmtPatrolPlan, UICTX_PatrolPlan_Changed);
        this.initUIContextManager((JComponent)this.prmtCheckGroup, UICTX_QCGroup_Changed);
        this.initUIContextManager((JComponent)this.comboBizType, UICTX_BizType_Changed);
        this.initUIContextManager((JComponent)this.prmtMaterial, UICTX_Material_Changed);
        this.initUIContextManager((JComponent)this.prmtProductLine, UICTX_ProductLine_Changed);
        this.initUIContextManager((JComponent)this.prmtTechLine, UICTX_TechLine_Changed);
    }

    public void registerUIManager(IUIContextManager manager) {
        super.registerUIManager(manager);
        if (manager.getType().equals("MainOrgUnit")) {
            QCMMPatrolReportMainOrgActionForFilterUI itemAction = new QCMMPatrolReportMainOrgActionForFilterUI();
            itemAction.putParam("prmtQualityOrgUnit", this.prmtQualityOrgUnit);
            itemAction.putParam("prmtAdminOrgUnit", this.prmtAdminOrgUnit);
            itemAction.putParam("prmtCheckGroup", this.prmtCheckGroup);
            itemAction.putParam("prmtChecker", this.prmtChecker);
            itemAction.putParam("prmtBillNumberStart", this.prmtBillNumberStart);
            itemAction.putParam("prmtBillNumberEnd", this.prmtBillNumberEnd);
            itemAction.putParam("prmtPatrolPlan", this.prmtPatrolPlan);
            itemAction.putParam("prmtMaterial", this.prmtMaterial);
            itemAction.putParam("prmtProductLine", this.prmtProductLine);
            itemAction.putParam("prmtTechLine", this.prmtTechLine);
            itemAction.putParam("prmtWP", this.prmtWP);
            itemAction.putParam("prmtProductLineWP", this.prmtProductLineWP);
            itemAction.putParam("comboBizType", this.comboBizType);
            itemAction.putParam("ui", (Object)this);
            manager.registerAction((IUIContextAction)itemAction);
        } else if (manager.getType().equals(UICTX_PatrolPlan_Changed)) {
            QCMMPatrolReportPatrolPlanActionForFilterUI itemAction = new QCMMPatrolReportPatrolPlanActionForFilterUI();
            itemAction.putParam("prmtQualityOrgUnit", this.prmtQualityOrgUnit);
            itemAction.putParam("prmtPatrolPlan", this.prmtPatrolPlan);
            itemAction.putParam("prmtMaterial", this.prmtMaterial);
            itemAction.putParam("prmtProductLine", this.prmtProductLine);
            itemAction.putParam("prmtTechLine", this.prmtTechLine);
            itemAction.putParam("prmtWP", this.prmtWP);
            itemAction.putParam("prmtProductLineWP", this.prmtProductLineWP);
            itemAction.putParam("ui", (Object)this);
            manager.registerAction((IUIContextAction)itemAction);
        } else if (manager.getType().equals(UICTX_QCGroup_Changed)) {
            QCMMPatrolReportQCGroupActionForFilterUI itemAction = new QCMMPatrolReportQCGroupActionForFilterUI();
            itemAction.putParam("prmtCheckGroup", this.prmtCheckGroup);
            itemAction.putParam("prmtChecker", this.prmtChecker);
            manager.registerAction((IUIContextAction)itemAction);
        } else if (manager.getType().equals(UICTX_BizType_Changed)) {
            QCMMPatrolReportBizTypeActionForFilterUI itemAction = new QCMMPatrolReportBizTypeActionForFilterUI();
            itemAction.putParam("prmtProductLine", this.prmtProductLine);
            itemAction.putParam("prmtTechLine", this.prmtTechLine);
            itemAction.putParam("comboBizType", this.comboBizType);
            itemAction.putParam("prmtMaterial", this.prmtMaterial);
            itemAction.putParam("prmtWP", this.prmtWP);
            itemAction.putParam("prmtProductLineWP", this.prmtProductLineWP);
            itemAction.putParam("prmtQualityOrgUnit", this.prmtQualityOrgUnit);
            itemAction.putParam("prmtPatrolPlan", this.prmtPatrolPlan);
            itemAction.putParam("prmtBillNumberStart", this.prmtBillNumberStart);
            itemAction.putParam("prmtBillNumberEnd", this.prmtBillNumberEnd);
            manager.registerAction((IUIContextAction)itemAction);
        } else if (manager.getType().equals(UICTX_Material_Changed)) {
            QCMMPatrolReportMaterialActionForFilterUI itemAction = new QCMMPatrolReportMaterialActionForFilterUI();
            itemAction.putParam("prmtProductLine", this.prmtProductLine);
            itemAction.putParam("prmtTechLine", this.prmtTechLine);
            itemAction.putParam("prmtWP", this.prmtWP);
            itemAction.putParam("prmtProductLineWP", this.prmtProductLineWP);
            itemAction.putParam("prmtPatrolPlan", this.prmtPatrolPlan);
            itemAction.putParam("prmtMaterial", this.prmtMaterial);
            itemAction.putParam("prmtQualityOrgUnit", this.prmtQualityOrgUnit);
            manager.registerAction((IUIContextAction)itemAction);
        } else if (manager.getType().equals(UICTX_ProductLine_Changed)) {
            QCMMPatrolReportProductLineActionForFilterUI itemAction = new QCMMPatrolReportProductLineActionForFilterUI();
            itemAction.putParam("prmtProductLine", this.prmtProductLine);
            itemAction.putParam("prmtProductLineWP", this.prmtProductLineWP);
            itemAction.putParam("prmtPatrolPlan", this.prmtPatrolPlan);
            manager.registerAction((IUIContextAction)itemAction);
        } else if (manager.getType().equals(UICTX_TechLine_Changed)) {
            QCMMPatrolReportTechLineActionForFilterUI itemAction = new QCMMPatrolReportTechLineActionForFilterUI();
            itemAction.putParam("prmtTechLine", this.prmtTechLine);
            itemAction.putParam("prmtWP", this.prmtWP);
            itemAction.putParam("prmtPatrolPlan", this.prmtPatrolPlan);
            manager.registerAction((IUIContextAction)itemAction);
        }
    }

    private void initF7Selector() throws BOSException, EASBizException {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("id");
        sic.add("number");
        sic.add("name");
        sic.add("planEntrys.*");
        sic.add("planEntrys.material.id");
        sic.add("planEntrys.material.number");
        this.prmtPatrolPlan.setSelectorCollection(sic);
    }

    public void registerQueryFilterManager(IQueryFilterManager manager) {
        super.registerQueryFilterManager(manager);
        CompositeFilterElement rootElement = this.getFilterManager().getRootElement();
        new BillStatusAction((CoreUIObject)this, this.comboBillStatus);
        new BizTypeAction((CoreUIObject)this, this.comboBizType);
        rootElement.add((IFilterElement)new SingleFilterElement("billStatus", (Component)this.comboBillStatus));
        rootElement.add((IFilterElement)new SingleFilterElement("productDept.id", (Component)this.prmtAdminOrgUnit));
        rootElement.add((IFilterElement)new SingleFilterElement("billType.QCBizType", (Component)this.comboBizType));
        rootElement.add((IFilterElement)new SingleFilterElement("qCGroup.id", (Component)this.prmtCheckGroup));
        rootElement.add((IFilterElement)new SingleFilterElement("checker.id", (Component)this.prmtChecker));
        rootElement.add((IFilterElement)new SingleFilterElement("routingInspectionPlan.id", (Component)this.prmtPatrolPlan));
        rootElement.add((IFilterElement)new SingleFilterElement("material.id", (Component)this.prmtMaterial));
        rootElement.add((IFilterElement)new SingleFilterElement("standardRooting.id", (Component)this.prmtTechLine));
        rootElement.add((IFilterElement)new SingleFilterElement("productLine.id", (Component)this.prmtProductLine));
        rootElement.add((IFilterElement)new SingleFilterElement("sourceBillNumber", (Component)this.txtProductOrderNo, (Object)CompareType.LIKE));
        RangeFilterElement number = new RangeFilterElement("number", (Component)this.prmtBillNumberStart, (Component)this.prmtBillNumberEnd);
        number.getFrom().putUserInfo("key", "number");
        number.getTo().putUserInfo("key", "number");
        rootElement.add((IFilterElement)number);
        RangeFilterElement bizDate = new RangeFilterElement("reportDate", (Component)this.pkBizDateStart, (Component)this.pkBizDateEnd);
        bizDate.setDefaultValue((Object)new String[]{QMDateUtils.getLastMonthString(), QMDateUtils.getDayBeginString()});
        rootElement.add((IFilterElement)bizDate);
        if (this.comboBizType.getSelectedItem() != null) {
            SingleFilterElement wpNoFilterElement = new SingleFilterElement("wpNo", (Component)this.prmtWP);
            wpNoFilterElement.putUserInfo("key", "wpSeq");
            SingleFilterElement productLineWpNoFilterElement = new SingleFilterElement("wpNo", (Component)this.prmtProductLineWP);
            productLineWpNoFilterElement.putUserInfo("key", "number");
            rootElement.add((IFilterElement)wpNoFilterElement);
            rootElement.add((IFilterElement)productLineWpNoFilterElement);
        }
    }

    public boolean verify() {
        Date from = (Date)this.pkBizDateStart.getValue();
        Date to = (Date)this.pkBizDateEnd.getValue();
        if (from == null) {
            MsgBox.showWarning((Component)((Object)this), (String)QCMMPatrolReportEditUIHelper.getMsg("FilterUI_Verify1", null));
            this.pkBizDateStart.requestFocus();
            SysUtil.abort();
        }
        if (to == null) {
            MsgBox.showWarning((Component)((Object)this), (String)QCMMPatrolReportEditUIHelper.getMsg("FilterUI_Verify2", null));
            this.pkBizDateEnd.requestFocus();
            SysUtil.abort();
        }
        if (from != null && to != null && from.after(to)) {
            MsgBox.showWarning((Component)((Object)this), (String)QCMMPatrolReportEditUIHelper.getMsg("FilterUI_Verify3", null));
            this.pkBizDateStart.requestFocus();
            SysUtil.abort();
        }
        if (this.prmtBillNumberStart.getData() != null && this.prmtBillNumberEnd.getData() == null || this.prmtBillNumberStart.getData() == null && this.prmtBillNumberEnd.getData() != null) {
            MsgBox.showWarning((Component)((Object)this), (String)QCMMPatrolReportEditUIHelper.getMsg("FilterUI_Verify4", null));
            this.prmtBillNumberStart.requestFocus();
            SysUtil.abort();
        }
        boolean b = super.verify();
        return b;
    }

    public static FilterInfo removeFilter(FilterInfo filter, String condition) {
        if (StringUtil.isEmpty((String)condition)) {
            return null;
        }
        if (filter != null && filter.getFilterItems() != null) {
            for (int i = 0; i < filter.getFilterItems().size(); ++i) {
                if (!condition.equals(filter.getFilterItems().get(i).get("propertyName"))) continue;
                filter.getFilterItems().remove(filter.getFilterItems().get(i));
                filter.setMaskString("#0 OR #1");
                break;
            }
        }
        return filter;
    }

    public static FilterInfo addFilter(FilterInfo filter, String condition, Set set) throws BOSException {
        if (StringUtil.isEmpty((String)condition)) {
            return null;
        }
        FilterInfo tempfilter = new FilterInfo();
        tempfilter.getFilterItems().add(new FilterItemInfo(condition, (Object)set, CompareType.INCLUDE));
        filter.mergeFilter(tempfilter, "and");
        return filter;
    }
}

