/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.qm.qc.client;

import com.kingdee.bos.appframework.client.servicebinding.ActionProxyFactory;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.ctrl.swing.KDMenuItem;
import com.kingdee.bos.ctrl.swing.util.CtrlFormatUtilities;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IItemAction;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.eas.base.btp.client.BTPBillListImpl;
import com.kingdee.eas.framework.CoreBillBaseCollection;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.client.CoreBillListUI;
import com.kingdee.eas.framework.client.IBTPBillList;
import com.kingdee.eas.qm.common.QMBillBaseStatusEnum;
import com.kingdee.eas.qm.common.client.QMCoreBaseFilterUI;
import com.kingdee.eas.qm.common.client.util.QMClientUtils;
import com.kingdee.eas.qm.common.print.ITDPrintStrategy;
import com.kingdee.eas.qm.common.util.KDTableUtils;
import com.kingdee.eas.qm.qc.IQCReinspectReq;
import com.kingdee.eas.qm.qc.QCBillInfo;
import com.kingdee.eas.qm.qc.QCReinspectReqCollection;
import com.kingdee.eas.qm.qc.QCReinspectReqFactory;
import com.kingdee.eas.qm.qc.QCReinspectReqInfo;
import com.kingdee.eas.qm.qc.QCSampleInfo;
import com.kingdee.eas.qm.qc.QCUITypeEnum;
import com.kingdee.eas.qm.qc.client.AbstractQCReinspectReqListUI;
import com.kingdee.eas.qm.qc.client.print.QCReinspectReqTDPrintStrategyFactory;
import com.kingdee.eas.qm.qc.client.util.QMBotpInstanceUIHelper;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.Action;
import javax.swing.JMenuItem;
import org.apache.log4j.Logger;

public class QCReinspectReqListUI
extends AbstractQCReinspectReqListUI {
    private static final long serialVersionUID = -6090099997257604114L;
    private static final Logger logger = CoreUIObject.getLogger(QCReinspectReqListUI.class);
    private IBTPBillList billList = null;

    @Override
    protected ICoreBase getBizInterface() throws Exception {
        return QCReinspectReqFactory.getRemoteInstanceWithObjectContext(this.getMainOrgContext());
    }

    protected Class getEntityModel() {
        return IQCReinspectReq.class;
    }

    @Override
    protected IObjectValue createNewData() {
        QCReinspectReqInfo objectValue = new QCReinspectReqInfo();
        return objectValue;
    }

    public void actionCreateTo_actionPerformed(ActionEvent e) throws Exception {
        this.getUIContext().put("QCBizType", this.getQCBizType());
        super.actionCreateTo_actionPerformed(e);
    }

    protected QMCoreBaseFilterUI newInstanceFilterUI() throws Exception {
        return null;
    }

    @Override
    public void actionCreateToQCBill_actionPerformed(ActionEvent e) throws Exception {
        this.getUIContext().put("QCBizType", this.getQCBizType());
        this.getUIContext().put("currentCreateTo", new QCBillInfo().getBOSType().toString());
        this.checkSelected();
        ArrayList idList = new ArrayList();
        ArrayList entriesKey = new ArrayList();
        this.getBillIdList(idList, entriesKey);
        this.verifyCreateToQCBill(idList);
        String[] idArray = new String[idList.size()];
        idList.toArray(idArray);
        this.billList.createTo(idArray, new String[]{this.getEntriesName()}, entriesKey, this.getBizType().toString(), this.getBOTPSelectors());
    }

    protected void verifyCreateToQCBill(List idList) throws Exception {
        HashSet set = new HashSet();
        for (int i = 0; i < idList.size(); ++i) {
            set.add(idList.get(i));
        }
        EntityViewInfo e = new EntityViewInfo();
        e.getSelector().add("id");
        e.getSelector().add("number");
        e.getSelector().add("billStatus");
        e.getSelector().add("isResample");
        e.getSelector().add("isExistDownstre");
        FilterInfo info = new FilterInfo();
        info.getFilterItems().add(new FilterItemInfo("id", set, CompareType.INCLUDE));
        e.setFilter(info);
        QCReinspectReqCollection col = QCReinspectReqFactory.getRemoteInstanceWithObjectContext(this.getMainOrgContext()).getQCReinspectReqCollection(e);
        String errorMsg = "";
        int size = col.size();
        for (int i = 0; i < size; ++i) {
            QCReinspectReqInfo bill = col.get(i);
            String number = bill.getNumber();
            QMBillBaseStatusEnum billStatus = bill.getBillStatus();
            boolean isResample = bill.isIsResample();
            boolean isExistDownstre = bill.isIsExistDownstre();
            if (billStatus.getValue() != 30) {
                errorMsg = errorMsg + MessageFormat.format(EASResource.getString((String)"com.kingdee.eas.qm.qc.QCReinspectReqResource", (String)"UNAUDIT_CANNOT_CREATETO_LIST"), number) + "\n";
                continue;
            }
            if (isResample) {
                errorMsg = errorMsg + MessageFormat.format(EASResource.getString((String)"com.kingdee.eas.qm.qc.QCReinspectReqResource", (String)"RESAMPLE_CANNOT_CREATETO_LIST"), number) + "\n";
                continue;
            }
            if (!isExistDownstre) continue;
            errorMsg = errorMsg + MessageFormat.format(EASResource.getString((String)"com.kingdee.eas.qm.qc.QCReinspectReqResource", (String)"ALREADY_CREATED_LIST"), number) + "\n";
        }
        if (!errorMsg.equals("")) {
            MsgBox.showInfo((Component)((Object)this), (String)errorMsg);
            SysUtil.abort();
        }
    }

    protected void verifyCreateTOQCSample(List idList) throws Exception {
        HashSet set = new HashSet();
        for (int i = 0; i < idList.size(); ++i) {
            set.add(idList.get(i));
        }
        EntityViewInfo e = new EntityViewInfo();
        e.getSelector().add("id");
        e.getSelector().add("number");
        e.getSelector().add("billStatus");
        e.getSelector().add("isResample");
        e.getSelector().add("isExistDownstre");
        FilterInfo info = new FilterInfo();
        info.getFilterItems().add(new FilterItemInfo("id", set, CompareType.INCLUDE));
        e.setFilter(info);
        QCReinspectReqCollection col = QCReinspectReqFactory.getRemoteInstanceWithObjectContext(this.getMainOrgContext()).getQCReinspectReqCollection(e);
        String errorMsg = "";
        int size = col.size();
        for (int i = 0; i < size; ++i) {
            QCReinspectReqInfo bill = col.get(i);
            String number = bill.getNumber();
            QMBillBaseStatusEnum billStatus = bill.getBillStatus();
            boolean isResample = bill.isIsResample();
            boolean isExistDownstre = bill.isIsExistDownstre();
            if (billStatus.getValue() != 30) {
                errorMsg = errorMsg + MessageFormat.format(EASResource.getString((String)"com.kingdee.eas.qm.qc.QCReinspectReqResource", (String)"UNAUDIT_CANNOT_CREATETO_LIST"), number) + "\n";
                continue;
            }
            if (!isResample) {
                errorMsg = errorMsg + MessageFormat.format(EASResource.getString((String)"com.kingdee.eas.qm.qc.QCReinspectReqResource", (String)"NOTRESAMPLE_CANNOT_CREATETO_LIST"), number) + "\n";
                continue;
            }
            if (!isExistDownstre) continue;
            errorMsg = errorMsg + MessageFormat.format(EASResource.getString((String)"com.kingdee.eas.qm.qc.QCReinspectReqResource", (String)"ALREADY_CREATED_LIST"), number) + "\n";
        }
        if (!errorMsg.equals("")) {
            MsgBox.showInfo((Component)((Object)this), (String)errorMsg);
            SysUtil.abort();
        }
    }

    @Override
    public void actionCreateToQCSample_actionPerformed(ActionEvent e) throws Exception {
        this.getUIContext().put("QCBizType", this.getQCBizType());
        this.getUIContext().put("currentCreateTo", new QCSampleInfo().getBOSType().toString());
        this.checkSelected();
        ArrayList idList = new ArrayList();
        ArrayList entriesKey = new ArrayList();
        this.getBillIdList(idList, entriesKey);
        this.verifyCreateTOQCSample(idList);
        String[] idArray = new String[idList.size()];
        idList.toArray(idArray);
        this.billList.createTo(idArray, new String[]{this.getEntriesName()}, entriesKey, this.getBizType().toString(), this.getBOTPSelectors());
    }

    public void onLoad() throws Exception {
        super.onLoad();
        KDTableUtils.setFieldsHorizontalAlignment((Styles.HorizontalAlignment)Styles.HorizontalAlignment.RIGHT, (KDTable)this.tblMain, (String[])new String[]{"deliverQty", "sampleQty", "qcSequence", "entrys.seq", "entrys.lower", "entrys.upper"});
        this.actionTDPrint.setEnabled(false);
        this.actionTDPrint.setVisible(false);
        this.actionTDPrintPreview.setEnabled(false);
        this.actionTDPrintPreview.setVisible(false);
        this.tblMain.getColumn("bizDate").getStyleAttributes().setNumberFormat(CtrlFormatUtilities.getDateFormatString());
        this.tblMain.getColumn("reqFinishDate").getStyleAttributes().setNumberFormat(CtrlFormatUtilities.getDateFormatString());
        this.tblMain.getColumn("auditTime").getStyleAttributes().setNumberFormat(CtrlFormatUtilities.getDateFormatString());
        this.tblMain.getColumn("createTime").getStyleAttributes().setNumberFormat(CtrlFormatUtilities.getDateFormatString());
        this.tblMain.getColumn("lastUpdateTime").getStyleAttributes().setNumberFormat(CtrlFormatUtilities.getDateFormatString());
        this.billList = new BTPBillListImpl((CoreBillListUI)this);
        this.billList.init();
    }

    public List getDestBosTypeForBotp(CoreBillBaseCollection srcBillInfos, List destBosTypeList) {
        if (destBosTypeList != null && destBosTypeList.size() > 0) {
            Iterator it = destBosTypeList.iterator();
            while (it.hasNext()) {
                if (this.getUIContext().get("currentCreateTo").equals(it.next())) continue;
                it.remove();
            }
        }
        return destBosTypeList;
    }

    protected void initActionStatus() {
        super.initActionStatus();
        this.actionCreateToQCBill.setEnabled(true);
        this.actionCreateToQCBill.setVisible(true);
        this.actionCreateToQCSample.setEnabled(true);
        this.actionCreateToQCSample.setVisible(true);
    }

    public QCUITypeEnum getQCBizType() {
        return null;
    }

    public String getInstanceListUIClassName(Map uiContext, QCUITypeEnum qcBizType) {
        String listUIClassName = "";
        if (qcBizType == null) {
            return listUIClassName;
        }
        if (QCUITypeEnum.purCheck == qcBizType) {
            listUIClassName = "com.kingdee.eas.qm.qc.client.QCPurReinspectReqListUI";
        } else if (QCUITypeEnum.invCheck == qcBizType) {
            listUIClassName = "com.kingdee.eas.qm.qc.client.QCInvReinspectReqListUI";
        } else if (QCUITypeEnum.pdtCheck == qcBizType) {
            listUIClassName = "com.kingdee.eas.qm.qc.client.QCMMReinspectReqListUI";
        } else if (QCUITypeEnum.otherCheck == qcBizType) {
            listUIClassName = "com.kingdee.eas.qm.qc.client.QCOtherReinspectReqListUI";
        }
        return listUIClassName;
    }

    @Override
    public void actionUnAudit_actionPerformed(ActionEvent e) throws Exception {
        super.actionUnAudit_actionPerformed(e);
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.menuCreateToFromQCReinspecReq.setIcon(QMClientUtils.getIcon((String)"imgTbtn_zoomdown"));
        this.btnCreateToQCBill.setIcon(QMClientUtils.getIcon((String)"imgTbtn_zoomdown"));
        KDMenuItem createToQCSampleMenuItem = new KDMenuItem();
        createToQCSampleMenuItem.setAction((Action)((IItemAction)ActionProxyFactory.getProxy((Object)((Object)this.actionCreateToQCSample), (Class[])new Class[]{IItemAction.class}, (Map)this.getServiceContext())));
        this.btnCreateToQCBill.addAssistMenuItem((JMenuItem)createToQCSampleMenuItem);
        KDMenuItem createToQCBillMenuItem = new KDMenuItem();
        createToQCBillMenuItem.setAction((Action)((IItemAction)ActionProxyFactory.getProxy((Object)((Object)this.actionCreateToQCBill), (Class[])new Class[]{IItemAction.class}, (Map)this.getServiceContext())));
        this.btnCreateToQCBill.addAssistMenuItem((JMenuItem)createToQCBillMenuItem);
    }

    public IUIObject getInstance(Map uiContext) {
        QCUITypeEnum qcBizType = QMBotpInstanceUIHelper.getUITypeFromBotpCtxForListUI(uiContext);
        if (qcBizType == null) {
            return null;
        }
        String listUIClassName = this.getInstanceListUIClassName(uiContext, qcBizType);
        IUIObject uiObj = null;
        try {
            uiObj = (IUIObject)Class.forName(listUIClassName).newInstance();
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
        return uiObj;
    }

    public void actionTraceDown_actionPerformed(ActionEvent e) throws Exception {
        this.getUIContext().put("QCBizType", this.getQCBizType());
        super.actionTraceDown_actionPerformed(e);
    }

    public void actionTraceUp_actionPerformed(ActionEvent e) throws Exception {
        this.getUIContext().put("QCBizType", this.getQCBizType());
        super.actionTraceUp_actionPerformed(e);
    }

    @Override
    protected void recycleNumberByOrg(IObjectValue editData, String orgType, String number) {
    }

    protected String getPrintLogItem() {
        return "qm_QCPurReinspectReq_print";
    }

    @Override
    public void actionTDPrint_actionPerformed(ActionEvent e) throws Exception {
        this.doInvokeTDPrint(true);
    }

    @Override
    public void actionTDPrintPreview_actionPerformed(ActionEvent e) throws Exception {
        this.doInvokeTDPrint(false);
    }

    public ITDPrintStrategy getTDPrintStrategy() throws Exception {
        ITDPrintStrategy printStrategy = QCReinspectReqTDPrintStrategyFactory.buildTDPrintStrategy(this.getQCBizType());
        return printStrategy;
    }
}

