/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.qm.qc.client;

import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.qm.common.filter.CompositeFilterElement;
import com.kingdee.eas.qm.common.filter.IFilterElement;
import com.kingdee.eas.qm.common.filter.IQueryFilterManager;
import com.kingdee.eas.qm.common.filter.RangeFilterElement;
import com.kingdee.eas.qm.common.filter.SingleFilterElement;
import com.kingdee.eas.qm.qc.client.AbstractQCRelateWeighFilterUI;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.util.Date;
import org.apache.log4j.Logger;

public class QCRelateWeighFilterUI
extends AbstractQCRelateWeighFilterUI {
    private static final Logger logger = CoreUIObject.getLogger(QCRelateWeighFilterUI.class);
    private static final String PUR_TYPE_NUM = "WT001";

    public void onLoad() throws Exception {
        super.onLoad();
        this.dpGrossWeightEndTime.setValue(null);
        this.dpGrossWeightStartTime.setValue(null);
        this.dpTareWeightEndTime.setValue(null);
        this.dpTareWeightStartTime.setValue(null);
    }

    public void clear() {
        super.clear();
    }

    public void registerQueryFilterManager(IQueryFilterManager manager) {
        super.registerQueryFilterManager(manager);
        CompositeFilterElement rootElement = this.getFilterManager().getRootElement();
        SingleFilterElement prmtWeighType = new SingleFilterElement("prmtWeighType", (Component)this.prmtWeighType);
        SingleFilterElement combWeighStatus = new SingleFilterElement("combWeighStatus", (Component)this.combWeighStatus);
        SingleFilterElement carNum = new SingleFilterElement("carNum", (Component)this.carNum);
        RangeFilterElement grossWeightTime = new RangeFilterElement("GrossWeightTime", (Component)this.dpGrossWeightStartTime, (Component)this.dpGrossWeightEndTime);
        RangeFilterElement tareWeightTime = new RangeFilterElement("TareWeightTime", (Component)this.dpTareWeightStartTime, (Component)this.dpTareWeightEndTime);
        rootElement.add((IFilterElement)prmtWeighType);
        rootElement.add((IFilterElement)combWeighStatus);
        rootElement.add((IFilterElement)grossWeightTime);
        rootElement.add((IFilterElement)tareWeightTime);
        rootElement.add((IFilterElement)carNum);
    }

    public boolean verify() {
        super.verify();
        if (this.prmtWeighType.getValue() == null) {
            MsgBox.showInfo((String)this.getMultiLangString("WEIGHTYPE_IS_NULL"));
            this.prmtWeighType.requestFocus();
            return false;
        }
        Date fromdate = (Date)this.dpTareWeightStartTime.getValue();
        Date todate = (Date)this.dpTareWeightEndTime.getValue();
        if (fromdate != null && todate != null && fromdate.after(todate)) {
            MsgBox.showInfo((String)this.getMultiLangString("TAREWEIGHT_ISNOT_RIGHTDATE"));
            this.dpTareWeightEndTime.setValue(null);
            this.dpTareWeightEndTime.requestFocus();
            return false;
        }
        fromdate = (Date)this.dpGrossWeightStartTime.getValue();
        todate = (Date)this.dpGrossWeightEndTime.getValue();
        if (fromdate != null && todate != null && fromdate.after(todate)) {
            MsgBox.showInfo((String)this.getMultiLangString("GROSSWEIGHT_ISNOT_RIGHTDATE"));
            this.dpGrossWeightEndTime.setValue(null);
            this.dpGrossWeightEndTime.requestFocus();
            return false;
        }
        return true;
    }

    protected String getMultiLangString(String key) {
        return EASResource.getString((String)"com.kingdee.eas.qm.qc.client.QCRelateWeighFilterResource", (String)key);
    }
}

