/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.qm.qc.client;

import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.org.CtrlUnitFactory;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.QualityOrgUnitInfo;
import com.kingdee.eas.qm.basedata.QCBizTypeEnum;
import com.kingdee.eas.qm.basedata.SampleSolutionEnum;
import com.kingdee.eas.qm.basedata.client.util.F7BDRegUtils;
import com.kingdee.eas.qm.common.filter.CompositeFilterElement;
import com.kingdee.eas.qm.common.filter.IFilterElement;
import com.kingdee.eas.qm.common.filter.IQueryFilterManager;
import com.kingdee.eas.qm.common.filter.RangeFilterElement;
import com.kingdee.eas.qm.common.filter.SingleFilterElement;
import com.kingdee.eas.qm.common.util.QMDateUtils;
import com.kingdee.eas.qm.qc.QCRequestInfo;
import com.kingdee.eas.qm.qc.client.AbstractQCReportCreateFilterUI;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.apache.log4j.Logger;

public class QCReportCreateFilterUI
extends AbstractQCReportCreateFilterUI {
    private static final long serialVersionUID = 513278059713218659L;
    private static final Logger logger = CoreUIObject.getLogger(QCReportCreateFilterUI.class);

    public QCReportCreateFilterUI() throws Exception {
        logger.debug((Object)"QCReportCreateFilterUI");
    }

    public void onLoad() throws Exception {
        super.onLoad();
        Calendar a = Calendar.getInstance();
        a.add(2, -1);
        this.pkReqDateBegin.setValue((Object)a.getTime());
        a = Calendar.getInstance();
        a.add(2, 1);
        this.pkReqDateEnd.setValue((Object)a.getTime());
        this.prmtSamplePlan.setSelectedItem((Object)SampleSolutionEnum.takeOutCheck);
    }

    public void registerQueryFilterManager(IQueryFilterManager manager) {
        super.registerQueryFilterManager(manager);
        CompositeFilterElement rootElement = this.getFilterManager().getRootElement();
        SingleFilterElement prmtSamplePlan = new SingleFilterElement("prmtSamplePlan", (Component)this.prmtSamplePlan);
        SingleFilterElement requestNumber = new SingleFilterElement("request.id", (Component)this.prmtRequestNumber);
        SingleFilterElement materialNumber = new SingleFilterElement("material.id", (Component)this.prmtMaterial);
        RangeFilterElement datetime = new RangeFilterElement("datetime", (Component)this.pkReqDateBegin, (Component)this.pkReqDateEnd);
        datetime.setDefaultValue((Object)new String[]{QMDateUtils.getLastMonthString(), QMDateUtils.getDayBeginString()});
        rootElement.add((IFilterElement)prmtSamplePlan);
        rootElement.add((IFilterElement)requestNumber);
        rootElement.add((IFilterElement)materialNumber);
        rootElement.add((IFilterElement)datetime);
    }

    public void doQCRequestBillFilter(KDBizPromptBox prmt) throws Exception {
        QualityOrgUnitInfo orgInfo = (QualityOrgUnitInfo)this.prmtCreateOrg.getData();
        String orgID = "";
        if (orgInfo != null) {
            orgID = orgInfo.getId().toString();
        }
        EntityViewInfo ev = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("qualityOrgUnit.id", (Object)orgID, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("billStatus", (Object)new Integer(30), CompareType.EQUALS));
        QCBizTypeEnum[] bizTypes = (QCBizTypeEnum[])this.getUIContext().get("QCBizType");
        if (bizTypes != null && bizTypes.length > 0) {
            HashSet<Integer> typeSet = new HashSet<Integer>();
            for (int i = 0; i < bizTypes.length; ++i) {
                typeSet.add(new Integer(bizTypes[i].getValue()));
            }
            filter.getFilterItems().add(new FilterItemInfo("billType.QCBizType", typeSet, CompareType.INCLUDE));
        }
        ev.setFilter(filter);
        prmt.setEntityViewInfo(ev);
    }

    public void doMaterialFilter() throws Exception {
        QualityOrgUnitInfo orgInfo = (QualityOrgUnitInfo)this.prmtCreateOrg.getData();
        this.prmtMaterial = F7BDRegUtils.regMaterialF7((KDBizPromptBox)this.prmtMaterial, (Object)((Object)this), (boolean)false, (OrgType)OrgType.Quality, (OrgUnitInfo)orgInfo);
        if (orgInfo != null && orgInfo.getCU() != null) {
            orgInfo.setCU(CtrlUnitFactory.getRemoteInstance().getCtrlUnitInfo((IObjectPK)new ObjectUuidPK(orgInfo.getCU().getId())));
            this.prmtMaterial.setCurrentCtrlUnit(orgInfo.getCU());
        }
    }

    public void setCreateOrgInfo(QualityOrgUnitInfo orgInfo) throws Exception {
        this.prmtCreateOrg.setData((Object)orgInfo);
        this.doQCRequestBillFilter(this.prmtRequestNumber);
        this.doMaterialFilter();
    }

    public Map getFilterMap() {
        HashMap<String, Object> filters = new HashMap<String, Object>();
        String orgID = ((QualityOrgUnitInfo)this.prmtCreateOrg.getData()).getId().toString();
        filters.put("MainOrgID", orgID);
        if (this.prmtRequestNumber.getData() != null) {
            QCRequestInfo requestInfo = (QCRequestInfo)this.prmtRequestNumber.getData();
            filters.put("RequestBillID", requestInfo.getId().toString());
        }
        if (this.prmtMaterial.getData() != null) {
            MaterialInfo materialInfo = (MaterialInfo)this.prmtMaterial.getData();
            filters.put("MaterialID", materialInfo.getId().toString());
        }
        if (this.pkReqDateBegin.getValue() != null && this.pkReqDateEnd.getValue() != null) {
            HashMap<String, Object> dateMap = new HashMap<String, Object>();
            dateMap.put("Begin", this.pkReqDateBegin.getValue());
            dateMap.put("End", this.pkReqDateEnd.getValue());
            filters.put("ReqDate", dateMap);
        }
        if (this.prmtSamplePlan.getSelectedItem() != null) {
            SampleSolutionEnum samp = (SampleSolutionEnum)this.prmtSamplePlan.getSelectedItem();
            filters.put("samplePlan", new Integer(samp.getValue()));
        }
        return filters;
    }

    public boolean verify() {
        boolean flag = super.verify();
        if (this.prmtCreateOrg.getData() == null) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.qm.qc.QCAutoGenerateResource", (String)"22_QCReportCreateFilterUI"));
            SysUtil.abort();
            return false;
        }
        if (this.pkReqDateBegin.getValue() != null && this.pkReqDateEnd.getValue() == null || this.pkReqDateBegin.getValue() == null && this.pkReqDateEnd.getValue() != null) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.qm.qc.QCAutoGenerateResource", (String)"23_QCReportCreateFilterUI"));
            SysUtil.abort();
            return false;
        }
        Date beginDate = (Date)this.pkReqDateBegin.getValue();
        Date endDate = (Date)this.pkReqDateEnd.getValue();
        if (beginDate != null && endDate != null && beginDate.compareTo(endDate) == 1) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.qm.qc.QCAutoGenerateResource", (String)"24_QCReportCreateFilterUI"));
            SysUtil.abort();
            return false;
        }
        return flag;
    }

    public boolean isLoading() {
        return true;
    }
}

