/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.qm.qc.client;

import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.swing.KDFormattedTextField;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.ui.face.ItemAction;
import com.kingdee.eas.basedata.assistant.MeasureUnitInfo;
import com.kingdee.eas.basedata.org.QualityOrgUnitInfo;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.qm.basedata.QCGroupInfo;
import com.kingdee.eas.qm.basedata.QCIdentityEnum;
import com.kingdee.eas.qm.basedata.QCInstrumentGroupInfo;
import com.kingdee.eas.qm.basedata.QCItemInfo;
import com.kingdee.eas.qm.basedata.QCSamplingProgramInfo;
import com.kingdee.eas.qm.basedata.QCStrategyEnum;
import com.kingdee.eas.qm.basedata.QCValueAcquisitionModeEnum;
import com.kingdee.eas.qm.basedata.QCValueTypeEnum;
import com.kingdee.eas.qm.common.util.QMPrecisionUtil;
import com.kingdee.eas.qm.qc.QCItemBaseInfo;
import com.kingdee.eas.qm.qc.QCItemSampleEntryCollection;
import com.kingdee.eas.qm.qc.QCReportEntryInfo;
import com.kingdee.eas.qm.qc.client.AbstractQCReportEntryEditUI;
import com.kingdee.eas.qm.qc.client.QCReportEditUI;
import com.kingdee.eas.qm.qc.client.util.QCUIUtil;
import com.kingdee.eas.qm.qc.client.util.qcreport.QCReportEditUIF7FilterHelper;
import com.kingdee.eas.qm.qc.client.util.qcreport.QCReportEditUIHelper;
import com.kingdee.util.StringUtils;
import java.math.BigDecimal;
import org.apache.log4j.Logger;

public class QCReportEntryEditUI
extends AbstractQCReportEntryEditUI {
    private static final long serialVersionUID = 8750044790412424870L;
    private static Logger logger = Logger.getLogger(QCReportEntryEditUI.class);

    public QCReportEntryEditUI() throws Exception {
        this.txtEachSampleQty.setMaximumValue((Comparable)QMPrecisionUtil.BigDecimal_MaxValue);
        this.txtSampleQty.setMaximumValue((Comparable)QMPrecisionUtil.BigDecimal_MaxValue);
    }

    @Override
    protected void doAfterLoadAndSwitch() {
        super.doAfterLoadAndSwitch();
    }

    @Override
    protected QCItemSampleEntryCollection getCurrEntryColl() {
        QCReportEntryInfo info = (QCReportEntryInfo)this.currInfo;
        return info.getSampleEntry();
    }

    @Override
    protected void setControlStatusByOwnerUI() {
        super.setControlStatusByOwnerUI();
        this.prmtDelegOrgUnit.setEntityViewInfo(QCReportEditUIF7FilterHelper.getDeleGOrgUnitView());
        QualityOrgUnitInfo delegateOrgInfo = (QualityOrgUnitInfo)this.prmtDelegOrgUnit.getValue();
        this.prmtQCInstrumentGroup.setEntityViewInfo(QCReportEditUIF7FilterHelper.getQCInstrumentGroupView());
        QCInstrumentGroupInfo groupInfo = (QCInstrumentGroupInfo)this.prmtQCInstrumentGroup.getValue();
        QCGroupInfo qcGroupInfo = (QCGroupInfo)this.prmtQCGroup.getValue();
        this.configF7QCGroup(delegateOrgInfo);
        this.configF7QCInstrument(delegateOrgInfo, groupInfo);
        this.configF7Checker(qcGroupInfo);
        if (!(this.getOwnerUI() instanceof QCReportEditUI)) {
            return;
        }
        QCReportEditUI ownerUI = (QCReportEditUI)this.getOwnerUI();
        KDTable itemTable = ownerUI.getQCItemTable();
        if (this.currIndex < 0 || this.currIndex >= itemTable.getRowCount()) {
            return;
        }
        IRow row = itemTable.getRow(this.currIndex);
        this.prmtDelegOrgUnit.setEnabled(!row.getCell("delegateQualityOrg").getStyleAttributes().isLocked());
        this.prmtQCGroup.setEnabled(!row.getCell("qCGroup").getStyleAttributes().isLocked());
        this.prmtChecker.setEnabled(!row.getCell("checker").getStyleAttributes().isLocked());
        this.prmtQCInstrumentGroup.setEnabled(!row.getCell("qCInstrumentGroup").getStyleAttributes().isLocked());
        this.prmtQCInstrument.setEnabled(!row.getCell("qCInstrument").getStyleAttributes().isLocked());
        this.chkIsMustCheck.setEnabled(!row.getCell("isMustCheck").getStyleAttributes().isLocked());
        this.chkIsKeyItem.setEnabled(!row.getCell("isKeyItem").getStyleAttributes().isLocked());
        QCStrategyEnum qCStrategy = ownerUI.getQCStrategy();
        QCSamplingProgramInfo samProInfo = (QCSamplingProgramInfo)row.getCell("sampleProgram").getValue();
        if (qCStrategy != null && QCStrategyEnum.oneStepCheck.equals((Object)qCStrategy) && samProInfo == null) {
            this.txtSampleShares.setEnabled(true);
        } else {
            this.txtSampleShares.setEnabled(false);
        }
        Integer mergeQty = (Integer)row.getCell("mergeItemQty").getValue();
        if (qCStrategy != null && (QCStrategyEnum.threeStepCheck.equals((Object)qCStrategy) || QCStrategyEnum.twoStepCheck.equals((Object)qCStrategy)) && mergeQty != null && mergeQty <= 1) {
            this.txtCheckValueText.setEnabled(false);
            this.txtCheckValueNum.setEnabled(false);
            this.txtCheckValueCmb.setEnabled(false);
        }
        this.comboCheckResult.setEnabled(!row.getCell("checkResult").getStyleAttributes().isLocked());
        QCItemInfo itemInfo = (QCItemInfo)row.getCell("qcItemNumber").getValue();
        if (itemInfo != null && QCIdentityEnum.point.equals((Object)itemInfo.getQCIdentity())) {
            this.kdtSampleEntry.getColumn("defectQty").getStyleAttributes().setLocked(false);
            this.kdtSampleEntry.getColumn("eachSampleValue").getStyleAttributes().setLocked(true);
        } else {
            this.kdtSampleEntry.getColumn("defectQty").getStyleAttributes().setLocked(true);
            this.kdtSampleEntry.getColumn("eachSampleValue").getStyleAttributes().setLocked(false);
        }
        this.txtPassShares.setEnabled(!row.getCell("passShares").getStyleAttributes().isLocked());
        this.txtUnPassShares.setEnabled(!row.getCell("unPassShares").getStyleAttributes().isLocked());
        this.comboJudgeType.setEnabled(!row.getCell("judgeType").getStyleAttributes().isLocked());
        this.txtDefaultValueText.setEnabled(!row.getCell("qcDefaultValue").getStyleAttributes().isLocked());
        this.txtDefaultValueNum.setEnabled(!row.getCell("qcDefaultValue").getStyleAttributes().isLocked());
        this.txtDefaultValueCmb.setEnabled(!row.getCell("qcDefaultValue").getStyleAttributes().isLocked());
        this.comboLowerLimit.setEnabled(!row.getCell("lowerLimit").getStyleAttributes().isLocked());
        this.txtLower.setEnabled(!row.getCell("lower").getStyleAttributes().isLocked());
        this.comboUpperLimit.setEnabled(!row.getCell("upperLimit").getStyleAttributes().isLocked());
        this.txtUpper.setEnabled(!row.getCell("upper").getStyleAttributes().isLocked());
        this.txtRemark.setEnabled(!row.getCell("remark").getStyleAttributes().isLocked());
        this.txtQCDescription.setEnabled(!row.getCell("qCDescription").getStyleAttributes().isLocked());
        this.setEachSampleQtyAndSampleQtyPrecision();
        this.txtDefectQty.setEnabled(!row.getCell("defectQty").getStyleAttributes().isLocked());
        this.txtSampleNumber.setEnabled(!row.getCell("sampleNumber").getStyleAttributes().isLocked());
        if (qCStrategy != null && (QCStrategyEnum.threeStepCheck.equals((Object)qCStrategy) || QCStrategyEnum.twoStepCheck.equals((Object)qCStrategy))) {
            this.kdtSampleEntry.setEnabled(false);
            this.actionAddLine.setEnabled(false);
            this.actionRemoveLine.setEnabled(false);
            this.actionInsertLine.setEnabled(false);
        } else {
            this.kdtSampleEntry.setEnabled(true);
            QCValueAcquisitionModeEnum qcVAME = (QCValueAcquisitionModeEnum)row.getCell("qCValueAcquisitionMode").getValue();
            if (qcVAME != null && qcVAME.equals((Object)QCValueAcquisitionModeEnum.BYSAMPLEQTY)) {
                this.actionAddLine.setEnabled(true);
                this.actionRemoveLine.setEnabled(true);
                this.actionInsertLine.setEnabled(true);
            }
        }
        if (OprtState.VIEW.equals(this.getOprtState())) {
            this.setActionDisabled(new ItemAction[]{this.actionAddLine, this.actionInsertLine, this.actionRemoveLine});
            return;
        }
    }

    @Override
    protected void afterDelegOrgUnitChanged(DataChangeEvent e) {
        super.afterDelegOrgUnitChanged(e);
        QualityOrgUnitInfo delegateOrgInfo = (QualityOrgUnitInfo)e.getNewValue();
        QCInstrumentGroupInfo groupInfo = (QCInstrumentGroupInfo)this.prmtQCInstrumentGroup.getValue();
        this.configF7QCGroup(delegateOrgInfo);
        this.configF7QCInstrument(delegateOrgInfo, groupInfo);
    }

    private void configF7QCInstrument(QualityOrgUnitInfo delegateOrgInfo, QCInstrumentGroupInfo groupInfo) {
        this.prmtQCInstrument.setEntityViewInfo(QCReportEditUIF7FilterHelper.getQCInstrumentView(groupInfo, delegateOrgInfo));
    }

    private void configF7QCGroup(QualityOrgUnitInfo delegateOrgInfo) {
        this.prmtQCGroup.setEntityViewInfo(QCReportEditUIF7FilterHelper.getQCGroupView(delegateOrgInfo));
    }

    private void configF7Checker(QCGroupInfo qcGroupInfo) {
        this.prmtChecker.setEntityViewInfo(QCReportEditUIF7FilterHelper.getCheckerView(qcGroupInfo));
        this.prmtChecker.setSelectorCollection(QCReportEditUIF7FilterHelper.getCheckerSic());
    }

    @Override
    protected void afterQCGroupChanged(DataChangeEvent e) {
        super.afterQCGroupChanged(e);
        QCGroupInfo groupInfo = (QCGroupInfo)e.getNewValue();
        this.configF7Checker(groupInfo);
    }

    @Override
    protected void afterQCInstrumentGroupChanged(DataChangeEvent e) {
        super.afterQCInstrumentGroupChanged(e);
        QCInstrumentGroupInfo groupInfo = (QCInstrumentGroupInfo)e.getNewValue();
        QualityOrgUnitInfo delegateOrgInfo = (QualityOrgUnitInfo)this.prmtDelegOrgUnit.getValue();
        this.configF7QCInstrument(delegateOrgInfo, groupInfo);
    }

    @Override
    protected Object doModifyValue(QCItemBaseInfo info, Object qcResult) {
        Object modifyValue = super.doModifyValue(info, qcResult);
        try {
            QCValueTypeEnum valueType = info.getQCValueType();
            if (valueType == QCValueTypeEnum.number || valueType == QCValueTypeEnum.formula) {
                modifyValue = QCReportEditUIHelper.modifyCheckValue(info.getQCModifyMode(), modifyValue);
            }
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
        return modifyValue;
    }

    public QCReportEntryInfo getCurrEntryInfo() {
        return (QCReportEntryInfo)this.getCurrInfo();
    }

    public IRow getQCReportItemEntryRow() {
        if (!(this.getOwnerUI() instanceof QCReportEditUI)) {
            return null;
        }
        QCReportEditUI ownerUI = (QCReportEditUI)this.getOwnerUI();
        KDTable itemTable = ownerUI.getQCItemTable();
        if (this.currIndex < 0 || this.currIndex >= itemTable.getRowCount()) {
            return null;
        }
        IRow row = itemTable.getRow(this.currIndex);
        return row;
    }

    @Override
    protected boolean isNeedModifyValue() {
        return true;
    }

    @Override
    public boolean checkBeforeWindowClosing() {
        if (this.isFocusQCValue) {
            String tempValue = this.txtCheckValueNum.getText();
            BigDecimal checkValue = null;
            try {
                if (!StringUtils.isEmpty((String)tempValue)) {
                    checkValue = new BigDecimal(tempValue);
                }
            }
            catch (Exception e) {
                logger.error((Object)e);
            }
            this.txtCheckValueNum.setNumberValue((Number)checkValue);
        }
        return super.checkBeforeWindowClosing();
    }

    @Override
    protected void initListener() {
        super.initListener();
        this.txtEachSampleQty.addDataChangeListener(new DataChangeListener(){

            public void dataChanged(DataChangeEvent eventObj) {
                QCReportEntryEditUI.this.setSampleQty();
            }
        });
        this.txtSampleShares.addDataChangeListener(new DataChangeListener(){

            public void dataChanged(DataChangeEvent eventObj) {
                QCReportEntryEditUI.this.setSampleQty();
            }
        });
        this.prmtEachSampleUnit.addDataChangeListener(new DataChangeListener(){

            public void dataChanged(DataChangeEvent eventObj) {
                QCReportEntryEditUI.this.setEachSampleQtyAndSampleQtyPrecision();
            }
        });
    }

    protected void setSampleQty() {
        BigDecimal eachSampleQty = this.txtEachSampleQty.getBigDecimalValue();
        BigDecimal sampleShares = this.txtSampleShares.getBigDecimalValue();
        if (eachSampleQty != null && sampleShares != null) {
            BigDecimal sampleQty = eachSampleQty.multiply(sampleShares);
            if (sampleQty.compareTo(QMPrecisionUtil.BigDecimal_MaxValue) == 1) {
                sampleQty = QMPrecisionUtil.BigDecimal_MaxValue;
            }
            this.txtSampleQty.setValue((Object)sampleQty);
        } else {
            this.txtSampleQty.setValue((Object)new BigDecimal("0"));
        }
    }

    protected void setEachSampleQtyAndSampleQtyPrecision() {
        int dataPrecision = 4;
        Object data = this.prmtEachSampleUnit.getData();
        if (data != null && data instanceof MeasureUnitInfo) {
            MeasureUnitInfo unitInfo = (MeasureUnitInfo)data;
            dataPrecision = unitInfo.getQtyPrecision();
            this.txtEachSampleQty.setPrecision(dataPrecision);
            this.txtSampleQty.setPrecision(dataPrecision);
        }
        if (data == null) {
            this.txtEachSampleQty.setPrecision(8);
            this.txtSampleQty.setPrecision(8);
        }
    }

    @Override
    protected void configControlsAfterLoad() {
        super.configControlsAfterLoad();
        QCUIUtil.setCommitBeforeClose(new KDFormattedTextField[]{this.txtEachSampleQty, this.txtSampleQty});
    }
}

