/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.qm.qc.client;

import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.qm.basedata.QCBizTypeEnum;
import com.kingdee.eas.qm.common.client.action.BillStatusAction;
import com.kingdee.eas.qm.common.client.action.IUIContextAction;
import com.kingdee.eas.qm.common.client.action.IUIContextManager;
import com.kingdee.eas.qm.common.filter.CompositeFilterElement;
import com.kingdee.eas.qm.common.filter.F7FilterElement;
import com.kingdee.eas.qm.common.filter.FixedFilterElement;
import com.kingdee.eas.qm.common.filter.IFilterElement;
import com.kingdee.eas.qm.common.filter.IQueryFilterManager;
import com.kingdee.eas.qm.common.filter.RangeFilterElement;
import com.kingdee.eas.qm.common.filter.SingleFilterElement;
import com.kingdee.eas.qm.common.util.QMDateUtils;
import com.kingdee.eas.qm.qc.QCReportFactory;
import com.kingdee.eas.qm.qc.QCReportInfo;
import com.kingdee.eas.qm.qc.QCUITypeEnum;
import com.kingdee.eas.qm.qc.client.AbstractQCReportFilterUI;
import com.kingdee.eas.qm.qc.client.action.report.QCReportMainOrgActionForFilterUI;
import com.kingdee.eas.qm.qc.client.util.QCUIBizTypeUtil;
import com.kingdee.eas.qm.qc.client.util.qcreport.QCReportEditUIHelper;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.util.Date;
import java.util.HashSet;
import java.util.Map;
import org.apache.log4j.Logger;

public class QCReportFilterUI
extends AbstractQCReportFilterUI {
    private static final long serialVersionUID = 342606296463901102L;
    private static final Logger logger = CoreUIObject.getLogger(QCReportFilterUI.class);
    private Map materialFilterCacheMap = null;

    public QCReportFilterUI() throws Exception {
        logger.debug((Object)"");
    }

    public QCUITypeEnum getQCUIType() {
        return QCUITypeEnum.purCheck;
    }

    public void registerUIManager(IUIContextManager manager) {
        super.registerUIManager(manager);
        if (manager.getType().equals("MainOrgUnit")) {
            new BillStatusAction((CoreUIObject)this, this.comboBillStatus);
            QCReportMainOrgActionForFilterUI mainOrgAction = new QCReportMainOrgActionForFilterUI();
            mainOrgAction.putParam("org", this.prmtQualityOrgUnit);
            mainOrgAction.putParam("checker", this.prmtChecker);
            mainOrgAction.putParam("billNumberStart", this.prmtBillNumberStart);
            mainOrgAction.putParam("billNumberEnd", this.prmtBillNumberEnd);
            mainOrgAction.putParam("material", this.prmtMaterial);
            mainOrgAction.putParam("QCBizType", QCUIBizTypeUtil.getQCBizTypes(this.getQCUIType()));
            mainOrgAction.putParam("ui", (Object)this);
            manager.registerAction((IUIContextAction)mainOrgAction);
        }
    }

    public void registerQueryFilterManager(IQueryFilterManager manager) {
        super.registerQueryFilterManager(manager);
        RangeFilterElement number = new RangeFilterElement("number", (Component)this.prmtBillNumberStart, (Component)this.prmtBillNumberEnd);
        String bosType = new QCReportInfo().getBOSType().toString();
        number.getFrom().putUserInfo("key", "number");
        number.getFrom().putUserInfo("bosType", bosType);
        number.getTo().putUserInfo("key", "number");
        number.getTo().putUserInfo("bosType", bosType);
        RangeFilterElement bizDate = new RangeFilterElement("reportDate", (Component)this.pkBizDateStart, (Component)this.pkBizDateEnd);
        bizDate.setDefaultValue((Object)new String[]{QMDateUtils.getLastMonthString(), QMDateUtils.getDayBeginString()});
        F7FilterElement checker = new F7FilterElement("checker.id", this.prmtChecker);
        checker.putUserInfo("key", "id");
        checker.putVOKey("person");
        SingleFilterElement material = new SingleFilterElement("material.id", (Component)this.prmtMaterial);
        material.putUserInfo("key", "id");
        SingleFilterElement requestNumber = new SingleFilterElement("requestNum", (Component)this.txtRequestBillNumber);
        requestNumber.setCompareType(CompareType.LIKE);
        SingleFilterElement billstatus = new SingleFilterElement("billStatus", (Component)this.comboBillStatus);
        CompositeFilterElement rootElement = this.getFilterManager().getRootElement();
        rootElement.add((IFilterElement)number);
        rootElement.add((IFilterElement)bizDate);
        rootElement.add((IFilterElement)checker);
        rootElement.add((IFilterElement)material);
        rootElement.add((IFilterElement)requestNumber);
        rootElement.add((IFilterElement)billstatus);
        FilterInfo filterInfo = new FilterInfo();
        HashSet<Integer> set = new HashSet<Integer>();
        QCBizTypeEnum[] types = QCUIBizTypeUtil.getQCBizTypes(this.getQCUIType());
        for (int i = 0; i < types.length; ++i) {
            set.add(new Integer(types[i].getValue()));
        }
        FilterItemInfo info = new FilterItemInfo("billType.QCBizType", set, CompareType.INCLUDE);
        filterInfo.getFilterItems().add(info);
        FixedFilterElement fixed = new FixedFilterElement(filterInfo);
        manager.getRootElement().add((IFilterElement)fixed);
    }

    public boolean verify() {
        Date from = (Date)this.pkBizDateStart.getValue();
        Date to = (Date)this.pkBizDateEnd.getValue();
        if (from == null) {
            MsgBox.showWarning((Component)((Object)this), (String)QCReportEditUIHelper.getMsg("FilterUI_Verify1", null));
            this.pkBizDateStart.requestFocus();
            SysUtil.abort();
        }
        if (to == null) {
            MsgBox.showWarning((Component)((Object)this), (String)QCReportEditUIHelper.getMsg("FilterUI_Verify2", null));
            this.pkBizDateEnd.requestFocus();
            SysUtil.abort();
        }
        if (from != null && to != null && from.after(to)) {
            MsgBox.showWarning((Component)((Object)this), (String)QCReportEditUIHelper.getMsg("FilterUI_Verify3", null));
            this.pkBizDateStart.requestFocus();
            SysUtil.abort();
        }
        if (this.prmtBillNumberStart.getData() != null && this.prmtBillNumberEnd.getData() == null || this.prmtBillNumberStart.getData() == null && this.prmtBillNumberEnd.getData() != null) {
            MsgBox.showWarning((Component)((Object)this), (String)QCReportEditUIHelper.getMsg("FilterUI_Verify4", null));
            this.prmtBillNumberStart.requestFocus();
            SysUtil.abort();
        }
        boolean b = super.verify();
        return b;
    }

    public void onLoad() throws Exception {
        OrgType mainBizOrgType = this.getMainBizOrgType();
        String viewPermission = this.getViewPermItemName();
        if (this.materialFilterCacheMap == null) {
            this.materialFilterCacheMap = QCReportFactory.getRemoteInstanceWithObjectContext(this.getMainOrgContext()).getMaterialCache(mainBizOrgType, viewPermission);
        }
        this.getUIContext().put("MaterialFilterCache", this.materialFilterCacheMap);
        super.onLoad();
    }
}

