/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.qm.qc.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.KDTableHelper;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.mm.lot.BatchFileCollection;
import com.kingdee.eas.mm.lot.BatchFileFactory;
import com.kingdee.eas.mm.lot.BatchFileInfo;
import com.kingdee.eas.mm.lot.IBatchFile;
import com.kingdee.eas.qm.common.util.KDTableUtils;
import com.kingdee.eas.qm.qc.IQCertificate;
import com.kingdee.eas.qm.qc.QCertificateFactory;
import com.kingdee.eas.qm.qc.ReportSourceTypeEnum;
import com.kingdee.eas.qm.qc.client.AbstractQCertificateChooseLotUI;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.KDTableUtil;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.UuidException;
import java.awt.event.ActionEvent;
import javax.swing.JComponent;
import org.apache.log4j.Logger;

public class QCertificateChooseLotUI
extends AbstractQCertificateChooseLotUI {
    private static final Logger logger = CoreUIObject.getLogger(QCertificateChooseLotUI.class);
    protected boolean isSingleSelect = true;
    protected BatchFileInfo batchFileInfo = null;
    protected String checkedLot = null;
    protected BatchFileCollection batchFileCol = null;
    public boolean isCanceled = true;
    private String resClass = "com.kingdee.eas.basedata.person.client.PersonResource.";

    @Override
    public SelectorItemCollection getSelectors() {
        return super.getSelectors();
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.configTable();
    }

    private void configTable() throws Exception {
        this.tblMain.checkParsed();
        this.tblMain.getSelectManager().setSelectMode(2);
        this.tblMain.getDataRequestManager().setDataRequestMode(0);
        this.tblMain.getStyleAttributes().setLocked(true);
        KDTableHelper.releaseEnterAndTab((JComponent)this.tblMain);
        KDTableHelper.releaseEsc((JComponent)this.tblMain);
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.actionQuery.setVisible(false);
    }

    protected void tblMain_tableClicked(KDTMouseEvent e) throws Exception {
        int[] rowID;
        KDTSelectBlock block;
        if (this.isOrderForClickTableHead() && e.getType() == 0 && e.getButton() == 1 && e.getClickCount() == 1) {
            super.tblMain_tableClicked(e);
            return;
        }
        if (this.tblMain.getSelectManager().size() > 0 && (block = this.tblMain.getSelectManager().get(0)).getMode() == 8 && (rowID = KDTableUtil.getSelectedRows((KDTable)this.tblMain)).length == 1) {
            return;
        }
        if (e.getClickCount() == 2 && this.isSingleSelect) {
            int[] rowID2 = KDTableUtil.getSelectedRows((KDTable)this.tblMain);
            if (rowID2.length > 0) {
                this.checkedLot = this.tblMain.getCell(rowID2[0], "lotNo").getValue().toString();
                this.isCanceled = false;
                this.getUIWindow().close();
            } else {
                MsgBox.showInfo((String)EASResource.getString((String)(this.resClass + "NO_SELECT_ROW")));
            }
        }
    }

    public void actionRefresh_actionPerformed(ActionEvent e) throws Exception {
        this.fillData();
    }

    public void actionQuery_actionPerformed(ActionEvent e) throws Exception {
        this.fillData();
    }

    private void fillData() throws Exception {
        this.tblMain.removeRows();
        String materialID = (String)this.getUIContext().get("materialID");
        ReportSourceTypeEnum rptSrcType = (ReportSourceTypeEnum)((Object)this.getUIContext().get("rptSrcType"));
        IQCertificate ibiz = (IQCertificate)this.getBizInterface();
        IRowSet rs = ibiz.chooseLot(materialID, rptSrcType);
        KDTableUtils.fillDataOnTable((KDTable)this.tblMain, (IRowSet)rs);
    }

    @Override
    public void actionConfirm_actionPerformed(ActionEvent e) throws Exception {
        if (this.isSingleSelect) {
            int[] rowID = KDTableUtil.getSelectedRows((KDTable)this.tblMain);
            if (rowID.length > 0) {
                this.checkedLot = this.tblMain.getCell(rowID[0], "lotNo").getValue().toString();
                this.isCanceled = false;
                this.getUIWindow().close();
            }
        } else {
            if (this.batchFileCol == null) {
                this.batchFileCol = new BatchFileCollection();
            }
            this.isCanceled = false;
            this.getUIWindow().close();
        }
    }

    @Override
    public void actionQuit_actionPerformed(ActionEvent e) throws Exception {
        this.isCanceled = true;
        this.getUIWindow().close();
    }

    protected String getEditUIName() {
        return null;
    }

    protected ICoreBase getBizInterface() throws Exception {
        return QCertificateFactory.getRemoteInstance();
    }

    protected void getBatchFileInfo(String strID) throws BOSException, EASBizException, UuidException {
        IBatchFile iBatchFile = BatchFileFactory.getRemoteInstance();
        this.batchFileInfo = iBatchFile.getBatchFileInfo((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)strID)));
    }

    protected OrgType getMainBizOrgType() {
        return OrgType.Quality;
    }
}

