/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.qm.qc.client;

import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.basedata.org.QualityOrgUnitInfo;
import com.kingdee.eas.qm.basedata.QCGroupPersonInfo;
import com.kingdee.eas.qm.common.filter.CompositeFilterElement;
import com.kingdee.eas.qm.common.filter.F7FilterElement;
import com.kingdee.eas.qm.common.filter.IFilterElement;
import com.kingdee.eas.qm.common.filter.IQueryFilterManager;
import com.kingdee.eas.qm.common.filter.RangeFilterElement;
import com.kingdee.eas.qm.common.filter.SingleFilterElement;
import com.kingdee.eas.qm.common.util.QMDateUtils;
import com.kingdee.eas.qm.qc.client.AbstractQCertificateCreateFilterUI;
import com.kingdee.eas.qm.qc.client.util.qcreport.QCReportEditUIHelper;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class QCertificateCreateFilterUI
extends AbstractQCertificateCreateFilterUI {
    private static final Logger logger = CoreUIObject.getLogger(QCertificateCreateFilterUI.class);

    @Override
    public void storeFields() {
        super.storeFields();
    }

    public void setQualityOrgInfo(QualityOrgUnitInfo orgInfo) throws Exception {
        this.prmtOrgUnit.setData((Object)orgInfo);
    }

    public void registerQueryFilterManager(IQueryFilterManager manager) {
        super.registerQueryFilterManager(manager);
        CompositeFilterElement rootElement = this.getFilterManager().getRootElement();
        rootElement.add((IFilterElement)new SingleFilterElement("number", (Component)this.txtNumber));
        F7FilterElement checker = new F7FilterElement("checker.id", this.prmtPerson);
        checker.putUserInfo("key", "id");
        checker.putVOKey("person");
        rootElement.add((IFilterElement)new SingleFilterElement("description", (Component)this.txtDescription));
        RangeFilterElement bizDate = new RangeFilterElement("reportDate", (Component)this.pkBizDateFrom, (Component)this.pkBizDateTo);
        bizDate.setDefaultValue((Object)new String[]{QMDateUtils.getLastMonthString(), QMDateUtils.getDayBeginString()});
        bizDate.getFrom().putUserInfo("key", "reportDate");
        bizDate.getTo().putUserInfo("key", "reportDate");
        rootElement.add((IFilterElement)bizDate);
        SingleFilterElement isFirstCreate = new SingleFilterElement("isFirstCreate", (Component)this.cbFirstCreate);
        isFirstCreate.setDefaultValue(Boolean.toString(true));
        rootElement.add((IFilterElement)isFirstCreate);
    }

    public boolean verify() {
        Date from = (Date)this.pkBizDateFrom.getValue();
        Date to = (Date)this.pkBizDateTo.getValue();
        if (from != null && to != null && from.after(to)) {
            MsgBox.showWarning((Component)((Object)this), (String)QCReportEditUIHelper.getMsg("FilterUI_Verify3", null));
            this.pkBizDateFrom.requestFocus();
            SysUtil.abort();
        }
        return super.verify();
    }

    public Map getFilterMap() {
        String description;
        HashMap<String, Object> filterMap = new HashMap<String, Object>();
        String number = this.txtNumber.getText().trim();
        if (!StringUtils.isEmpty((String)number)) {
            filterMap.put("reportNumber", number);
        }
        if (this.prmtPerson.getData() != null) {
            QCGroupPersonInfo checker = (QCGroupPersonInfo)this.prmtPerson.getData();
            filterMap.put("checkerID", checker.getId().toString());
        }
        if (!StringUtils.isEmpty((String)(description = this.txtDescription.getText().trim()))) {
            filterMap.put("description", description);
        }
        if (this.pkBizDateFrom.getValue() != null) {
            filterMap.put("reportDateFrom", this.pkBizDateFrom.getValue());
        }
        if (this.pkBizDateTo.getValue() != null) {
            filterMap.put("reportDateTo", this.pkBizDateTo.getValue());
        }
        filterMap.put("isFirstCreate", new Boolean(this.cbFirstCreate.isSelected()));
        return filterMap;
    }
}

