/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.qm.qc.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.appframework.syncUI.ThreadPool;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.util.KDTableUtil;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.kdf.util.render.CellCheckBoxRenderer;
import com.kingdee.bos.ctrl.kdf.util.render.IBasicRender;
import com.kingdee.bos.ctrl.swing.KDCheckBox;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.ctrl.swing.util.CtrlFormatUtilities;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.eas.base.commonquery.client.CommonQueryDialog;
import com.kingdee.eas.base.commonquery.client.CustomerQueryPanel;
import com.kingdee.eas.base.commonquery.client.IPromptBoxFactory;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.QualityOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.qm.common.util.QMResourceUtils;
import com.kingdee.eas.qm.common.util.QMStringUtils;
import com.kingdee.eas.qm.common.verify.AbstractVerifyItem;
import com.kingdee.eas.qm.common.verify.IVerifyItem;
import com.kingdee.eas.qm.common.verify.IVerifyManager;
import com.kingdee.eas.qm.common.verify.VerifyManager;
import com.kingdee.eas.qm.qc.IQCertificate;
import com.kingdee.eas.qm.qc.IQCertificateCreateFacade;
import com.kingdee.eas.qm.qc.QCReportFactory;
import com.kingdee.eas.qm.qc.QCertificateCreateFacadeFactory;
import com.kingdee.eas.qm.qc.QCertificateFactory;
import com.kingdee.eas.qm.qc.QCertificateInfo;
import com.kingdee.eas.qm.qc.client.AbstractQCertificateCreateListUI;
import com.kingdee.eas.qm.qc.client.HQHPCustomDialog;
import com.kingdee.eas.qm.qc.client.QCMMReportEditUI;
import com.kingdee.eas.qm.qc.client.QCPurReportEditUI;
import com.kingdee.eas.qm.qc.client.QCertificateCreateFilterUI;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import edu.emory.mathcs.backport.java.util.Arrays;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.JCheckBox;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.apache.log4j.Logger;

public class QCertificateCreateListUI
extends AbstractQCertificateCreateListUI {
    private static final Logger logger = CoreUIObject.getLogger(QCertificateCreateListUI.class);
    private static final String COL_SELECTED = "selected";
    private static final String COL_KEY = "reportID";
    private static final String COL_LotNo = "pdtLotNo";
    private static final String COL_MaterialID = "materialID";
    private static final String COL_MaterialNum = "materialNum";
    private static final String COL_MaterialName = "materialName";
    public static final String[] Table_Col_Keys = new String[]{"pdtLotNo", "checkLot", "materialID", "materialNum", "materialName", "materialMode", "reportID", "reportNum", "reportDate", "bizType"};
    public static final String KEY_ID = "id";
    public static final String KEY_MATERIALID = "materialID";
    public static final String KEY_MATERIALNUM = "materialNum";
    public static final String KEY_MATERIALNAME = "materialName";
    public static final String KEY_BILLTYPE = "bizType";
    private QCertificateCreateFilterUI filterUI = null;
    protected Context mainOrgCtx = null;
    private static final String QCertificateRes = "com.kingdee.eas.qm.qc.QCertificateResource";
    Map params = null;

    @Override
    public void storeFields() {
        super.storeFields();
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.uiConfig();
        this.configTable();
        this.tblMain.getColumn("reportDate").getStyleAttributes().setNumberFormat(CtrlFormatUtilities.getDateFormatString());
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.actionConfirm.setEnabled(true);
        this.actionConfirm.setVisible(true);
    }

    protected void uiConfig() throws Exception {
        this.mainOrgCtx = (Context)this.getUIContext().get("MainOrgCtx");
    }

    protected void configTable() throws Exception {
        this.tblMain.checkParsed();
        this.tblMain.getSelectManager().setSelectMode(2);
        this.tblMain.getDataRequestManager().setDataRequestMode(0);
        this.tblMain.getStyleAttributes().setLocked(true);
        this.tblMain.getColumn(COL_SELECTED).getStyleAttributes().setLocked(false);
        this.tblMain.getColumn(COL_SELECTED).setRenderer((IBasicRender)new CellCheckBoxRenderer());
    }

    public void actionQuery_actionPerformed(ActionEvent e) throws Exception {
        CommonQueryDialog dialog = this.getDialog();
        if (dialog == null) {
            dialog = this.initCommonQueryDialog();
        } else if (this.getUIWindow() == null) {
            dialog.setOwner((Component)this.getUIContext().get("OwnerWindow"));
        } else {
            dialog.setOwner((Component)((Object)this));
        }
        if (this.actionQuery.isDaemonRun()) {
            ThreadPool.destroyMonitor();
        }
        if (dialog.show()) {
            this.fillData();
        } else {
            SysUtil.abort();
        }
    }

    @Override
    public void actionConfirm_actionPerformed(ActionEvent e) throws Exception {
        ArrayList rptIDs = this.getSelectedIdValues();
        this.getCofirmVerify().verify();
        QCertificateInfo info = (QCertificateInfo)this.getUIContext().get("QCertificateInfo");
        IQCertificate ibiz = this.getQCerBizInterface();
        IObjectPK pk = ibiz.createCertificateInfo(rptIDs, info);
        Map OwnerUICtx = (Map)this.getUIContext().get("OwnerUICtx");
        OwnerUICtx.put("CreateCercificateResult", pk);
        this.uiWindow.close();
    }

    protected ArrayList getSelectedIdValues() {
        ArrayList<Object> selectList = new ArrayList<Object>();
        for (int i = 0; i < this.tblMain.getRowCount(); ++i) {
            IRow row = this.tblMain.getRow(i);
            Boolean selected = (Boolean)row.getCell(COL_SELECTED).getValue();
            if (null == selected || !selected.booleanValue()) continue;
            selectList.add(row.getCell(COL_KEY).getValue());
        }
        return selectList;
    }

    private ArrayList getSelectedValues() {
        ArrayList selectList = new ArrayList();
        for (int i = 0; i < this.tblMain.getRowCount(); ++i) {
            IRow row = this.tblMain.getRow(i);
            Boolean selected = (Boolean)row.getCell(COL_SELECTED).getValue();
            if (null == selected || !selected.booleanValue()) continue;
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put(KEY_ID, row.getCell(COL_KEY).getValue());
            map.put("materialID", row.getCell("materialID").getValue());
            map.put("materialNum", row.getCell("materialNum").getValue());
            map.put("materialName", row.getCell("materialName").getValue());
            selectList.add(map);
        }
        return selectList;
    }

    private void fillData() throws Exception {
        QCertificateInfo info = (QCertificateInfo)this.getUIContext().get("QCertificateInfo");
        this.tblMain.removeRows();
        IQCertificateCreateFacade iqc = QCertificateCreateFacadeFactory.getRemoteInstanceWithObjectContext(this.mainOrgCtx);
        Map rtnMap = iqc.getBtpCreateFromList((IObjectValue)info, this.filterUI.getFilterMap());
        List rstList = (List)rtnMap.get("rtnResultSet");
        Map relation = (Map)rtnMap.get("relation");
        if (null == rstList || rstList.size() <= 0) {
            return;
        }
        this.fillDataOnTableByColName(this.tblMain, rstList, Table_Col_Keys);
        this.afterFillData(info, relation, rstList.size());
    }

    private void fillDataOnTableByColName(KDTable table, List rstList, String[] colNames) {
        if (null == rstList || rstList.size() <= 0) {
            return;
        }
        int tableColSize = table.getColumnCount();
        Iterator iter = rstList.iterator();
        while (iter.hasNext()) {
            IRow row = table.addRow();
            List vec = (List)iter.next();
            for (int i = 0; i < vec.size() && i <= tableColSize; ++i) {
                row.getCell(colNames[i]).setValue(vec.get(i));
            }
        }
    }

    private void afterFillData(QCertificateInfo info, final Map relation, final int rstSize) {
        KDCheckBox checkBox = new KDCheckBox();
        checkBox.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                QCertificateCreateListUI.this.tblMain_CheckBox_stateChanged(e, relation, rstSize);
            }
        });
        checkBox.setEditable(true);
        checkBox.setEnabled(true);
        checkBox.setSelected(false);
        KDTDefaultCellEditor editor = new KDTDefaultCellEditor((JCheckBox)checkBox);
        this.tblMain.getColumn(COL_SELECTED).setEditor((ICellEditor)editor);
        String initMaterialID = info.getMaterial().getId().toString();
        boolean flag = false;
        int index = -1;
        for (int i = 0; i < rstSize; ++i) {
            String selMaterialID = "";
            String selLotNo = "";
            if (null != this.tblMain.getCell(i, "materialID").getValue()) {
                selMaterialID = this.tblMain.getCell(i, "materialID").getValue().toString();
            }
            if (null != this.tblMain.getCell(i, COL_LotNo).getValue()) {
                selLotNo = this.tblMain.getCell(i, COL_LotNo).getValue().toString();
            }
            if (!flag && initMaterialID.equals(selMaterialID) && !QMStringUtils.isEmpty((String)selLotNo)) {
                flag = true;
                index = i;
                this.tblMain.getCell(i, COL_SELECTED).setValue((Object)Boolean.TRUE);
                continue;
            }
            this.tblMain.getCell(i, COL_SELECTED).setValue((Object)Boolean.FALSE);
        }
        if (!flag) {
            this.tblMain.getCell(0, COL_SELECTED).setValue((Object)Boolean.TRUE);
            index = 0;
        }
        if (index >= 0) {
            this.setSubReportSelect(index, relation, true, rstSize);
        }
    }

    public void tblMain_CheckBox_stateChanged(ChangeEvent e, Map relation, int rsSize) {
        KDCheckBox chkBox = (KDCheckBox)e.getSource();
        boolean isSelect = chkBox.isSelected();
        int rowIndex = this.tblMain.getSelectManager().get().getBeginRow();
        if (rowIndex < 0) {
            return;
        }
        this.setSubReportSelect(rowIndex, relation, isSelect, rsSize);
    }

    private void setSubReportSelect(int rowIndex, Map relation, boolean isSelect, int rsSize) {
        String selectMaterialID = (String)this.tblMain.getCell(rowIndex, "materialID").getValue();
        if (null == relation) {
            return;
        }
        String subMaterialIDs = (String)relation.get(selectMaterialID);
        if (QMStringUtils.isEmpty((String)subMaterialIDs)) {
            return;
        }
        List subList = Arrays.asList((Object[])subMaterialIDs.split("','"));
        String temp = "";
        for (int i = rowIndex + 1; i < rsSize; ++i) {
            String currMaterialID = (String)this.tblMain.getCell(i, "materialID").getValue();
            String currPdtLotNo = (String)this.tblMain.getCell(i, COL_LotNo).getValue();
            if (subList.contains(currMaterialID)) {
                this.tblMain.getCell(i, COL_SELECTED).getStyleAttributes().setLocked(!isSelect);
                if (!temp.equals(currMaterialID)) {
                    this.tblMain.getCell(i, COL_SELECTED).setValue((Object)new Boolean(isSelect));
                    this.setSubReportSelect(i, relation, isSelect, rsSize);
                }
            }
            temp = currMaterialID;
        }
    }

    protected String getEditUIName() {
        int[] selectRows = KDTableUtil.getSelectedRows((KDTable)this.tblMain);
        String editUIName = "";
        if (selectRows == null || selectRows.length == 0) {
            return editUIName;
        }
        int selectIndex = selectRows[0];
        int billType = Integer.parseInt(this.tblMain.getCell(selectIndex, KEY_BILLTYPE).getValue().toString());
        if (billType == 10) {
            editUIName = QCPurReportEditUI.class.getName();
        }
        if (billType == 20 || billType == 30) {
            editUIName = QCMMReportEditUI.class.getName();
        }
        return editUIName;
    }

    protected ICoreBase getBizInterface() throws Exception {
        return QCReportFactory.getRemoteInstance();
    }

    private IQCertificate getQCerBizInterface() throws Exception {
        return QCertificateFactory.getRemoteInstanceWithObjectContext(this.mainOrgCtx);
    }

    protected String getKeyFieldName() {
        return COL_KEY;
    }

    protected OrgType getMainBizOrgType() {
        return OrgType.Quality;
    }

    private IVerifyManager getCofirmVerify() {
        VerifyManager verify = new VerifyManager();
        verify.addVerifyItem((IVerifyItem)new AbstractVerifyItem(){

            public boolean verify() throws EASBizException, BOSException {
                ArrayList selectValues = QCertificateCreateListUI.this.getSelectedValues();
                if (null == selectValues || selectValues.size() <= 0) {
                    MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_MustSelected"));
                    SysUtil.abort();
                }
                String materialIDs = "";
                String repMaterials = "";
                String repMaterialIDs = "";
                for (int i = 0; i < selectValues.size(); ++i) {
                    Map map = (Map)selectValues.get(i);
                    String selectMaterialID = (String)map.get("materialID");
                    String selectMaterialName = (String)map.get("materialName");
                    if (materialIDs.indexOf(selectMaterialID) <= 0) {
                        materialIDs = materialIDs + "," + selectMaterialID;
                        continue;
                    }
                    if (repMaterialIDs.indexOf(selectMaterialID) > 0) continue;
                    repMaterialIDs = repMaterialIDs + "," + selectMaterialID;
                    repMaterials = repMaterials + "," + selectMaterialName;
                }
                if (!QMStringUtils.isEmpty((String)repMaterialIDs)) {
                    repMaterials = repMaterials.substring(1);
                    MsgBox.showWarning((String)QMResourceUtils.getMessage((String)QCertificateCreateListUI.QCertificateRes, (String)"MaterialCannotRepeat", (String[])new String[]{repMaterials}));
                    SysUtil.abort();
                }
                return true;
            }
        });
        return verify;
    }

    protected IQueryExecutor getQueryExecutor(IMetaDataPK queryPK, EntityViewInfo viewInfo) {
        return null;
    }

    protected CommonQueryDialog initCommonQueryDialog() {
        IPromptBoxFactory promptBoxFactory;
        HQHPCustomDialog dialog = new HQHPCustomDialog();
        if (this.getUIWindow() == null) {
            dialog.setOwner((Component)this.getUIContext().get("OwnerWindow"));
        } else {
            dialog.setOwner((Component)((Object)this));
        }
        dialog.setUiObject((IUIObject)this);
        dialog.setParentUIClassName(this.getMetaDataPK().getFullName());
        dialog.setQueryObjectPK(this.mainQueryPK);
        dialog.setTitle(this.getUITitle() + " - " + EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Query_Filter"));
        if (this.orgContextManager != null) {
            if (this.orgContextManager.getOwner() != null && this.orgContextManager.getOwner() instanceof CustomerQueryPanel) {
                dialog.addUserPanel((KDPanel)((CustomerQueryPanel)this.orgContextManager.getOwner()));
            }
            this.orgContextManager.init(this.getUIContext());
        }
        if ((promptBoxFactory = this.getPromptBoxFactory()) != null) {
            dialog.setPromptBoxFactory(promptBoxFactory);
        }
        dialog.setMaxReturnCountVisible(true);
        dialog.setVisibleTableCols(this.getQueryShowField());
        try {
            if (this.filterUI == null) {
                this.filterUI = new QCertificateCreateFilterUI();
            }
            QualityOrgUnitInfo mainOrgInfo = (QualityOrgUnitInfo)((CoreUI)this.getUIContext().get("Owner")).getMainOrgInfo();
            this.filterUI.setQualityOrgInfo(mainOrgInfo);
            dialog.addUserPanel((KDPanel)this.filterUI);
            dialog.setShowFilter(false);
            dialog.setShowSorter(false);
            dialog.setUiObject(null);
            dialog.setWidth(500);
            dialog.setHeight(300);
        }
        catch (Exception e) {
            this.handleException(e);
        }
        return dialog;
    }
}

