/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.qm.qc.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.util.KDTableUtil;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDDatePicker;
import com.kingdee.bos.ctrl.swing.KDTextField;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.bot.BOTRelationCollection;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.ItemAction;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.org.AdminOrgUnitCollection;
import com.kingdee.eas.basedata.org.DelegationPartsEnum;
import com.kingdee.eas.basedata.org.IOrgUnitRelation;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitCollection;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgUnitRelationFactory;
import com.kingdee.eas.basedata.org.QualityOrgUnitInfo;
import com.kingdee.eas.basedata.person.IPersonFacade;
import com.kingdee.eas.basedata.person.PersonFacadeFactory;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.qm.basedata.QCAnalysisMethodEnum;
import com.kingdee.eas.qm.basedata.QCItemInfo;
import com.kingdee.eas.qm.basedata.QCValueTypeEnum;
import com.kingdee.eas.qm.basedata.client.util.QCStandardClientUtils;
import com.kingdee.eas.qm.common.cache.QMBatchExecuteParam;
import com.kingdee.eas.qm.common.client.action.AbstractUIContextAction;
import com.kingdee.eas.qm.common.client.action.DelegationOrgUnitAction;
import com.kingdee.eas.qm.common.client.action.IUIAction;
import com.kingdee.eas.qm.common.client.action.IUIContextAction;
import com.kingdee.eas.qm.common.client.action.IUIContextManager;
import com.kingdee.eas.qm.common.client.util.QMClientUtils;
import com.kingdee.eas.qm.common.print.ITDPrintStrategy;
import com.kingdee.eas.qm.common.util.KDTableUtils;
import com.kingdee.eas.qm.common.util.QMPrecisionUtil;
import com.kingdee.eas.qm.common.util.QMResourceUtils;
import com.kingdee.eas.qm.common.util.QMSelectorUtils;
import com.kingdee.eas.qm.common.util.QMStringUtils;
import com.kingdee.eas.qm.common.util.QMUtils;
import com.kingdee.eas.qm.common.verify.IVerifyItem;
import com.kingdee.eas.qm.common.verify.IVerifyManager;
import com.kingdee.eas.qm.common.verify.VerifyManager;
import com.kingdee.eas.qm.qc.QCertificateEntryCollection;
import com.kingdee.eas.qm.qc.QCertificateFactory;
import com.kingdee.eas.qm.qc.QCertificateInfo;
import com.kingdee.eas.qm.qc.ReportSourceTypeEnum;
import com.kingdee.eas.qm.qc.client.AbstractQCertificateEditUI;
import com.kingdee.eas.qm.qc.client.QCChooseLotPromptBox;
import com.kingdee.eas.qm.qc.client.QCMMReportEditUI;
import com.kingdee.eas.qm.qc.client.QCPurReportEditUI;
import com.kingdee.eas.qm.qc.client.QCertificateCreateListUI;
import com.kingdee.eas.qm.qc.client.action.certificate.QCercificateMainOrgAction;
import com.kingdee.eas.qm.qc.client.action.certificate.QCercificateMaterialAction;
import com.kingdee.eas.qm.qc.client.print.QCertificateTDPrintStrategy;
import com.kingdee.eas.qm.qc.client.verify.QCertificateCreateFromVerifyItem;
import com.kingdee.eas.qm.qc.client.verify.QCertificateSubmitVerifyItem;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JTextField;
import org.apache.log4j.Logger;

public class QCertificateEditUI
extends AbstractQCertificateEditUI {
    private static final Logger logger = CoreUIObject.getLogger(QCertificateEditUI.class);
    private static final String QCertificateRes = "com.kingdee.eas.qm.qc.QCertificateResource";
    private static final String TB_QCITEM = "qcItem";
    private static final String TB_QCMETHOD = "qcMethod";
    private static final String TB_CHECKVALUE = "checkValue";
    private static final String TB_DEFAULTVALUE = "defaultValue";
    private static final String TB_QCENUMS = "qcEnum";
    private static final String TB_MATERIAL = "material";
    private static final String TB_UNIT = "unit";
    private static final String TB_UPPERLIMIT = "upperLimit";
    private static final String TB_UPPER = "upper";
    private static final String TB_LOWERLIMIT = "lowerLimit";
    private static final String TB_LOWER = "lower";
    private static final String TB_QCDESCRIPTION = "qcDescription";
    private static final String TB_STANDARDREQUIREMENT = "standardRequirement";
    private static final String TB_REMARK = "remark";
    private static final String TB_DATAPRECISION = "dataPrecision";
    private static final String TB_REPORTID = "qcReportID";
    private static final String TB_REPORTTYPEID = "rptTypeID";
    private static final String TB_MODIFYMODE = "modifyMode";
    private static final String UICTX_MATERIAL = "material";
    private static final String UICTX_RPTSRC = "reportSrcType";

    @Override
    public void loadFields() {
        this.doLoadFields();
    }

    public void doLoadFields() {
        this.reportSrcType.setSelectedIndex(-1, true);
        this.beforLoadFields();
        super.loadFields();
        this.afterLoadFields();
    }

    public void afterLoadFields() {
        super.afterLoadFields();
        for (int i = 0; i < this.kdtEntrys.getRowCount(); ++i) {
            this.setCheckValueAndDefaultValueType(this.kdtEntrys, i);
        }
    }

    protected void initDataStatus() {
        super.initDataStatus();
        this.actionAddLine.setEnabled(false);
        this.actionInsertLine.setEnabled(false);
        this.initEntryFieldEditor();
        this.setActionEnable();
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.btnChooseLotNo.setIcon(QMClientUtils.getIcon((String)"imgTbtn_selectlot"));
        this.menuItemChooseLotNo.setIcon(QMClientUtils.getIcon((String)"imgTbtn_selectlot"));
        this.btnCreateFrom.setIcon(QMClientUtils.getIcon((String)"imgTbtn_takebill"));
        this.menuItemCreateFrom.setIcon(QMClientUtils.getIcon((String)"imgTbtn_takebill"));
        this.menuItemCreateFrom.setAccelerator(null);
    }

    public void initUIContextManager() {
        super.initUIContextManager();
        this.initUIContextManager((JComponent)this.prmtmaterial, "material");
        this.initUIContextManager((JComponent)this.reportSrcType, UICTX_RPTSRC);
    }

    public void registerUIManager(IUIContextManager manager) {
        super.registerUIManager(manager);
        if (manager.getType().equals("MainOrgUnit")) {
            DelegationOrgUnitAction action = new DelegationOrgUnitAction((Component)((Object)this), OrgType.Quality, this.prmtstorageOrgUnit, DelegationPartsEnum.THE_FROM_UNIT, OrgType.Storage);
            manager.registerAction((IUIContextAction)action);
            QCercificateMainOrgAction mainOrgAction = new QCercificateMainOrgAction(TB_QCITEM, TB_QCMETHOD, this.kdtEntrys, this.prmtmaterial, this.prmtperson);
            manager.registerAction((IUIContextAction)mainOrgAction);
        } else if (manager.getType().equals("material")) {
            QCercificateMaterialAction materialAction = new QCercificateMaterialAction(this.materialMode);
            manager.registerAction((IUIContextAction)materialAction);
        } else if (manager.getType().equals(UICTX_RPTSRC)) {
            RptSrcAction action = new RptSrcAction(this.pkbomDate, this.txtpdtLotNo, this.prmtstorageOrgUnit);
            manager.registerAction((IUIContextAction)action);
        }
    }

    @Override
    public SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        QMSelectorUtils.addSelectorWithIDAndNumberAndName((SelectorItemCollection)sic, (String)"storageOrgUnit");
        QMSelectorUtils.addSelectorWithIDAndNumberAndName((SelectorItemCollection)sic, (String)"material");
        QMSelectorUtils.addSelectorWithIDAndNumberAndName((SelectorItemCollection)sic, (String)"qcStandard");
        QMSelectorUtils.addSelectorWithIDAndNumberAndName((SelectorItemCollection)sic, (String)"qcCriterion");
        QMSelectorUtils.addSelectorWithIDAndNumberAndName((SelectorItemCollection)sic, (String)"person");
        QMSelectorUtils.addSelectorWithIDAndNumberAndName((SelectorItemCollection)sic, (String)"qualityOrgUnit");
        sic.add(new SelectorItemInfo("entrys.*"));
        QMSelectorUtils.addSelectorWithIDAndNumberAndName((SelectorItemCollection)sic, (String)"entrys.material");
        QMSelectorUtils.addSelectorWithIDAndNumberAndName((SelectorItemCollection)sic, (String)"entrys.qCItem");
        QMSelectorUtils.addSelectorWithPros((SelectorItemCollection)sic, (String)"entrys.qCItem", (String[])new String[]{"qCItemAttr"});
        sic.add(new SelectorItemInfo("entrys.qcItem.qCValueType"));
        sic.add(new SelectorItemInfo("entrys.qcItem.analysisMethod"));
        QMSelectorUtils.addSelectorWithIDAndNumberAndName((SelectorItemCollection)sic, (String)"entrys.qCMethod");
        QMSelectorUtils.addSelectorWithIDAndNumberAndName((SelectorItemCollection)sic, (String)"entrys.qCFrequency");
        QMSelectorUtils.addSelectorWithIDAndNumberAndName((SelectorItemCollection)sic, (String)"entrys.judgeMaterial");
        QMSelectorUtils.addSelectorWithPros((SelectorItemCollection)sic, (String)"entrys.unit", (String[])new String[]{"id", "number", "name", "qtyPrecision"});
        QMSelectorUtils.addSelectorWithPros((SelectorItemCollection)sic, (String)"entrys.qCModifyMode", (String[])new String[]{"id", "number", "name", TB_DATAPRECISION});
        QMSelectorUtils.addSelectorWithIDAndNumberAndName((SelectorItemCollection)sic, (String)"creator");
        QMSelectorUtils.addSelectorWithIDAndNumberAndName((SelectorItemCollection)sic, (String)"lastUpdateUser");
        QMSelectorUtils.addSelectorWithIDAndNumberAndName((SelectorItemCollection)sic, (String)"auditor");
        return sic;
    }

    public void actionRemoveLine_actionPerformed(ActionEvent e) throws Exception {
        super.actionRemoveLine_actionPerformed(e);
        if (this.kdtEntrys.getRowCount() <= 0) {
            this.setActionEnable();
        }
    }

    @Override
    public void actionChooseLotNo_actionPerformed(ActionEvent e) throws Exception {
        if (null == this.prmtmaterial.getValue()) {
            this.prmtmaterial.requestFocus();
            MsgBox.showWarning((String)QMResourceUtils.getMessage((String)QCertificateRes, (String)"MaterialCannotNull"));
            SysUtil.abort();
        }
        EntityViewInfo env = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        String materialID = ((MaterialInfo)this.prmtmaterial.getValue()).getId().toString();
        filter.getFilterItems().add(new FilterItemInfo("material.id", (Object)materialID, CompareType.EQUALS));
        env.setFilter(filter);
        HashMap<String, Object> hash = new HashMap<String, Object>();
        hash.put("F7_EVI", env);
        hash.put("materialID", materialID);
        hash.put("rptSrcType", this.reportSrcType.getSelectedItem());
        QCChooseLotPromptBox box = new QCChooseLotPromptBox((IUIObject)this, hash);
        box.setEntityViewInfo(env);
        box.show();
        if (null != box.getData()) {
            this.txtpdtLotNo.setText((String)box.getData());
        }
    }

    @Override
    public void actionViewSrcReport_actionPerformed(ActionEvent e) throws Exception {
        int selectIndex = this.getSelectIndex();
        if (selectIndex < 0) {
            MsgBox.showInfo((String)QMResourceUtils.getMessage((String)QCertificateRes, (String)"PlsSelectEntry"));
            return;
        }
        String rptID = (String)this.kdtEntrys.getCell(selectIndex, TB_REPORTID).getValue();
        String rptTypeID = (String)this.kdtEntrys.getCell(selectIndex, TB_REPORTTYPEID).getValue();
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"ID", (Object)rptID);
        String reportUIName = this.getRptEditUIName(rptTypeID);
        IUIWindow uiWindow = null;
        uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(reportUIName, (Map)uiContext, null, OprtState.VIEW);
        uiWindow.show();
    }

    private int getSelectIndex() {
        int selectIndex = -1;
        int[] selectRows = KDTableUtil.getSelectedRows((KDTable)this.kdtEntrys);
        if (null != selectRows && selectRows.length > 0) {
            selectIndex = selectRows[0];
        }
        return selectIndex;
    }

    private String getRptEditUIName(String rptTypeID) {
        String editUIName = "";
        if (QMStringUtils.isEmpty((String)rptTypeID)) {
            return editUIName;
        }
        if (rptTypeID.equals("4o71JVzlT/avO5iRUJkDRObqiQE=")) {
            editUIName = QCPurReportEditUI.class.getName();
        } else if (rptTypeID.equals("GnHD33UuQOmGDfR7lyYQGebqiQE=")) {
            editUIName = QCMMReportEditUI.class.getName();
        }
        return editUIName;
    }

    @Override
    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        this.getSubmitVerifyItem().verify();
        super.actionSubmit_actionPerformed(e);
    }

    @Override
    public void actionCreateFrom_actionPerformed(ActionEvent e) throws Exception {
        this.getCreateFromVerifyItem().verify();
        String uiClassName = QCertificateCreateListUI.class.getName();
        UIContext uiCtx = new UIContext((Object)this);
        uiCtx.put((Object)"Owner", (Object)this);
        uiCtx.put((Object)"MainOrgCtx", (Object)this.getMainOrgContext());
        uiCtx.put((Object)"OwnerUICtx", (Object)this.getUIContext());
        uiCtx.put((Object)"QCertificateInfo", (Object)this.getEditData());
        IUIWindow win = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(uiClassName, (Map)uiCtx);
        win.show();
        this.showCreateFromResultSet();
    }

    protected void showCreateFromResultSet() throws Exception {
        try {
            IObjectPK pk = (IObjectPK)this.getUIContext().get("CreateCercificateResult");
            if (pk == null) {
                return;
            }
            this.processSucessData(pk);
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            if (this.getUIContext().containsKey("CreateCercificateResult")) {
                this.getUIContext().remove("CreateCercificateResult");
            }
        }
    }

    private void processSucessData(IObjectPK pk) throws Exception {
        IObjectValue objValue = this.getValue(pk);
        this.unLockThisEditData();
        this.setSave(true);
        this.setSaved(true);
        this.setOprtState("EDIT");
        this.setDataObject(objValue);
        this.loadFields();
        this.showMessageForStatus();
    }

    protected void unLockThisEditData() {
        if (this.editData.getId() != null) {
            try {
                this.pubFireVOChangeListener(this.editData.getId().toString());
            }
            catch (Throwable e1) {
                logger.error((Object)e1);
            }
        }
    }

    public ITDPrintStrategy getTDPrintStrategy() throws Exception {
        QCertificateTDPrintStrategy printStrategy = new QCertificateTDPrintStrategy();
        return printStrategy;
    }

    private IVerifyManager getCreateFromVerifyItem() {
        VerifyManager manager = new VerifyManager();
        QCertificateCreateFromVerifyItem item = new QCertificateCreateFromVerifyItem(this);
        manager.addVerifyItem((IVerifyItem)item);
        return manager;
    }

    private IVerifyManager getSubmitVerifyItem() {
        VerifyManager manager = new VerifyManager();
        QCertificateSubmitVerifyItem item = new QCertificateSubmitVerifyItem(this);
        manager.addVerifyItem((IVerifyItem)item);
        return manager;
    }

    @Override
    protected ICoreBase getBizInterface() throws Exception {
        return QCertificateFactory.getRemoteInstanceWithObjectContext(this.getMainOrgContext());
    }

    protected KDBizPromptBox getMainBizOrg() {
        return this.prmtQualityOrgUnit;
    }

    protected IObjectValue createNewDetailData(KDTable table, IRow srcRow) {
        return null;
    }

    @Override
    protected IObjectValue createNewData() {
        return this.doCreateNewData(null);
    }

    public KDTextField getNumTextField() {
        return this.txtNumber;
    }

    protected IObjectValue newInstanceData() throws EASBizException, BOSException {
        QCertificateInfo objectValue = new QCertificateInfo();
        UserInfo user = SysContext.getSysContext().getCurrentUserInfo();
        objectValue.setCreator(user);
        objectValue.setPerson(this.getDefaultPerson());
        objectValue.setReportSrcType(ReportSourceTypeEnum.material);
        return objectValue;
    }

    private PersonInfo getDefaultPerson() throws BOSException, EASBizException {
        PersonInfo person = SysContext.getSysContext().getCurrentUserInfo().getPerson();
        OrgUnitInfo mainOrgUnit = this.getDefaultMainBizOrg();
        if (null == person || null == mainOrgUnit) {
            return null;
        }
        IOrgUnitRelation iOrgRelation = OrgUnitRelationFactory.getRemoteInstance();
        OrgUnitCollection collection = iOrgRelation.getToUnit(mainOrgUnit.getId().toString(), 32, 0);
        IPersonFacade ibiz = PersonFacadeFactory.getRemoteInstance();
        AdminOrgUnitCollection adminCol = ibiz.getAdminOrgUnitByPerson(person.getId());
        for (int i = 0; i < collection.size(); ++i) {
            OrgUnitInfo orgUnit = collection.get(i);
            if (!adminCol.containsKey((Object)orgUnit.getId())) continue;
            return person;
        }
        return null;
    }

    @Override
    protected void applyDefaultValue(IObjectValue vo) {
        vo.put(UICTX_RPTSRC, (Object)new Integer(30));
    }

    private void initEntryFieldEditor() {
        this.setEntryTextFieldEditor(this.kdtEntrys, TB_QCDESCRIPTION, 100);
        this.setEntryTextFieldEditor(this.kdtEntrys, TB_STANDARDREQUIREMENT, 255);
        this.setEntryTextFieldEditor(this.kdtEntrys, TB_REMARK, 255);
    }

    protected void setActionEnable() {
        Component[] comps = new Component[]{this.prmtQualityOrgUnit, this.prmtstorageOrgUnit, this.prmtmaterial, this.reportSrcType, this.txtpdtLotNo, this.pkbomDate};
        QCertificateEntryCollection entrys = (QCertificateEntryCollection)((Object)this.getDataObject().get("entrys"));
        if (this.getOprtState().equals(OprtState.ADDNEW) || this.getOprtState().equals(OprtState.EDIT) && (null == entrys || entrys.size() <= 0)) {
            QMUtils.setComponentEnable((Component[])comps, (boolean)true);
            this.setItemActionEnable(new ItemAction[]{this.actionViewSrcReport}, false);
            this.setItemActionEnable(new ItemAction[]{this.actionChooseLotNo, this.actionCreateFrom}, true);
        } else {
            QMUtils.setComponentEnable((Component[])comps, (boolean)false);
            this.setItemActionEnable(new ItemAction[]{this.actionChooseLotNo, this.actionCreateFrom}, false);
            this.setItemActionEnable(new ItemAction[]{this.actionViewSrcReport}, true);
        }
    }

    private void setEntryTextFieldEditor(KDTable comp, String colName, int maxLength) {
        KDTextField text_editor = new KDTextField();
        text_editor.setMaxLength(maxLength);
        KDTDefaultCellEditor text_CellEditor = new KDTDefaultCellEditor((JTextField)text_editor);
        comp.getColumn(colName).setEditor((ICellEditor)text_CellEditor);
    }

    private void setTextFieldEditor(KDTable comp, int rowIndex, String colName, int maxLength) {
        KDTextField text_editor = new KDTextField();
        text_editor.setMaxLength(maxLength);
        KDTDefaultCellEditor text_CellEditor = new KDTDefaultCellEditor((JTextField)text_editor);
        comp.getCell(rowIndex, colName).setEditor((ICellEditor)text_CellEditor);
    }

    private void setCheckValueAndDefaultValueType(KDTable comp, int rowIndex) {
        QCItemInfo qcItem = (QCItemInfo)comp.getCell(rowIndex, TB_QCITEM).getValue();
        if (null == qcItem || null == qcItem.getQCValueType() || null == qcItem.getAnalysisMethod()) {
            return;
        }
        QCValueTypeEnum valueType = qcItem.getQCValueType();
        QCAnalysisMethodEnum analysisMethod = qcItem.getAnalysisMethod();
        String[] lockCols = new String[]{TB_UPPERLIMIT, TB_UPPER, TB_LOWERLIMIT, TB_LOWER};
        if (valueType == QCValueTypeEnum.enumvalue) {
            String enumsValue = (String)comp.getCell(rowIndex, TB_QCENUMS).getValue();
            KDComboBox combox = new KDComboBox();
            if (!StringUtil.isEmptyString((String)enumsValue)) {
                Object[] items = enumsValue.split("#");
                combox.addItems(items);
            }
            KDTDefaultCellEditor editor = new KDTDefaultCellEditor((JComboBox)combox);
            comp.getCell(rowIndex, TB_CHECKVALUE).setEditor((ICellEditor)editor);
            comp.getCell(rowIndex, TB_DEFAULTVALUE).setEditor((ICellEditor)editor);
        } else if (valueType == QCValueTypeEnum.number || valueType == QCValueTypeEnum.formula) {
            String[] qtyCols = new String[]{TB_CHECKVALUE, TB_DEFAULTVALUE, TB_LOWER, TB_UPPER};
            int precision = QCStandardClientUtils.getRowCheckValuePrecision((KDTable)this.kdtEntrys, (int)rowIndex, (String)TB_MODIFYMODE, (String)TB_DATAPRECISION, (String)TB_UNIT);
            QMPrecisionUtil.setRowNumberEditor((int)precision, (KDTable)comp, (int)rowIndex, (String[])qtyCols, null, null);
        } else if (valueType == QCValueTypeEnum.text) {
            this.setTextFieldEditor(comp, rowIndex, TB_CHECKVALUE, 255);
            this.setTextFieldEditor(comp, rowIndex, TB_DEFAULTVALUE, 255);
        }
        if (valueType == QCValueTypeEnum.number || valueType == QCValueTypeEnum.formula) {
            KDTableUtils.setLockCells((KDTable)comp, (int)rowIndex, (String[])lockCols, (boolean)false);
        } else {
            KDTableUtils.setLockCells((KDTable)comp, (int)rowIndex, (String[])lockCols, (boolean)true);
        }
    }

    protected String getAddNewPermItemName() {
        return "qm_QCertificate_02addnew";
    }

    protected String getViewPermItemName() {
        return "qm_QCertificate_01view";
    }

    public BOTRelationCollection getMakeRelations() {
        return null;
    }

    protected boolean isSupportTDPrint() {
        return true;
    }

    protected JTextField getTDPrintNumTxtField() {
        return this.txtprintNum;
    }

    @Override
    public void actionPrint_actionPerformed(ActionEvent e) throws Exception {
        this.doInvokePrint(true);
    }

    @Override
    public void actionPrintPreview_actionPerformed(ActionEvent e) throws Exception {
        this.doInvokePrint(false);
    }

    public List getOnloadCache() {
        List list = super.getOnloadCache();
        QualityOrgUnitInfo mainOrgUnit = (QualityOrgUnitInfo)this.getDefaultMainBizOrg();
        PersonInfo person = SysContext.getSysContext().getCurrentUserInfo().getPerson();
        if (null != mainOrgUnit) {
            QMBatchExecuteParam p1 = new QMBatchExecuteParam(BOSObjectType.create((String)"3B2666DB"), IOrgUnitRelation.class, "getToUnit", new Class[]{String.class, Integer.TYPE, Integer.TYPE}, new Object[]{mainOrgUnit.getId().toString(), new Integer(32), new Integer(0)});
            list.add(p1);
        }
        if (null != person) {
            QMBatchExecuteParam p2 = new QMBatchExecuteParam(BOSObjectType.create((String)"B2BB34E7"), IPersonFacade.class, "getAdminOrgUnitByPerson", new Class[]{BOSUuid.class}, new Object[]{person.getId()});
            list.add(p2);
        }
        return list;
    }

    protected void setItemActionEnable(ItemAction[] actions, boolean flag) {
        for (int i = 0; i < actions.length; ++i) {
            ItemAction action = actions[i];
            if (action == null) continue;
            action.setVisible(flag);
            action.setEnabled(flag);
        }
    }

    protected void afterSelectLine(KDTable table, IObjectValue lineData) {
        int row = table.getSelectManager().get().getBeginRow();
        int selectCol = table.getSelectManager().get().getBeginCol();
        int isMustCheckCol = this.kdtEntrys.getColumnIndex("isMustCheck");
        if (selectCol == table.getSelectManager().get().getEndCol() && selectCol == isMustCheckCol) {
            if (this.kdtEntrys.getCell(row, isMustCheckCol).getValue() != null && Boolean.TRUE.equals(this.kdtEntrys.getCell(row, isMustCheckCol).getValue())) {
                this.kdtEntrys.getCell(row, isMustCheckCol).setValue((Object)Boolean.FALSE);
            } else {
                this.kdtEntrys.getCell(row, isMustCheckCol).setValue((Object)Boolean.TRUE);
            }
        }
    }

    public class RptSrcAction
    extends AbstractUIContextAction
    implements IUIAction {
        private KDBizPromptBox storageUnit;
        private KDDatePicker bomDate;
        private KDTextField pdtLot;

        public RptSrcAction(KDDatePicker bomDate, KDTextField pdtLot, KDBizPromptBox storageUnit) {
            this.bomDate = bomDate;
            this.pdtLot = pdtLot;
            this.storageUnit = storageUnit;
        }

        public void changeUIContext(CoreUIObject owner, Context ctx) throws BOSException, EASBizException {
            ReportSourceTypeEnum rptSrc = (ReportSourceTypeEnum)((Object)ctx.get((Object)"NewValue"));
            if (null == rptSrc) {
                return;
            }
            if (rptSrc.getValue() == 30) {
                this.bomDate.setRequired(false);
                this.storageUnit.setRequired(false);
                this.pdtLot.setRequired(false);
            } else if (rptSrc.getValue() == 20) {
                this.bomDate.setRequired(true);
                this.storageUnit.setRequired(true);
                this.pdtLot.setRequired(true);
            } else if (rptSrc.getValue() == 10) {
                this.bomDate.setRequired(true);
                this.storageUnit.setRequired(true);
                this.pdtLot.setRequired(false);
            }
        }
    }
}

