/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.qm.qc.client.action;

import com.kingdee.bos.Context;
import com.kingdee.bos.appframework.databinding.DataBinder;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTPropertyChangeEvent;
import com.kingdee.bos.ctrl.swing.KDFormattedTextField;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.basedata.assistant.MeasureUnitInfo;
import com.kingdee.eas.qm.common.client.action.AbstractUIContextAction;
import com.kingdee.eas.qm.common.client.action.IUIContextAction;
import com.kingdee.eas.qm.common.util.QMPrecisionUtil;
import com.kingdee.eas.qm.qc.client.QCSampleEditUI;
import com.kingdee.eas.qm.qc.util.QMUnitConvertHelper;
import java.math.BigDecimal;
import java.util.HashMap;

public class QCSampleKDTSampleSharesAction
extends AbstractUIContextAction
implements IUIContextAction {
    private KDTable kdtEntrys;
    private KDTable kdtItemEntries;
    private DataBinder dataBinder;
    private KDFormattedTextField txtSampleQty;
    private KDBizPromptBox prmtUnit;
    private KDFormattedTextField txtTotalSampleShares;

    public QCSampleKDTSampleSharesAction(KDTable table, KDTable table1, KDBizPromptBox prmtUnit, KDFormattedTextField txtSampleQty, KDFormattedTextField txtTotalSampleShares, DataBinder dataBinder) {
        this.kdtEntrys = table;
        this.kdtItemEntries = table1;
        this.prmtUnit = prmtUnit;
        this.txtSampleQty = txtSampleQty;
        this.txtTotalSampleShares = txtTotalSampleShares;
        this.dataBinder = dataBinder;
    }

    public void changeUIContext(CoreUIObject owner, Context ctx) {
        if (this.isloading(owner)) {
            return;
        }
        QCSampleEditUI ui = (QCSampleEditUI)owner;
        KDTPropertyChangeEvent e = (KDTPropertyChangeEvent)ctx.get((Object)"event");
        if (ui.isSampleQtyAutoSumParamSelected()) {
            QCSampleKDTSampleSharesAction.changeSampleRelation(ui.getUnitMap(), this.kdtEntrys, this.kdtItemEntries, this.prmtUnit, this.txtSampleQty, this.txtTotalSampleShares, this.dataBinder, e);
        } else {
            QCSampleKDTSampleSharesAction.setTableRowSampleQtyValue(this.kdtEntrys, e);
        }
        this.dataBinder.storeLineFields(this.kdtEntrys, this.kdtEntrys.getRow(e.getRowIndex()), null);
    }

    public static void changeSampleRelation(HashMap unitMap, KDTable kdtEntrys, KDTable kdtItemEntries, KDBizPromptBox prmtUnit, KDFormattedTextField txtSampleQty, KDFormattedTextField txtTotalSampleShares, DataBinder dataBinder, KDTPropertyChangeEvent e) {
        BigDecimal totalSampleShares;
        if (e != null && e.getColIndex() == kdtEntrys.getColumnIndex("sampleShares")) {
            QCSampleKDTSampleSharesAction.setTableRowSampleQtyValue(kdtEntrys, e);
            totalSampleShares = QCSampleKDTSampleSharesAction.sumTotalSampleShares(kdtEntrys);
            if (txtTotalSampleShares != null) {
                txtTotalSampleShares.setValue((Object)totalSampleShares);
            }
        } else if (e != null && e.getColIndex() == kdtEntrys.getColumnIndex("eachSampleQty")) {
            QCSampleKDTSampleSharesAction.setTableRowSampleQtyValue(kdtEntrys, e);
        } else if (e == null) {
            totalSampleShares = QCSampleKDTSampleSharesAction.sumTotalSampleShares(kdtEntrys);
            if (txtTotalSampleShares != null) {
                txtTotalSampleShares.setValue((Object)totalSampleShares);
            }
        }
        MeasureUnitInfo unitInfo = (MeasureUnitInfo)prmtUnit.getValue();
        BigDecimal sampleQtySum = QCSampleKDTSampleSharesAction.sumTotalSampleQty(kdtEntrys, unitInfo, unitMap);
        txtSampleQty.setValue((Object)sampleQtySum);
    }

    private static BigDecimal sumTotalSampleShares(KDTable kdtEntrys) {
        BigDecimal totalSampleShares = new BigDecimal("0");
        int size = kdtEntrys.getRowCount();
        for (int i = 0; i < size; ++i) {
            Object obj = kdtEntrys.getCell(i, "sampleShares").getValue();
            BigDecimal sampleShares = new BigDecimal("0");
            if (obj != null) {
                sampleShares = obj instanceof BigDecimal ? (BigDecimal)obj : new BigDecimal(obj.toString());
            }
            if (sampleShares == null) continue;
            totalSampleShares = totalSampleShares.add(sampleShares);
        }
        return totalSampleShares;
    }

    private static void setTableRowSampleQtyValue(KDTable kdtEntrys, KDTPropertyChangeEvent e) {
        BigDecimal eachSampleQty = new BigDecimal("0");
        Object eachSampleQtyObj = kdtEntrys.getCell(e.getRowIndex(), "eachSampleQty").getValue();
        Object sampleSharesObj = kdtEntrys.getCell(e.getRowIndex(), "sampleShares").getValue();
        if (eachSampleQtyObj != null && sampleSharesObj != null) {
            eachSampleQty = eachSampleQtyObj instanceof BigDecimal ? (BigDecimal)eachSampleQtyObj : new BigDecimal(eachSampleQtyObj.toString());
            sampleSharesObj = sampleSharesObj instanceof BigDecimal ? (BigDecimal)sampleSharesObj : new BigDecimal(sampleSharesObj.toString());
            BigDecimal sampleQty = eachSampleQty.multiply((BigDecimal)sampleSharesObj);
            int scale = eachSampleQty.scale();
            if (QMPrecisionUtil.BigDecimal_MaxValue.compareTo(sampleQty) < 0) {
                sampleQty = QMPrecisionUtil.BigDecimal_MaxValue;
                sampleQty = sampleQty.setScale(scale, 1);
            } else {
                sampleQty = sampleQty.setScale(scale, 4);
            }
            kdtEntrys.getCell(e.getRowIndex(), "sampleQty").setValue((Object)sampleQty);
        }
    }

    public static BigDecimal sumTotalSampleQty(KDTable kdtEntrys, MeasureUnitInfo unitInfo, HashMap unitMap) {
        BigDecimal sampleQtySum = new BigDecimal("0");
        int precision = 4;
        MeasureUnitInfo entryUnitInfo = null;
        int size = kdtEntrys.getRowCount();
        for (int i = 0; i < size; ++i) {
            BigDecimal newSampleQty;
            MeasureUnitInfo sampleUnitInfo;
            Object obj = kdtEntrys.getCell(i, "sampleQty").getValue();
            BigDecimal sampleQty = new BigDecimal("0");
            if (obj != null) {
                sampleQty = obj instanceof BigDecimal ? (BigDecimal)obj : new BigDecimal(obj.toString());
            }
            if ((sampleUnitInfo = (MeasureUnitInfo)kdtEntrys.getCell(i, "unit").getValue()) != null) {
                entryUnitInfo = sampleUnitInfo;
            }
            if (sampleUnitInfo == null || sampleQty == null || unitInfo == null || (newSampleQty = QMUnitConvertHelper.convertQtyFromMap(unitMap, sampleUnitInfo.getId().toString(), unitInfo.getId().toString(), sampleQty, false)) == null) continue;
            sampleQtySum = sampleQtySum.add(newSampleQty);
        }
        if (unitInfo != null) {
            precision = unitInfo.getQtyPrecision();
        } else if (entryUnitInfo != null) {
            precision = entryUnitInfo.getQtyPrecision();
        }
        sampleQtySum = sampleQtySum.setScale(precision, 4);
        return sampleQtySum;
    }
}

