/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.qm.qc.client.action;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTPropertyChangeEvent;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDFormattedTextField;
import com.kingdee.bos.ctrl.swing.KDTextField;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.basedata.assistant.MeasureUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.qm.basedata.IQCSamplingProgramFacade;
import com.kingdee.eas.qm.basedata.IQCStandardItemEntry;
import com.kingdee.eas.qm.basedata.ItemTypeEnum;
import com.kingdee.eas.qm.basedata.QCAnalysisMethodEnum;
import com.kingdee.eas.qm.basedata.QCItemInfo;
import com.kingdee.eas.qm.basedata.QCSamplingProgramFacadeFactory;
import com.kingdee.eas.qm.basedata.QCSamplingProgramInfo;
import com.kingdee.eas.qm.basedata.QCStandardFacadeFactory;
import com.kingdee.eas.qm.basedata.QCStandardItemEntryCollection;
import com.kingdee.eas.qm.basedata.QCStandardItemEntryFactory;
import com.kingdee.eas.qm.basedata.QCStandardItemEntryInfo;
import com.kingdee.eas.qm.basedata.QCValueTypeEnum;
import com.kingdee.eas.qm.basedata.client.util.QCItemDynamicGroupManager;
import com.kingdee.eas.qm.common.client.action.AbstractUIContextAction;
import com.kingdee.eas.qm.common.client.action.IUIContextAction;
import com.kingdee.eas.qm.common.util.NumericUtils;
import com.kingdee.eas.qm.common.util.QMPrecisionUtil;
import com.kingdee.eas.qm.common.util.QMStringUtils;
import com.kingdee.eas.qm.common.util.backup.QMHelper;
import com.kingdee.eas.qm.qc.IQCRequestEntry;
import com.kingdee.eas.qm.qc.QCReinspectReqInfo;
import com.kingdee.eas.qm.qc.QCRequestEntryFactory;
import com.kingdee.eas.qm.qc.QCRequestEntryInfo;
import com.kingdee.eas.qm.qc.client.QCReinspectReqEditUI;
import java.math.BigDecimal;
import java.util.Map;
import javax.swing.JComboBox;
import javax.swing.JTextField;
import org.apache.log4j.Logger;

public class ReinspectReqKDTableQCItemAction
extends AbstractUIContextAction
implements IUIContextAction {
    private static final Logger logger = CoreUIObject.getLogger(ReinspectReqKDTableQCItemAction.class);
    private KDTable kdtEntrys;
    protected QCItemDynamicGroupManager dynaGroupUtils;
    String colName;

    public ReinspectReqKDTableQCItemAction(QCReinspectReqEditUI owner, KDTable kdtEntrys) {
        this.kdtEntrys = kdtEntrys;
    }

    public ReinspectReqKDTableQCItemAction(QCReinspectReqEditUI owner, KDTable kdtEntrys, QCItemDynamicGroupManager dynaGroupUtils) {
        this.kdtEntrys = kdtEntrys;
        this.dynaGroupUtils = dynaGroupUtils;
    }

    public ReinspectReqKDTableQCItemAction() {
    }

    private QCStandardItemEntryInfo getQCStandardItemEntryInfo(String QCStandardID, String QCItemID) {
        QCStandardItemEntryInfo info = null;
        try {
            EntityViewInfo viewInfo = new EntityViewInfo();
            SelectorItemCollection selector = new SelectorItemCollection();
            selector.add(new SelectorItemInfo("*"));
            selector.add(new SelectorItemInfo("qCFrequency.*"));
            selector.add(new SelectorItemInfo("qCMethod.*"));
            selector.add(new SelectorItemInfo("qCModifyMode.*"));
            selector.add(new SelectorItemInfo("unit.*"));
            viewInfo.setSelector(selector);
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("parent", (Object)QCStandardID, CompareType.EQUALS));
            filter.getFilterItems().add(new FilterItemInfo("qCItem", (Object)QCItemID, CompareType.EQUALS));
            viewInfo.setFilter(filter);
            IQCStandardItemEntry qcsie = QCStandardItemEntryFactory.getRemoteInstance();
            QCStandardItemEntryCollection entrys = qcsie.getQCStandardItemEntryCollection(viewInfo);
            if (entrys.size() > 0) {
                info = entrys.get(0);
            }
        }
        catch (BOSException e) {
            logger.error((Object)e);
        }
        return info;
    }

    public void changeUIContext(CoreUIObject owner, Context ctx) {
        KDTPropertyChangeEvent event = (KDTPropertyChangeEvent)ctx.get((Object)"event");
        int rowIndex = event.getRowIndex();
        QCItemInfo itemInfo = (QCItemInfo)ctx.get((Object)"NewValue");
        IRow row = this.kdtEntrys.getRow(rowIndex);
        QCReinspectReqEditUI editUI = (QCReinspectReqEditUI)owner;
        try {
            this.dynaGroupUtils.fillQCItemGroup();
        }
        catch (Exception e) {
            owner.handUIException((Throwable)e);
        }
        if (!this.isloading(owner)) {
            QCStandardItemEntryInfo itemEntryInfo = null;
            if (itemInfo != null) {
                String QCItemID = itemInfo.getId().toString();
                String QCStandardID = editUI.getQCStandardID();
                itemEntryInfo = this.getQCStandardItemEntryInfo(QCStandardID, QCItemID);
            }
            row.getCell("enums").setValue((Object)(itemInfo != null ? itemInfo.getEnums() : null));
            row.getCell("qcItemName").setValue((Object)(itemInfo != null ? itemInfo.getName() : null));
            row.getCell("analysisMethod").setValue((Object)(itemInfo != null ? itemInfo.getAnalysisMethod() : null));
            row.getCell("qCValueType").setValue((Object)(itemInfo != null ? itemInfo.getQCValueType() : null));
            row.getCell("qCItemAttr").setValue((Object)(itemInfo != null ? itemInfo.getQCItemAttr() : null));
            row.getCell("isRuinous").setValue((Object)(itemInfo != null ? new Boolean(itemInfo.isIsRuinous()) : null));
            if (itemEntryInfo != null) {
                row.getCell("remark").setValue((Object)itemEntryInfo.getRemark());
                row.getCell("expression").setValue((Object)itemEntryInfo.getExpression());
                row.getCell("standardRequirement").setValue((Object)itemEntryInfo.getStandardRequirement());
                row.getCell("checkStep").setValue((Object)itemEntryInfo.getCheckStep());
                row.getCell("isMustCheck").setValue((Object)new Boolean(itemEntryInfo.isIsMustCheck()));
                row.getCell("isKeyItem").setValue((Object)new Boolean(itemEntryInfo.isIsKeyItem()));
                row.getCell("qCFrequency").setValue((Object)itemEntryInfo.getQCFrequency());
                row.getCell("qCMethod").setValue((Object)itemEntryInfo.getQCMethod());
                row.getCell("judgeType").setValue((Object)itemEntryInfo.getJudgeType());
                row.getCell("lowerLimit").setValue((Object)itemEntryInfo.getLowerLimit());
                row.getCell("lower").setValue((Object)itemEntryInfo.getLower());
                row.getCell("upperLimit").setValue((Object)itemEntryInfo.getUpperLimit());
                row.getCell("upper").setValue((Object)itemEntryInfo.getUpper());
                row.getCell("qCModifyMode").setValue((Object)itemEntryInfo.getQCModifyMode());
                row.getCell("dataPrecision").setValue((Object)new Integer(itemEntryInfo.getDataPrecision()));
                row.getCell("unit").setValue((Object)itemEntryInfo.getUnit());
                row.getCell("qCValueAcquisitionMode").setValue((Object)itemEntryInfo.getQCValueAcquisitionMode());
                if (QCValueTypeEnum.number.equals((Object)itemInfo.getQCValueType())) {
                    this.setCellWithNumber(row, "defaultValue");
                }
                if (QCValueTypeEnum.enumvalue.equals((Object)itemInfo.getQCValueType()) && !QMHelper.isEmpty((String)itemInfo.getEnums())) {
                    KDComboBox cbodefaultValue = new KDComboBox();
                    Object[] list = QMHelper.parseEnumString((String)itemInfo.getEnums());
                    cbodefaultValue.removeAllItems();
                    cbodefaultValue.addItems(list);
                    cbodefaultValue.setSelectedItem((Object)itemInfo.getDefaultValue());
                    row.getCell("defaultValue").setEditor((ICellEditor)new KDTDefaultCellEditor((JComboBox)cbodefaultValue));
                }
                row.getCell("defaultValue").setValue((Object)itemEntryInfo.getDefaultValue());
                ObjectUuidPK itemEntrypk = new ObjectUuidPK(itemEntryInfo.getId());
                try {
                    Map dataMap = QCStandardFacadeFactory.getRemoteInstance().getAllStandardEntryExtValue(editUI.getQCStandardPK(), (IObjectPK)itemEntrypk, editUI.getQualityOrgUnitPK());
                    row.getCell("deleOrgUnit").setValue(dataMap.get("DelegOrgUnit"));
                    row.getCell("qCGroup").setValue(dataMap.get("QCGroup"));
                    row.getCell("qCInstrumentGroup").setValue(dataMap.get("QCInstrumentGroup"));
                    row.getCell("qCInstrument").setValue(dataMap.get("QCInstrument"));
                    QCSamplingProgramInfo sampleProgram = (QCSamplingProgramInfo)dataMap.get("SampleProgram");
                    row.getCell("sampleProgram").setValue((Object)sampleProgram);
                    this.setSampleQtys(ctx, editUI, row, sampleProgram);
                }
                catch (EASBizException e) {
                    editUI.handUIException(e);
                }
                catch (BOSException e) {
                    editUI.handUIException(e);
                }
            } else {
                row.getCell("remark").setValue(null);
                row.getCell("expression").setValue(null);
                row.getCell("standardRequirement").setValue(null);
                row.getCell("checkStep").setValue(null);
                row.getCell("isMustCheck").setValue(null);
                row.getCell("isKeyItem").setValue(null);
                row.getCell("qCFrequency").setValue(null);
                row.getCell("qCMethod").setValue(null);
                row.getCell("judgeType").setValue(null);
                row.getCell("lowerLimit").setValue(null);
                row.getCell("lower").setValue(null);
                row.getCell("upperLimit").setValue(null);
                row.getCell("upper").setValue(null);
                row.getCell("defaultValue").setValue(null);
                row.getCell("deleOrgUnit").setValue(null);
                row.getCell("qCGroup").setValue(null);
                row.getCell("qCInstrumentGroup").setValue(null);
                row.getCell("qCInstrument").setValue(null);
                row.getCell("qCModifyMode").setValue(null);
                row.getCell("dataPrecision").setValue(null);
                row.getCell("unit").setValue(null);
                row.getCell("sampleProgram").setValue(null);
                row.getCell("sampleShares").setValue(null);
                row.getCell("acValue").setValue(null);
                row.getCell("reValue").setValue(null);
            }
        }
        this.controlItemInfoOnEntrys(this.kdtEntrys, rowIndex, itemInfo, editUI.getQCStandardID());
    }

    private void controlItemInfoOnEntrys(KDTable kdtItemEntries, int rowIndex, QCItemInfo itemInfo, String standardID) {
        if (itemInfo == null) {
            return;
        }
        IRow row = this.kdtEntrys.getRow(rowIndex);
        if (ItemTypeEnum.standard.equals(row.getCell("itemType").getValue())) {
            this.setEntryRowLocked(row, true);
        }
        if (ItemTypeEnum.append.equals(row.getCell("itemType").getValue())) {
            this.setEntryRowLocked(row, true);
            row.getCell("qCItem").getStyleAttributes().setLocked(false);
            row.getCell("judgeType").getStyleAttributes().setLocked(false);
            row.getCell("lowerLimit").getStyleAttributes().setLocked(false);
            row.getCell("lower").getStyleAttributes().setLocked(false);
            row.getCell("upperLimit").getStyleAttributes().setLocked(false);
            row.getCell("upper").getStyleAttributes().setLocked(false);
            row.getCell("defaultValue").getStyleAttributes().setLocked(false);
            if (QCAnalysisMethodEnum.quantitativeAnalysis.equals((Object)itemInfo.getAnalysisMethod())) {
                this.setCellWithNumber(row, "lower");
                this.setCellWithNumber(row, "upper");
            } else {
                row.getCell("judgeType").getStyleAttributes().setLocked(true);
                row.getCell("lowerLimit").getStyleAttributes().setLocked(true);
                row.getCell("lower").getStyleAttributes().setLocked(true);
                row.getCell("upperLimit").getStyleAttributes().setLocked(true);
                row.getCell("upper").getStyleAttributes().setLocked(true);
                row.getCell("judgeType").setValue(null);
                row.getCell("lowerLimit").setValue(null);
                row.getCell("lower").setValue(null);
                row.getCell("upperLimit").setValue(null);
                row.getCell("upper").setValue(null);
            }
            if (QCValueTypeEnum.formula.equals((Object)itemInfo.getQCValueType())) {
                row.getCell("defaultValue").getStyleAttributes().setLocked(true);
            }
            if (QCValueTypeEnum.number.equals((Object)itemInfo.getQCValueType())) {
                this.setCellWithNumber(row, "defaultValue");
            }
            if (QCValueTypeEnum.enumvalue.equals((Object)itemInfo.getQCValueType()) && !QMHelper.isEmpty((String)itemInfo.getEnums())) {
                KDComboBox cbodefaultValue = new KDComboBox();
                Object[] list = QMHelper.parseEnumString((String)itemInfo.getEnums());
                cbodefaultValue.removeAllItems();
                cbodefaultValue.addItems(list);
                cbodefaultValue.setSelectedItem((Object)itemInfo.getDefaultValue());
                row.getCell("defaultValue").setEditor((ICellEditor)new KDTDefaultCellEditor((JComboBox)cbodefaultValue));
            }
            if (QCValueTypeEnum.text.equals((Object)itemInfo.getQCValueType())) {
                KDTextField txtBox = new KDTextField();
                txtBox.setMaxLength(255);
                KDTDefaultCellEditor editor = new KDTDefaultCellEditor((JTextField)txtBox);
                row.getCell("defaultValue").setEditor((ICellEditor)editor);
            }
        }
    }

    public void setCellWithNumber(IRow row, String cellName) {
        KDFormattedTextField colTxtField = new KDFormattedTextField();
        colTxtField.setDataType(1);
        int dataPrecision = this.getDataPrecision(row);
        colTxtField.setPrecision(dataPrecision);
        colTxtField.setHorizontalAlignment(4);
        colTxtField.setSupportedEmpty(true);
        colTxtField.setRemoveingZeroInDispaly(false);
        colTxtField.setMaximumValue((Comparable)new BigDecimal("9999999999999.99999999"));
        colTxtField.setMinimumValue((Comparable)new BigDecimal("-9999999999999.99999999"));
        row.getCell(cellName).setEditor((ICellEditor)new KDTDefaultCellEditor((JTextField)colTxtField));
        String fmstr = QMPrecisionUtil.getFormatString((int)dataPrecision);
        ICell cell = row.getCell(cellName);
        cell.getStyleAttributes().setNumberFormat(fmstr);
    }

    public int getDataPrecision(IRow row) {
        int dataPrecision = 4;
        Object standardDataPrecision = row.getCell("dataPrecision").getValue();
        MeasureUnitInfo unitInfo = (MeasureUnitInfo)row.getCell("unit").getValue();
        if (standardDataPrecision != null && QMStringUtils.isNumber((String)standardDataPrecision.toString())) {
            BigDecimal tempBig = new BigDecimal(standardDataPrecision.toString());
            dataPrecision = tempBig.intValue();
        } else if (unitInfo != null) {
            dataPrecision = unitInfo.getQtyPrecision();
        }
        if (dataPrecision < -8 || dataPrecision > 8) {
            dataPrecision = 4;
        }
        return dataPrecision;
    }

    private void setEntryRowLocked(IRow row, boolean lock) {
        for (int i = 0; i < this.kdtEntrys.getColumnCount(); ++i) {
            row.getCell(i).getStyleAttributes().setLocked(lock);
        }
    }

    protected void setSampleQtys(Context ctx, QCReinspectReqEditUI editUI, IRow row, QCSamplingProgramInfo sampleProgram) throws BOSException, EASBizException {
        String oql;
        IQCRequestEntry ireq;
        QCRequestEntryInfo reqEntry;
        ICell cellSampleShares = row.getCell("sampleShares");
        ICell cellAC = row.getCell("acValue");
        ICell cellRE = row.getCell("reValue");
        if (sampleProgram == null) {
            cellSampleShares.setValue(null);
            cellAC.setValue(null);
            cellRE.setValue(null);
            return;
        }
        QCReinspectReqInfo reinInfo = (QCReinspectReqInfo)editUI.getDataObject();
        String reqEntryId = reinInfo.getQCReqEntryID();
        BigDecimal deliverQty = null;
        if (!QMStringUtils.isEmpty((String)reqEntryId) && !NumericUtils.equalsZero((BigDecimal)(deliverQty = (reqEntry = (ireq = QCRequestEntryFactory.getRemoteInstanceWithObjectContext(ctx)).getQCRequestEntryInfo(oql = "select deliverQty where id='" + reqEntryId + "'")).getDeliverQty()))) {
            IQCSamplingProgramFacade facade = QCSamplingProgramFacadeFactory.getRemoteInstance();
            Map map = facade.getAcceptStandard(sampleProgram.getId().toString(), deliverQty);
            cellAC.setValue(map.get("ac"));
            cellRE.setValue(map.get("re"));
            cellSampleShares.setValue(map.get("sampleCount"));
        }
    }
}

