/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.qm.qc.client.action.hqhp;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.swing.KDCheckBox;
import com.kingdee.bos.ctrl.swing.util.CtrlFormatUtilities;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.qm.common.client.action.AbstractUIContextAction;
import com.kingdee.eas.qm.common.client.action.IUIContextAction;
import com.kingdee.eas.qm.qc.HQHPCalBillInfo;
import com.kingdee.eas.qm.qc.HQHPCalBillQcReportEntryCollection;
import com.kingdee.eas.qm.qc.HQHPCalBillQcReportEntryInfo;
import com.kingdee.eas.qm.qc.PricingPatternEnum;
import com.kingdee.eas.qm.qc.util.HQHPUtil;
import com.kingdee.util.StringUtils;
import java.math.BigDecimal;

public class HQHPQcReportConPriceSAction
extends AbstractUIContextAction
implements IUIContextAction {
    private KDTable kdtQcReportEntry;
    private KDCheckBox chkIsCaled;
    private boolean isFromSettleQuanS = false;

    public HQHPQcReportConPriceSAction(KDTable kdtQcReportEntry, KDCheckBox chkIsCaled, boolean isFromSettleQuanS) {
        this.kdtQcReportEntry = kdtQcReportEntry;
        this.chkIsCaled = chkIsCaled;
        this.isFromSettleQuanS = isFromSettleQuanS;
    }

    public void changeUIContext(CoreUIObject owner, Context ctx) throws BOSException, EASBizException {
        if (this.isloading(owner) || this.kdtQcReportEntry.getSelectManager().getActiveRowIndex() < 0) {
            return;
        }
        HQHPCalBillInfo editData = (HQHPCalBillInfo)owner.getDataObject();
        this.calcAvgPrice(editData);
    }

    private void calcAvgPrice(HQHPCalBillInfo editData) throws EASBizException, BOSException {
        PricingPatternEnum pricingPattern = editData.getPricingPattern();
        int index = this.kdtQcReportEntry.getSelectManager().getActiveRowIndex();
        BigDecimal conPriceRec = (BigDecimal)this.kdtQcReportEntry.getCell(index, "conPriceRec").getValue();
        if (conPriceRec == null || HQHPUtil.isZero(conPriceRec)) {
            return;
        }
        if (PricingPatternEnum.CONPRICE.equals((Object)pricingPattern) || this.isFromSettleQuanS) {
            editData.setIsCaled(false);
            this.chkIsCaled.setSelected(false);
        }
        this.setModifyCellToEditData(editData);
        HQHPUtil.calcPercentWeight(null, editData);
        this.storeQcReport(editData);
        String[] reportSumFields = new String[]{"settleQuanS", "percent", "conPriceAvg", "moneyAvg"};
        HQHPUtil.appendFootRow(this.kdtQcReportEntry, reportSumFields, null);
        this.kdtQcReportEntry.getFootManager().getFootRow(0).getCell("percent").getStyleAttributes().setNumberFormat(CtrlFormatUtilities.getDecimalFormatString());
        int priceScale = this.initPriceScale(editData);
        BigDecimal avgPrice = HQHPUtil.getPriceInScale((BigDecimal)this.kdtQcReportEntry.getFootManager().getFootRow(0).getCell("conPriceAvg").getValue(), priceScale);
        if (avgPrice != null && HQHPUtil.notZero(avgPrice)) {
            editData.setUnitPrice(avgPrice);
        }
    }

    private int initPriceScale(HQHPCalBillInfo editData) throws EASBizException, BOSException {
        int priceScale = 4;
        String paramValue = HQHPUtil.getPriceParamValue(null, "HQHP002", editData.getPurOrgUnit().getId().toString());
        if (!StringUtils.isEmpty((String)paramValue) && !"DEFAULT".equals(paramValue)) {
            priceScale = Integer.parseInt(paramValue);
        }
        return priceScale;
    }

    private void setModifyCellToEditData(HQHPCalBillInfo editData) {
        int index = this.kdtQcReportEntry.getSelectManager().getActiveRowIndex();
        BigDecimal conPriceRec = (BigDecimal)this.kdtQcReportEntry.getCell(index, "conPriceRec").getValue();
        String id = this.kdtQcReportEntry.getCell(index, "id").getValue().toString();
        HQHPCalBillQcReportEntryInfo calBillQcReportEntryInfo = editData.getQcReportEntry().get(BOSUuid.read((String)id));
        calBillQcReportEntryInfo.setConPriceRec(conPriceRec);
        BigDecimal settleQuanS = (BigDecimal)this.kdtQcReportEntry.getCell(index, "settleQuanS").getValue();
        calBillQcReportEntryInfo.setSettleQuanS(settleQuanS);
    }

    private void storeQcReport(HQHPCalBillInfo editData) {
        HQHPCalBillQcReportEntryCollection qcReportEntry = editData.getQcReportEntry();
        for (int i = 0; i < qcReportEntry.size(); ++i) {
            HQHPCalBillQcReportEntryInfo calBillQcReportEntryInfo = qcReportEntry.get(i);
            String qcReportId = qcReportEntry.get(i).getQcPurReport().getId().toString();
            IRow row = this.getRowByReportId(qcReportId);
            if (row == null) continue;
            row.getCell("conPriceAvg").setValue((Object)calBillQcReportEntryInfo.getConPriceAvg());
            row.getCell("moneyAvg").setValue((Object)calBillQcReportEntryInfo.getMoneyAvg());
            row.getCell("percent").setValue((Object)calBillQcReportEntryInfo.getPercent());
        }
    }

    private IRow getRowByReportId(String reportId) {
        for (int i = 0; i < this.kdtQcReportEntry.getRowCount(); ++i) {
            String id = this.kdtQcReportEntry.getRow(i).getCell("reportID").getValue().toString();
            if (!id.equals(reportId)) continue;
            return this.kdtQcReportEntry.getRow(i);
        }
        return null;
    }
}

