/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.qm.qc.client.action.hqhp;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectEvent;
import com.kingdee.bos.ctrl.swing.util.CtrlFormatUtilities;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.basedata.master.material.MultiMeasureUnitFactory;
import com.kingdee.eas.basedata.master.material.MultiMeasureUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.qm.common.QMBillBaseStatusEnum;
import com.kingdee.eas.qm.common.client.action.AbstractUIContextAction;
import com.kingdee.eas.qm.common.client.action.IUIContextAction;
import com.kingdee.eas.qm.qc.HQHPCalBillFactory;
import com.kingdee.eas.qm.qc.HQHPCalBillInfo;
import com.kingdee.eas.qm.qc.HQHPCalBillQcReportEntryCollection;
import com.kingdee.eas.qm.qc.QCReportInfo;
import com.kingdee.eas.qm.qc.util.HQHPUtil;
import com.kingdee.util.StringUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;

public class HQHPQcReprotEntryAction
extends AbstractUIContextAction
implements IUIContextAction {
    private KDTable kdtQcReportEntrys;
    private KDTable kdtRelWeighEntrys;
    private int qtyScale = 2;

    public HQHPQcReprotEntryAction(KDTable kdtQcReportEntrys, KDTable kdtRelWeighEntrys) {
        this.kdtQcReportEntrys = kdtQcReportEntrys;
        this.kdtRelWeighEntrys = kdtRelWeighEntrys;
    }

    public void changeUIContext(CoreUIObject owner, Context context) throws BOSException, EASBizException {
        if (this.isloading(owner)) {
            return;
        }
        HQHPCalBillInfo editData = (HQHPCalBillInfo)owner.getDataObject();
        if (!editData.isIsWeigh()) {
            return;
        }
        KDTSelectEvent e = (KDTSelectEvent)context.get((Object)"event");
        if (e.getPrevSelectBlock() != null && e.getPrevSelectBlock().getTop() == e.getSelectBlock().getTop()) {
            return;
        }
        int top = e.getSelectBlock().getTop();
        if (top < 0) {
            return;
        }
        IRow row = this.kdtQcReportEntrys.getRow(top);
        String reportID = row.getCell("reportID").getValue().toString();
        String requestEntryID = "";
        HQHPCalBillQcReportEntryCollection qcReportEntry = editData.getQcReportEntry();
        for (int i = 0; i < qcReportEntry.size(); ++i) {
            QCReportInfo qcPurReport = qcReportEntry.get(i).getQcPurReport();
            if (!reportID.equals(qcPurReport.getId().toString())) continue;
            requestEntryID = qcPurReport.getRequestEntryID();
            break;
        }
        ArrayList<String> p = new ArrayList<String>();
        p.add(reportID);
        p.add(requestEntryID);
        p.add(editData.getId().toString());
        Map relWeighInfo = HQHPCalBillFactory.getRemoteInstance().getCurRelWeighInfo(p);
        List rows = (List)relWeighInfo.get("list");
        if (rows.size() == 0) {
            return;
        }
        this.initQtyScale(editData.getPurOrgUnit().getId().toString(), editData.getPurContractEntry().getMaterial().getId().toString(), editData.getPurContractEntry().getUnit().getId().toString());
        this.fillTableWithList(this.kdtRelWeighEntrys, rows);
        this.addDryWeighInfo(editData, reportID);
        this.addSupplierQty(editData);
        String[] sumFields = new String[]{"grossWeight", "tareWeight", "incidental", "netWeight", "deductWeight", "dryWeight", "supplierQty", "supplierDryWeight"};
        HQHPUtil.appendFootRow(this.kdtRelWeighEntrys, sumFields, null);
    }

    private void initQtyScale(String purOrgUnitId, String materialId, String unitId) throws BOSException, EASBizException {
        MultiMeasureUnitInfo multiUnitInfo;
        this.qtyScale = 2;
        String paramValue = HQHPUtil.getQtyParamValue(null, "HQHP001", purOrgUnitId);
        if (!StringUtils.isEmpty((String)paramValue) && !"DEFAULT".equals(paramValue)) {
            this.qtyScale = Integer.parseInt(paramValue);
        } else if (unitId != null && (multiUnitInfo = MultiMeasureUnitFactory.getRemoteInstance().getMultiUnit(materialId, unitId)) != null) {
            this.qtyScale = multiUnitInfo.getQtyPrecision();
        }
    }

    private void addSupplierQty(HQHPCalBillInfo editData) {
        BigDecimal netWeightAmount = editData.getNetWeightAmount();
        BigDecimal supplierAmount = editData.getSupplierAmount();
        if (netWeightAmount == null || HQHPUtil.isZero(netWeightAmount) || supplierAmount == null) {
            return;
        }
        BigDecimal netWeightInReport = this.calWeighBillNetWeight();
        if (HQHPUtil.isZero(netWeightInReport)) {
            return;
        }
        BigDecimal supplierQtyInReport = HQHPUtil.multiply(netWeightInReport.divide(netWeightAmount, 10, 4), supplierAmount, 10);
        BigDecimal supplierQtyTillLastRow = HQHPUtil.BigDecimal_Zero;
        for (int i = 0; i < this.kdtRelWeighEntrys.getRowCount(); ++i) {
            IRow row = this.kdtRelWeighEntrys.getRow(i);
            if (row.getCell("netWeight").getValue() == null) continue;
            BigDecimal netWeight = new BigDecimal(row.getCell("netWeight").getValue().toString());
            BigDecimal supplierQty = null;
            if (i != this.kdtRelWeighEntrys.getRowCount() - 1) {
                supplierQty = HQHPUtil.multiply(netWeight.divide(netWeightInReport, 10, 4), supplierQtyInReport, 10);
                supplierQtyTillLastRow = supplierQtyTillLastRow.add(supplierQty);
                row.getCell("supplierQty").setValue((Object)supplierQty);
            } else {
                supplierQty = supplierQtyInReport.subtract(supplierQtyTillLastRow);
                row.getCell("supplierQty").setValue((Object)supplierQty);
            }
            if (row.getCell("deductWeight").getValue() == null) continue;
            BigDecimal deduct = new BigDecimal(row.getCell("deductWeight").getValue().toString());
            row.getCell("supplierDryWeight").setValue((Object)supplierQty.subtract(deduct));
        }
    }

    private BigDecimal calWeighBillNetWeight() {
        BigDecimal netWeightInReport = HQHPUtil.BigDecimal_Zero;
        for (int i = 0; i < this.kdtRelWeighEntrys.getRowCount(); ++i) {
            IRow row = this.kdtRelWeighEntrys.getRow(i);
            if (row.getCell("netWeight").getValue() == null) continue;
            BigDecimal netWeight = new BigDecimal(row.getCell("netWeight").getValue().toString());
            netWeightInReport = netWeightInReport.add(netWeight);
        }
        return netWeightInReport;
    }

    private void fillTableWithList(KDTable table, List rows) {
        table.removeRows();
        for (int i = 0; i < rows.size(); ++i) {
            IRow row = table.addRow();
            Map rowMap = (Map)rows.get(i);
            for (int j = 0; j < table.getColumnCount(); ++j) {
                String key = table.getColumnKey(j);
                if (rowMap.get(key) == null) continue;
                if ("billStatus".equals(key)) {
                    row.getCell(key).setValue((Object)QMBillBaseStatusEnum.getEnum((int)HQHPUtil.getInt(rowMap.get(key))));
                    continue;
                }
                if ("isContinuousCar".equals(key) || "isMuchCarry".equals(key)) {
                    row.getCell(key).setValue((Object)HQHPUtil.getBoolean(rowMap.get(key)));
                    continue;
                }
                if ("auditTime".equals(key)) {
                    row.getCell(key).setValue((Object)CtrlFormatUtilities.getDateFormat().format((Date)rowMap.get(key)));
                    continue;
                }
                row.getCell(key).setValue(rowMap.get(key));
            }
        }
    }

    private void addDryWeighInfo(HQHPCalBillInfo editData, String reportID) throws EASBizException, BOSException {
        BigDecimal netWeightInReport = this.calWeighBillNetWeight();
        BigDecimal netWeight = editData.getNetWeightAmount();
        BigDecimal dryWeight = editData.getDryWeightAmount();
        BigDecimal totalDeductWeight = editData.getTotalDeductWeight();
        BigDecimal divide = null;
        if (netWeight != null && netWeight.compareTo(HQHPUtil.BigDecimal_Zero) != 0) {
            divide = netWeightInReport.divide(netWeight, 10, 4);
        }
        if (divide != null && dryWeight != null && totalDeductWeight != null) {
            BigDecimal dryWeightInReport = divide.multiply(dryWeight).setScale(this.qtyScale, 4);
            BigDecimal deductWeightInReport = divide.multiply(totalDeductWeight).setScale(this.qtyScale, 4);
            this.addDryWeightToEachWeighBill(netWeightInReport, dryWeightInReport, deductWeightInReport);
        }
    }

    private void addDryWeightToEachWeighBill(BigDecimal netWeightInReport, BigDecimal dryWeightInReport, BigDecimal deductWeightInReport) {
        if (dryWeightInReport == null || dryWeightInReport.compareTo(HQHPUtil.BigDecimal_Zero) == 0) {
            return;
        }
        if (netWeightInReport.compareTo(HQHPUtil.BigDecimal_Zero) == 0) {
            return;
        }
        for (int i = 0; i < this.kdtRelWeighEntrys.getRowCount(); ++i) {
            IRow row = this.kdtRelWeighEntrys.getRow(i);
            if (row.getCell("netWeight").getValue() == null) continue;
            BigDecimal netWeight = new BigDecimal(row.getCell("netWeight").getValue().toString());
            BigDecimal deductWeight = netWeight.divide(netWeightInReport, 10, 4).multiply(deductWeightInReport).setScale(this.qtyScale, 4);
            BigDecimal dryWeight = netWeight.subtract(deductWeight);
            row.getCell("dryWeight").setValue((Object)dryWeight);
            row.getCell("deductWeight").setValue((Object)deductWeight);
        }
    }
}

