/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.qm.qc.client.action.qcbill;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTPropertyChangeEvent;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.basedata.assistant.MeasureUnitInfo;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.master.material.MultiMeasureUnitFactory;
import com.kingdee.eas.basedata.master.material.MultiMeasureUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.qm.common.cache.IQMCacheManager;
import com.kingdee.eas.qm.common.client.action.AbstractUIContextAction;
import com.kingdee.eas.qm.common.client.action.IUIContextAction;
import com.kingdee.eas.qm.common.util.KDTableUtils;
import com.kingdee.eas.qm.common.util.QMConstant;
import com.kingdee.eas.qm.common.util.QMUnitAndExchangeUtils;
import com.kingdee.eas.qm.qc.QCBillInfo;
import com.kingdee.eas.qm.qc.client.QCBillEditUI;
import com.kingdee.eas.qm.qc.client.util.QCUIUtil;
import java.math.BigDecimal;

public class EachSampleUnitChangedAction
extends AbstractUIContextAction
implements IUIContextAction {
    private KDTable sampleTable;
    private boolean isChanging = false;

    public EachSampleUnitChangedAction(KDTable table) {
        this.sampleTable = table;
    }

    public void changeUIContext(CoreUIObject owner, Context ctx) throws BOSException, EASBizException {
        QCBillEditUI editUI = (QCBillEditUI)owner;
        KDTPropertyChangeEvent e = (KDTPropertyChangeEvent)ctx.get((Object)"event");
        int rowIndex = e.getRowIndex();
        MaterialInfo material = ((QCBillInfo)owner.getDataObject()).getMaterial();
        MeasureUnitInfo oldUnitValue = (MeasureUnitInfo)e.getOldValue();
        MeasureUnitInfo unitValue = (MeasureUnitInfo)ctx.get((Object)"NewValue");
        if (editUI.isSampleSharesAutoSum()) {
            this.convertQty(editUI, rowIndex, material, oldUnitValue, unitValue);
        }
        if (this.isChanging) {
            return;
        }
        this.isChanging = true;
        this.isChanging = false;
    }

    private void convertQty(QCBillEditUI editUI, int rowIndex, MaterialInfo material, MeasureUnitInfo oldUnitValue, MeasureUnitInfo unitValue) throws EASBizException, BOSException {
        IRow row = this.sampleTable.getRow(rowIndex);
        if (material != null && oldUnitValue != null && unitValue != null) {
            if (oldUnitValue.equals((Object)unitValue)) {
                return;
            }
            BigDecimal eachSampleQty = QCUIUtil.getBigDecimalValueFromCell(row.getCell("eachSampleQty"));
            if (eachSampleQty == null) {
                return;
            }
            IQMCacheManager cache = editUI.getCacheManager();
            String mulityKey = material.getId().toString() + oldUnitValue.getId().toString();
            MultiMeasureUnitInfo oldmultiUnit = this.getMultiUnit(material, oldUnitValue, cache, mulityKey);
            mulityKey = material.getId().toString() + unitValue.getId().toString();
            MultiMeasureUnitInfo multiUnit = this.getMultiUnit(material, unitValue, cache, mulityKey);
            KDTableUtils.setBigDecimalFieldsPrecision((int)multiUnit.getQtyPrecision(), (KDTable)this.sampleTable, (String[])new String[]{"eachSampleQty", "sampleQty"});
            BigDecimal targetQty = QMConstant.ZERO;
            targetQty = QMUnitAndExchangeUtils.getQtyAfterCovert((BigDecimal)eachSampleQty, (BigDecimal)targetQty, (MultiMeasureUnitInfo)oldmultiUnit, (MultiMeasureUnitInfo)multiUnit);
            row.getCell("eachSampleQty").setValue((Object)targetQty);
        }
    }

    private MultiMeasureUnitInfo getMultiUnit(MaterialInfo material, MeasureUnitInfo unitValue, IQMCacheManager cache, String mulityKey) throws BOSException, EASBizException {
        MultiMeasureUnitInfo oldmultiUnit = null;
        if (cache.get((Object)mulityKey) != null) {
            oldmultiUnit = (MultiMeasureUnitInfo)cache.get((Object)mulityKey);
        } else {
            oldmultiUnit = MultiMeasureUnitFactory.getRemoteInstance().getMultiUnit(material.getId().toString(), unitValue.getId().toString());
            cache.put((Object)mulityKey, (Object)oldmultiUnit);
        }
        return oldmultiUnit;
    }
}

