/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.qm.qc.client.action.reject;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.qm.common.util.QMStringUtils;
import com.kingdee.eas.qm.qc.QCReportEntryCollection;
import com.kingdee.eas.qm.qc.QCReportEntryInfo;
import com.kingdee.eas.qm.qc.QCReportFactory;
import com.kingdee.eas.qm.qc.QCReportInfo;
import com.kingdee.eas.qm.qc.client.action.QCItemEntryDoubleClickedAction;
import com.kingdee.eas.qm.qc.client.util.QCItemEntryEditUIHelper;
import com.kingdee.eas.qm.qc.client.util.qcreport.QCReportEditUIHelper;

public class QCRejectDoubleClickedAction
extends QCItemEntryDoubleClickedAction {
    public QCRejectDoubleClickedAction(KDTable table) {
        super(table);
    }

    @Override
    protected IObjectCollection getNewEntryCollection() {
        return null;
    }

    @Override
    public void changeUIContext(CoreUIObject owner, Context ctx) throws BOSException, EASBizException {
        KDTMouseEvent e = (KDTMouseEvent)ctx.get((Object)"event");
        int rowIndex = e.getRowIndex();
        int colIndex = e.getColIndex();
        if (!this.isNeedDoubleCol(colIndex)) {
            return;
        }
        String currRptEntryId = (String)this.table.getCell(rowIndex, "srcBillEntryId").getValue();
        QCReportInfo rptInfo = this.getRptInfo(rowIndex);
        QCReportEntryCollection rptEntrys = rptInfo.getEntrys();
        QCReportEntryInfo currRptEntry = rptEntrys.get(BOSUuid.read((String)currRptEntryId));
        owner.getUIContext().put("Context_DetailUIOprtState", OprtState.VIEW);
        QCItemEntryEditUIHelper.showEntryEditUI(owner, (Object)rptEntrys, currRptEntry);
    }

    private QCReportInfo getRptInfo(int rowIndex) throws EASBizException, BOSException {
        QCReportInfo rptInfo = null;
        String rptId = (String)this.table.getCell(rowIndex, "srcBillId").getValue();
        if (!QMStringUtils.isEmpty((String)rptId)) {
            rptInfo = QCReportFactory.getRemoteInstance().getQCReportInfo((IObjectPK)new ObjectUuidPK(rptId), this.getRptSelector());
        }
        return rptInfo;
    }

    private SelectorItemCollection getRptSelector() {
        SelectorItemCollection sic = QCReportEditUIHelper.getSelectorForQCReport();
        sic.add("entrys.sampleEntry.*");
        sic.add("entrys.sampleEntry.unit.*");
        return sic;
    }

    private boolean isNeedDoubleCol(int colIndex) {
        int qcValueAcqIndex = this.table.getColumnIndex("qCValueAcquisitionMode");
        int sampleSharesIndex = this.table.getColumnIndex("sampleShares");
        int passSharesIndex = this.table.getColumnIndex("passShares");
        int unPassSharesIndex = this.table.getColumnIndex("unPassShares");
        boolean flag = false;
        if (qcValueAcqIndex == colIndex || sampleSharesIndex == colIndex || passSharesIndex == colIndex || unPassSharesIndex == colIndex) {
            flag = true;
        }
        return flag;
    }
}

