/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.qm.qc.client.action.request;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTPropertyChangeEvent;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDTextField;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.qm.basedata.QCAnalysisMethodEnum;
import com.kingdee.eas.qm.basedata.QCItemAttributeEnum;
import com.kingdee.eas.qm.basedata.QCItemFacadeFactory;
import com.kingdee.eas.qm.basedata.QCItemInfo;
import com.kingdee.eas.qm.basedata.QCValueAcquisitionModeEnum;
import com.kingdee.eas.qm.basedata.QCValueTypeEnum;
import com.kingdee.eas.qm.basedata.client.util.QCStandardClientUtils;
import com.kingdee.eas.qm.basedata.client.util.QCStandardEditUIF7FilterHelper;
import com.kingdee.eas.qm.common.client.util.QMClientUtils;
import com.kingdee.eas.qm.common.util.KDTableUtils;
import com.kingdee.eas.qm.common.util.QMConstant;
import com.kingdee.eas.qm.common.util.QMPrecisionUtil;
import com.kingdee.eas.qm.qc.client.QCRequestEditUI;
import com.kingdee.eas.qm.qc.client.action.request.AbstractRequestUIContextAction;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JComboBox;
import javax.swing.JTextField;

public class RequestKDTableQCItemAction
extends AbstractRequestUIContextAction {
    private KDTable entry = null;
    KDBizPromptBox prmtQCItem;
    QCRequestEditUI ui;

    public RequestKDTableQCItemAction(QCRequestEditUI ui, KDTable entry) {
        this.ui = ui;
        this.entry = entry;
    }

    public void changeUIContext(CoreUIObject owner, Context ctx) throws BOSException, EASBizException {
        if (this.isloading(owner)) {
            return;
        }
        KDTPropertyChangeEvent e = (KDTPropertyChangeEvent)ctx.get((Object)"event");
        IRow row = this.entry.getRow(e.getRowIndex());
        QCItemInfo qcItem = (QCItemInfo)ctx.get((Object)"NewValue");
        try {
            this.registerQCItemGroup(this.ui);
        }
        catch (Exception exp) {
            this.ui.handUIException(exp);
        }
        this.setAcquisitionModeDefault(row, qcItem);
        this.setSampleProgram(this.ui, row, qcItem);
        this.setUnit(this.ui, row, qcItem);
        this.setDataPrecision(this.ui, row, qcItem);
        this.setModifyMode(this.ui, row, qcItem);
        this.setFieldStatus(this.ui, row, qcItem);
        RequestKDTableQCItemAction.setDefaultValueEditor(this.ui, this.entry, row, qcItem);
        this.setInterEditorValue(this.ui, row, qcItem);
        this.setEditorDataPrecision(this.ui, row, qcItem);
    }

    protected void setInterEditorValue(QCRequestEditUI ui, IRow row, QCItemInfo qcItem) throws EASBizException, BOSException {
        ICell itemNameCell = row.getCell("qcItemName");
        ICell valueTypeCell = row.getCell("qcValueType");
        ICell itemAttrCell = row.getCell("itemAttr");
        ICell delOrgCell = row.getCell("delegateQualityOrg");
        ICell qcGrpCell = row.getCell("qcGroup");
        ICell analysisMethodCell = row.getCell("analysisMethod");
        String itemName = qcItem == null ? "" : qcItem.getName();
        itemNameCell.setValue((Object)itemName);
        QCValueTypeEnum valueType = qcItem == null ? null : qcItem.getQCValueType();
        valueTypeCell.setValue((Object)valueType);
        QCItemAttributeEnum itemAttr = qcItem == null ? null : qcItem.getQCItemAttr();
        itemAttrCell.setValue((Object)itemAttr);
        QCAnalysisMethodEnum analysisMethod = qcItem == null ? null : qcItem.getAnalysisMethod();
        analysisMethodCell.setValue((Object)analysisMethod);
        String defaultValue = qcItem == null ? null : qcItem.getDefaultValue();
        row.getCell("defaultValue").setValue((Object)defaultValue);
        Object delOrg = null;
        Object qcGrp = null;
        if (qcItem != null) {
            String orgID = ui.getMainOrgInfo().getId().toString();
            Map map = new HashMap();
            map = QCItemFacadeFactory.getRemoteInstance().getDelegOrgUnitAndQCGroup(orgID, qcItem.getId().toString());
            delOrg = map.get("ORG");
            qcGrp = map.get("GROUP");
        }
        delOrgCell.setValue(delOrg);
        qcGrpCell.setValue(qcGrp);
        row.getCell("qcModifyMode").setValue(null);
    }

    protected void setEditorDataPrecision(QCRequestEditUI ui, IRow row, QCItemInfo qcItem) {
        QCValueTypeEnum valueType;
        QCValueTypeEnum qCValueTypeEnum = valueType = qcItem == null ? null : qcItem.getQCValueType();
        if (valueType != QCValueTypeEnum.number && valueType != QCValueTypeEnum.formula) {
            return;
        }
        int dataPrecision = QCStandardClientUtils.getRowCheckValuePrecision((KDTable)this.entry, (int)row.getRowIndex(), (String)"qcModifyMode", (String)"dataPrecision", (String)"unit");
        KDTableUtils.setBigDecimalFieldsPrecision((int)dataPrecision, (KDTable)this.entry, (int)row.getRowIndex(), (String[])new String[]{"defaultValue", "lower", "upper"});
    }

    private void registerQCItemGroup(QCRequestEditUI ui) throws Exception {
        ui.getDynaGroupManager().fillQCItemGroup();
    }

    protected void setAcquisitionModeDefault(IRow row, QCItemInfo qcItem) {
        ICell cell = row.getCell("qcValueAcquisitionMode");
        if (null == qcItem) {
            cell.setValue(null);
            return;
        }
        if (row.getStyleAttributes().isLocked()) {
            return;
        }
        cell.setValue((Object)qcItem.getQCValueAcquisitionMode());
        if (QCValueTypeEnum.formula.equals((Object)qcItem.getQCValueType())) {
            cell.getStyleAttributes().setLocked(true);
            cell.setValue((Object)QCValueAcquisitionModeEnum.BYQCITEM);
        } else {
            cell.getStyleAttributes().setLocked(false);
        }
    }

    protected void setSampleProgram(QCRequestEditUI ui, IRow row, QCItemInfo qcItem) {
        ICell cellSampleProgram = row.getCell("sampleProgram");
        ICell cellSampleShares = row.getCell("sampleShares");
        ICell cellAC = row.getCell("ac");
        ICell cellRE = row.getCell("re");
        cellSampleProgram.setValue(null);
        cellSampleShares.setValue(null);
        cellAC.setValue(null);
        cellRE.setValue(null);
        String orgId = ui.getMainOrgInfo().getId().toString();
        EntityViewInfo ev = QCStandardEditUIF7FilterHelper.getSampleProgramView((String)orgId, (QCItemInfo)qcItem);
        KDBizPromptBox prmtSamProgram = this.registerEntryF7("com.kingdee.eas.qm.basedata.app.QCSamplingProgramF7Query");
        prmtSamProgram.setEntityViewInfo(ev);
        this.addF7ToCellEditor(this.entry, prmtSamProgram, row.getRowIndex(), "sampleProgram");
    }

    protected void setUnit(QCRequestEditUI ui, IRow row, QCItemInfo qcItem) {
        ICell cellUnit = row.getCell("unit");
        if (qcItem == null) {
            cellUnit.setValue(null);
            cellUnit.getStyleAttributes().setBackground(QMConstant.UnRequired_Color);
        } else {
            QCValueTypeEnum valueType = qcItem.getQCValueType();
            if (QCValueTypeEnum.number.equals((Object)valueType) || QCValueTypeEnum.formula.equals((Object)valueType)) {
                cellUnit.getStyleAttributes().setBackground(QMConstant.Required_Color);
            } else {
                cellUnit.getStyleAttributes().setBackground(QMConstant.UnRequired_Color);
            }
        }
    }

    protected void setDataPrecision(QCRequestEditUI ui, IRow row, QCItemInfo qcItem) {
        ICell cell = row.getCell("dataPrecision");
        if (qcItem == null) {
            cell.setValue(null);
        } else {
            cell.setValue((Object)new Integer(qcItem.getDataPrecision()));
        }
    }

    protected void setModifyMode(QCRequestEditUI ui, IRow row, QCItemInfo qcItem) {
        boolean isRequired = qcItem == null ? false : qcItem.isIsModify();
        ICell cell = row.getCell("qcModifyMode");
        if (isRequired) {
            cell.getStyleAttributes().setBackground(QMConstant.Required_Color);
        } else {
            cell.getStyleAttributes().setBackground(QMConstant.UnRequired_Color);
        }
    }

    protected void setFieldStatus(QCRequestEditUI ui, IRow row, QCItemInfo qcItem) {
        if (qcItem == null) {
            return;
        }
        QCValueTypeEnum valueType = qcItem.getQCValueType();
        boolean isLock = QCValueTypeEnum.text.equals((Object)valueType) || QCValueTypeEnum.enumvalue.equals((Object)valueType);
        QMClientUtils.lockCells((IRow)row, (String[])new String[]{"mergeMode", "judgeType", "lowerLimit", "lower", "upperLimit", "upper", "qcModifyMode"}, (boolean)isLock);
        boolean isJudgeTypeRequired = QCItemAttributeEnum.checkItem.equals((Object)qcItem.getQCItemAttr()) && QCAnalysisMethodEnum.quantitativeAnalysis.equals((Object)qcItem.getAnalysisMethod());
        ICell cellJudgeType = row.getCell("judgeType");
        if (isJudgeTypeRequired) {
            cellJudgeType.getStyleAttributes().setBackground(QMConstant.Required_Color);
        } else {
            cellJudgeType.getStyleAttributes().setBackground(QMConstant.UnRequired_Color);
        }
    }

    public static void setDefaultValueEditor(QCRequestEditUI ui, KDTable entry, IRow row, QCItemInfo qcItem) {
        if (qcItem == null) {
            return;
        }
        QCValueTypeEnum valueType = qcItem.getQCValueType();
        ICell cellDefaultValue = row.getCell("defaultValue");
        if (QCValueTypeEnum.enumvalue.equals((Object)valueType)) {
            String enumsValue = qcItem.getEnums();
            KDComboBox combox = new KDComboBox();
            if (!StringUtil.isEmptyString((String)enumsValue)) {
                Object[] items = enumsValue.split("#");
                combox.addItems(items);
            }
            KDTDefaultCellEditor editor = new KDTDefaultCellEditor((JComboBox)combox);
            cellDefaultValue.setEditor((ICellEditor)editor);
        } else if (QCValueTypeEnum.formula.equals((Object)valueType)) {
            KDTextField txtBox = new KDTextField();
            KDTDefaultCellEditor editor = new KDTDefaultCellEditor((JTextField)txtBox);
            cellDefaultValue.setEditor((ICellEditor)editor);
            cellDefaultValue.getStyleAttributes().setLocked(true);
        } else if (QCValueTypeEnum.number.equals((Object)valueType)) {
            int precision = QCStandardClientUtils.getRowCheckValuePrecision((KDTable)entry, (int)row.getRowIndex(), (String)"qcModifyMode", (String)"dataPrecision", (String)"unit");
            QMPrecisionUtil.setRowNumberEditor((int)precision, (IRow)row, (String[])new String[]{"defaultValue", "lower", "upper"}, null, null, (boolean)true);
        } else {
            KDTextField txtBox = new KDTextField();
            txtBox.setMaxLength(255);
            KDTDefaultCellEditor editor = new KDTDefaultCellEditor((JTextField)txtBox);
            cellDefaultValue.setEditor((ICellEditor)editor);
        }
    }
}

