/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.qm.qc.client.action.request;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTPropertyChangeEvent;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.qm.basedata.IQCSamplingProgramFacade;
import com.kingdee.eas.qm.basedata.QCSamplingProgramFacadeFactory;
import com.kingdee.eas.qm.basedata.QCSamplingProgramInfo;
import com.kingdee.eas.qm.qc.client.QCRequestEditUI;
import com.kingdee.eas.qm.qc.client.action.request.AbstractRequestUIContextAction;
import java.math.BigDecimal;
import java.util.Map;

public class RequestKDTableSampleProgramAction
extends AbstractRequestUIContextAction {
    private KDTable itemEntry;
    private QCRequestEditUI ui = null;

    public RequestKDTableSampleProgramAction(KDTable itemEntry) {
        this.itemEntry = itemEntry;
    }

    public void changeUIContext(CoreUIObject owner, Context ctx) throws BOSException, EASBizException {
        this.ui = (QCRequestEditUI)owner;
        IRow materialRow = this.ui.getActivedMaterialRow();
        if (null == materialRow) {
            return;
        }
        BigDecimal deliverQty = (BigDecimal)materialRow.getCell("deliverQty").getValue();
        KDTPropertyChangeEvent event = (KDTPropertyChangeEvent)ctx.get((Object)"event");
        int rowIdx = event.getRowIndex();
        QCSamplingProgramInfo sampleProgram = (QCSamplingProgramInfo)event.getNewValue();
        RequestKDTableSampleProgramAction.setSampleProgramQty(this.itemEntry, deliverQty, rowIdx, sampleProgram);
    }

    public static void setSampleProgramQty(KDTable itemEntry, BigDecimal deliverQty, int itemRowIdx, QCSamplingProgramInfo sampleProgram) throws BOSException, EASBizException {
        ICell cellAC = itemEntry.getCell(itemRowIdx, "ac");
        ICell cellRE = itemEntry.getCell(itemRowIdx, "re");
        ICell cellShares = itemEntry.getCell(itemRowIdx, "sampleShares");
        cellAC.setValue(null);
        cellRE.setValue(null);
        cellShares.setValue(null);
        if (null == sampleProgram) {
            cellShares.getStyleAttributes().setLocked(false);
            cellAC.getStyleAttributes().setLocked(false);
            cellRE.getStyleAttributes().setLocked(false);
            return;
        }
        cellShares.getStyleAttributes().setLocked(true);
        cellAC.getStyleAttributes().setLocked(true);
        cellRE.getStyleAttributes().setLocked(true);
        if (null == deliverQty) {
            return;
        }
        IQCSamplingProgramFacade facade = QCSamplingProgramFacadeFactory.getRemoteInstance();
        Map map = facade.getAcceptStandard(sampleProgram.getId().toString(), deliverQty);
        BigDecimal sampleShares = map.get("sampleCount") != null ? (BigDecimal)map.get("sampleCount") : null;
        BigDecimal acValue = map.get("ac") != null ? (BigDecimal)map.get("ac") : null;
        BigDecimal reValue = map.get("re") != null ? (BigDecimal)map.get("re") : null;
        cellAC.setValue((Object)acValue);
        cellRE.setValue((Object)reValue);
        cellShares.setValue((Object)sampleShares);
    }
}

