/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.qm.qc.client.action.request;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTPropertyChangeEvent;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.swing.KDFormattedTextField;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.basedata.assistant.MeasureUnitInfo;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.master.material.MultiMeasureUnitFactory;
import com.kingdee.eas.basedata.master.material.MultiMeasureUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.qm.common.cache.IQMCacheManager;
import com.kingdee.eas.qm.common.client.action.AbstractUIContextAction;
import com.kingdee.eas.qm.common.client.action.IUIContextAction;
import com.kingdee.eas.qm.common.util.QMConstant;
import com.kingdee.eas.qm.qc.client.QCRequestEditUI;
import com.kingdee.eas.scm.common.util.PrecisionUtil;
import java.math.BigDecimal;
import javax.swing.JTextField;

public class RequestKDTableUnitAction
extends AbstractUIContextAction
implements IUIContextAction {
    private KDTable kdtEntrys;
    String colName;

    public RequestKDTableUnitAction(QCRequestEditUI owner, KDTable kdtEntrys) {
        this.kdtEntrys = kdtEntrys;
    }

    public void changeUIContext(CoreUIObject owner, Context context) throws EASBizException, BOSException {
        QCRequestEditUI editUI = (QCRequestEditUI)owner;
        KDTPropertyChangeEvent event = (KDTPropertyChangeEvent)context.get((Object)"event");
        if (event.getColIndex() == this.kdtEntrys.getColumnIndex("unit")) {
            MeasureUnitInfo unit = (MeasureUnitInfo)context.get((Object)"NewValue");
            IRow row = this.kdtEntrys.getRow(event.getRowIndex());
            MaterialInfo material = (MaterialInfo)row.getCell("material").getValue();
            int qtyPrecision = 6;
            BigDecimal baseQty = (BigDecimal)row.getCell("baseDdeliverQty").getValue();
            BigDecimal rate = null;
            if (material != null && unit != null) {
                IQMCacheManager cache = editUI.getCacheManager();
                MultiMeasureUnitInfo multiUnit = null;
                String key = material.getId().toString() + unit.getId().toString();
                if (cache.get((Object)key) != null) {
                    multiUnit = (MultiMeasureUnitInfo)cache.get((Object)key);
                } else {
                    multiUnit = MultiMeasureUnitFactory.getRemoteInstance().getMultiUnit(material.getId().toString(), unit.getId().toString());
                    cache.put((Object)key, (Object)multiUnit);
                }
                qtyPrecision = multiUnit.getQtyPrecision();
                rate = multiUnit.getBaseConvsRate();
                unit.setBigDecimal("rate", rate);
                unit.setInt("precision", qtyPrecision);
            } else if (material == null && unit != null) {
                qtyPrecision = unit.getQtyPrecision();
            }
            KDFormattedTextField textDeliverQty = new KDFormattedTextField();
            textDeliverQty.setName("kdtEntrys_deliverQty_TextField");
            textDeliverQty.setHorizontalAlignment(4);
            textDeliverQty.setDataType(1);
            textDeliverQty.setMinimumValue((Comparable)QMConstant.ZERO);
            textDeliverQty.setMaximumValue((Comparable)QMConstant.MAX_VALUE);
            textDeliverQty.setPrecision(qtyPrecision);
            KDTDefaultCellEditor editorDeliverQty = new KDTDefaultCellEditor((JTextField)textDeliverQty);
            row.getCell("deliverQty").setEditor((ICellEditor)editorDeliverQty);
            String fmt = PrecisionUtil.getFormatString((int)qtyPrecision);
            row.getCell("deliverQty").getStyleAttributes().setNumberFormat(fmt);
            if (!this.isloading(owner)) {
                if (baseQty != null && rate != null) {
                    BigDecimal value = baseQty.divide(rate, qtyPrecision, 4);
                    row.getCell("deliverQty").setValue((Object)value);
                } else if (baseQty != null && rate == null) {
                    BigDecimal value = baseQty.setScale(qtyPrecision, 4);
                    row.getCell("deliverQty").setValue((Object)value);
                } else if (row.getCell("deliverQty").getValue() != null) {
                    BigDecimal value = (BigDecimal)row.getCell("deliverQty").getValue();
                    value = value.setScale(qtyPrecision, 4);
                    row.getCell("deliverQty").setValue((Object)value);
                }
            }
        } else if (event.getColIndex() == this.kdtEntrys.getColumnIndex("deliverQty")) {
            BigDecimal dlvqty = (BigDecimal)context.get((Object)"NewValue");
            if (dlvqty == null) {
                dlvqty = new BigDecimal("0");
            }
            IRow row = this.kdtEntrys.getRow(event.getRowIndex());
            MeasureUnitInfo unit = (MeasureUnitInfo)row.getCell("unit").getValue();
            if (!this.isloading(owner) && unit != null) {
                BigDecimal rate = unit.getBigDecimal("rate");
                int qtyPrecision = unit.getInt("precision");
                if (rate == null) {
                    rate = QMConstant.ONE;
                }
                BigDecimal baseDlvQty = dlvqty.multiply(rate);
                row.getCell("baseDdeliverQty").setValue((Object)baseDlvQty);
            }
        }
    }
}

