/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.qm.qc.client.util;

import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.swing.KDTextField;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIException;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.framework.client.EditUI;
import com.kingdee.eas.qm.qc.QCBillInfo;
import com.kingdee.eas.qm.qc.QCBillSampleEntryInfo;
import com.kingdee.eas.qm.qc.QCMMPatrolReportInfo;
import com.kingdee.eas.qm.qc.QCRejectProcessInfo;
import com.kingdee.eas.qm.qc.QCReportInfo;
import com.kingdee.eas.qm.qc.client.QCBillEditUI;
import com.kingdee.eas.qm.qc.client.QCBillEntryEditUI;
import com.kingdee.eas.qm.qc.client.QCMMPatrolReportEditUI;
import com.kingdee.eas.qm.qc.client.QCMMPatrolReportEntryEditUI;
import com.kingdee.eas.qm.qc.client.QCRejectProcessEditUI;
import com.kingdee.eas.qm.qc.client.QCReportEditUI;
import com.kingdee.eas.qm.qc.client.QCReportEntryEditUI;
import com.kingdee.eas.qm.qc.client.util.qcbill.QCBillResourceUtil;
import com.kingdee.eas.util.AbortException;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.BaseException;
import java.awt.Component;
import java.util.Map;
import org.apache.log4j.Logger;

public class QCItemEntryEditUIHelper {
    private static final Logger logger = CoreUIObject.getLogger(QCItemEntryEditUIHelper.class);

    public static void showEntryEditUI(Object ownerUI, Object rowInfoCollection, Object curRowInfo) {
        CoreUI ui = (CoreUI)ownerUI;
        QCItemEntryEditUIHelper.showQCDetailUI(ui, curRowInfo, rowInfoCollection);
    }

    private static void showQCDetailUI(CoreUI owner, Object curRowInfo, Object rowInfoCollection) {
        try {
            IUIWindow ui = QCItemEntryEditUIHelper.createQCDetailUI(owner, curRowInfo, rowInfoCollection);
            if (ui != null) {
                ui.show();
            }
        }
        catch (BaseException e) {
            logger.error((Object)e);
            String string = QCBillResourceUtil.getMsg("Error_ShowEntryEditUIError");
            MsgBox.showDetailAndOK((Component)owner, (String)string, (String)e.getMessage(), (int)1);
            return;
        }
        catch (AbortException e1) {
            logger.error((Object)e1);
        }
    }

    private static IUIWindow createQCDetailUI(CoreUI owner, Object curRowInfo, Object rowInfoCollection) throws UIException {
        UIContext context = new UIContext((Object)owner);
        context.put((Object)"InitDataObject", curRowInfo);
        context.put((Object)"Context_RowInfoCollection", rowInfoCollection);
        String winClassName = QCReportEntryEditUI.class.getName();
        if (owner instanceof QCBillEditUI) {
            winClassName = QCBillEntryEditUI.class.getName();
        } else if (owner instanceof QCMMPatrolReportEditUI) {
            winClassName = QCMMPatrolReportEntryEditUI.class.getName();
        }
        IUIWindow uiWin = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(winClassName, (Map)context);
        return uiWin;
    }

    public static void initHead(EditUI editUI, KDTextField txtMaterialNumber, KDTextField txtMaterialName, KDBizPromptBox prmtQCStandard, KDTextField txtSampleNumber, KDTextField txtSampleDesc) {
        QCMMPatrolReportInfo info;
        if (editUI == null) {
            return;
        }
        if (editUI instanceof QCBillEditUI) {
            QCBillSampleEntryInfo currSampleInfo;
            QCBillInfo info2 = (QCBillInfo)editUI.getDataObject();
            if (info2 != null) {
                MaterialInfo material = info2.getMaterial();
                if (material != null) {
                    txtMaterialNumber.setText(material.getNumber());
                    txtMaterialName.setText(material.getName());
                }
                prmtQCStandard.setValue((Object)info2.getQcStandard());
            }
            if ((currSampleInfo = ((QCBillEditUI)editUI).getCurrSampleInfo()) != null) {
                txtSampleNumber.setText(currSampleInfo.getNumber());
                txtSampleDesc.setText(currSampleInfo.getSampleDes());
            }
        } else if (editUI instanceof QCReportEditUI) {
            QCReportInfo info3 = (QCReportInfo)editUI.getDataObject();
            if (info3 != null) {
                MaterialInfo material = info3.getMaterial();
                if (material != null) {
                    txtMaterialNumber.setText(material.getNumber());
                    txtMaterialName.setText(material.getName());
                }
                prmtQCStandard.setValue((Object)info3.getQCStandard());
            }
        } else if (editUI instanceof QCRejectProcessEditUI) {
            QCRejectProcessInfo info4 = (QCRejectProcessInfo)editUI.getDataObject();
            if (null != info4) {
                MaterialInfo material = info4.getMaterial();
                if (null != material) {
                    txtMaterialNumber.setText(material.getNumber());
                    txtMaterialName.setText(material.getName());
                }
                prmtQCStandard.setValue((Object)info4.getQcStandard());
            }
        } else if (editUI instanceof QCMMPatrolReportEditUI && (info = (QCMMPatrolReportInfo)editUI.getDataObject()) != null) {
            MaterialInfo material = info.getMaterial();
            if (material != null) {
                txtMaterialNumber.setText(material.getNumber());
                txtMaterialName.setText(material.getName());
            }
            prmtQCStandard.setValue((Object)info.getQCStandard());
        }
    }

    public static SelectorItemCollection getHeadAndEntrySelectors() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("delegOrgUnit.*"));
        sic.add(new SelectorItemInfo("qCValueType"));
        sic.add(new SelectorItemInfo("qCGroup.*"));
        sic.add(new SelectorItemInfo("checker.*"));
        sic.add(new SelectorItemInfo("qCInstrumentGroup.*"));
        sic.add(new SelectorItemInfo("qCInstrument.*"));
        sic.add(new SelectorItemInfo("qCItem.*"));
        sic.add(new SelectorItemInfo("sampleEntry.*"));
        sic.add(new SelectorItemInfo("sampleEntry.unit.*"));
        return sic;
    }
}

