/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.qm.qc.client.util;

import com.kingdee.bos.ctrl.extendcontrols.BizDataFormat;
import com.kingdee.bos.ctrl.extendcontrols.IDataFormat;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.kdf.util.render.IBasicRender;
import com.kingdee.bos.ctrl.kdf.util.render.ObjectValueRender;
import com.kingdee.bos.ctrl.swing.IKDEditor;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDFormattedTextField;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.ctrl.swing.KDTextField;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.dao.query.SQLExecutorFactory;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.qm.basedata.QCItemInfo;
import com.kingdee.eas.qm.basedata.QCSamplingProgramInfo;
import com.kingdee.eas.qm.basedata.QCValueTypeEnum;
import com.kingdee.eas.qm.basedata.client.util.QCStandardClientUtils;
import com.kingdee.eas.qm.common.util.QMPrecisionUtil;
import com.kingdee.eas.qm.common.util.backup.QMHelper;
import com.kingdee.eas.qm.qc.QCItemBaseInfo;
import com.kingdee.eas.qm.qc.QCReinspectReqEntryFactory;
import com.kingdee.eas.qm.qc.QCRequestQcItemEntryFactory;
import com.kingdee.eas.qm.qc.QCSampleItemEntryInfo;
import com.kingdee.eas.qm.qc.client.QCSampleEditUI;
import com.kingdee.jdbc.rowset.IRowSet;
import java.awt.Rectangle;
import java.math.BigDecimal;
import javax.swing.JComboBox;
import javax.swing.JTextField;
import org.apache.log4j.Logger;

public class QCSampleEditUIHelper {
    private static final Logger logger = CoreUIObject.getLogger(QCSampleEditUIHelper.class);

    public static void initTableTxtLength(KDTable kdtEntrys) {
        kdtEntrys.getColumn("number").setEditor((ICellEditor)QCSampleEditUIHelper.createTxtField(80));
        kdtEntrys.getColumn("sampleDes").setEditor((ICellEditor)QCSampleEditUIHelper.createTxtField(80));
        kdtEntrys.getColumn("sampleClaim").setEditor((ICellEditor)QCSampleEditUIHelper.createTxtField(80));
        kdtEntrys.getColumn("sampleAddress").setEditor((ICellEditor)QCSampleEditUIHelper.createTxtField(100));
        kdtEntrys.getColumn("depPosition").setEditor((ICellEditor)QCSampleEditUIHelper.createTxtField(80));
        kdtEntrys.getColumn("remark").setEditor((ICellEditor)QCSampleEditUIHelper.createTxtField(255));
    }

    private static KDTDefaultCellEditor createTxtField(int length) {
        KDTextField txtField = new KDTextField();
        txtField.setMaxLength(length);
        return new KDTDefaultCellEditor((JTextField)txtField);
    }

    public static void initTableF7(KDTable kdtEntrys, KDTable kdtItemEntries) {
        QCSampleEditUIHelper.updateF7(kdtEntrys, "com.kingdee.eas.qm.basedata.app.F7SampleStatusQuery", "sampleStatus");
        QCSampleEditUIHelper.createNewF7(kdtItemEntries, "com.kingdee.eas.qm.common.app.F7QualityOrgUnitQuery", "delegOrgUnit");
        QCSampleEditUIHelper.createNewF7(kdtItemEntries, "com.kingdee.eas.basedata.assistant.app.F7MeasureUnitQuery", "unit");
        EntityViewInfo v = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        KDBizPromptBox prmtDelegOrgUnit = (KDBizPromptBox)kdtItemEntries.getColumn("delegOrgUnit").getEditor().getComponent();
        filter.appendFilterItem("isbizunit", (Object)"1");
        v.setFilter(filter);
        prmtDelegOrgUnit.setEntityViewInfo(v);
        QCSampleEditUIHelper.createNewF7(kdtItemEntries, "com.kingdee.eas.qm.basedata.app.F7QCGroupQuery", "qCGroup");
        QCSampleEditUIHelper.createNewF7(kdtItemEntries, "com.kingdee.eas.qm.basedata.app.F7qCInstrumentGroupQuery", "qCInstrumentGroup");
        QCSampleEditUIHelper.updateF7(kdtItemEntries, "com.kingdee.eas.qm.basedata.app.F7QCModifyModeQuery", "qCModifyMode");
    }

    private static KDBizPromptBox createNewF7(KDTable kdt, String f7query, String colKey) {
        KDBizPromptBox prmt = new KDBizPromptBox();
        prmt.setCommitFormat("$number$;$name$");
        prmt.setEditFormat("$number$");
        prmt.setDisplayFormat("$number$");
        prmt.setQueryInfo(f7query);
        prmt.setRequired(true);
        prmt.setEditable(true);
        prmt.setVisible(true);
        prmt.setEnabled(true);
        kdt.getColumn(colKey).setEditor((ICellEditor)new KDTDefaultCellEditor((IKDEditor)prmt));
        ObjectValueRender ovr = new ObjectValueRender();
        ovr.setFormat((IDataFormat)new BizDataFormat("$name$"));
        kdt.getColumn(colKey).setRenderer((IBasicRender)ovr);
        return prmt;
    }

    private static void updateF7(KDTable kdt, String f7query, String colKey) {
        EntityViewInfo v = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        KDBizPromptBox prmt = (KDBizPromptBox)kdt.getColumn(colKey).getEditor().getComponent();
        filter.appendFilterItem("CHECKEDSTATUS", (Object)String.valueOf(2));
        v.setFilter(filter);
        prmt.setQueryInfo(f7query);
        prmt.setEntityViewInfo(v);
    }

    public static void createQCItemF7(QCSampleEditUI qcSampleEditUI, KDTable kdtItemEntries, boolean isFromQCRequest, String sourceID) {
        KDBizPromptBox prmt = QCSampleEditUIHelper.createNewF7(kdtItemEntries, "com.kingdee.eas.qm.basedata.app.F7QCItemQuery", "qCItem");
        ObjectValueRender ovr = new ObjectValueRender();
        ovr.setFormat((IDataFormat)new BizDataFormat("$number$"));
        kdtItemEntries.getColumn("qCItem").setRenderer((IBasicRender)ovr);
        if (sourceID == null) {
            return;
        }
        EntityViewInfo v = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        StringBuffer sql = new StringBuffer("select ItemEntry.FQCITEMID from ");
        if (isFromQCRequest) {
            sql.append("T_QM_QCRequestQcItemEntry ItemEntry where exists ").append("(select 1 from t_Qm_Qcrequestentry sampleEntry,").append("t_Qm_Qcstandarditementries standardItem ").append("where ItemEntry.fentryid = sampleEntry.fid ").append("and standardItem.Fparentid = sampleEntry.Fqcstandardid ").append("and standardItem.Fitemtype = 0 ").append("and ItemEntry.Fentryid = '");
        } else {
            sql.append("t_qm_qcreinspectreqentry  ItemEntry where exists ").append("(select 1 from t_Qm_Qcreinspectreq qcrein,").append("t_Qm_Qcstandarditementries standardItem ").append("where ItemEntry.Fparentid = qcrein.fid ").append("and standardItem.Fparentid = qcrein.Fqcstandardid ").append("and standardItem.Fitemtype = 0 ").append(" and ItemEntry.Fparentid = '");
        }
        sql.append(sourceID).append("')");
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)sql.toString(), CompareType.INNER));
        filter.getFilterItems().add(new FilterItemInfo("deletedStatus", (Object)new Integer(1), CompareType.EQUALS));
        v.setFilter(filter);
        prmt.setEntityViewInfo(v);
        SelectorItemCollection itemCols = new SelectorItemCollection();
        itemCols.add(new SelectorItemInfo("*"));
        itemCols.add(new SelectorItemInfo("group.*"));
        prmt.setSelectorCollection(itemCols);
        prmt.setF7Context(qcSampleEditUI.getMainOrgContext());
    }

    public static QCSampleItemEntryInfo getQCItemBaseInfo(String qCItemID, boolean isFromQCRequest, String sourceID) {
        if (sourceID == null) {
            return new QCSampleItemEntryInfo();
        }
        String itemEntryID = null;
        StringBuffer sql = new StringBuffer("select FID from ");
        if (isFromQCRequest) {
            sql.append("T_QM_QCRequestQcItemEntry where FENTRYID='");
        } else {
            sql.append("t_qm_qcreinspectreqentry where FPARENTID='");
        }
        sql.append(sourceID).append("' and FQCITEMID='").append(qCItemID).append("'");
        try {
            IRowSet rs = SQLExecutorFactory.getRemoteInstance((String)sql.toString()).executeSQL();
            if (rs.next()) {
                itemEntryID = rs.getString("FID");
            }
        }
        catch (Exception e1) {
            logger.error((Object)e1);
        }
        QCItemBaseInfo itemBaseInfo = null;
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("*"));
        selector.add(new SelectorItemInfo("qCItem.*"));
        selector.add(new SelectorItemInfo("qCItem.group.longNumber"));
        selector.add(new SelectorItemInfo("qCInstrumentGroup.*"));
        selector.add(new SelectorItemInfo("qCInstrument.*"));
        selector.add(new SelectorItemInfo("delegOrgUnit.*"));
        selector.add(new SelectorItemInfo("qCGroup.*"));
        selector.add(new SelectorItemInfo("qCMethod.*"));
        selector.add(new SelectorItemInfo("qCFrequency.*"));
        selector.add(new SelectorItemInfo("qCModifyMode.*"));
        selector.add(new SelectorItemInfo("unit.*"));
        selector.add(new SelectorItemInfo("sampleProgram.id"));
        selector.add(new SelectorItemInfo("sampleProgram.number"));
        selector.add(new SelectorItemInfo("sampleProgram.name"));
        selector.add(new SelectorItemInfo("sampleShares"));
        selector.add(new SelectorItemInfo("acValue"));
        selector.add(new SelectorItemInfo("reValue"));
        try {
            itemBaseInfo = isFromQCRequest ? QCRequestQcItemEntryFactory.getRemoteInstance().getQCRequestQcItemEntryInfo((IObjectPK)new ObjectStringPK(itemEntryID), selector) : QCReinspectReqEntryFactory.getRemoteInstance().getQCReinspectReqEntryInfo((IObjectPK)new ObjectStringPK(itemEntryID), selector);
        }
        catch (Exception e1) {
            logger.error((Object)e1);
        }
        return QCSampleEditUIHelper.changeToBaseInfo(itemBaseInfo, isFromQCRequest);
    }

    protected static QCSampleItemEntryInfo changeToBaseInfo(QCItemBaseInfo sourceInfo, boolean isFromQCRequest) {
        QCSampleItemEntryInfo samInfo = new QCSampleItemEntryInfo();
        if (sourceInfo == null) {
            return samInfo;
        }
        samInfo.setQCItem(sourceInfo.getQCItem());
        samInfo.setCheckStep(sourceInfo.getCheckStep());
        samInfo.setStandardRequirement(sourceInfo.getStandardRequirement());
        samInfo.setIsKeyItem(sourceInfo.isIsKeyItem());
        samInfo.setIsMustCheck(sourceInfo.isIsMustCheck());
        samInfo.setQCFrequency(sourceInfo.getQCFrequency());
        samInfo.setQCMethod(sourceInfo.getQCMethod());
        samInfo.setJudgeType(sourceInfo.getJudgeType());
        samInfo.setLowerLimit(sourceInfo.getLowerLimit());
        samInfo.setLower(sourceInfo.getLower());
        samInfo.setUpperLimit(sourceInfo.getUpperLimit());
        samInfo.setUpper(sourceInfo.getUpper());
        samInfo.setDefaultValue(sourceInfo.getDefaultValue());
        samInfo.setDelegOrgUnit(sourceInfo.getDelegOrgUnit());
        samInfo.setQCGroup(sourceInfo.getQCGroup());
        samInfo.setQCInstrumentGroup(sourceInfo.getQCInstrumentGroup());
        samInfo.setQCInstrument(sourceInfo.getQCInstrument());
        samInfo.setQCModifyMode(sourceInfo.getQCModifyMode());
        samInfo.setRemark(sourceInfo.getRemark());
        samInfo.setAnalysisMethod(sourceInfo.getAnalysisMethod());
        samInfo.setQCItemAttr(sourceInfo.getQCItemAttr());
        samInfo.setQCValueType(sourceInfo.getQCValueType());
        samInfo.setEnums(sourceInfo.getEnums());
        samInfo.setDataPrecision(sourceInfo.getDataPrecision());
        samInfo.setUnit(sourceInfo.getUnit());
        samInfo.setIsBalanceItem(sourceInfo.isIsBalanceItem());
        samInfo.setIsRuinous(sourceInfo.isIsRuinous());
        samInfo.setExpression(sourceInfo.getExpression());
        samInfo.setQCValueAcquisitionMode(sourceInfo.getQCValueAcquisitionMode());
        samInfo.setSampleProgram(sourceInfo.getSampleProgram());
        samInfo.setSampleShares(sourceInfo.getSampleShares());
        samInfo.setAcValue(sourceInfo.getAcValue());
        samInfo.setReValue(sourceInfo.getReValue());
        return samInfo;
    }

    public static void setHeadPanelOriginalBounds(KDPanel[] ps) {
        for (int i = 0; i < ps.length; ++i) {
            ps[i].putClientProperty((Object)"OriginalBounds", (Object)new Rectangle(0, 0, 870, 120));
        }
    }

    public static void formatItemEntryCell(KDTable table, int rowIndex) {
        IRow row = table.getRow(rowIndex);
        QCItemInfo qCItemInfo = (QCItemInfo)row.getCell("qCItem").getValue();
        if (qCItemInfo == null) {
            row.getCell("qCItem").getStyleAttributes().setLocked(false);
        } else {
            if (QCValueTypeEnum.formula.equals((Object)qCItemInfo.getQCValueType())) {
                row.getCell("defaultValue").getStyleAttributes().setLocked(true);
                QCSampleEditUIHelper.setItemEntryPrecision(table, rowIndex, false);
            } else if (QCValueTypeEnum.number.equals((Object)qCItemInfo.getQCValueType())) {
                QCSampleEditUIHelper.setItemEntryPrecision(table, rowIndex, true);
            } else {
                row.getCell("lowerLimit").getStyleAttributes().setLocked(true);
                row.getCell("lower").getStyleAttributes().setLocked(true);
                row.getCell("upperLimit").getStyleAttributes().setLocked(true);
                row.getCell("upper").getStyleAttributes().setLocked(true);
                if (QCValueTypeEnum.enumvalue.equals((Object)qCItemInfo.getQCValueType()) && !QMHelper.isEmpty((String)qCItemInfo.getEnums())) {
                    KDComboBox cbodefaultValue = new KDComboBox();
                    Object[] list = QMHelper.parseEnumString((String)qCItemInfo.getEnums());
                    cbodefaultValue.removeAllItems();
                    cbodefaultValue.addItems(list);
                    cbodefaultValue.setSelectedItem((Object)qCItemInfo.getDefaultValue());
                    row.getCell("defaultValue").setEditor((ICellEditor)new KDTDefaultCellEditor((JComboBox)cbodefaultValue));
                }
                if (QCValueTypeEnum.text.equals((Object)qCItemInfo.getQCValueType())) {
                    KDTextField txtBox = new KDTextField();
                    txtBox.setMaxLength(255);
                    KDTDefaultCellEditor editor = new KDTDefaultCellEditor((JTextField)txtBox);
                    row.getCell("defaultValue").setEditor((ICellEditor)editor);
                }
            }
            ICell cell = row.getCell("sampleProgram");
            QCSamplingProgramInfo qCSamplingProgramInfo = (QCSamplingProgramInfo)cell.getValue();
            if (qCSamplingProgramInfo != null) {
                row.getCell("sampleShares").getStyleAttributes().setLocked(true);
            }
        }
    }

    public static void setItemEntryPrecision(KDTable table, int rowIndex, boolean containDefaultValue) {
        int dataPrecision = QCStandardClientUtils.getRowCheckValuePrecision((KDTable)table, (int)rowIndex, (String)"qCModifyMode", (String)"dataPrecision", (String)"unit");
        if (dataPrecision < 0) {
            dataPrecision = 0;
        }
        IRow row = table.getRow(rowIndex);
        String[] cols = QCSampleEditUIHelper.getItemEntryPrecisionCols(containDefaultValue);
        for (int i = 0; i < cols.length; ++i) {
            if (row.getCell(cols[i]) == null) continue;
            row.getCell(cols[i]).setEditor((ICellEditor)new KDTDefaultCellEditor((JTextField)QCSampleEditUIHelper.getBigDecimalTextField(dataPrecision, null)));
            row.getCell(cols[i]).getStyleAttributes().setNumberFormat(QMPrecisionUtil.getFormatString((int)dataPrecision));
        }
    }

    public static KDFormattedTextField getBigDecimalTextField(int precision, BigDecimal maxValue) {
        KDFormattedTextField colTxtField = new KDFormattedTextField();
        colTxtField.setDataType(1);
        colTxtField.setPrecision(precision);
        colTxtField.setHorizontalAlignment(4);
        colTxtField.setSupportedEmpty(true);
        colTxtField.setRemoveingZeroInDispaly(false);
        colTxtField.setMinimumValue((Comparable)QMPrecisionUtil.BigDecimal_MinValue);
        if (maxValue != null) {
            colTxtField.setMaximumValue((Comparable)maxValue);
        } else {
            colTxtField.setMaximumValue((Comparable)QMPrecisionUtil.BigDecimal_MaxValue);
        }
        return colTxtField;
    }

    protected static String[] getItemEntryPrecisionCols(boolean containDefaultValue) {
        if (containDefaultValue) {
            return new String[]{"lower", "upper", "defaultValue"};
        }
        return new String[]{"lower", "upper"};
    }
}

