/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.qm.qc.client.util;

import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDFormattedTextField;
import com.kingdee.eas.qm.common.client.util.QMClientVerifyUtils;
import com.kingdee.eas.qm.common.util.QMConstant;
import com.kingdee.util.StringUtils;
import com.kingdee.util.TypeConversionUtils;
import java.awt.Component;
import java.awt.Container;
import java.math.BigDecimal;
import java.util.Set;

public class QCUIUtil {
    public static final String PK_DateTime_DefaultPattern = "yyyy-MM-dd HH:mm:ss";
    public static final BigDecimal MAX_QCVALUE = new BigDecimal("2147483647.00000000");
    public static final BigDecimal MIN_QCVALUE = new BigDecimal("-2147483648.00000000");

    public static BigDecimal getBigDecimalValueFromCell(ICell cell) {
        if (cell == null || cell.getValue() == null) {
            return null;
        }
        Object value = cell.getValue();
        BigDecimal bd = TypeConversionUtils.objToBigDecimal((Object)value);
        return bd;
    }

    public static void setControlEnableStatus(Component[] components, boolean b) {
        for (int i = 0; i < components.length; ++i) {
            components[i].setEnabled(b);
        }
    }

    public static void setAllControlEnabled(Container ui, boolean canEdit) {
        if (!canEdit) {
            Set allComponents = QMClientVerifyUtils.getAllComponents((Container)ui);
            for (Component c : allComponents) {
                c.setEnabled(false);
            }
        }
    }

    public static void setInputPositiveInt(KDFormattedTextField[] fields) {
        for (int i = 0; i < fields.length; ++i) {
            fields[i].setDataType(0);
            fields[i].setMaximumValue((Comparable)new BigDecimal(Integer.MAX_VALUE));
            fields[i].setMinimumValue((Comparable)QMConstant.ZERO);
            fields[i].setHorizontalAlignment(4);
        }
    }

    public static void setInputBigDecimal(KDFormattedTextField[] fields) {
        for (int i = 0; i < fields.length; ++i) {
            fields[i].setMaximumValue((Comparable)new BigDecimal("9999999999999.99999999"));
            fields[i].setMinimumValue((Comparable)new BigDecimal("-9999999999999.99999999"));
            fields[i].setHorizontalAlignment(4);
        }
    }

    public static KDFormattedTextField getBigDecimalField() {
        KDFormattedTextField field = new KDFormattedTextField();
        field.setMaximumValue((Comparable)new BigDecimal("9999999999999.99999999"));
        field.setMinimumValue((Comparable)new BigDecimal("-9999999999999.99999999"));
        field.setDataType(1);
        return field;
    }

    public static void setCommitBeforeClose(KDFormattedTextField[] fields) {
        for (int i = 0; i < fields.length; ++i) {
            fields[i].setSupportedEmpty(true);
            fields[i].setDataVerifierType(12);
            fields[i].setCommitsOnValidEdit(true);
        }
    }

    public static int getIndexOfCmbList(KDComboBox cmb, String value) {
        if (StringUtils.isEmpty((String)value)) {
            return -1;
        }
        int cnt = cmb.getItemCount();
        for (int i = 0; i < cnt; ++i) {
            if (cmb.getItemAt(i) == null || !cmb.getItemAt(i).equals(value)) continue;
            return i;
        }
        return -1;
    }
}

