/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.qm.qc.client.util.qcreport;

import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.swing.KDLabelContainer;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.kscript.dom.stmt.CodeStmt;
import com.kingdee.bos.kscript.dom.stmt.VarDeclItem;
import com.kingdee.bos.kscript.dom.stmt.VarDeclStmt;
import com.kingdee.bos.kscript.parser.KScriptParser;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.eas.common.SysConstant;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.qm.basedata.EvaluateModeEnum;
import com.kingdee.eas.qm.basedata.QCIdentityEnum;
import com.kingdee.eas.qm.basedata.QCItemInfo;
import com.kingdee.eas.qm.basedata.QCModifyModeInfo;
import com.kingdee.eas.qm.basedata.QCSamplingProgramFactory;
import com.kingdee.eas.qm.basedata.QCSamplingProgramInfo;
import com.kingdee.eas.qm.basedata.QCValueAcquisitionModeEnum;
import com.kingdee.eas.qm.basedata.QCValueTypeEnum;
import com.kingdee.eas.qm.basedata.client.util.QCStandardClientUtils;
import com.kingdee.eas.qm.basedata.formula.utils.QMFormulaUtils;
import com.kingdee.eas.qm.basedata.util.QCModifyModeHelper;
import com.kingdee.eas.qm.common.util.KDTableUtils;
import com.kingdee.eas.qm.common.util.QMConstant;
import com.kingdee.eas.qm.common.util.QMSelectorUtils;
import com.kingdee.eas.qm.qc.QCReportException;
import com.kingdee.eas.qm.qc.client.util.qcreport.QCMMPatrolReportEditUIF7FilterHelper;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.Rectangle;
import java.math.BigDecimal;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JComponent;
import org.apache.log4j.Logger;

public class QCMMPatrolReportEditUIHelper {
    private static Logger logger = Logger.getLogger(QCMMPatrolReportEditUIHelper.class);
    public static final String resPath = "com.kingdee.eas.qm.qc.QCMMPatrolReportResource";
    public static final String[] unLockCols_NotPurCon_ParamOpen = new String[]{"remark", "isMustCheck", "isKeyItem", "checkValue", "checkResult", "qCDescription", "delegateQualityOrg", "qCGroup", "checker", "qCInstrumentGroup", "qCInstrument", "sampleNumber", "seqNo", "checkTime", "judgeType", "upperLimit", "upper", "lower", "lowerLimit"};
    public static final String[] unLockCols_NotPurCon_ParamClose = new String[]{"remark", "isMustCheck", "isKeyItem", "checkValue", "checkResult", "qCDescription", "delegateQualityOrg", "qCGroup", "checker", "qCInstrumentGroup", "qCInstrument", "sampleNumber", "seqNo", "checkTime"};

    public static String getMsg(String key, Object[] objs) {
        String msg = EASResource.getString((String)resPath, (String)key);
        if (objs != null && objs.length > 0) {
            msg = MessageFormat.format(msg, objs);
        }
        return msg;
    }

    public static SelectorItemCollection getSelectorForQCReport() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        QMSelectorUtils.addSelectorWithIDAndNumberAndName((SelectorItemCollection)sic, (String[])new String[]{"qCGroup", "checker", "material", "qualityOrgUnit", "sourceBillType", "creator", "lastUpdateUser", "auditor", "device", "person", "productDept", "productLine", "classGroup", "classTeam", "standardRooting", "formulaNum"});
        sic.add(new SelectorItemInfo("routingInspectionPlan.*"));
        sic.add(new SelectorItemInfo("routingInspectionPlan.entrys.*"));
        QMSelectorUtils.addSelectorWithPros((SelectorItemCollection)sic, (String)"qCStandard", (String[])new String[]{"id", "name", "number", "isRI", "sampleSolution"});
        sic.add(new SelectorItemInfo("qCStandard.itemEntries.*"));
        QMSelectorUtils.addSelectorWithPros((SelectorItemCollection)sic, (String[])new String[]{"billType", "unit"}, (String[])new String[]{"*"});
        QMSelectorUtils.addSelectorWithPros((SelectorItemCollection)sic, (String)"entrys", (String[])new String[]{"*"});
        QMSelectorUtils.addSelectorWithPros((SelectorItemCollection)sic, (String[])new String[]{"entrys.qCItem", "entrys.qCItem.group", "entrys.qCModifyMode", "entrys.unit"}, (String[])new String[]{"*"});
        QMSelectorUtils.addSelectorWithIDAndNumberAndName((SelectorItemCollection)sic, (String[])new String[]{"entrys.qCGroup", "entrys.checker", "entrys.delegOrgUnit", "entrys.qCInstrumentGroup", "entrys.qCInstrument", "entrys.sourceBillType", "entrys.qCFrequency", "entrys.qCMethod", "entrys.sampleProgram"});
        sic.add("entrys.sampleProgram.evaluationMode");
        QMSelectorUtils.addSelectorWithPros((SelectorItemCollection)sic, (String)"nCPPREntries", (String[])new String[]{"*"});
        QMSelectorUtils.addSelectorWithIDAndNumberAndName((SelectorItemCollection)sic, (String[])new String[]{"nCPPREntries.material", "nCPPREntries.dPProcessMode", "nCPPREntries.unit", "nCPPREntries.sourceBillType"});
        return sic;
    }

    public static void setHeadPanelOriginalBounds(KDPanel[] ps) {
        for (int i = 0; i < ps.length; ++i) {
            ps[i].putClientProperty((Object)"OriginalBounds", (Object)new Rectangle(0, 0, 870, 120));
        }
    }

    public static void controlItemEntryOfPatrolReport(CoreUI ui, KDTable kdtItemEntries, int rowIndex, Map params) throws Exception {
        boolean canEditItemEntry = (Boolean)params.get("CanEditItemEntry");
        IRow row = kdtItemEntries.getRow(rowIndex);
        String[] unLockCols = null;
        unLockCols = canEditItemEntry ? unLockCols_NotPurCon_ParamOpen : unLockCols_NotPurCon_ParamClose;
        KDTableUtils.setUnLockColumn((KDTable)kdtItemEntries, (int)rowIndex, (String[])unLockCols);
        QCMMPatrolReportEditUIHelper.setRowLockByQuantitativeAnalysis(kdtItemEntries, rowIndex);
        KDTableUtils.registerComboBoxToColumn((KDTable)kdtItemEntries, (String)"checkResult", (String)"com.kingdee.eas.qm.qc.QCResultJudgeEnum");
        if (kdtItemEntries.getCell(rowIndex, "sampleProgram").getValue() != null) {
            kdtItemEntries.getCell(rowIndex, "sampleShares").getStyleAttributes().setLocked(false);
        } else {
            kdtItemEntries.getCell(rowIndex, "sampleShares").getStyleAttributes().setLocked(true);
        }
        kdtItemEntries.getCell(rowIndex, "passShares").getStyleAttributes().setLocked(false);
        kdtItemEntries.getCell(rowIndex, "unPassShares").getStyleAttributes().setLocked(false);
        QCSamplingProgramInfo samProInfo = (QCSamplingProgramInfo)row.getCell("sampleProgram").getValue();
        QCValueAcquisitionModeEnum qcvamodeValue = (QCValueAcquisitionModeEnum)kdtItemEntries.getCell(rowIndex, "qCValueAcquisitionMode").getValue();
        if (qcvamodeValue != null && QCValueAcquisitionModeEnum.BYSAMPLEQTY.equals((Object)qcvamodeValue)) {
            kdtItemEntries.getCell(rowIndex, "defectQty").getStyleAttributes().setLocked(true);
            kdtItemEntries.getCell(rowIndex, "sampleShares").getStyleAttributes().setLocked(true);
            kdtItemEntries.getCell(rowIndex, "passShares").getStyleAttributes().setLocked(true);
            kdtItemEntries.getCell(rowIndex, "unPassShares").getStyleAttributes().setLocked(true);
        } else {
            QCItemInfo itemInfo = (QCItemInfo)kdtItemEntries.getCell(rowIndex, "qcItemNumber").getValue();
            if (itemInfo != null && itemInfo.getQCIdentity() != null && QCIdentityEnum.point.equals((Object)itemInfo.getQCIdentity())) {
                kdtItemEntries.getCell(rowIndex, "defectQty").getStyleAttributes().setLocked(false);
            } else {
                kdtItemEntries.getCell(rowIndex, "defectQty").getStyleAttributes().setLocked(true);
            }
            if (samProInfo != null) {
                kdtItemEntries.getCell(rowIndex, "sampleShares").getStyleAttributes().setLocked(true);
            } else {
                kdtItemEntries.getCell(rowIndex, "sampleShares").getStyleAttributes().setLocked(false);
            }
            kdtItemEntries.getCell(rowIndex, "passShares").getStyleAttributes().setLocked(false);
            kdtItemEntries.getCell(rowIndex, "unPassShares").getStyleAttributes().setLocked(false);
        }
        if (samProInfo != null) {
            samProInfo = QCSamplingProgramFactory.getRemoteInstance().getQCSamplingProgramInfo((IObjectPK)new ObjectUuidPK(samProInfo.getId()));
            if (EvaluateModeEnum.countdeterminebysys.equals((Object)samProInfo.getEvaluationMode()) || EvaluateModeEnum.pointdeterminebysys.equals((Object)samProInfo.getEvaluationMode())) {
                row.getCell("checkResult").getStyleAttributes().setLocked(true);
                BigDecimal acValue = (BigDecimal)row.getCell("acValue").getValue();
                BigDecimal reValue = (BigDecimal)row.getCell("reValue").getValue();
                BigDecimal unPassQty = (BigDecimal)row.getCell("unPassShares").getValue();
                BigDecimal defectQty = (BigDecimal)row.getCell("defectQty").getValue();
                if (EvaluateModeEnum.countdeterminebysys.equals((Object)samProInfo.getEvaluationMode()) && acValue != null && reValue != null && unPassQty != null && unPassQty.compareTo(acValue) == 1 && unPassQty.compareTo(reValue) == -1) {
                    row.getCell("checkResult").getStyleAttributes().setLocked(false);
                } else if (EvaluateModeEnum.pointdeterminebysys.equals((Object)samProInfo.getEvaluationMode()) && acValue != null && reValue != null && defectQty != null && defectQty.compareTo(acValue) == 1 && defectQty.compareTo(reValue) == -1) {
                    row.getCell("checkResult").getStyleAttributes().setLocked(false);
                }
            }
        } else {
            row.getCell("checkResult").getStyleAttributes().setLocked(false);
        }
        int dataPrection = QCStandardClientUtils.getRowCheckValuePrecision((KDTable)kdtItemEntries, (int)rowIndex, (String)"qcModifyMethod", (String)"dataPrecision", (String)"checkUnit");
        QCStandardClientUtils.setCheckValueAndDefaultValueByValueType((KDTable)kdtItemEntries, (int)rowIndex, (String)"qcValueType", (String)"qcEnums", (String[])new String[]{"checkValue", "qcDefaultValue"}, (int)dataPrection);
        QCValueAcquisitionModeEnum qcvamValue = (QCValueAcquisitionModeEnum)row.getCell("qCValueAcquisitionMode").getValue();
        if (qcvamValue != null && QCValueAcquisitionModeEnum.BYSAMPLEQTY.equals((Object)qcvamValue)) {
            row.getCell("checkValue").getStyleAttributes().setLocked(true);
            row.getCell("checkValue").getStyleAttributes().setBackground(QMConstant.UnRequired_Color);
        } else {
            row.getCell("checkValue").getStyleAttributes().setLocked(false);
            QCItemInfo itemInfo = (QCItemInfo)row.getCell("qcItemNumber").getValue();
            if (itemInfo != null && (QCValueTypeEnum.number.equals((Object)itemInfo.getQCValueType()) || QCValueTypeEnum.formula.equals((Object)itemInfo.getQCValueType()))) {
                row.getCell("checkValue").getStyleAttributes().setBackground(QMConstant.Required_Color);
            } else {
                row.getCell("checkValue").getStyleAttributes().setBackground(QMConstant.UnRequired_Color);
            }
        }
    }

    public static String getWaringInfo(JComponent jbox) {
        KDLabelContainer parentPanel = (KDLabelContainer)jbox.getParent();
        return QCMMPatrolReportEditUIHelper.getMsg("Value_Empty", new String[]{parentPanel.getBoundLabelText()});
    }

    public static void caclExpressionResult(CoreUI ui, Context ctx, KDTable kdtEntrys) {
        StringBuffer detailMsg = new StringBuffer();
        boolean hasFormula = false;
        for (int i = 0; i < kdtEntrys.getRowCount(); ++i) {
            IRow row = kdtEntrys.getRow(i);
            if (row.getCell("qcValueType").getValue() != QCValueTypeEnum.formula) continue;
            hasFormula = true;
            String exp = (String)row.getCell("expression").getValue();
            if (StringUtils.isEmpty((String)exp)) {
                detailMsg.append(QCMMPatrolReportEditUIHelper.getMsg("Forumal_info1", new String[]{String.valueOf(i + 1)}) + "\n");
                continue;
            }
            String msg = EASResource.getString((String)"com.kingdee.eas.qm.qc.QCAutoGenerateResource", (String)"34_QCReportEditUIHelper");
            MessageFormat mf = new MessageFormat(msg);
            logger.debug((Object)(i + 1 + mf.format(new String[]{exp})));
            Object obj = null;
            try {
                obj = QCMMPatrolReportEditUIHelper.innerExpCompute(ctx, kdtEntrys, row, exp);
                if (obj instanceof BigDecimal) {
                    QCModifyModeInfo modifyInfo = (QCModifyModeInfo)row.getCell("qcModifyMethod").getValue();
                    obj = QCMMPatrolReportEditUIHelper.modifyCheckValue(modifyInfo, obj);
                }
                if (obj instanceof BigDecimal) {
                    obj = new BigDecimal(((BigDecimal)obj).doubleValue());
                }
                detailMsg.append(QCMMPatrolReportEditUIHelper.getMsg("Forumal_info2", new String[]{String.valueOf(i + 1), "\n", obj + "\n"}));
            }
            catch (Throwable e) {
                detailMsg.append(QCMMPatrolReportEditUIHelper.getMsg("Forumal_info3", new String[]{String.valueOf(i + 1), "\n" + e.getMessage() + "\n"}));
            }
            row.getCell("checkValue").setValue(obj);
            QCMMPatrolReportEditUIF7FilterHelper.autoComputeCheckResult(kdtEntrys, ui, i);
        }
        if (hasFormula) {
            MsgBox.showDetailAndOK((Component)ui, (String)(QCMMPatrolReportEditUIHelper.getMsg("Forumal_info4", null) + "\n"), (String)detailMsg.toString(), (int)1);
        } else {
            MsgBox.showWarning((Component)ui, (String)QCMMPatrolReportEditUIHelper.getMsg("Forumal_info5", null));
        }
    }

    public static Object innerExpCompute(Context ctx, KDTable kdtEntrys, IRow row, String exp) throws Exception {
        HashMap<String, BigDecimal> localCtx = new HashMap<String, BigDecimal>();
        KScriptParser parse = new KScriptParser(exp);
        parse.parse();
        for (CodeStmt stmt : parse.stmtList) {
            if (!(stmt instanceof VarDeclStmt)) continue;
            VarDeclStmt declStmt = (VarDeclStmt)stmt;
            for (VarDeclItem item : declStmt.varDeclList) {
                if ("formula_result".equals(item.name)) continue;
                boolean hasItem = false;
                for (int i = 0; i < kdtEntrys.getRowCount(); ++i) {
                    QCItemInfo qcitem;
                    String tempVar;
                    IRow innerRow = kdtEntrys.getRow(i);
                    if (innerRow.getCell("qcValueType").getValue() != QCValueTypeEnum.number || innerRow.getCell("qcItemNumber").getValue() == null || !item.name.equals(tempVar = QMFormulaUtils.getVarNameByQCItemNumber((String)(qcitem = (QCItemInfo)innerRow.getCell("qcItemNumber").getValue()).getNumber()))) continue;
                    hasItem = true;
                    BigDecimal checkValue = SysConstant.BIGZERO;
                    if (innerRow.getCell("checkValue").getValue() == null) {
                        throw new QCReportException(QCReportException.FORMULA_ERROR3, new String[]{qcitem.getNumber(), qcitem.getName()});
                    }
                    checkValue = new BigDecimal(innerRow.getCell("checkValue").getValue().toString());
                    localCtx.put(item.name, checkValue);
                }
                if (hasItem) continue;
                String itemOtherName = QMFormulaUtils.getVarAliasFromExpByVarName((String)exp, (String)item.name);
                String alias = QMFormulaUtils.parserFormulaToAliasString((String)exp);
                String displayString = QMFormulaUtils.parserFormulaToDisplayString((String)exp);
                throw new QCReportException(QCReportException.FORMULA_ERROR2, new String[]{"\n" + displayString + alias + "", item.name, itemOtherName});
            }
        }
        Object object = QMFormulaUtils.evalFormula((Context)ctx, (String)exp, localCtx);
        if (object == null) {
            throw new QCReportException(QCReportException.FORMULA_ERROR1);
        }
        return object;
    }

    private static void setRowLockByQuantitativeAnalysis(KDTable kdtItemEntries, int rowIndex) {
        QCItemInfo itemInfo = (QCItemInfo)kdtItemEntries.getRow(rowIndex).getCell("qcItemNumber").getValue();
        if (itemInfo == null || !QCValueTypeEnum.number.equals((Object)itemInfo.getQCValueType()) && !QCValueTypeEnum.formula.equals((Object)itemInfo.getQCValueType())) {
            kdtItemEntries.getRow(rowIndex).getCell("judgeType").getStyleAttributes().setLocked(true);
            kdtItemEntries.getRow(rowIndex).getCell("upper").getStyleAttributes().setLocked(true);
            kdtItemEntries.getRow(rowIndex).getCell("upperLimit").getStyleAttributes().setLocked(true);
            kdtItemEntries.getRow(rowIndex).getCell("lower").getStyleAttributes().setLocked(true);
            kdtItemEntries.getRow(rowIndex).getCell("lowerLimit").getStyleAttributes().setLocked(true);
        }
    }

    public static Object modifyCheckValue(QCModifyModeInfo modifyInfo, Object o) {
        if (modifyInfo != null && o != null) {
            try {
                BigDecimal modifyTo = new BigDecimal(o.toString());
                int dataPrecision = 8;
                BigDecimal afterModifyVar = QCModifyModeHelper.modify((BigDecimal)modifyTo, (QCModifyModeInfo)modifyInfo, (int)dataPrecision);
                o = afterModifyVar;
            }
            catch (NumberFormatException nfe) {
                logger.error((Object)nfe);
            }
        }
        return o;
    }
}

