/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.qm.qc.client.util.qcreport;

import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.qm.qc.QCReportCreateResult;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class QCReportCreateResultHelper {
    public static final String resPath = "com.kingdee.eas.qm.qc.QCReportCreateResource";

    public static void processResultInfoFromCreateReport(CoreUI ui, QCReportCreateResult result) throws Exception {
        Map errorMap = result.getErrorList();
        Map successMap = result.getSucessMap();
        boolean isCreateByRequestEntry = result.isCreateByRequestEntry();
        StringBuffer detailMsg = new StringBuffer();
        detailMsg.append(QCReportCreateResultHelper.buildSucessMsg(successMap));
        detailMsg.append(QCReportCreateResultHelper.buildErrorMsg(errorMap, isCreateByRequestEntry));
        MsgBox.showDetailAndOK((Component)ui, (String)QCReportCreateResultHelper.buildTitleMsg(successMap, errorMap), (String)detailMsg.toString(), (int)1);
    }

    public static void processResultInfoFromCreateReport(CoreUI ui, List retResult) throws Exception {
        if (retResult == null || retResult.size() <= 0) {
            return;
        }
        Iterator iter = retResult.iterator();
        HashMap errorMap = new HashMap();
        HashMap successMap = new HashMap();
        StringBuffer detailMsg = new StringBuffer();
        while (iter.hasNext()) {
            QCReportCreateResult result = (QCReportCreateResult)iter.next();
            boolean isCreateByRequestEntry = result.isCreateByRequestEntry();
            detailMsg.append(QCReportCreateResultHelper.buildSucessMsg(result.getSucessMap()));
            detailMsg.append(QCReportCreateResultHelper.buildErrorMsg(result.getErrorList(), isCreateByRequestEntry));
            errorMap.putAll(result.getErrorList());
            successMap.putAll(result.getSucessMap());
        }
        MsgBox.showDetailAndOK((Component)ui, (String)QCReportCreateResultHelper.buildTitleMsg(successMap, errorMap), (String)detailMsg.toString(), (int)1);
    }

    public static String buildTitleMsg(Map successMap, Map errorMap) {
        StringBuffer msgTitle = new StringBuffer();
        msgTitle.append(QCReportCreateResultHelper.getMsg("CreateFrom_TitleMsg", new Object[]{new Integer(successMap.size()), "\n" + new Integer(errorMap.size()), "\n", "\n\n"}));
        return msgTitle.toString();
    }

    public static String buildSucessMsg(Map successMap) {
        if (successMap.size() == 0) {
            return "";
        }
        Map qcbills = successMap.get("QCBILLS") == null ? null : (Map)successMap.get("QCBILLS");
        successMap.remove("QCBILLS");
        Iterator it = successMap.values().iterator();
        StringBuffer msg = new StringBuffer();
        while (it.hasNext()) {
            String qcBillList;
            String fnumber = (String)it.next();
            String[] key = fnumber.split("<#>");
            String string = qcbills == null ? "" : (qcBillList = qcbills.get(key[1]) == null ? "" : "" + ((StringBuffer)qcbills.get(key[1])).toString() + "");
            if (qcBillList != null && qcBillList.length() > 0 && qcBillList.endsWith(",")) {
                qcBillList = qcBillList.substring(0, qcBillList.length() - 1);
                qcBillList = "\n" + QCReportCreateResultHelper.getMsg("BillType_QCBILL", null) + ":\u3010" + qcBillList + "\u3011";
            }
            String createtomsg = "\n" + QCReportCreateResultHelper.getMsg("BillReport_Suc", null) + QCReportCreateResultHelper.getMsg("BillReport_sheng", null) + qcBillList;
            msg.append(QCReportCreateResultHelper.getMsg("CreateFrom_SuccessMsg", new Object[]{key[2], key[0], StringUtil.isEmptyString((String)qcBillList) ? "" : createtomsg}) + "\n\n");
        }
        StringBuffer message = new StringBuffer();
        message.append("================================================\n");
        message.append(msg.toString());
        message.append("================================================\n");
        return message.toString();
    }

    public static String buildErrorMsg(Map errorMap, boolean isCreateByRequestEntry) {
        StringBuffer message = new StringBuffer();
        Map qcbills = errorMap.get("QCBILLS") == null ? null : (Map)errorMap.get("QCBILLS");
        errorMap.remove("QCBILLS");
        if (errorMap.size() > 0) {
            for (Map.Entry entry : errorMap.entrySet()) {
                List errorMsgList = (List)entry.getValue();
                String msgKey = (String)entry.getKey();
                if (isCreateByRequestEntry) {
                    String qcBillList;
                    String[] requestkeys = msgKey.split("<#>");
                    HashMap<String, Object> keyMsgMap = new HashMap<String, Object>();
                    for (int i = 0; i < errorMsgList.size(); ++i) {
                        String keyMsg = (String)errorMsgList.get(i);
                        keyMsgMap.put(keyMsg, null);
                    }
                    String string = qcbills == null ? "" : (qcBillList = qcbills.get(requestkeys[0] + "<&>" + requestkeys[1]) == null ? "" : "" + ((StringBuffer)qcbills.get(requestkeys[0] + "<&>" + requestkeys[1])).toString() + "");
                    if (qcBillList != null && qcBillList.length() > 0 && qcBillList.endsWith(",")) {
                        qcBillList = "\u3010" + qcBillList.substring(0, qcBillList.length() - 1) + "\u3011";
                    }
                    message.append(QCReportCreateResultHelper.getMsg("CreateFrom_ErrorMsg_Request", new Object[]{requestkeys[0] + "\n", requestkeys[1] + "\n", "\n", "\n" + QCReportCreateResultHelper.buildDetailErrorMsg(keyMsgMap), qcBillList}));
                    message.append("\n\n");
                    continue;
                }
                HashMap<String, Object> keyMsgMap = new HashMap<String, Object>();
                for (int i = 0; i < errorMsgList.size(); ++i) {
                    String keyMsg = (String)errorMsgList.get(i);
                    keyMsgMap.put(keyMsg, null);
                }
                message.append(QCReportCreateResultHelper.getMsg("CreateFrom_ErrorMsg_Sample", new Object[]{msgKey + "\n", "\n", "\n" + QCReportCreateResultHelper.buildDetailErrorMsg(keyMsgMap)}));
                message.append("\n\n");
            }
        }
        return message.toString();
    }

    public static String buildDetailErrorMsg(Map keyMsgMap) {
        Iterator it = keyMsgMap.keySet().iterator();
        StringBuffer msg = new StringBuffer();
        while (it.hasNext()) {
            String keyMsg = (String)it.next();
            String[] msgs = keyMsg.split("#");
            String billType = msgs[1];
            if ("QCBILL".equals(billType)) {
                msg.append(QCReportCreateResultHelper.getMsg("CreateFrom_ErrorMsg_QCBILL", new Object[]{msgs[2], msgs[0]}) + "\n");
            } else if ("QCREQUEST".equals(billType)) {
                msg.append(QCReportCreateResultHelper.getMsg("CreateFrom_ErrorMsg_QCREQUEST", new Object[]{msgs[2], msgs[0]}) + "\n");
            } else if ("QCREIINSPECTREQ".equals(billType)) {
                msg.append(QCReportCreateResultHelper.getMsg("CreateFrom_ErrorMsg_QCREIINSPECTREQ", new Object[]{msgs[2], msgs[0]}) + "\n");
            } else if ("QCSAMPLE".equals(billType)) {
                msg.append(QCReportCreateResultHelper.getMsg("CreateFrom_ErrorMsg_QCSAMPLE", new Object[]{msgs[2], msgs[0]}) + "\n");
            }
            if (!"QCREPORT".equals(billType)) continue;
            billType = QCReportCreateResultHelper.getMsg("BillType_QCREPORT", null);
        }
        return msg.toString();
    }

    public static String getMsg(String key, Object[] objs) {
        String msg = EASResource.getString((String)resPath, (String)key);
        if (objs != null && objs.length > 0) {
            msg = MessageFormat.format(msg, objs);
        }
        return msg;
    }
}

