/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.qm.qc.client.verify;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.swing.KDDatePicker;
import com.kingdee.bos.ctrl.swing.KDLabelContainer;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.ctrl.swing.KDScrollPane;
import com.kingdee.bos.ctrl.swing.KDTextArea;
import com.kingdee.bos.ctrl.swing.KDTextField;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.qm.common.util.QMResourceUtils;
import com.kingdee.eas.qm.common.util.QMStringUtils;
import com.kingdee.eas.qm.common.verify.AbstractVerifyItem;
import com.kingdee.eas.qm.common.verify.IVerifyItem;
import com.kingdee.eas.qm.qc.QCRejectProcessInfo;
import com.kingdee.eas.qm.qc.client.QCRejectProcessEditUI;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.Container;

public class QCRejectProcessSaveVerifyItem
extends AbstractVerifyItem
implements IVerifyItem {
    private QCRejectProcessEditUI ui;
    private static final String QCRejectProcessRes = "com.kingdee.eas.qm.qc.QCRejectProcessResource";
    private static String path = "com.kingdee.eas.fm.common.FMResource";

    public QCRejectProcessSaveVerifyItem(QCRejectProcessEditUI ui) {
        this.ui = ui;
    }

    public boolean verify() throws EASBizException, BOSException {
        QCRejectProcessInfo info = (QCRejectProcessInfo)this.ui.getEditData();
        if (!info.isFromBOTP()) {
            MsgBox.showWarning((Component)((Object)this.ui), (String)QMResourceUtils.getMessage((String)QCRejectProcessRes, (String)"NotFromBotpCannotSave"));
            SysUtil.abort();
        }
        if (info.getRstEntry().isEmpty()) {
            MsgBox.showWarning((Component)((Object)this.ui), (String)QMResourceUtils.getMessage((String)QCRejectProcessRes, (String)"RstEntryCannotNull"));
            SysUtil.abort();
        }
        this.verifyHead();
        this.verifyEntry();
        return true;
    }

    private boolean verifyHead() {
        KDPanel base = (KDPanel)this.ui.getComponentByName("base");
        KDTextField txtNumber = (KDTextField)this.ui.getComponentByName("txtNumber");
        KDDatePicker dateBizDate = (KDDatePicker)this.ui.getComponentByName("dateBizDate");
        if (QMStringUtils.isEmpty((String)txtNumber.getText())) {
            this.ui.switchHeadPanel(base);
            txtNumber.requestFocus();
            MsgBox.showWarning((Component)((Object)this.ui), (String)this.getMessage((Component)txtNumber));
            SysUtil.abort();
        }
        if (QMStringUtils.isEmpty((String)dateBizDate.getText())) {
            this.ui.switchHeadPanel(base);
            dateBizDate.requestFocus();
            MsgBox.showWarning((Component)((Object)this.ui), (String)this.getMessage((Component)dateBizDate));
            SysUtil.abort();
        }
        return true;
    }

    private boolean verifyEntry() {
        KDPanel rptEntrys = (KDPanel)this.ui.getComponentByName("rptEntrys");
        KDPanel exesEntrys = (KDPanel)this.ui.getComponentByName("exesEntrys");
        KDPanel rstEntrys = (KDPanel)this.ui.getComponentByName("rstEntrys");
        KDTable kdtRptEntry = (KDTable)this.ui.getComponentByName("kdtEntrys");
        KDTable kdtExeEntry = (KDTable)this.ui.getComponentByName("kdtExesEntry");
        KDTable kdtRstEntry = (KDTable)this.ui.getComponentByName("kdtRstEntry");
        this.verifyEntryEmpty(kdtRptEntry, rptEntrys, new String[]{"dpReason"});
        this.verifyEntryEmpty(kdtExeEntry, exesEntrys, new String[]{"chargeDepart", "chargePerson"});
        this.verifyEntryEmpty(kdtRstEntry, rstEntrys, new String[]{"dpProcessMode", "qty", "unit"});
        return true;
    }

    private void verifyEntryEmpty(KDTable kdtEntry, KDPanel panel, String[] colNames) {
        IRow row = null;
        for (int j = 0; j < kdtEntry.getRowCount(); ++j) {
            row = kdtEntry.getRow(j);
            for (int i = 0; i < colNames.length; ++i) {
                String colName = colNames[i];
                int colIndex = kdtEntry.getColumnIndex(colName);
                if (!EmptyUtil.isEmpty((Object)row.getCell(colName).getValue())) continue;
                this.ui.switchEntryPanel(panel);
                kdtEntry.getEditManager().editCellAt(row.getRowIndex(), colIndex);
                String headValue = (String)kdtEntry.getHeadRow(0).getCell(colName).getValue();
                String msg = headValue + " " + EASResource.getString((String)path, (String)"CanNotBeNull");
                msg = msg.replaceAll("#", " " + headValue + " ");
                MsgBox.showWarning((Component)((Object)this.ui), (String)msg);
                SysUtil.abort();
            }
        }
    }

    private String getMessage(Component component) {
        String text = this.getCompLabelText(component);
        return text + EASResource.getString((String)path, (String)"CanNotBeNull");
    }

    private String getCompLabelText(Component component) {
        Container cont2;
        Container cont;
        String text = "";
        Container parent = component.getParent();
        if (parent instanceof KDLabelContainer) {
            text = ((KDLabelContainer)parent).getBoundLabelText();
        } else if (component instanceof KDTextArea && (cont = parent) != null && (cont2 = cont.getParent()) instanceof KDScrollPane && cont2.getParent() instanceof KDLabelContainer) {
            text = ((KDLabelContainer)cont2.getParent()).getBoundLabelText();
        }
        return text;
    }
}

