/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.qm.qc.client.verify;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.eas.basedata.org.QualityOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.SysConstant;
import com.kingdee.eas.qm.basedata.JudgeTypeEnum;
import com.kingdee.eas.qm.basedata.QCItemInfo;
import com.kingdee.eas.qm.basedata.QCLowerLimitEnum;
import com.kingdee.eas.qm.basedata.QCStrategyEnum;
import com.kingdee.eas.qm.basedata.QCUpperLimitEnum;
import com.kingdee.eas.qm.basedata.QCValueTypeEnum;
import com.kingdee.eas.qm.basedata.SampleSolutionEnum;
import com.kingdee.eas.qm.basedata.client.util.QCStandardEditUIHelper;
import com.kingdee.eas.qm.common.util.NumericUtils;
import com.kingdee.eas.qm.common.util.QMEqualsUtils;
import com.kingdee.eas.qm.common.util.QMResourceUtils;
import com.kingdee.eas.qm.common.verify.AbstractVerifyItem;
import com.kingdee.eas.qm.common.verify.IVerifyItem;
import com.kingdee.eas.qm.qc.QCRequestEntryInfo;
import com.kingdee.eas.qm.qc.QCRequestQcItemEntryCollection;
import com.kingdee.eas.qm.qc.QCRequestQcItemEntryInfo;
import com.kingdee.eas.qm.qc.client.QCRequestEditUI;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.math.BigDecimal;

public class QCRequestSaveClientVerifyItem
extends AbstractVerifyItem
implements IVerifyItem {
    private QCRequestEditUI ui;
    private String res = "com.kingdee.eas.qm.qc.QCRequestResource";

    public QCRequestSaveClientVerifyItem(QCRequestEditUI ui) {
        this.ui = ui;
    }

    public boolean verify() throws EASBizException, BOSException {
        KDPanel panel = (KDPanel)this.ui.getComponentByName("material");
        KDTable entry = (KDTable)this.ui.getComponentByName("kdtEntrys");
        if (null == entry) {
            return true;
        }
        ICell cell = null;
        int qtyColIndex = entry.getColumnIndex("deliverQty");
        for (int i = 0; i < entry.getRowCount(); ++i) {
            BigDecimal qty;
            cell = entry.getCell(i, "deliverQty");
            if (null != cell && null != cell.getValue() && (qty = (BigDecimal)cell.getValue()).compareTo(SysConstant.BIGZERO) <= 0) {
                this.ui.switchEntryPanel(panel);
                entry.getEditManager().editCellAt(i, qtyColIndex);
                MsgBox.showWarning((String)QMResourceUtils.getMessage((String)this.res, (String)"DeliverQtyMustMoreThanZero"));
                SysUtil.abort();
            }
            this.verifyItemEntry(entry, i);
        }
        return true;
    }

    private void isSampleSharesOverDeliver(KDTable entry, int rowIndex) {
        QCRequestEntryInfo entryInfo = (QCRequestEntryInfo)entry.getRow(rowIndex).getUserObject();
        QCRequestQcItemEntryCollection itemEntryCol = entryInfo.getQcItemEntrys();
        if (null == itemEntryCol || !SampleSolutionEnum.takeOutCheck.equals((Object)entryInfo.getQcType())) {
            return;
        }
        for (int i = 0; i < itemEntryCol.size(); ++i) {
            String[] params;
            String msg;
            QCRequestQcItemEntryInfo itemEntry = itemEntryCol.get(i);
            if (NumericUtils.equalsZero((BigDecimal)entryInfo.getDeliverQty()) || NumericUtils.equalsZero((BigDecimal)itemEntry.getSampleShares()) || entryInfo.getDeliverQty().compareTo(itemEntry.getSampleShares()) > 0 || !MsgBox.isYes((int)MsgBox.showConfirm2((String)(msg = QMResourceUtils.getMessage((String)this.res, (String)"SampleSharesOverDeliverQty", (String[])(params = new String[]{entryInfo.getMaterial().getName(), itemEntry.getQCItem().getName()})))))) continue;
            entry.getCell(rowIndex, "qcType").setValue((Object)SampleSolutionEnum.allCheck);
            entryInfo.setQcType(SampleSolutionEnum.allCheck);
        }
    }

    private void verifyItemEntry(KDTable entry, int rowIndex) {
        QCRequestEntryInfo entryInfo = (QCRequestEntryInfo)entry.getRow(rowIndex).getUserObject();
        QCRequestQcItemEntryCollection itemEntryCol = entryInfo.getQcItemEntrys();
        if (itemEntryCol == null || itemEntryCol.size() == 0) {
            String msg = this.ui.getMsg("QCItemEntryIsNull", new String[]{String.valueOf(rowIndex + 1)});
            MsgBox.showInfo((String)msg);
            SysUtil.abort();
        }
        if (QCStrategyEnum.oneStepCheck.equals((Object)entryInfo.getQcStrategy())) {
            this.isSuitedDelOrg(entryInfo, itemEntryCol);
        }
        for (int i = 0; i < itemEntryCol.size(); ++i) {
            QCRequestQcItemEntryInfo itemEntry = itemEntryCol.get(i);
            QCItemInfo qcItem = itemEntry.getQCItem();
            String[] params = new String[]{String.valueOf(rowIndex + 1)};
            if (qcItem == null) {
                MsgBox.showInfo((String)this.ui.getMsg("ItemEntryQCItemCannotNull", params));
                SysUtil.abort();
            }
            if (itemEntry.getDelegOrgUnit() == null) {
                MsgBox.showInfo((String)this.ui.getMsg("ItemEntryDelOrgCannotNull", params));
                SysUtil.abort();
            }
            params = new String[]{String.valueOf(rowIndex + 1), qcItem.getName()};
            QCValueTypeEnum valueType = qcItem.getQCValueType();
            if (QCValueTypeEnum.number.equals((Object)valueType) || QCValueTypeEnum.formula.equals((Object)valueType)) {
                if (itemEntry.getUnit() == null) {
                    MsgBox.showInfo((Component)((Object)this.ui), (String)this.ui.getMsg("ItemEntryUnitCannotNull", params));
                    SysUtil.abort();
                }
                if (itemEntry.getJudgeType() == null || itemEntry.getJudgeType().equals((Object)JudgeTypeEnum.NULL)) {
                    MsgBox.showInfo((Component)((Object)this.ui), (String)this.ui.getMsg("ItemEntryJudgeTypeCannotNull", params));
                    SysUtil.abort();
                }
            }
            if (qcItem.isIsModify() && itemEntry.getQCModifyMode() == null) {
                MsgBox.showInfo((Component)((Object)this.ui), (String)this.ui.getMsg("ItemEntryModifyModeCannotNull", params));
                SysUtil.abort();
            }
            if (!this.isLowerMatchLimit(itemEntry)) {
                MsgBox.showInfo((Component)((Object)this.ui), (String)this.ui.getMsg("ItemEntry_LowerLimit_Empty", params));
                SysUtil.abort();
            }
            if (!this.isUpperMatchLimit(itemEntry)) {
                MsgBox.showInfo((Component)((Object)this.ui), (String)this.ui.getMsg("ItemEntry_UpperLimit_Empty", params));
                SysUtil.abort();
            }
            if (null != itemEntry.getLower() && null != itemEntry.getUpper() && itemEntry.getLower().compareTo(itemEntry.getUpper()) > 0) {
                MsgBox.showInfo((Component)((Object)this.ui), (String)this.ui.getMsg("ItemEntryLowerMustLessUpper", params));
                SysUtil.abort();
            }
            if (itemEntry.getJudgeType() != null && !JudgeTypeEnum.NULL.equals((Object)itemEntry.getJudgeType()) && itemEntry.getLower() == null && itemEntry.getUpper() == null) {
                MsgBox.showInfo((Component)((Object)this.ui), (String)this.ui.getMsg("ItemEntry_JudgeTypeNotNULL", params));
                SysUtil.abort();
            }
            JudgeTypeEnum judgeType = itemEntry.getJudgeType();
            QCLowerLimitEnum lowerLimit = itemEntry.getLowerLimit();
            BigDecimal biglower = itemEntry.getLower();
            QCUpperLimitEnum upperLimit = itemEntry.getUpperLimit();
            BigDecimal bigupper = itemEntry.getUpper();
            if (judgeType.equals((Object)JudgeTypeEnum.NULL) && lowerLimit.equals(QCLowerLimitEnum.isNull) && biglower == null && upperLimit.equals(QCUpperLimitEnum.isNull) && bigupper == null) continue;
            if (judgeType.equals((Object)JudgeTypeEnum.NULL) && (lowerLimit.equals(QCLowerLimitEnum.isNull) && biglower == null || upperLimit.equals(QCUpperLimitEnum.isNull) && bigupper == null)) {
                MsgBox.showInfo((Component)((Object)this.ui), (String)this.ui.getMsg("Verify_QcJudgeTypeCheck1", params));
                SysUtil.abort();
                continue;
            }
            if (judgeType.equals((Object)JudgeTypeEnum.NULL) || valueType == null || !QCValueTypeEnum.formula.equals((Object)valueType) && !QCValueTypeEnum.number.equals((Object)valueType)) continue;
            if (lowerLimit.equals(QCLowerLimitEnum.isNull) && upperLimit.equals(QCUpperLimitEnum.isNull)) {
                MsgBox.showInfo((Component)((Object)this.ui), (String)this.ui.getMsg("Verify_QcJudgeTypeCheck2", params));
                SysUtil.abort();
                continue;
            }
            if (lowerLimit.equals(QCLowerLimitEnum.isNull) || biglower == null || upperLimit.equals(QCUpperLimitEnum.isNull) || bigupper == null) continue;
            if (lowerLimit.equals(QCLowerLimitEnum.equal) && upperLimit.equals(QCUpperLimitEnum.equal)) {
                if (bigupper.compareTo(biglower) != 0) {
                    MsgBox.showInfo((Component)((Object)this.ui), (String)this.ui.getMsg("Verify_QcJudgeTypeCheck3", params));
                    SysUtil.abort();
                }
            } else if (lowerLimit.equals(QCLowerLimitEnum.equal) || upperLimit.equals(QCUpperLimitEnum.equal)) {
                MsgBox.showInfo((Component)((Object)this.ui), (String)this.ui.getMsg("Verify_QcJudgeTypeCheck4", params));
                SysUtil.abort();
            }
            if (lowerLimit.equals(QCLowerLimitEnum.greater) || upperLimit.equals(QCUpperLimitEnum.less)) {
                if (bigupper.compareTo(biglower) > 0) continue;
                MsgBox.showInfo((Component)((Object)this.ui), (String)this.ui.getMsg("Verify_QcJudgeTypeCheck5", params));
                SysUtil.abort();
                continue;
            }
            if (bigupper.compareTo(biglower) >= 0) continue;
            MsgBox.showInfo((Component)((Object)this.ui), (String)this.ui.getMsg("Verify_QcJudgeTypeCheck5", params));
            SysUtil.abort();
        }
    }

    private void isSuitedDelOrg(QCRequestEntryInfo entryInfo, QCRequestQcItemEntryCollection itemEntryCol) {
        if (entryInfo.getQcStrategy() == null) {
            return;
        }
        if (QCStrategyEnum.oneStepCheck.equals((Object)entryInfo.getQcStrategy())) {
            QualityOrgUnitInfo orgInfo = (QualityOrgUnitInfo)this.ui.getMainOrgInfo();
            for (int i = 0; i < itemEntryCol.size(); ++i) {
                QCRequestQcItemEntryInfo itemEntry = itemEntryCol.get(i);
                if (QMEqualsUtils.equals((Object)orgInfo, (Object)itemEntry.getDelegOrgUnit())) continue;
                MsgBox.showInfo((Component)((Object)this.ui), (String)QCStandardEditUIHelper.getMsg((String)"OneStepCheck_OrgSame", null));
                SysUtil.abort();
            }
        }
    }

    protected boolean isLowerMatchLimit(QCRequestQcItemEntryInfo entry) {
        return (null != entry.getLower() || null == entry.getLowerLimit() || entry.getLowerLimit() == QCLowerLimitEnum.isNull) && (null == entry.getLower() || null != entry.getLowerLimit() && entry.getLowerLimit() != QCLowerLimitEnum.isNull);
    }

    protected boolean isUpperMatchLimit(QCRequestQcItemEntryInfo entry) {
        return (null != entry.getUpper() || null == entry.getUpperLimit() || entry.getUpperLimit() == QCUpperLimitEnum.isNull) && (null == entry.getUpper() || null != entry.getUpperLimit() && entry.getUpperLimit() != QCUpperLimitEnum.isNull);
    }
}

