/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.qm.qc.client.verify;

import com.kingdee.bos.BOSException;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.qm.basedata.QCItemInfo;
import com.kingdee.eas.qm.basedata.QCLowerLimitEnum;
import com.kingdee.eas.qm.basedata.QCUpperLimitEnum;
import com.kingdee.eas.qm.common.util.QMResourceUtils;
import com.kingdee.eas.qm.common.util.QMStringUtils;
import com.kingdee.eas.qm.common.verify.AbstractVerifyItem;
import com.kingdee.eas.qm.common.verify.IVerifyItem;
import com.kingdee.eas.qm.qc.QCertificateEntryCollection;
import com.kingdee.eas.qm.qc.QCertificateEntryInfo;
import com.kingdee.eas.qm.qc.QCertificateInfo;
import com.kingdee.eas.qm.qc.client.QCertificateEditUI;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.util.ArrayList;

public class QCertificateSubmitVerifyItem
extends AbstractVerifyItem
implements IVerifyItem {
    private QCertificateEditUI ui;
    private static final String QCertificateRes = "com.kingdee.eas.qm.qc.QCertificateResource";

    public QCertificateSubmitVerifyItem(QCertificateEditUI ui) {
        this.ui = ui;
        this.ui.storeFields();
    }

    public boolean verify() throws EASBizException, BOSException {
        QCertificateInfo info = (QCertificateInfo)this.ui.getEditData();
        QCertificateEntryCollection entrys = info.getEntrys();
        if (null == entrys || entrys.size() <= 0) {
            MsgBox.showWarning((Component)((Object)this.ui), (String)QMResourceUtils.getMessage((String)QCertificateRes, (String)"EntryCannotNull"));
            SysUtil.abort();
        }
        ArrayList<QCItemInfo> qcItems = new ArrayList<QCItemInfo>();
        String repeatItemName = "";
        String repeatItemIDs = "";
        String unMatchIndexs = "";
        String qtyIndexs = "";
        for (int i = 0; i < entrys.size(); ++i) {
            QCertificateEntryInfo entryInfo = entrys.get(i);
            if (qcItems.contains(entryInfo.getQCItem()) && repeatItemIDs.indexOf(entryInfo.getQCItem().getId().toString()) < 0) {
                repeatItemName = repeatItemName + "," + entryInfo.getQCItem().getName();
                repeatItemIDs = repeatItemIDs + "," + entryInfo.getQCItem().getId().toString();
            }
            qcItems.add(entryInfo.getQCItem());
            if (!this.isLowerMatchLimit(entryInfo)) {
                MsgBox.showWarning((Component)((Object)this.ui), (String)QMResourceUtils.getMessage((String)QCertificateRes, (String)"ItemEntry_LowerLimit_Empty", (String[])new String[]{String.valueOf(i + 1)}));
                SysUtil.abort();
            }
            if (!this.isUpperMatchLimit(entryInfo)) {
                MsgBox.showWarning((Component)((Object)this.ui), (String)QMResourceUtils.getMessage((String)QCertificateRes, (String)"ItemEntry_UpperLimit_Empty", (String[])new String[]{String.valueOf(i + 1)}));
                SysUtil.abort();
            }
            if (null != entryInfo.getLower() && null != entryInfo.getUpper() && entryInfo.getLower().compareTo(entryInfo.getUpper()) > 0) {
                MsgBox.showWarning((Component)((Object)this.ui), (String)QMResourceUtils.getMessage((String)QCertificateRes, (String)"LowerBigThenUpper", (String[])new String[]{String.valueOf(i + 1)}));
                SysUtil.abort();
            }
            if (!QMStringUtils.isEmpty((String)repeatItemName)) {
                repeatItemName = repeatItemName.substring(1);
                MsgBox.showWarning((Component)((Object)this.ui), (String)QMResourceUtils.getMessage((String)QCertificateRes, (String)"EntryQCItemCannotRepeat", (String[])new String[]{repeatItemName}));
                SysUtil.abort();
            }
            if (entryInfo.getLowerLimit().equals((Object)QCLowerLimitEnum.equal) && entryInfo.getUpperLimit().equals((Object)QCUpperLimitEnum.equal)) {
                if (entryInfo.getUpper().compareTo(entryInfo.getLower()) == 0) continue;
                MsgBox.showWarning((Component)((Object)this.ui), (String)QMResourceUtils.getMessage((String)QCertificateRes, (String)"EqualMarkValidation", (String[])new String[]{String.valueOf(i + 1)}));
                SysUtil.abort();
                continue;
            }
            if ((!entryInfo.getLowerLimit().equals((Object)QCLowerLimitEnum.equal) || entryInfo.getUpperLimit().equals((Object)QCUpperLimitEnum.isNull)) && (entryInfo.getLowerLimit().equals((Object)QCLowerLimitEnum.isNull) || !entryInfo.getUpperLimit().equals((Object)QCUpperLimitEnum.equal))) continue;
            MsgBox.showWarning((Component)((Object)this.ui), (String)QMResourceUtils.getMessage((String)QCertificateRes, (String)"EqualMarkValidation", (String[])new String[]{String.valueOf(i + 1)}));
            SysUtil.abort();
        }
        return true;
    }

    private boolean isLowerMatchLimit(QCertificateEntryInfo entry) {
        return (null != entry.getLower() || null == entry.getLowerLimit() || entry.getLowerLimit() == QCLowerLimitEnum.isNull) && (null == entry.getLower() || null != entry.getLowerLimit() && entry.getLowerLimit() != QCLowerLimitEnum.isNull);
    }

    private boolean isUpperMatchLimit(QCertificateEntryInfo entry) {
        return (null != entry.getUpper() || null == entry.getUpperLimit() || entry.getUpperLimit() == QCUpperLimitEnum.isNull) && (null == entry.getUpper() || null != entry.getUpperLimit() && entry.getUpperLimit() != QCUpperLimitEnum.isNull);
    }
}

