/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.qm.qc.client.verify.qcreport;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.ctrl.swing.KDDatePicker;
import com.kingdee.bos.ctrl.swing.KDFormattedTextField;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.ctrl.swing.KDTextField;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.SysConstant;
import com.kingdee.eas.qm.qc.QCMMPatrolReportInfo;
import com.kingdee.eas.qm.qc.client.QCMMPatrolReportEditUI;
import com.kingdee.eas.qm.qc.client.util.qcreport.QCMMPatrolReportEditUIHelper;
import com.kingdee.eas.qm.qc.client.verify.qcreport.QCMMPatrolReportClientBaseVerifyItem;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.util.Map;
import javax.swing.JComponent;

public class QCMMPatrolReportCommonClientVerifyItem
extends QCMMPatrolReportClientBaseVerifyItem {
    public QCMMPatrolReportCommonClientVerifyItem(QCMMPatrolReportInfo reportInfo, Map params) {
        super(reportInfo, params);
    }

    public boolean verify() throws EASBizException, BOSException {
        BigDecimal unpassQty;
        QCMMPatrolReportEditUI ui = (QCMMPatrolReportEditUI)((Object)this.getParams("UI"));
        KDPanel basePanel = (KDPanel)ui.getComponentByName("base");
        KDPanel checkRsPanel = (KDPanel)ui.getComponentByName("qcresult");
        if (!this.reportInfo.isFromBOTP()) {
            MsgBox.showWarning((Component)((Object)ui), (String)QCMMPatrolReportEditUIHelper.getMsg("QCMMPatrolReport_CanNotAddNew", null));
            SysUtil.abort();
        }
        if (StringUtil.isEmptyString((String)this.reportInfo.getNumber())) {
            ui.switchToHeadPanel(basePanel);
            KDTextField txt = (KDTextField)ui.getComponentByName("txtNumber");
            MsgBox.showWarning((Component)((Object)ui), (String)QCMMPatrolReportEditUIHelper.getWaringInfo((JComponent)txt));
            txt.requestFocus();
            SysUtil.abort();
        }
        if (this.reportInfo.getReportDate() == null) {
            ui.switchToHeadPanel(basePanel);
            KDDatePicker pkDate = (KDDatePicker)ui.getComponentByName("dateBizDate");
            MsgBox.showWarning((Component)((Object)ui), (String)QCMMPatrolReportEditUIHelper.getWaringInfo((JComponent)pkDate));
            pkDate.requestFocus();
            SysUtil.abort();
        }
        if (this.reportInfo.getPassQty() == null) {
            ui.switchToHeadPanel(checkRsPanel);
            KDFormattedTextField txtPassQty = (KDFormattedTextField)ui.getComponentByName("txtpassQty");
            MsgBox.showWarning((Component)((Object)ui), (String)QCMMPatrolReportEditUIHelper.getWaringInfo((JComponent)txtPassQty));
            txtPassQty.requestFocus();
            SysUtil.abort();
        }
        if (this.reportInfo.getUnPassQty() == null) {
            ui.switchToHeadPanel(checkRsPanel);
            KDFormattedTextField txtUnPassQty = (KDFormattedTextField)ui.getComponentByName("txtunPassQty");
            MsgBox.showWarning((Component)((Object)ui), (String)QCMMPatrolReportEditUIHelper.getWaringInfo((JComponent)txtUnPassQty));
            txtUnPassQty.requestFocus();
            SysUtil.abort();
        }
        BigDecimal sendQty = this.reportInfo.getDeliverQty() != null && !this.reportInfo.getDeliverQty().toString().equals("0E-8") ? this.reportInfo.getDeliverQty() : SysConstant.BIGZERO;
        BigDecimal passQty = this.reportInfo.getPassQty() != null && !this.reportInfo.getPassQty().toString().equals("0E-8") ? this.reportInfo.getPassQty() : SysConstant.BIGZERO;
        BigDecimal sumQty = passQty.add(unpassQty = this.reportInfo.getUnPassQty() != null && !this.reportInfo.getUnPassQty().toString().equals("0E-8") ? this.reportInfo.getUnPassQty() : SysConstant.BIGZERO);
        if (sumQty.compareTo(sendQty) != 0) {
            ui.switchToHeadPanel(checkRsPanel);
            KDFormattedTextField numTxt = (KDFormattedTextField)ui.getComponentByName("txtpassQty");
            int precision = numTxt.getPrecision() == 10 ? 4 : numTxt.getPrecision();
            StringBuffer format = new StringBuffer("#0.");
            for (int i = 0; i < precision; ++i) {
                format.append("0");
            }
            DecimalFormat qtyFormat = new DecimalFormat(format.toString());
            MsgBox.showWarning((Component)((Object)ui), (String)QCMMPatrolReportEditUIHelper.getMsg("Qty_CommonVerify", new String[]{"(" + qtyFormat.format(passQty) + ")\n", "(" + qtyFormat.format(unpassQty) + ")\n", "(" + qtyFormat.format(sumQty) + ")\n", "(" + qtyFormat.format(sendQty) + ")"}));
            numTxt.requestFocus();
            SysUtil.abort();
        }
        return true;
    }
}

