/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.qm.qc.client.verify.qcreport;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.table.KDTEditManager;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDFormattedTextField;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.SysConstant;
import com.kingdee.eas.qm.basedata.JudgeTypeEnum;
import com.kingdee.eas.qm.basedata.QCBizBillTypeInfo;
import com.kingdee.eas.qm.basedata.QCLowerLimitEnum;
import com.kingdee.eas.qm.basedata.QCUpperLimitEnum;
import com.kingdee.eas.qm.basedata.QCValueAcquisitionModeEnum;
import com.kingdee.eas.qm.basedata.QCValueTypeEnum;
import com.kingdee.eas.qm.basedata.SampleSolutionEnum;
import com.kingdee.eas.qm.qc.CheckResultEnum;
import com.kingdee.eas.qm.qc.QCItemSampleEntryCollection;
import com.kingdee.eas.qm.qc.QCItemSampleEntryInfo;
import com.kingdee.eas.qm.qc.QCMMPatrolReportEntryInfo;
import com.kingdee.eas.qm.qc.QCMMPatrolReportInfo;
import com.kingdee.eas.qm.qc.QCMMPatrolReportNCPPREntryInfo;
import com.kingdee.eas.qm.qc.QCResultJudgeEnum;
import com.kingdee.eas.qm.qc.client.QCMMPatrolReportEditUI;
import com.kingdee.eas.qm.qc.client.util.qcreport.QCMMPatrolReportEditUIHelper;
import com.kingdee.eas.qm.qc.client.verify.qcreport.QCMMPatrolReportClientBaseVerifyItem;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.math.BigDecimal;
import java.util.Iterator;
import java.util.Map;
import javax.swing.JComponent;

public class QCMMPatrolReportSubmitClientVerifyItem
extends QCMMPatrolReportClientBaseVerifyItem {
    public QCMMPatrolReportSubmitClientVerifyItem(QCMMPatrolReportInfo reportInfo, Map params) {
        super(reportInfo, params);
    }

    public boolean verify() throws EASBizException, BOSException {
        this.verifyHead();
        this.verifyQCItemEntry();
        this.verifyNCCPEntrys();
        return true;
    }

    protected void verifyHead() throws EASBizException, BOSException {
        BigDecimal sampleUnPassQty;
        KDFormattedTextField txtTotalSampleQty;
        BigDecimal totalSampleQty;
        KDComboBox combox;
        KDFormattedTextField numTxt;
        QCMMPatrolReportEditUI ui = (QCMMPatrolReportEditUI)((Object)this.getParams("UI"));
        KDPanel checkRsPanel = (KDPanel)ui.getComponentByName("qcresult");
        KDBizPromptBox prmt = (KDBizPromptBox)ui.getComponentByName("prmtunit");
        if (prmt.isRequired() && prmt.getData() == null) {
            ui.switchToHeadPanel(checkRsPanel);
            MsgBox.showWarning((Component)((Object)ui), (String)QCMMPatrolReportEditUIHelper.getWaringInfo((JComponent)prmt));
            prmt.requestFocus();
            SysUtil.abort();
        }
        if ((numTxt = (KDFormattedTextField)ui.getComponentByName("txtpassQty")).isRequired() && (numTxt.getBigDecimalValue() == null || numTxt.getBigDecimalValue().signum() < 0)) {
            ui.switchToHeadPanel(checkRsPanel);
            MsgBox.showWarning((Component)((Object)ui), (String)QCMMPatrolReportEditUIHelper.getWaringInfo((JComponent)numTxt));
            numTxt.requestFocus();
            SysUtil.abort();
        }
        if ((numTxt = (KDFormattedTextField)ui.getComponentByName("txtunPassQty")).isRequired() && (numTxt.getBigDecimalValue() == null || numTxt.getBigDecimalValue().signum() < 0)) {
            ui.switchToHeadPanel(checkRsPanel);
            MsgBox.showWarning((Component)((Object)ui), (String)QCMMPatrolReportEditUIHelper.getWaringInfo((JComponent)numTxt));
            numTxt.requestFocus();
            SysUtil.abort();
        }
        if ((numTxt = (KDFormattedTextField)ui.getComponentByName("txtsamplePassQty")).isRequired() && (numTxt.getBigDecimalValue() == null || numTxt.getBigDecimalValue().signum() < 0)) {
            ui.switchToHeadPanel(checkRsPanel);
            MsgBox.showWarning((Component)((Object)ui), (String)QCMMPatrolReportEditUIHelper.getWaringInfo((JComponent)numTxt));
            numTxt.requestFocus();
            SysUtil.abort();
        }
        if ((numTxt = (KDFormattedTextField)ui.getComponentByName("txtsampleUnPassQty")).isRequired() && (numTxt.getBigDecimalValue() == null || numTxt.getBigDecimalValue().signum() < 0)) {
            ui.switchToHeadPanel(checkRsPanel);
            MsgBox.showWarning((Component)((Object)ui), (String)QCMMPatrolReportEditUIHelper.getWaringInfo((JComponent)numTxt));
            numTxt.requestFocus();
            SysUtil.abort();
        }
        if ((combox = (KDComboBox)ui.getComponentByName("checkResult")).getSelectedItem() == null || combox.getSelectedItem() == CheckResultEnum.isnull) {
            ui.switchToHeadPanel(checkRsPanel);
            MsgBox.showWarning((Component)((Object)ui), (String)QCMMPatrolReportEditUIHelper.getWaringInfo((JComponent)combox));
            combox.requestFocus();
            SysUtil.abort();
        }
        BigDecimal bigDecimal = totalSampleQty = (txtTotalSampleQty = (KDFormattedTextField)ui.getComponentByName("txtTotalSampleQty")).getBigDecimalValue() == null ? new BigDecimal("0") : txtTotalSampleQty.getBigDecimalValue();
        if (totalSampleQty.compareTo(new BigDecimal("0")) == -1) {
            String msg = QCMMPatrolReportEditUIHelper.getMsg("TotalSampleQtyNotNull", null);
            MsgBox.showWarning((Component)((Object)ui), (String)msg);
            txtTotalSampleQty.requestFocus();
            SysUtil.abort();
        }
        KDFormattedTextField txtSamplePassQty = (KDFormattedTextField)ui.getComponentByName("txtsamplePassQty");
        KDFormattedTextField txtSampleUnPassQty = (KDFormattedTextField)ui.getComponentByName("txtsampleUnPassQty");
        BigDecimal samplePassQty = txtSamplePassQty.getBigDecimalValue() == null ? new BigDecimal("0") : txtSamplePassQty.getBigDecimalValue();
        BigDecimal sumQty = samplePassQty.add(sampleUnPassQty = txtSampleUnPassQty.getBigDecimalValue() == null ? new BigDecimal("0") : txtSampleUnPassQty.getBigDecimalValue());
        if (sumQty.compareTo(totalSampleQty) != 0) {
            String msg = QCMMPatrolReportEditUIHelper.getMsg("TotalSampleQtyVerify", null);
            MsgBox.showWarning((Component)((Object)ui), (String)msg);
            txtTotalSampleQty.requestFocus();
            SysUtil.abort();
        }
        SampleSolutionEnum sampleSolution = null;
        if (this.reportInfo.getQCStandard() != null) {
            sampleSolution = this.reportInfo.getQCStandard().getSampleSolution();
        }
        if (SampleSolutionEnum.takeOutCheck.equals(sampleSolution)) {
            BigDecimal unPassQty;
            KDFormattedTextField txtdeliverQty = (KDFormattedTextField)ui.getComponentByName("txtdeliverQty");
            BigDecimal deliverQty = txtdeliverQty.getBigDecimalValue() == null ? new BigDecimal("0") : txtdeliverQty.getBigDecimalValue();
            KDFormattedTextField txtpassQty = (KDFormattedTextField)ui.getComponentByName("txtpassQty");
            BigDecimal passQty = txtpassQty.getBigDecimalValue() == null ? new BigDecimal("0") : txtpassQty.getBigDecimalValue();
            KDFormattedTextField txtunPassQty = (KDFormattedTextField)ui.getComponentByName("txtunPassQty");
            BigDecimal bigDecimal2 = unPassQty = txtunPassQty.getBigDecimalValue() == null ? new BigDecimal("0") : txtunPassQty.getBigDecimalValue();
            if (deliverQty.compareTo(passQty.add(unPassQty)) != 0) {
                String msg = QCMMPatrolReportEditUIHelper.getMsg("DeliverQtyVerify", null);
                MsgBox.showWarning((Component)((Object)ui), (String)msg);
                txtpassQty.requestFocus();
                SysUtil.abort();
            }
        }
        KDPanel basePanel = (KDPanel)ui.getComponentByName("base");
        KDFormattedTextField txtPatrolDeliverQty = (KDFormattedTextField)ui.getComponentByName("txtPatrolDeliverQty");
        BigDecimal patrolDeliverQty = txtPatrolDeliverQty.getBigDecimalValue();
        if (patrolDeliverQty == null || SysConstant.BIGZERO.compareTo(patrolDeliverQty) != -1) {
            ui.switchToHeadPanel(basePanel);
            String msg = QCMMPatrolReportEditUIHelper.getMsg("PatrolDeliverQtyNotNull", null);
            MsgBox.showWarning((Component)((Object)ui), (String)msg);
            txtPatrolDeliverQty.requestFocus();
            SysUtil.abort();
        }
    }

    protected void verifyQCItemEntry() {
        QCMMPatrolReportEditUI ui = (QCMMPatrolReportEditUI)((Object)this.getParams("UI"));
        KDPanel checkRsPanel = (KDPanel)ui.getComponentByName("qcresult");
        KDTable table = (KDTable)this.getParams("kdTable");
        KDTEditManager kdtEditManager = table.getEditManager();
        Iterator it = this.reportInfo.getEntrys().iterator();
        int rowIndex = 0;
        boolean allOKItem = true;
        while (it.hasNext()) {
            QCValueTypeEnum valueType;
            ++rowIndex;
            QCMMPatrolReportEntryInfo entryInfo = (QCMMPatrolReportEntryInfo)it.next();
            SampleSolutionEnum sse = null;
            if (this.reportInfo.getQCStandard() != null) {
                sse = this.reportInfo.getQCStandard().getSampleSolution();
            }
            if (sse != null && SampleSolutionEnum.takeOutCheck.equals((Object)sse) && entryInfo.getSampleShares() == null) {
                MsgBox.showInfo((String)QCMMPatrolReportEditUIHelper.getMsg("SampleSharesNotNull", new String[]{String.valueOf(rowIndex)}));
                kdtEditManager.editCellAt(rowIndex - 1, table.getColumnIndex("sampleShares"));
                SysUtil.abort();
            }
            if (entryInfo.getQCItem() == null) {
                MsgBox.showInfo((String)QCMMPatrolReportEditUIHelper.getMsg("QCItem_Empty", new String[]{String.valueOf(rowIndex)}));
                kdtEditManager.editCellAt(rowIndex - 1, table.getColumnIndex("qcItemNumber"));
                SysUtil.abort();
            }
            if (QCValueAcquisitionModeEnum.BYQCITEM == entryInfo.getQCValueAcquisitionMode()) {
                QCValueTypeEnum valueType2 = entryInfo.getQCItem().getQCValueType();
                if (valueType2 != null && (QCValueTypeEnum.number.equals((Object)valueType2) || QCValueTypeEnum.formula.equals((Object)valueType2)) && StringUtil.isEmptyString((String)entryInfo.getCheckValue())) {
                    MsgBox.showInfo((String)QCMMPatrolReportEditUIHelper.getMsg("CheckValue_Empty", new String[]{String.valueOf(rowIndex)}));
                    kdtEditManager.editCellAt(rowIndex - 1, table.getColumnIndex("checkValue"));
                    SysUtil.abort();
                }
            } else if (QCValueAcquisitionModeEnum.BYSAMPLEQTY == entryInfo.getQCValueAcquisitionMode()) {
                if (QCResultJudgeEnum.cancel == entryInfo.getCheckResult()) continue;
                QCItemSampleEntryCollection sItemEntrys = entryInfo.getSampleEntry();
                QCValueTypeEnum valueType3 = entryInfo.getQCItem().getQCValueType();
                if (sItemEntrys == null || sItemEntrys.size() == 0) {
                    MsgBox.showInfo((String)QCMMPatrolReportEditUIHelper.getMsg("ItemSampleEntryNotNull", new String[]{String.valueOf(rowIndex)}));
                    kdtEditManager.editCellAt(rowIndex - 1, table.getColumnIndex("attachment"));
                    SysUtil.abort();
                }
                int size = sItemEntrys.size();
                for (int i = 0; i < size; ++i) {
                    QCItemSampleEntryInfo iSampleEntryInfo = sItemEntrys.get(i);
                    QCResultJudgeEnum result = iSampleEntryInfo.getEachSampleResult();
                    String value = iSampleEntryInfo.getEachSampleValue();
                    if (valueType3 == null) continue;
                    if (QCValueTypeEnum.number.equals((Object)valueType3) || QCValueTypeEnum.formula.equals((Object)valueType3)) {
                        if (result != null && !QCResultJudgeEnum.isNull.equals((Object)result) && value != null) continue;
                        MsgBox.showInfo((String)QCMMPatrolReportEditUIHelper.getMsg("ItemSampleEntryValueAndResultNotNull", new String[]{String.valueOf(rowIndex)}));
                        kdtEditManager.editCellAt(rowIndex - 1, table.getColumnIndex("attachment"));
                        SysUtil.abort();
                        continue;
                    }
                    if (result != null && !QCResultJudgeEnum.isNull.equals((Object)result)) continue;
                    MsgBox.showInfo((String)QCMMPatrolReportEditUIHelper.getMsg("ItemSampleEntryResultNotNull", new String[]{String.valueOf(rowIndex)}));
                    kdtEditManager.editCellAt(rowIndex - 1, table.getColumnIndex("attachment"));
                    SysUtil.abort();
                }
            }
            if (entryInfo.getCheckResult() == null || QCResultJudgeEnum.isNull.equals((Object)entryInfo.getCheckResult())) {
                MsgBox.showInfo((String)QCMMPatrolReportEditUIHelper.getMsg("CheckResult_Empty", new String[]{String.valueOf(rowIndex)}));
                kdtEditManager.editCellAt(rowIndex - 1, table.getColumnIndex("checkResult"));
                SysUtil.abort();
            }
            if (entryInfo.isIsKeyItem() && entryInfo.getCheckResult() == QCResultJudgeEnum.noDeterminant) {
                kdtEditManager.editCellAt(rowIndex - 1, table.getColumnIndex("checkResult"));
                MsgBox.showInfo((String)QCMMPatrolReportEditUIHelper.getMsg("KeyItem_CheckRs", new String[]{String.valueOf(rowIndex)}));
                SysUtil.abort();
            }
            if (entryInfo.getCheckResult() != QCResultJudgeEnum.pass) {
                allOKItem = false;
            }
            if ((entryInfo.getLowerLimit() == null || entryInfo.getLowerLimit() == QCLowerLimitEnum.isNull) && entryInfo.getLower() != null || entryInfo.getLowerLimit() != null && entryInfo.getLowerLimit() != QCLowerLimitEnum.isNull && entryInfo.getLower() == null) {
                kdtEditManager.editCellAt(rowIndex - 1, table.getColumnIndex("lowerLimit"));
                MsgBox.showInfo((String)QCMMPatrolReportEditUIHelper.getMsg("ItemEntry_LowerLimit_Empty", new String[]{String.valueOf(rowIndex)}));
                SysUtil.abort();
            }
            if ((entryInfo.getUpperLimit() == null || entryInfo.getUpperLimit() == QCUpperLimitEnum.isNull) && entryInfo.getUpper() != null || entryInfo.getUpperLimit() != null && entryInfo.getUpperLimit() != QCUpperLimitEnum.isNull && entryInfo.getUpper() == null) {
                kdtEditManager.editCellAt(rowIndex - 1, table.getColumnIndex("upperLimit"));
                MsgBox.showInfo((String)QCMMPatrolReportEditUIHelper.getMsg("ItemEntry_UpperLimit_Empty", new String[]{String.valueOf(rowIndex)}));
                SysUtil.abort();
            }
            BigDecimal lower = entryInfo.getLower();
            BigDecimal upper = entryInfo.getUpper();
            if (lower != null && upper != null) {
                if (lower.compareTo(upper) > 0) {
                    kdtEditManager.editCellAt(rowIndex - 1, table.getColumnIndex("upper"));
                    MsgBox.showInfo((String)QCMMPatrolReportEditUIHelper.getMsg("LowerCannotMoreThanUpper", new String[]{String.valueOf(rowIndex)}));
                    SysUtil.abort();
                }
                if (upper.compareTo(lower) == 0 && (entryInfo.getLowerLimit().equals((Object)QCLowerLimitEnum.greater) || entryInfo.getUpperLimit().equals((Object)QCUpperLimitEnum.less))) {
                    kdtEditManager.editCellAt(rowIndex - 1, table.getColumnIndex("upper"));
                    MsgBox.showInfo((String)QCMMPatrolReportEditUIHelper.getMsg("LowUpLimitEquals", new String[]{String.valueOf(rowIndex)}));
                    SysUtil.abort();
                }
            }
            JudgeTypeEnum judgeType = entryInfo.getJudgeType();
            QCLowerLimitEnum lowerLimit = entryInfo.getLowerLimit();
            QCUpperLimitEnum upperLimit = entryInfo.getUpperLimit();
            int colIndex = table.getColumnIndex("judgeType");
            if (judgeType.equals((Object)JudgeTypeEnum.NULL) && lowerLimit.equals(QCLowerLimitEnum.isNull) && lower == null && upperLimit.equals(QCUpperLimitEnum.isNull) && upper == null) continue;
            if (judgeType.equals((Object)JudgeTypeEnum.NULL) && (lowerLimit.equals(QCLowerLimitEnum.isNull) && lower == null || upperLimit.equals(QCUpperLimitEnum.isNull) && upper == null)) {
                kdtEditManager.editCellAt(rowIndex - 1, colIndex);
                MsgBox.showInfo((String)QCMMPatrolReportEditUIHelper.getMsg("Verify_QcJudgeTypeCheck1", new String[]{String.valueOf(rowIndex)}));
                SysUtil.abort();
                continue;
            }
            if (judgeType.equals((Object)JudgeTypeEnum.NULL) || (valueType = entryInfo.getQCValueType()) == null || !QCValueTypeEnum.formula.equals((Object)valueType) && !QCValueTypeEnum.number.equals((Object)valueType)) continue;
            if (lowerLimit.equals(QCLowerLimitEnum.isNull) && upperLimit.equals(QCUpperLimitEnum.isNull)) {
                kdtEditManager.editCellAt(rowIndex - 1, colIndex);
                MsgBox.showInfo((String)QCMMPatrolReportEditUIHelper.getMsg("Verify_QcJudgeTypeCheck2", new String[]{String.valueOf(rowIndex)}));
                SysUtil.abort();
                continue;
            }
            if (lowerLimit.equals(QCLowerLimitEnum.isNull) || lower == null || upperLimit.equals(QCUpperLimitEnum.isNull) || upper == null) continue;
            if (lowerLimit.equals(QCLowerLimitEnum.equal) && upperLimit.equals(QCUpperLimitEnum.equal)) {
                if (upper.compareTo(lower) != 0) {
                    MsgBox.showInfo((String)QCMMPatrolReportEditUIHelper.getMsg("Verify_QcJudgeTypeCheck3", new String[]{String.valueOf(rowIndex)}));
                    SysUtil.abort();
                }
            } else if (lowerLimit.equals(QCLowerLimitEnum.equal) || upperLimit.equals(QCUpperLimitEnum.equal)) {
                MsgBox.showInfo((String)QCMMPatrolReportEditUIHelper.getMsg("Verify_QcJudgeTypeCheck4", new String[]{String.valueOf(rowIndex)}));
                SysUtil.abort();
            }
            if (lowerLimit.equals(QCLowerLimitEnum.greater) || upperLimit.equals(QCUpperLimitEnum.less)) {
                if (upper.compareTo(lower) > 0) continue;
                kdtEditManager.editCellAt(rowIndex - 1, colIndex);
                MsgBox.showInfo((String)QCMMPatrolReportEditUIHelper.getMsg("Verify_QcJudgeTypeCheck5", new String[]{String.valueOf(rowIndex)}));
                SysUtil.abort();
                continue;
            }
            if (upper.compareTo(lower) >= 0) continue;
            kdtEditManager.editCellAt(rowIndex - 1, colIndex);
            MsgBox.showInfo((String)QCMMPatrolReportEditUIHelper.getMsg("Verify_QcJudgeTypeCheck5", new String[]{String.valueOf(rowIndex)}));
            SysUtil.abort();
        }
        BigDecimal unpassQty = this.reportInfo.getUnPassQty();
        if (unpassQty == null) {
            unpassQty = SysConstant.BIGZERO;
        }
        if (allOKItem) {
            if (unpassQty.signum() != 0) {
                KDFormattedTextField numTxt;
                if (this.reportInfo.getNCPPREntries().size() > 0) {
                    numTxt = (KDFormattedTextField)ui.getComponentByName("txtunPassQty");
                    ui.switchToHeadPanel(checkRsPanel);
                    MsgBox.showInfo((String)(QCMMPatrolReportEditUIHelper.getMsg("nccp_allPass", null) + QCMMPatrolReportEditUIHelper.getMsg("NCCP_RemoveEntry", null)));
                    numTxt.requestFocus();
                    SysUtil.abort();
                } else {
                    numTxt = (KDFormattedTextField)ui.getComponentByName("txtunPassQty");
                    ui.switchToHeadPanel(checkRsPanel);
                    MsgBox.showInfo((String)QCMMPatrolReportEditUIHelper.getMsg("nccp_allPass", null));
                    numTxt.requestFocus();
                    SysUtil.abort();
                }
            } else if (unpassQty.signum() == 0 && this.reportInfo.getNCPPREntries().size() > 0) {
                MsgBox.showInfo((String)QCMMPatrolReportEditUIHelper.getMsg("NCCP_Allpass_RemoveEntry", null));
                SysUtil.abort();
            }
        }
    }

    protected void verifyNCCPEntrys() throws EASBizException, BOSException {
        QCBizBillTypeInfo bizTypeInfo = this.reportInfo.getBillType();
        if (bizTypeInfo == null || bizTypeInfo.getQCBOGroup() == null || !"riT9zswST8WoeecRK1GOvg5tH1I=".equals(bizTypeInfo.getQCBOGroup().getId().toString())) {
            return;
        }
        KDTable nncpTable = (KDTable)this.getParams("nccpKdTable");
        KDTEditManager kdtEditManager = nncpTable.getEditManager();
        BigDecimal unpassQty = this.reportInfo.getUnPassBaseQty();
        if (unpassQty == null) {
            unpassQty = SysConstant.BIGZERO;
        }
        Iterator it = this.reportInfo.getNCPPREntries().iterator();
        BigDecimal totalQty = SysConstant.BIGZERO;
        int rowIndex = 0;
        while (it.hasNext()) {
            ++rowIndex;
            QCMMPatrolReportNCPPREntryInfo entryInfo = (QCMMPatrolReportNCPPREntryInfo)it.next();
            if (entryInfo.getMaterial() == null) {
                kdtEditManager.editCellAt(rowIndex - 1, nncpTable.getColumnIndex("material"));
                MsgBox.showWarning((String)QCMMPatrolReportEditUIHelper.getMsg("Value_Empty", new String[]{QCMMPatrolReportEditUIHelper.getMsg("NCCP_Col_Material", null)}));
                SysUtil.abort();
            } else if (entryInfo.getDPProcessMode() == null) {
                kdtEditManager.editCellAt(rowIndex - 1, nncpTable.getColumnIndex("dPProcessMode"));
                MsgBox.showWarning((String)QCMMPatrolReportEditUIHelper.getMsg("Value_Empty", new String[]{QCMMPatrolReportEditUIHelper.getMsg("NCCP_Col_DPProcess", null)}));
                SysUtil.abort();
            } else if (entryInfo.getQty() == null) {
                kdtEditManager.editCellAt(rowIndex - 1, nncpTable.getColumnIndex("qty"));
                MsgBox.showWarning((String)QCMMPatrolReportEditUIHelper.getMsg("Value_Empty", new String[]{QCMMPatrolReportEditUIHelper.getMsg("NCCP_Col_Qty", null)}));
                SysUtil.abort();
            } else if (entryInfo.getQty().signum() != 1) {
                kdtEditManager.editCellAt(rowIndex - 1, nncpTable.getColumnIndex("qty"));
                MsgBox.showWarning((String)QCMMPatrolReportEditUIHelper.getMsg("NCCP_Col_BiggerThenZero", null));
                SysUtil.abort();
            } else if (entryInfo.getUnit() == null) {
                kdtEditManager.editCellAt(rowIndex - 1, nncpTable.getColumnIndex("unit"));
                MsgBox.showWarning((String)QCMMPatrolReportEditUIHelper.getMsg("Value_Empty", new String[]{QCMMPatrolReportEditUIHelper.getMsg("NCCP_Col_Unit", null)}));
                SysUtil.abort();
            } else if (entryInfo.getBaseUnit() == null) {
                kdtEditManager.editCellAt(rowIndex - 1, nncpTable.getColumnIndex("unit"));
                MsgBox.showWarning((String)QCMMPatrolReportEditUIHelper.getMsg("Value_Empty", new String[]{QCMMPatrolReportEditUIHelper.getMsg("NCCP_Col_BaseUnit", null)}));
                SysUtil.abort();
            }
            if (entryInfo.getQty() == null || entryInfo.getBaseQty() == null) continue;
            totalQty = totalQty.add(entryInfo.getBaseQty());
        }
        if (totalQty.compareTo(unpassQty) != 0) {
            if (nncpTable.getSelectManager().size() > 0) {
                kdtEditManager.editCellAt(rowIndex - 1, nncpTable.getColumnIndex("qty"));
            }
            MsgBox.showInfo((String)QCMMPatrolReportEditUIHelper.getMsg("nccp_UnpassQtySame", null));
            SysUtil.abort();
        }
    }
}

