/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.qm.qc.client.verify.qcreport;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.ctrl.swing.KDDatePicker;
import com.kingdee.bos.ctrl.swing.KDFormattedTextField;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.ctrl.swing.KDTextField;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.SysConstant;
import com.kingdee.eas.qm.basedata.SampleSolutionEnum;
import com.kingdee.eas.qm.qc.QCReportInfo;
import com.kingdee.eas.qm.qc.client.QCReportEditUI;
import com.kingdee.eas.qm.qc.client.util.qcreport.QCReportEditUIHelper;
import com.kingdee.eas.qm.qc.client.verify.qcreport.QCReportClientBaseVerifyItem;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.math.BigDecimal;
import java.util.Map;
import javax.swing.JComponent;

public class QCReportCommonClientVerifyItem
extends QCReportClientBaseVerifyItem {
    public QCReportCommonClientVerifyItem(QCReportInfo reportInfo, Map params) {
        super(reportInfo, params);
    }

    public boolean verify() throws EASBizException, BOSException {
        BigDecimal sumQty;
        QCReportEditUI ui = (QCReportEditUI)((Object)this.getParams("UI"));
        KDPanel basePanel = (KDPanel)ui.getComponentByName("base");
        KDPanel checkRsPanel = (KDPanel)ui.getComponentByName("qcresult");
        if (!this.reportInfo.isFromBOTP()) {
            MsgBox.showWarning((Component)((Object)ui), (String)QCReportEditUIHelper.getMsg("QCReport_CanNotAddNew", null));
            SysUtil.abort();
        }
        if (StringUtil.isEmptyString((String)this.reportInfo.getNumber())) {
            ui.switchToHeadPanel(basePanel);
            KDTextField txt = (KDTextField)ui.getComponentByName("txtNumber");
            MsgBox.showWarning((Component)((Object)ui), (String)QCReportEditUIHelper.getWaringInfo((JComponent)txt));
            txt.requestFocus();
            SysUtil.abort();
        }
        if (this.reportInfo.getReportDate() == null) {
            ui.switchToHeadPanel(basePanel);
            KDDatePicker pkDate = (KDDatePicker)ui.getComponentByName("dateBizDate");
            MsgBox.showWarning((Component)((Object)ui), (String)QCReportEditUIHelper.getWaringInfo((JComponent)pkDate));
            pkDate.requestFocus();
            SysUtil.abort();
        }
        if (this.reportInfo.getPassQty() == null) {
            ui.switchToHeadPanel(checkRsPanel);
            KDFormattedTextField txtPassQty = (KDFormattedTextField)ui.getComponentByName("txtpassQty");
            MsgBox.showWarning((Component)((Object)ui), (String)QCReportEditUIHelper.getWaringInfo((JComponent)txtPassQty));
            txtPassQty.requestFocus();
            SysUtil.abort();
        }
        if (this.reportInfo.getUnPassQty() == null) {
            ui.switchToHeadPanel(checkRsPanel);
            KDFormattedTextField txtUnPassQty = (KDFormattedTextField)ui.getComponentByName("txtunPassQty");
            MsgBox.showWarning((Component)((Object)ui), (String)QCReportEditUIHelper.getWaringInfo((JComponent)txtUnPassQty));
            txtUnPassQty.requestFocus();
            SysUtil.abort();
        }
        BigDecimal sendQty = this.reportInfo.getDeliverQty() != null && !this.reportInfo.getDeliverQty().toString().equals("0E-8") ? (BigDecimal)this.getParams("sendQty") : SysConstant.BIGZERO;
        BigDecimal passQty = this.reportInfo.getPassQty() != null && !this.reportInfo.getPassQty().toString().equals("0E-8") ? this.reportInfo.getPassQty() : SysConstant.BIGZERO;
        BigDecimal unpassQty = this.reportInfo.getUnPassQty() != null && !this.reportInfo.getUnPassQty().toString().equals("0E-8") ? this.reportInfo.getUnPassQty() : SysConstant.BIGZERO;
        BigDecimal lossQty = this.reportInfo.getLossQty() != null && !this.reportInfo.getLossQty().toString().equals("0E-8") ? this.reportInfo.getLossQty() : SysConstant.BIGZERO;
        boolean isFromQCBill = this.reportInfo.isQCReportFromQCBill();
        if (!isFromQCBill && this.reportInfo.getSampleSolution() != null && this.reportInfo.getSampleSolution() == SampleSolutionEnum.allCheck && passQty.compareTo(SysConstant.BIGZERO) == 0 && unpassQty.compareTo(SysConstant.BIGZERO) == 0 && lossQty.compareTo(SysConstant.BIGZERO) == 0) {
            ui.switchToHeadPanel(checkRsPanel);
            KDFormattedTextField numTxt = (KDFormattedTextField)ui.getComponentByName("txtpassQty");
            MsgBox.showWarning((Component)((Object)ui), (String)QCReportEditUIHelper.getMsg("NewPassQtyAndUpassQtyAndLossQtyNotZero", null));
            numTxt.requestFocus();
            SysUtil.abort();
        }
        if ((sumQty = passQty.add(unpassQty).add(lossQty)).compareTo(sendQty) == 1) {
            ui.switchToHeadPanel(checkRsPanel);
            KDFormattedTextField numTxt = (KDFormattedTextField)ui.getComponentByName("txtpassQty");
            MsgBox.showWarning((Component)((Object)ui), (String)QCReportEditUIHelper.getMsg("NewQty_CommonVerify", new String[]{"(" + passQty.toString() + ")\n", "(" + unpassQty.toString() + ")\n", "(" + lossQty.toString() + ")\n", "(" + sumQty.toString() + ")\n", "(" + sendQty.toString() + ")"}));
            numTxt.requestFocus();
            SysUtil.abort();
        }
        return true;
    }
}

