/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.qm.qc.client.verify.qcreport;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.table.KDTEditManager;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDFormattedTextField;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.eas.base.core.util.EqualsUtil;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.SysConstant;
import com.kingdee.eas.qm.basedata.JudgeTypeEnum;
import com.kingdee.eas.qm.basedata.QCBizBillTypeInfo;
import com.kingdee.eas.qm.basedata.QCLowerLimitEnum;
import com.kingdee.eas.qm.basedata.QCUpperLimitEnum;
import com.kingdee.eas.qm.basedata.QCValueAcquisitionModeEnum;
import com.kingdee.eas.qm.basedata.QCValueTypeEnum;
import com.kingdee.eas.qm.basedata.client.util.QCStandardEditUIHelper;
import com.kingdee.eas.qm.common.util.NumericUtils;
import com.kingdee.eas.qm.common.util.QMEqualsUtils;
import com.kingdee.eas.qm.qc.CheckResultEnum;
import com.kingdee.eas.qm.qc.QCItemSampleEntryCollection;
import com.kingdee.eas.qm.qc.QCItemSampleEntryInfo;
import com.kingdee.eas.qm.qc.QCReportEntryInfo;
import com.kingdee.eas.qm.qc.QCReportInfo;
import com.kingdee.eas.qm.qc.QCReportNCPPREntryInfo;
import com.kingdee.eas.qm.qc.QCResultJudgeEnum;
import com.kingdee.eas.qm.qc.client.QCReportEditUI;
import com.kingdee.eas.qm.qc.client.util.qcreport.QCReportEditUIHelper;
import com.kingdee.eas.qm.qc.client.verify.qcreport.QCReportClientBaseVerifyItem;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.enums.IntEnum;
import java.awt.Component;
import java.math.BigDecimal;
import java.util.Iterator;
import java.util.Map;
import javax.swing.JComponent;

public class QCReportSubmitClientVerifyItem
extends QCReportClientBaseVerifyItem {
    public QCReportSubmitClientVerifyItem(QCReportInfo reportInfo, Map params) {
        super(reportInfo, params);
    }

    public boolean verify() throws EASBizException, BOSException {
        this.verifyHead();
        this.verifyQCItemEntry();
        this.verifyNCCPEntrys();
        this.verifyRelWeighEntrys();
        return true;
    }

    protected void verifyRelWeighEntrys() throws EASBizException, BOSException {
    }

    protected void verifyHead() throws EASBizException, BOSException {
        String msg;
        BigDecimal unPassSampleShares;
        BigDecimal passSampleShares;
        BigDecimal totalSampleQty;
        KDComboBox combox;
        KDFormattedTextField numTxt;
        QCReportEditUI ui = (QCReportEditUI)((Object)this.getParams("UI"));
        KDPanel checkRsPanel = (KDPanel)ui.getComponentByName("qcresult");
        KDBizPromptBox prmt = (KDBizPromptBox)ui.getComponentByName("prmtunit");
        if (prmt.isRequired() && prmt.getData() == null) {
            ui.switchToHeadPanel(checkRsPanel);
            MsgBox.showWarning((Component)((Object)ui), (String)QCReportEditUIHelper.getWaringInfo((JComponent)prmt));
            prmt.requestFocus();
            SysUtil.abort();
        }
        if ((numTxt = (KDFormattedTextField)ui.getComponentByName("txtpassQty")).isRequired() && (numTxt.getBigDecimalValue() == null || numTxt.getBigDecimalValue().signum() < 0)) {
            ui.switchToHeadPanel(checkRsPanel);
            MsgBox.showWarning((Component)((Object)ui), (String)QCReportEditUIHelper.getWaringInfo((JComponent)numTxt));
            numTxt.requestFocus();
            SysUtil.abort();
        }
        if ((numTxt = (KDFormattedTextField)ui.getComponentByName("txtunPassQty")).isRequired() && (numTxt.getBigDecimalValue() == null || numTxt.getBigDecimalValue().signum() < 0)) {
            ui.switchToHeadPanel(checkRsPanel);
            MsgBox.showWarning((Component)((Object)ui), (String)QCReportEditUIHelper.getWaringInfo((JComponent)numTxt));
            numTxt.requestFocus();
            SysUtil.abort();
        }
        if ((numTxt = (KDFormattedTextField)ui.getComponentByName("txtsampleQty")).isRequired() && (numTxt.getBigDecimalValue() == null || numTxt.getBigDecimalValue().signum() < 0)) {
            ui.switchToHeadPanel(checkRsPanel);
            MsgBox.showWarning((Component)((Object)ui), (String)QCReportEditUIHelper.getWaringInfo((JComponent)numTxt));
            numTxt.requestFocus();
            SysUtil.abort();
        }
        if ((numTxt = (KDFormattedTextField)ui.getComponentByName("txtPassSampleShares")).isRequired() && (numTxt.getBigDecimalValue() == null || numTxt.getBigDecimalValue().signum() < 0)) {
            ui.switchToHeadPanel(checkRsPanel);
            MsgBox.showWarning((Component)((Object)ui), (String)QCReportEditUIHelper.getWaringInfo((JComponent)numTxt));
            numTxt.requestFocus();
            SysUtil.abort();
        }
        if ((numTxt = (KDFormattedTextField)ui.getComponentByName("txtUnPassSampleShares")).isRequired() && (numTxt.getBigDecimalValue() == null || numTxt.getBigDecimalValue().signum() < 0)) {
            ui.switchToHeadPanel(checkRsPanel);
            MsgBox.showWarning((Component)((Object)ui), (String)QCReportEditUIHelper.getWaringInfo((JComponent)numTxt));
            numTxt.requestFocus();
            SysUtil.abort();
        }
        if ((combox = (KDComboBox)ui.getComponentByName("checkResult")).isRequired() && (combox.getSelectedItem() == null || combox.getSelectedItem() == CheckResultEnum.isnull)) {
            ui.switchToHeadPanel(checkRsPanel);
            MsgBox.showWarning((Component)((Object)ui), (String)QCReportEditUIHelper.getWaringInfo((JComponent)combox));
            combox.requestFocus();
            SysUtil.abort();
        }
        if (!this.reportInfo.isQCReportFromQCBill()) {
            String msg2;
            BigDecimal lossQty;
            KDFormattedTextField txtdeliverQty = (KDFormattedTextField)ui.getComponentByName("txtdeliverQty");
            BigDecimal deliverQty = txtdeliverQty.getBigDecimalValue() == null ? new BigDecimal("0") : txtdeliverQty.getBigDecimalValue();
            KDFormattedTextField txtpassQty = (KDFormattedTextField)ui.getComponentByName("txtpassQty");
            BigDecimal passQty = txtpassQty.getBigDecimalValue() == null ? new BigDecimal("0") : txtpassQty.getBigDecimalValue();
            KDFormattedTextField txtunPassQty = (KDFormattedTextField)ui.getComponentByName("txtunPassQty");
            BigDecimal unPassQty = txtunPassQty.getBigDecimalValue() == null ? new BigDecimal("0") : txtunPassQty.getBigDecimalValue();
            KDFormattedTextField txtlossQty = (KDFormattedTextField)ui.getComponentByName("txtlossQty");
            BigDecimal bigDecimal = lossQty = txtlossQty.getBigDecimalValue() == null ? new BigDecimal("0") : txtlossQty.getBigDecimalValue();
            if (deliverQty.compareTo(passQty.add(unPassQty).add(lossQty)) != 0) {
                String msg3 = QCStandardEditUIHelper.getMsg((String)"com.kingdee.eas.qm.qc.QCReportResource", (String)"NewDeliverQtyVerify", null);
                MsgBox.showWarning((Component)((Object)ui), (String)msg3);
                txtpassQty.requestFocus();
                SysUtil.abort();
            } else if (this.reportInfo.getCheckResult().equals((Object)CheckResultEnum.unpass) && unPassQty.compareTo(new BigDecimal(0)) == 0 && MsgBox.showConfirm2((String)(msg2 = QCStandardEditUIHelper.getMsg((String)"com.kingdee.eas.qm.qc.QCReportResource", (String)"UnPassNumIsZero", null))) == 2) {
                txtunPassQty.requestFocus();
                SysUtil.abort();
            }
        }
        if (!this.reportInfo.isQCReportFromQCBill() && !this.verifySumQty(totalSampleQty = ((KDFormattedTextField)ui.getComponentByName("txtTotalSampleQty")).getBigDecimalValue(), passSampleShares = ((KDFormattedTextField)ui.getComponentByName("txtPassSampleShares")).getBigDecimalValue(), unPassSampleShares = ((KDFormattedTextField)ui.getComponentByName("txtUnPassSampleShares")).getBigDecimalValue()) && MsgBox.showConfirm2((String)(msg = QCStandardEditUIHelper.getMsg((String)"com.kingdee.eas.qm.qc.QCReportResource", (String)"ConfirmSumSampleShares", null))) == 2) {
            SysUtil.abort();
        }
        if (!this.reportInfo.isQCReportFromQCBill()) {
            BigDecimal samplePassQty = ((KDFormattedTextField)ui.getComponentByName("txtSamplePassQty")).getBigDecimalValue();
            BigDecimal sampleUnPassQty = ((KDFormattedTextField)ui.getComponentByName("txtSampleUnPassQty")).getBigDecimalValue();
            BigDecimal sampleQty = ((KDFormattedTextField)ui.getComponentByName("txtsampleQty")).getBigDecimalValue();
            if (!this.verifySumQty(sampleQty, samplePassQty, sampleUnPassQty) && MsgBox.showConfirm2((String)(msg = QCStandardEditUIHelper.getMsg((String)"com.kingdee.eas.qm.qc.QCReportResource", (String)"ConfirmSumSampleQty", null))) == 2) {
                SysUtil.abort();
            }
        }
    }

    protected boolean verifySumQty(BigDecimal totalQty, BigDecimal passQty, BigDecimal unPassQty) {
        boolean rtnFlag = false;
        BigDecimal sumQty = SysConstant.BIGZERO;
        if (passQty != null) {
            sumQty = sumQty.add(passQty);
        }
        if (unPassQty != null) {
            sumQty = sumQty.add(unPassQty);
        }
        if (NumericUtils.equalsZero((BigDecimal)sumQty) && NumericUtils.equalsZero((BigDecimal)totalQty)) {
            rtnFlag = true;
        }
        if (!NumericUtils.equalsZero((BigDecimal)sumQty) && !NumericUtils.equalsZero((BigDecimal)totalQty)) {
            rtnFlag = QMEqualsUtils.equals((Object)sumQty, (Object)totalQty);
        }
        return rtnFlag;
    }

    protected void verifyQCItemEntry() {
        QCReportEditUI ui = (QCReportEditUI)((Object)this.getParams("UI"));
        KDPanel checkRsPanel = (KDPanel)ui.getComponentByName("qcresult");
        KDTable table = (KDTable)this.getParams("kdTable");
        KDTEditManager kdtEditManager = table.getEditManager();
        Iterator it = this.reportInfo.getEntrys().iterator();
        int rowIndex = 0;
        boolean hasBadItem = false;
        boolean allOKItem = true;
        while (it.hasNext()) {
            QCValueTypeEnum valueType;
            ++rowIndex;
            QCReportEntryInfo entryInfo = (QCReportEntryInfo)it.next();
            if (entryInfo.getQCItem() == null) {
                MsgBox.showInfo((String)QCReportEditUIHelper.getMsg("QCItem_Empty", new String[]{String.valueOf(rowIndex)}));
                kdtEditManager.editCellAt(rowIndex - 1, table.getColumnIndex("qcItemNumber"));
                SysUtil.abort();
            }
            if (QCValueAcquisitionModeEnum.BYQCITEM == entryInfo.getQCValueAcquisitionMode()) {
                QCValueTypeEnum valueType2 = entryInfo.getQCItem().getQCValueType();
                if (valueType2 != null && (QCValueTypeEnum.number.equals((Object)valueType2) || QCValueTypeEnum.formula.equals((Object)valueType2)) && entryInfo.isIsMustCheck() && StringUtil.isEmptyString((String)entryInfo.getCheckValue())) {
                    MsgBox.showInfo((String)QCReportEditUIHelper.getMsg("CheckValue_Empty", new String[]{String.valueOf(rowIndex)}));
                    kdtEditManager.editCellAt(rowIndex - 1, table.getColumnIndex("checkValue"));
                    SysUtil.abort();
                }
            } else if (QCValueAcquisitionModeEnum.BYSAMPLEQTY == entryInfo.getQCValueAcquisitionMode()) {
                QCItemSampleEntryCollection sItemEntrys = entryInfo.getSampleEntry();
                QCValueTypeEnum valueType3 = entryInfo.getQCItem().getQCValueType();
                if (!(sItemEntrys != null && sItemEntrys.size() != 0 || EqualsUtil.equals((IntEnum)QCResultJudgeEnum.cancel, (IntEnum)entryInfo.getCheckResult()))) {
                    MsgBox.showInfo((String)QCReportEditUIHelper.getMsg("ItemSampleEntryNotNull", new String[]{String.valueOf(rowIndex)}));
                    kdtEditManager.editCellAt(rowIndex - 1, table.getColumnIndex("attachment"));
                    SysUtil.abort();
                }
                int size = sItemEntrys.size();
                for (int i = 0; i < size; ++i) {
                    QCItemSampleEntryInfo iSampleEntryInfo = sItemEntrys.get(i);
                    QCResultJudgeEnum result = iSampleEntryInfo.getEachSampleResult();
                    String value = iSampleEntryInfo.getEachSampleValue();
                    if (valueType3 == null) continue;
                    if (QCValueTypeEnum.number.equals((Object)valueType3) || QCValueTypeEnum.formula.equals((Object)valueType3)) {
                        if (result != null && !QCResultJudgeEnum.isNull.equals((Object)result) && value != null) continue;
                        MsgBox.showInfo((String)QCReportEditUIHelper.getMsg("ItemSampleEntryValueAndResultNotNull", new String[]{String.valueOf(rowIndex)}));
                        kdtEditManager.editCellAt(rowIndex - 1, table.getColumnIndex("attachment"));
                        SysUtil.abort();
                        continue;
                    }
                    if (result != null && !QCResultJudgeEnum.isNull.equals((Object)result)) continue;
                    MsgBox.showInfo((String)QCReportEditUIHelper.getMsg("ItemSampleEntryResultNotNull", new String[]{String.valueOf(rowIndex)}));
                    kdtEditManager.editCellAt(rowIndex - 1, table.getColumnIndex("attachment"));
                    SysUtil.abort();
                }
            }
            if (entryInfo.getCheckResult() == null || QCResultJudgeEnum.isNull.equals((Object)entryInfo.getCheckResult())) {
                MsgBox.showInfo((String)QCReportEditUIHelper.getMsg("CheckResult_Empty", new String[]{String.valueOf(rowIndex)}));
                kdtEditManager.editCellAt(rowIndex - 1, table.getColumnIndex("checkResult"));
                SysUtil.abort();
            }
            if (entryInfo.isIsKeyItem() && entryInfo.getCheckResult() == QCResultJudgeEnum.noDeterminant) {
                kdtEditManager.editCellAt(rowIndex - 1, table.getColumnIndex("checkResult"));
                MsgBox.showInfo((String)QCReportEditUIHelper.getMsg("KeyItem_CheckRs", new String[]{String.valueOf(rowIndex)}));
                SysUtil.abort();
            }
            if (entryInfo.getCheckResult() != QCResultJudgeEnum.pass && entryInfo.getCheckResult() != QCResultJudgeEnum.cancel) {
                allOKItem = false;
            }
            if (entryInfo.getCheckResult() == QCResultJudgeEnum.unPass) {
                hasBadItem = true;
            }
            if ((entryInfo.getLowerLimit() == null || entryInfo.getLowerLimit() == QCLowerLimitEnum.isNull) && entryInfo.getLower() != null || entryInfo.getLowerLimit() != null && entryInfo.getLowerLimit() != QCLowerLimitEnum.isNull && entryInfo.getLower() == null) {
                kdtEditManager.editCellAt(rowIndex - 1, table.getColumnIndex("lowerLimit"));
                MsgBox.showInfo((String)QCReportEditUIHelper.getMsg("ItemEntry_LowerLimit_Empty", new String[]{String.valueOf(rowIndex)}));
                SysUtil.abort();
            }
            if ((entryInfo.getUpperLimit() == null || entryInfo.getUpperLimit() == QCUpperLimitEnum.isNull) && entryInfo.getUpper() != null || entryInfo.getUpperLimit() != null && entryInfo.getUpperLimit() != QCUpperLimitEnum.isNull && entryInfo.getUpper() == null) {
                kdtEditManager.editCellAt(rowIndex - 1, table.getColumnIndex("upperLimit"));
                MsgBox.showInfo((String)QCReportEditUIHelper.getMsg("ItemEntry_UpperLimit_Empty", new String[]{String.valueOf(rowIndex)}));
                SysUtil.abort();
            }
            BigDecimal lower = entryInfo.getLower();
            BigDecimal upper = entryInfo.getUpper();
            if (lower != null && upper != null) {
                if (lower.compareTo(upper) > 0) {
                    kdtEditManager.editCellAt(rowIndex - 1, table.getColumnIndex("upper"));
                    MsgBox.showInfo((String)QCReportEditUIHelper.getMsg("LowerCannotMoreThanUpper", new String[]{String.valueOf(rowIndex)}));
                    SysUtil.abort();
                }
                if (upper.compareTo(lower) == 0 && (entryInfo.getLowerLimit().equals((Object)QCLowerLimitEnum.greater) || entryInfo.getUpperLimit().equals((Object)QCUpperLimitEnum.less))) {
                    kdtEditManager.editCellAt(rowIndex - 1, table.getColumnIndex("upper"));
                    MsgBox.showInfo((String)QCReportEditUIHelper.getMsg("LowUpLimitEquals", new String[]{String.valueOf(rowIndex)}));
                    SysUtil.abort();
                }
            }
            JudgeTypeEnum judgeType = entryInfo.getJudgeType();
            QCLowerLimitEnum lowerLimit = entryInfo.getLowerLimit();
            QCUpperLimitEnum upperLimit = entryInfo.getUpperLimit();
            int colIndex = table.getColumnIndex("judgeType");
            if (judgeType.equals((Object)JudgeTypeEnum.NULL) && lowerLimit.equals(QCLowerLimitEnum.isNull) && lower == null && upperLimit.equals(QCUpperLimitEnum.isNull) && upper == null) continue;
            if (judgeType.equals((Object)JudgeTypeEnum.NULL) && (lowerLimit.equals(QCLowerLimitEnum.isNull) && lower == null || upperLimit.equals(QCUpperLimitEnum.isNull) && upper == null)) {
                kdtEditManager.editCellAt(rowIndex - 1, colIndex);
                MsgBox.showInfo((String)QCReportEditUIHelper.getMsg("Verify_QcJudgeTypeCheck1", new String[]{String.valueOf(rowIndex)}));
                SysUtil.abort();
                continue;
            }
            if (judgeType.equals((Object)JudgeTypeEnum.NULL) || (valueType = entryInfo.getQCValueType()) == null || !QCValueTypeEnum.formula.equals((Object)valueType) && !QCValueTypeEnum.number.equals((Object)valueType)) continue;
            if (lowerLimit.equals(QCLowerLimitEnum.isNull) && upperLimit.equals(QCUpperLimitEnum.isNull)) {
                kdtEditManager.editCellAt(rowIndex - 1, colIndex);
                MsgBox.showInfo((String)QCReportEditUIHelper.getMsg("Verify_QcJudgeTypeCheck2", new String[]{String.valueOf(rowIndex)}));
                SysUtil.abort();
                continue;
            }
            if (lowerLimit.equals(QCLowerLimitEnum.isNull) || lower == null || upperLimit.equals(QCUpperLimitEnum.isNull) || upper == null) continue;
            if (lowerLimit.equals(QCLowerLimitEnum.equal) && upperLimit.equals(QCUpperLimitEnum.equal)) {
                if (upper.compareTo(lower) != 0) {
                    MsgBox.showInfo((String)QCReportEditUIHelper.getMsg("Verify_QcJudgeTypeCheck3", new String[]{String.valueOf(rowIndex)}));
                    SysUtil.abort();
                }
            } else if (lowerLimit.equals(QCLowerLimitEnum.equal) || upperLimit.equals(QCUpperLimitEnum.equal)) {
                MsgBox.showInfo((String)QCReportEditUIHelper.getMsg("Verify_QcJudgeTypeCheck4", new String[]{String.valueOf(rowIndex)}));
                SysUtil.abort();
            }
            if (lowerLimit.equals(QCLowerLimitEnum.greater) || upperLimit.equals(QCUpperLimitEnum.less)) {
                if (upper.compareTo(lower) > 0) continue;
                kdtEditManager.editCellAt(rowIndex - 1, colIndex);
                MsgBox.showInfo((String)QCReportEditUIHelper.getMsg("Verify_QcJudgeTypeCheck5", new String[]{String.valueOf(rowIndex)}));
                SysUtil.abort();
                continue;
            }
            if (upper.compareTo(lower) >= 0) continue;
            kdtEditManager.editCellAt(rowIndex - 1, colIndex);
            MsgBox.showInfo((String)QCReportEditUIHelper.getMsg("Verify_QcJudgeTypeCheck5", new String[]{String.valueOf(rowIndex)}));
            SysUtil.abort();
        }
        if (!((Boolean)this.getParams("isRequestFromRequest")).booleanValue()) {
            BigDecimal unpassQty = this.reportInfo.getUnPassQty();
            if (unpassQty == null) {
                unpassQty = SysConstant.BIGZERO;
            }
            if (allOKItem) {
                if (unpassQty.signum() != 0) {
                    KDFormattedTextField numTxt;
                    if (this.reportInfo.getNCPPREntries().size() > 0) {
                        numTxt = (KDFormattedTextField)ui.getComponentByName("txtunPassQty");
                        ui.switchToHeadPanel(checkRsPanel);
                        MsgBox.showInfo((String)(QCReportEditUIHelper.getMsg("nccp_allPass", null) + QCReportEditUIHelper.getMsg("NCCP_RemoveEntry", null)));
                        numTxt.requestFocus();
                        SysUtil.abort();
                    } else {
                        numTxt = (KDFormattedTextField)ui.getComponentByName("txtunPassQty");
                        ui.switchToHeadPanel(checkRsPanel);
                        MsgBox.showInfo((String)QCReportEditUIHelper.getMsg("nccp_allPass", null));
                        numTxt.requestFocus();
                        SysUtil.abort();
                    }
                } else if (unpassQty.signum() == 0 && this.reportInfo.getNCPPREntries().size() > 0) {
                    MsgBox.showInfo((String)QCReportEditUIHelper.getMsg("NCCP_Allpass_RemoveEntry", null));
                    SysUtil.abort();
                }
            }
        }
    }

    protected void verifyNCCPEntrys() throws EASBizException, BOSException {
        QCBizBillTypeInfo bizTypeInfo = this.reportInfo.getBillType();
        if (bizTypeInfo == null || bizTypeInfo.getQCBOGroup() == null || !"riT9zswST8WoeecRK1GOvg5tH1I=".equals(bizTypeInfo.getQCBOGroup().getId().toString())) {
            return;
        }
        KDTable nncpTable = (KDTable)this.getParams("nccpKdTable");
        KDTEditManager kdtEditManager = nncpTable.getEditManager();
        boolean isFromQCBill = (Boolean)this.getParams("isRequestFromRequest");
        BigDecimal unpassQty = this.reportInfo.getUnPassBaseQty();
        if (unpassQty == null) {
            unpassQty = SysConstant.BIGZERO;
        }
        Iterator it = this.reportInfo.getNCPPREntries().iterator();
        BigDecimal totalQty = SysConstant.BIGZERO;
        int rowIndex = 0;
        while (it.hasNext()) {
            ++rowIndex;
            QCReportNCPPREntryInfo entryInfo = (QCReportNCPPREntryInfo)it.next();
            if (entryInfo.getMaterial() == null) {
                kdtEditManager.editCellAt(rowIndex - 1, nncpTable.getColumnIndex("material"));
                MsgBox.showWarning((String)QCReportEditUIHelper.getMsg("Value_Empty", new String[]{QCReportEditUIHelper.getMsg("NCCP_Col_Material", null)}));
                SysUtil.abort();
            } else if (entryInfo.getDPProcessMode() == null) {
                kdtEditManager.editCellAt(rowIndex - 1, nncpTable.getColumnIndex("dPProcessMode"));
                MsgBox.showWarning((String)QCReportEditUIHelper.getMsg("Value_Empty", new String[]{QCReportEditUIHelper.getMsg("NCCP_Col_DPProcess", null)}));
                SysUtil.abort();
            } else if (entryInfo.getQty() == null) {
                kdtEditManager.editCellAt(rowIndex - 1, nncpTable.getColumnIndex("qty"));
                MsgBox.showWarning((String)QCReportEditUIHelper.getMsg("Value_Empty", new String[]{QCReportEditUIHelper.getMsg("NCCP_Col_Qty", null)}));
                SysUtil.abort();
            } else if (entryInfo.getQty().signum() != 1) {
                kdtEditManager.editCellAt(rowIndex - 1, nncpTable.getColumnIndex("qty"));
                MsgBox.showWarning((String)QCReportEditUIHelper.getMsg("NCCP_Col_BiggerThenZero", null));
                SysUtil.abort();
            } else if (entryInfo.getUnit() == null) {
                kdtEditManager.editCellAt(rowIndex - 1, nncpTable.getColumnIndex("unit"));
                MsgBox.showWarning((String)QCReportEditUIHelper.getMsg("Value_Empty", new String[]{QCReportEditUIHelper.getMsg("NCCP_Col_Unit", null)}));
                SysUtil.abort();
            } else if (entryInfo.getBaseUnit() == null) {
                kdtEditManager.editCellAt(rowIndex - 1, nncpTable.getColumnIndex("unit"));
                MsgBox.showWarning((String)QCReportEditUIHelper.getMsg("Value_Empty", new String[]{QCReportEditUIHelper.getMsg("NCCP_Col_BaseUnit", null)}));
                SysUtil.abort();
            }
            if (entryInfo.getQty() == null || entryInfo.getBaseQty() == null) continue;
            totalQty = totalQty.add(entryInfo.getBaseQty());
        }
        if (bizTypeInfo.isIsEnableMRB() || isFromQCBill) {
            return;
        }
        if (totalQty.compareTo(unpassQty) != 0) {
            if (nncpTable.getSelectManager().size() > 0) {
                kdtEditManager.editCellAt(rowIndex - 1, nncpTable.getColumnIndex("qty"));
            }
            MsgBox.showInfo((String)QCReportEditUIHelper.getMsg("nccp_UnpassQtySame", null));
            SysUtil.abort();
        }
    }
}

