/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.common;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.arap.api.IArApBillHeadInfo;
import com.kingdee.eas.scm.common.AbstractWriteBackHandler;
import com.kingdee.eas.scm.common.BizActionEnum;
import com.kingdee.eas.scm.common.SCMBillException;
import com.kingdee.eas.scm.common.util.WriteBackSQLHelper;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.Locale;

public class AP2SubOrderWriteBackHandler
extends AbstractWriteBackHandler {
    private static final String WBRESOURCE = "com.kingdee.eas.scm.common.WBResource";

    @Override
    protected boolean directlyInDB() {
        return true;
    }

    @Override
    protected void doHandle(Context ctx, BizActionEnum bizAction, IObjectValue destBillInfo) throws EASBizException, BOSException, SQLException {
        if (destBillInfo == null) {
            return;
        }
        if (destBillInfo.getInt("billType") == 203) {
            return;
        }
        IArApBillHeadInfo otherBillInfo = (IArApBillHeadInfo)destBillInfo;
        String destBillID = otherBillInfo.getId().toString();
        boolean isPurInvSysParam = WriteBackSQLHelper.getPurInvSysParam(ctx, otherBillInfo.getCompany());
        boolean isApQtyGtPoSysParam = WriteBackSQLHelper.getApQtyGtPoSysParam(ctx, otherBillInfo.getCompany());
        PreparedStatement pstmt = null;
        if (bizAction == BizActionEnum.AUDIT || bizAction == BizActionEnum.SUBMIT) {
            pstmt = this.createPreparedStatement("WB_PO2SubOrder_Audit", WriteBackSQLHelper.createAP2SubOrderWriteSQLDialect(BizActionEnum.AUDIT, ctx, isPurInvSysParam));
        } else if (bizAction == BizActionEnum.UNAUDIT) {
            pstmt = this.createPreparedStatement("WB_PO2SubOrder_UnAudit", WriteBackSQLHelper.createAP2SubOrderWriteSQLDialect(bizAction, ctx, isPurInvSysParam));
        } else {
            return;
        }
        this.executeUpdate(pstmt, new Object[]{destBillID});
        if (bizAction == BizActionEnum.AUDIT) {
            boolean apQtyOverPIQty;
            boolean verifyPurInvQty = true;
            if (otherBillInfo.getCompany() != null && otherBillInfo.getCompany().getId() != null) {
                verifyPurInvQty = WriteBackSQLHelper.isSysParamValue(ctx, otherBillInfo.getCompany().getId().toString(), "AP_025", true);
            }
            if (!(apQtyOverPIQty = WriteBackSQLHelper.isSysParamValue(ctx, otherBillInfo.getCompany().getId().toString(), "AP_OTHERBILL_QtyOverSource", false))) {
                if (12 == otherBillInfo.getInt("sourceBillType")) {
                    verifyPurInvQty = true;
                }
                this.verify(ctx, destBillID, isPurInvSysParam, isApQtyGtPoSysParam, verifyPurInvQty);
            }
        }
    }

    private void verify(Context ctx, String destBillID, boolean isPurInvSysParam, boolean isApQtyGtPoSysParam, boolean verifyPurInvQty) throws SQLException, EASBizException, BOSException {
        StringBuffer selectQuerySQL = new StringBuffer();
        if (verifyPurInvQty) {
            if (!isPurInvSysParam && !isApQtyGtPoSysParam) {
                selectQuerySQL.append("SELECT 1 as FErrType,");
            } else if (isPurInvSysParam && isApQtyGtPoSysParam) {
                selectQuerySQL.append("SELECT 2 as FErrType,");
            } else if (isPurInvSysParam && !isApQtyGtPoSysParam) {
                selectQuerySQL.append("SELECT case when (ISNULL(SUBCONTRACTORDERE.FTOTALRECEIPTQTY,0)-ISNULL(SUBCONTRACTORDERE.FTOTALRETURNSTOCKQTY,0)-ISNULL(SUBCONTRACTORDERE.FQTY,0)) >= 0 then 1 else 2 end  as FErrType,");
            } else if (!isPurInvSysParam && isApQtyGtPoSysParam) {
                return;
            }
        } else {
            if (isApQtyGtPoSysParam) {
                return;
            }
            selectQuerySQL.append("SELECT 1 as FErrType,");
        }
        selectQuerySQL.append("OTHERBILLE.FSEQ AS FSEQ,OTHERBILL.FNUMBER AS FNUMBER, SUBCONTRACTORDER.FNUMBER AS FWBNUMBER,SUBCONTRACTORDERE.FSEQ AS FWBSEQ");
        selectQuerySQL.append(" FROM T_AP_OTHERBILL OTHERBILL INNER JOIN T_AP_OTHERBILLENTRY OTHERBILLE ON OTHERBILL.FID = OTHERBILLE.FPARENTID");
        selectQuerySQL.append(" LEFT OUTER JOIN T_SM_SUBCONTRACTORDERENTRY SUBCONTRACTORDERE ON SUBCONTRACTORDERE.FID = OTHERBILLE.FCOREBILLENTRYID ");
        selectQuerySQL.append(" INNER JOIN T_SM_SUBCONTRACTORDER SUBCONTRACTORDER ON SUBCONTRACTORDER.FID=SUBCONTRACTORDERE.FParentID");
        selectQuerySQL.append(" WHERE OTHERBILL.FID = '").append(destBillID).append("'");
        if (verifyPurInvQty) {
            if (isPurInvSysParam && isApQtyGtPoSysParam) {
                selectQuerySQL.append(" AND ((ISNULL(OTHERBILLE.FQUANTITY,0) > 0 ");
                selectQuerySQL.append("AND ISNULL(SUBCONTRACTORDERE.FTOTALRECEIPTQTY,0)-ISNULL(SUBCONTRACTORDERE.FTOTALRETURNSTOCKQTY,0)-ISNULL(SUBCONTRACTORDERE.FTOTALAPQTY,0) < 0)");
                selectQuerySQL.append(" OR (ISNULL(OTHERBILLE.FQUANTITY,0) < 0 ");
                selectQuerySQL.append(" AND ABS(ISNULL(SUBCONTRACTORDERE.FTOTALRECEIPTQTY,0))-ABS(ISNULL(SUBCONTRACTORDERE.FTOTALRETURNSTOCKQTY,0))-ABS(ISNULL(SUBCONTRACTORDERE.FTOTALAPQTY,0)) < 0 ))");
            } else if (isPurInvSysParam && !isApQtyGtPoSysParam) {
                selectQuerySQL.append(" AND ((ISNULL(SUBCONTRACTORDERE.FTOTALRECEIPTQTY,0)-ISNULL(SUBCONTRACTORDERE.FTOTALRETURNSTOCKQTY,0) >= ISNULL(SUBCONTRACTORDERE.FQTY,0) ");
                selectQuerySQL.append(" AND ((ISNULL(OTHERBILLE.FQUANTITY,0)>0 AND ISNULL(SUBCONTRACTORDERE.FQTY,0)-ISNULL(SUBCONTRACTORDERE.FTOTALAPQTY,0) < 0) ");
                selectQuerySQL.append(" OR (ISNULL(OTHERBILLE.FQUANTITY,0)<0 AND ABS(ISNULL(SUBCONTRACTORDERE.FQTY,0)");
                selectQuerySQL.append(" -(ISNULL(SUBCONTRACTORDERE.FTOTALAPQTY,0) - ISNULL(OTHERBILLE.FQUANTITY,0)))-ABS(ISNULL(OTHERBILLE.FQUANTITY,0))<0)))");
                selectQuerySQL.append(" OR (ISNULL(SUBCONTRACTORDERE.FTOTALRECEIPTQTY,0)-ISNULL(SUBCONTRACTORDERE.FTOTALRETURNSTOCKQTY,0) < ISNULL(SUBCONTRACTORDERE.FQTY,0)");
                selectQuerySQL.append(" AND ((ISNULL(OTHERBILLE.FQUANTITY,0) > 0 ");
                selectQuerySQL.append(" AND ISNULL(SUBCONTRACTORDERE.FTOTALRECEIPTQTY,0)-ISNULL(SUBCONTRACTORDERE.FTOTALRETURNSTOCKQTY,0)-ISNULL(SUBCONTRACTORDERE.FTOTALAPQTY,0) < 0)");
                selectQuerySQL.append(" OR (ISNULL(OTHERBILLE.FQUANTITY,0) < 0 ");
                selectQuerySQL.append(" AND ABS(ISNULL(SUBCONTRACTORDERE.FTOTALRECEIPTQTY,0))-ABS(ISNULL(SUBCONTRACTORDERE.FTOTALRETURNSTOCKQTY,0))");
                selectQuerySQL.append(" -ABS(ISNULL(SUBCONTRACTORDERE.FTOTALAPQTY,0)) < 0 ))))");
            } else if (!isPurInvSysParam && !isApQtyGtPoSysParam) {
                selectQuerySQL.append(" AND ((ISNULL(OTHERBILLE.FQUANTITY,0)>0 AND ISNULL(SUBCONTRACTORDERE.FQTY,0)-ISNULL(SUBCONTRACTORDERE.FTOTALAPQTY,0) < 0) ");
                selectQuerySQL.append(" OR (ISNULL(OTHERBILLE.FQUANTITY,0)<0 AND ABS(ISNULL(SUBCONTRACTORDERE.FQTY,0))");
                selectQuerySQL.append(" -ABS(ISNULL(SUBCONTRACTORDERE.FTOTALAPQTY,0))<0 ))");
            }
            selectQuerySQL.append(" order by SUBCONTRACTORDERE.FSEQ ASC");
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)selectQuerySQL.toString());
            AP2SubOrderWriteBackHandler.verifyAPWriteBack(ctx, rowSet);
        } else {
            if (!isApQtyGtPoSysParam) {
                selectQuerySQL.append(" AND ((ISNULL(OTHERBILLE.FQUANTITY,0)>0 AND ISNULL(SUBCONTRACTORDERE.FQTY,0)-ISNULL(SUBCONTRACTORDERE.FTOTALAPQTY,0) < 0) ");
                selectQuerySQL.append(" OR (ISNULL(OTHERBILLE.FQUANTITY,0)<0 AND ABS(ISNULL(SUBCONTRACTORDERE.FQTY,0))");
                selectQuerySQL.append(" -ABS(ISNULL(SUBCONTRACTORDERE.FTOTALAPQTY,0)) < 0))");
            }
            selectQuerySQL.append(" order by SUBCONTRACTORDERE.FSEQ ASC");
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)selectQuerySQL.toString());
            AP2SubOrderWriteBackHandler.verifyAPWriteBack(ctx, rowSet);
        }
    }

    public static void verifyQtyAtSubmit(Context ctx, String idList, boolean isPurInvSysParam, boolean isApQtyGtPoSysParam, boolean verifyPurInvQty, boolean verifyPiOrSubBill) throws SQLException, EASBizException, BOSException {
        StringBuffer selectQuerySQL = new StringBuffer();
        if (verifyPurInvQty || verifyPiOrSubBill) {
            if (!isPurInvSysParam && !isApQtyGtPoSysParam) {
                selectQuerySQL.append("SELECT 1 as FErrType,");
            } else if (isPurInvSysParam && isApQtyGtPoSysParam) {
                selectQuerySQL.append("SELECT 2 as FErrType,");
            } else if (isPurInvSysParam && !isApQtyGtPoSysParam) {
                selectQuerySQL.append("SELECT case when (ISNULL(SUBCONTRACTORDERE.FTOTALRECEIPTQTY,0)-ISNULL(SUBCONTRACTORDERE.FTOTALRETURNSTOCKQTY,0)-ISNULL(SUBCONTRACTORDERE.FQTY,0)) >= 0 then 1 else 2 end  as FErrType,");
            } else if (!isPurInvSysParam && isApQtyGtPoSysParam) {
                return;
            }
        } else if (!verifyPurInvQty && !verifyPiOrSubBill) {
            if (isApQtyGtPoSysParam) {
                return;
            }
            selectQuerySQL.append("SELECT 1 as FErrType,");
        }
        selectQuerySQL.append("OTHERBILLE.FSEQ AS FSEQ,OTHERBILL.FNUMBER AS FNUMBER, SUBCONTRACTORDER.FNUMBER AS FWBNUMBER,SUBCONTRACTORDERE.FSEQ AS FWBSEQ");
        selectQuerySQL.append(" FROM T_AP_OTHERBILL OTHERBILL INNER JOIN T_AP_OTHERBILLENTRY OTHERBILLE ON OTHERBILL.FID = OTHERBILLE.FPARENTID");
        selectQuerySQL.append(" LEFT OUTER JOIN T_SM_SUBCONTRACTORDERENTRY SUBCONTRACTORDERE ON SUBCONTRACTORDERE.FID = OTHERBILLE.FCOREBILLENTRYID ");
        selectQuerySQL.append(" INNER JOIN T_SM_SUBCONTRACTORDER SUBCONTRACTORDER ON SUBCONTRACTORDER.FID=SUBCONTRACTORDERE.FParentID");
        selectQuerySQL.append(" WHERE OTHERBILL.FID = '").append(idList).append("'");
        if (verifyPurInvQty || verifyPiOrSubBill) {
            if (isPurInvSysParam && isApQtyGtPoSysParam) {
                selectQuerySQL.append(" AND ((ISNULL(OTHERBILLE.FQUANTITY,0) > 0 AND ISNULL(SUBCONTRACTORDERE.FTOTALRECEIPTQTY,0)-ISNULL(SUBCONTRACTORDERE.FTOTALRETURNSTOCKQTY,0)");
                selectQuerySQL.append(" -ISNULL(SUBCONTRACTORDERE.FTOTALAPQTY,0)-ISNULL(OTHERBILLE.FQUANTITY,0) < 0)");
                selectQuerySQL.append(" OR (ISNULL(OTHERBILLE.FQUANTITY,0) < 0 AND ABS(ISNULL(SUBCONTRACTORDERE.FTOTALRECEIPTQTY,0)-ISNULL(SUBCONTRACTORDERE.FTOTALRETURNSTOCKQTY,0)");
                selectQuerySQL.append(" -ISNULL(SUBCONTRACTORDERE.FTOTALAPQTY,0))-ABS(ISNULL(OTHERBILLE.FQUANTITY,0)) < 0))");
            } else if (isPurInvSysParam && !isApQtyGtPoSysParam) {
                selectQuerySQL.append(" AND ((ISNULL(SUBCONTRACTORDERE.FTOTALRECEIPTQTY,0)-ISNULL(SUBCONTRACTORDERE.FTOTALRETURNSTOCKQTY,0) >= ISNULL(SUBCONTRACTORDERE.FQTY,0) ");
                selectQuerySQL.append(" AND ((ISNULL(OTHERBILLE.FQUANTITY,0)>0  AND ISNULL(SUBCONTRACTORDERE.FQTY,0)-ISNULL(SUBCONTRACTORDERE.FTOTALAPQTY,0)-ISNULL(OTHERBILLE.FQUANTITY,0) < 0)");
                selectQuerySQL.append(" OR (ISNULL(OTHERBILLE.FQUANTITY,0)<0  AND ABS(ISNULL(SUBCONTRACTORDERE.FQTY,0)-ISNULL(SUBCONTRACTORDERE.FTOTALAPQTY,0))-ABS(ISNULL(OTHERBILLE.FQUANTITY,0)) < 0)) )");
                selectQuerySQL.append(" OR (ISNULL(SUBCONTRACTORDERE.FTOTALRECEIPTQTY,0)-ISNULL(SUBCONTRACTORDERE.FTOTALRETURNSTOCKQTY,0) < ISNULL(SUBCONTRACTORDERE.FQTY,0)");
                selectQuerySQL.append(" AND ((ISNULL(OTHERBILLE.FQUANTITY,0)>0  AND ISNULL(SUBCONTRACTORDERE.FTOTALRECEIPTQTY,0)-ISNULL(SUBCONTRACTORDERE.FTOTALRETURNSTOCKQTY,0)");
                selectQuerySQL.append(" -ISNULL(SUBCONTRACTORDERE.FTOTALAPQTY,0)-ISNULL(OTHERBILLE.FQUANTITY,0) < 0) ");
                selectQuerySQL.append(" OR (ISNULL(OTHERBILLE.FQUANTITY,0)<0  AND ABS(ISNULL(SUBCONTRACTORDERE.FTOTALRECEIPTQTY,0)-ISNULL(SUBCONTRACTORDERE.FTOTALRETURNSTOCKQTY,0)");
                selectQuerySQL.append(" -ISNULL(SUBCONTRACTORDERE.FTOTALAPQTY,0))-ABS(ISNULL(OTHERBILLE.FQUANTITY,0)) < 0 )) ) )");
            } else if (!isPurInvSysParam && !isApQtyGtPoSysParam) {
                selectQuerySQL.append(" AND ((ISNULL(OTHERBILLE.FQUANTITY,0)>0 AND ISNULL(SUBCONTRACTORDERE.FQTY,0)-ISNULL(SUBCONTRACTORDERE.FTOTALAPQTY,0)-ISNULL(OTHERBILLE.FQUANTITY,0) < 0)");
                selectQuerySQL.append(" OR (ISNULL(OTHERBILLE.FQUANTITY,0)<0 AND ABS(ISNULL(SUBCONTRACTORDERE.FQTY,0)-ISNULL(SUBCONTRACTORDERE.FTOTALAPQTY,0))-ABS(ISNULL(OTHERBILLE.FQUANTITY,0)) < 0))");
            }
            selectQuerySQL.append(" order by SUBCONTRACTORDERE.FSEQ ASC");
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)selectQuerySQL.toString());
            AP2SubOrderWriteBackHandler.verifyAPWriteBack(ctx, rowSet);
        } else if (!verifyPurInvQty && !verifyPiOrSubBill) {
            if (!isApQtyGtPoSysParam) {
                selectQuerySQL.append(" AND ((ISNULL(OTHERBILLE.FQUANTITY,0)>0 AND ISNULL(SUBCONTRACTORDERE.FQTY,0)-ISNULL(SUBCONTRACTORDERE.FTOTALAPQTY,0)-ISNULL(OTHERBILLE.FQUANTITY,0) < 0)");
                selectQuerySQL.append(" OR (ISNULL(OTHERBILLE.FQUANTITY,0)<0 AND ABS(ISNULL(SUBCONTRACTORDERE.FQTY,0)-ISNULL(SUBCONTRACTORDERE.FTOTALAPQTY,0))-ABS(ISNULL(OTHERBILLE.FQUANTITY,0)) < 0))");
            }
            selectQuerySQL.append(" order by SUBCONTRACTORDERE.FSEQ ASC");
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)selectQuerySQL.toString());
            AP2SubOrderWriteBackHandler.verifyAPWriteBack(ctx, rowSet);
        }
    }

    public static void verifyAPWriteBack(Context ctx, IRowSet rs) throws SQLException, SCMBillException {
        StringBuffer sql = new StringBuffer();
        String errorMsg = ResourceBase.getString((String)WBRESOURCE, (String)"WriteBackQtyErrorMsg", (Locale)ctx.getLocale());
        boolean isError = false;
        while (rs.next()) {
            isError = true;
            switch (rs.getInt("FErrType")) {
                case 1: {
                    sql.append(ResourceBase.getString((String)WBRESOURCE, (String)"AP_PURORDERERRO", (Locale)ctx.getLocale())).append("\n");
                    break;
                }
                case 2: {
                    sql.append(ResourceBase.getString((String)WBRESOURCE, (String)"AP_PIORDERERROR", (Locale)ctx.getLocale())).append("\n");
                }
            }
            sql.append(MessageFormat.format(errorMsg, ResourceBase.getString((String)WBRESOURCE, (String)"ARNO", (Locale)ctx.getLocale()), rs.getString("FNumber"), rs.getInt("FSeq"), ResourceBase.getString((String)WBRESOURCE, (String)"SUBORDER", (Locale)ctx.getLocale()), rs.getString("FWBNumber"), rs.getInt("FWBSeq")));
            sql.append("\n");
        }
        if (isError) {
            throw new SCMBillException(SCMBillException.WRITE_BACE_ERROR, new Object[]{sql.toString()});
        }
    }

    @Override
    protected void doHandle(Context ctx, BizActionEnum bizAction, String[] destBillIDs, String[][] srcCoreBillIDs) throws EASBizException, BOSException, SQLException {
        super.doHandle(ctx, bizAction, destBillIDs, srcCoreBillIDs);
    }
}

