/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.common;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.dynbusiness.util.BusinessProcessUtil;
import com.kingdee.eas.fi.arap.api.IArApBillHeadInfo;
import com.kingdee.eas.fi.arap.api.IArapBillEntryInfo;
import com.kingdee.eas.scm.common.AbstractWriteBackHandler;
import com.kingdee.eas.scm.common.BizActionEnum;
import com.kingdee.eas.scm.common.SCMBillException;
import com.kingdee.eas.scm.common.app.util.SCMServerUtil;
import com.kingdee.eas.scm.common.util.KsqlUtil;
import com.kingdee.eas.scm.common.util.WriteBackSQLHelper;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.LowTimer;
import com.kingdee.util.StringUtils;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.HashSet;
import java.util.Locale;
import org.apache.log4j.Logger;

public class AR2SIWriteBackHandler
extends AbstractWriteBackHandler {
    private static Logger logger = Logger.getLogger(AR2SIWriteBackHandler.class);
    private static final String WBRESOURCE = "com.kingdee.eas.scm.common.WBResource";

    @Override
    protected boolean directlyInDB() {
        return true;
    }

    @Override
    protected void doHandle(Context ctx, BizActionEnum bizAction, IObjectValue destBillInfo) throws EASBizException, BOSException, SQLException {
        if (destBillInfo == null) {
            return;
        }
        LowTimer lt = new LowTimer();
        boolean coreBillIsPur = false;
        boolean[] isWriteCore = new boolean[]{true, false, false, false};
        IArApBillHeadInfo otherBillInfo = (IArApBillHeadInfo)destBillInfo;
        IObjectCollection otherBillEntryCollection = otherBillInfo.getEntries();
        HashSet<String> sourceEntryIDSet = new HashSet<String>();
        HashSet<String> coreEntryIDSet = new HashSet<String>();
        int size = otherBillEntryCollection.size();
        for (int i = 0; i < size; ++i) {
            IArapBillEntryInfo otherBillentryInfo = (IArapBillEntryInfo)otherBillEntryCollection.getObject(i);
            if (otherBillentryInfo == null) continue;
            sourceEntryIDSet.add(otherBillentryInfo.getSourceBillEntryId());
            String coreBillTypeID = otherBillentryInfo.getCoreBillTypeId();
            if (coreBillTypeID != null) {
                coreEntryIDSet.add(otherBillentryInfo.getCoreBillEntryId());
                if (coreBillTypeID.equals("510b6503-0105-1000-e000-0113c0a812fd463ED552")) {
                    isWriteCore[1] = true;
                } else if (coreBillTypeID.equals("50957179-0105-1000-e008-8152c0a812fd463ED552")) {
                    isWriteCore[2] = true;
                } else if (coreBillTypeID.equals("Eg5BUQEVEADgAAABwKgOEEY+1VI=")) {
                    isWriteCore[3] = true;
                }
                if (!coreBillTypeID.equals("510b6503-0105-1000-e000-010bc0a812fd463ED552")) continue;
                coreBillIsPur = true;
                continue;
            }
            isWriteCore[1] = true;
        }
        SCMServerUtil.addSQLLock((Context)ctx, sourceEntryIDSet);
        String id = otherBillInfo.getId().toString();
        this.writeBackSaleIssueBill(bizAction, ctx, id);
        if (isWriteCore[1]) {
            this.writeBackOrder(bizAction, ctx, id);
        }
        if (isWriteCore[2]) {
            this.writeBackPurReturns(bizAction, ctx, id);
        }
        if (bizAction == BizActionEnum.AUDIT) {
            boolean isArQtyGtSoSysParam = WriteBackSQLHelper.getArQtyGtSoSysParam(ctx, otherBillInfo.getCompany());
            if (isWriteCore[1] || coreBillIsPur) {
                SCMServerUtil.addSQLLock((Context)ctx, coreEntryIDSet);
                boolean isArQtyGtSiSysParam = true;
                if (otherBillInfo.getCompany() != null && otherBillInfo.getCompany().getId() != null) {
                    isArQtyGtSiSysParam = WriteBackSQLHelper.isSysParamValue(ctx, otherBillInfo.getCompany().getId().toString(), "AR_QTY_CANT_GT_SI", true);
                }
                String idList = WriteBackSQLHelper.getKeyIdList(new String[]{id});
                this.verify(ctx, idList, isArQtyGtSoSysParam, isArQtyGtSiSysParam);
            }
        }
        logger.info((Object)("AR Writeback Total " + otherBillEntryCollection.size() + " Entries: " + lt.msValue()));
    }

    private void writeBackSaleIssueBill(BizActionEnum bizAction, Context ctx, String id) throws SQLException, BOSException {
        Object[] objectArray;
        PreparedStatement ps = null;
        if (bizAction == BizActionEnum.AUDIT) {
            ps = this.createPreparedStatement("WB_SI", WriteBackSQLHelper.createAR2SIWriteSQLDialect(bizAction, ctx));
        } else if (bizAction == BizActionEnum.UNAUDIT) {
            ps = this.createPreparedStatement("WB_SI_UnAduit", WriteBackSQLHelper.createAR2SIWriteSQLDialect(bizAction, ctx));
        }
        if (!KsqlUtil.isSQLServer(ctx)) {
            Object[] objectArray2 = new Object[2];
            objectArray2[0] = id;
            objectArray = objectArray2;
            objectArray2[1] = id;
        } else {
            Object[] objectArray3 = new Object[1];
            objectArray = objectArray3;
            objectArray3[0] = id;
        }
        this.executeUpdate(ps, objectArray);
    }

    private void writeBackOrder(BizActionEnum bizAction, Context ctx, String id) throws SQLException {
        Object[] objectArray;
        PreparedStatement ps = null;
        if (bizAction == BizActionEnum.AUDIT) {
            ps = this.createPreparedStatement("WB_SO", WriteBackSQLHelper.createAR2SOWriteSQLDialect(bizAction, ctx));
        } else if (bizAction == BizActionEnum.UNAUDIT) {
            ps = this.createPreparedStatement("WB_SO_UnAduit", WriteBackSQLHelper.createAR2SOWriteSQLDialect(bizAction, ctx));
        }
        if (!KsqlUtil.isSQLServer(ctx)) {
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = id;
            objectArray2[1] = id;
            objectArray = objectArray2;
            objectArray2[2] = id;
        } else {
            Object[] objectArray3 = new Object[2];
            objectArray3[0] = id;
            objectArray = objectArray3;
            objectArray3[1] = id;
        }
        this.executeUpdate(ps, objectArray);
    }

    private void writeBackPurReturns(BizActionEnum bizAction, Context ctx, String id) throws SQLException {
        Object[] objectArray;
        PreparedStatement ps = null;
        if (bizAction == BizActionEnum.AUDIT) {
            this.createPreparedStatement("WB_SR", WriteBackSQLHelper.createAR2SRWriteSQLDialect(bizAction, ctx));
        } else if (bizAction == BizActionEnum.UNAUDIT) {
            this.createPreparedStatement("WB_SR_UnAduit", WriteBackSQLHelper.createAR2SRWriteSQLDialect(bizAction, ctx));
        }
        if (!KsqlUtil.isSQLServer(ctx)) {
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = id;
            objectArray2[1] = id;
            objectArray = objectArray2;
            objectArray2[2] = id;
        } else {
            Object[] objectArray3 = new Object[2];
            objectArray3[0] = id;
            objectArray = objectArray3;
            objectArray3[1] = id;
        }
        this.executeUpdate(ps, objectArray);
    }

    private void writeBackStockTransferBill(BizActionEnum bizAction, Context ctx, String id) throws SQLException {
        Object[] objectArray;
        PreparedStatement ps = null;
        if (bizAction == BizActionEnum.AUDIT) {
            ps = this.createPreparedStatement("WB_ST", WriteBackSQLHelper.createAR2STWriteSQLDialect(bizAction, ctx));
        } else if (bizAction == BizActionEnum.UNAUDIT) {
            ps = this.createPreparedStatement("WB_ST_UnAduit", WriteBackSQLHelper.createAR2STWriteSQLDialect(bizAction, ctx));
        }
        if (!KsqlUtil.isSQLServer(ctx)) {
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = id;
            objectArray2[1] = id;
            objectArray = objectArray2;
            objectArray2[2] = id;
        } else {
            Object[] objectArray3 = new Object[2];
            objectArray3[0] = id;
            objectArray = objectArray3;
            objectArray3[1] = id;
        }
        this.executeUpdate(ps, objectArray);
    }

    private void verify(Context ctx, String idList, boolean isArQtyGtSoSysParam, boolean isArQtyGtSiSysParam) throws SCMBillException, SQLException, BOSException, EASBizException {
        boolean checkSaleOrderBill = false;
        StringBuffer sb = new StringBuffer();
        sb.append("SELECT 1 FROM T_AR_OTHERBILLENTRY ARE ");
        sb.append("INNER JOIN T_SD_SALEORDERENTRY SOE ON ARE.FCOREBILLENTRYID = SOE.FID ");
        sb.append("INNER JOIN T_SD_SALEORDER SO ON SO.FID = SOE.FPARENTID ");
        sb.append("INNER JOIN T_AR_OTHERBILL AR ON ARE.FPARENTID=AR.FID  ");
        sb.append("WHERE ((so.FIsCentralBalance = 1 and ar.FCompanyId = so.FCompanyOrgUnitID) or (so.FIsCentralBalance = 0 and ar.FCompanyId = soe.FCompanyOrgUnitID)) ");
        sb.append("AND ARE.FPARENTID = ").append(idList);
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sb.toString());
        if (rs.next()) {
            checkSaleOrderBill = true;
        }
        if (checkSaleOrderBill) {
            StringBuffer saleOrderQuery = new StringBuffer();
            if (isArQtyGtSoSysParam && isArQtyGtSiSysParam) {
                saleOrderQuery.append("SELECT 2 as FErrType,");
            } else if (!isArQtyGtSoSysParam && isArQtyGtSiSysParam) {
                saleOrderQuery.append("SELECT case when (ISNULL(SALEORDERE.FTOTALISSUEQTY,0)-ISNULL(SALEORDERE.FTOTALCANCELLINGSTOCKQTY,0)-ISNULL(SALEORDERE.FQTY,0)) >= 0 then 1 else 2 end  as FErrType,");
            } else {
                if (isArQtyGtSoSysParam && !isArQtyGtSiSysParam) {
                    return;
                }
                if (!isArQtyGtSoSysParam && !isArQtyGtSiSysParam) {
                    saleOrderQuery.append("SELECT 1 as FErrType,");
                }
            }
            saleOrderQuery.append(" OTHERBILLE.FSEQ AS FSEQ,OTHERBILL.FNUMBER AS FNUMBER,SALEORDER.FNUMBER AS FWBNUMBER,SALEORDERE.FSEQ AS FWBSEQ");
            saleOrderQuery.append(" FROM T_AR_OTHERBILL OTHERBILL INNER JOIN T_AR_OTHERBILLENTRY OTHERBILLE ON OTHERBILL.FID = OTHERBILLE.FPARENTID");
            saleOrderQuery.append(" LEFT OUTER JOIN T_SD_SALEORDERENTRY SALEORDERE ON SALEORDERE.FID = OTHERBILLE.FCOREBILLENTRYID ");
            saleOrderQuery.append(" INNER JOIN T_SD_SaleOrder SALEORDER ON SALEORDER.FID=SALEORDERE.FParentID");
            saleOrderQuery.append(" WHERE OTHERBILL.FID = ").append(idList);
            if (isArQtyGtSoSysParam && isArQtyGtSiSysParam) {
                saleOrderQuery.append(" AND ISNULL(SALEORDERE.FTOTALISSUEQTY,0)-ISNULL(SALEORDERE.FTOTALCANCELLINGSTOCKQTY,0)-ISNULL(SALEORDERE.FTOTALINVOICEDQTY,0) < 0");
            } else if (!isArQtyGtSoSysParam && isArQtyGtSiSysParam) {
                saleOrderQuery.append(" AND ((ISNULL(SALEORDERE.FTOTALISSUEQTY,0)-ISNULL(SALEORDERE.FTOTALCANCELLINGSTOCKQTY,0) > ISNULL(SALEORDERE.FQTY,0) ");
                saleOrderQuery.append(" AND ISNULL(SALEORDERE.FQTY,0)-ISNULL(SALEORDERE.FTOTALINVOICEDQTY,0) < 0)");
                saleOrderQuery.append(" OR (ISNULL(SALEORDERE.FTOTALISSUEQTY,0)-ISNULL(SALEORDERE.FTOTALCANCELLINGSTOCKQTY,0) <= ISNULL(SALEORDERE.FQTY,0)");
                saleOrderQuery.append(" AND ISNULL(SALEORDERE.FTOTALISSUEQTY,0)-ISNULL(SALEORDERE.FTOTALCANCELLINGSTOCKQTY,0)-ISNULL(SALEORDERE.FTOTALINVOICEDQTY,0) < 0) )");
            } else if (!isArQtyGtSoSysParam && !isArQtyGtSiSysParam) {
                saleOrderQuery.append(" AND ISNULL(SALEORDERE.FQTY,0)-ISNULL(SALEORDERE.FTOTALINVOICEDQTY,0) < 0");
            }
            saleOrderQuery.append(" AND OTHERBILLE.FQUANTITY >= 0 ");
            saleOrderQuery.append(" order by SALEORDERE.FSEQ ASC");
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)saleOrderQuery.toString());
            this.verifyAPWriteBack(ctx, rowSet);
        } else {
            AR2SIWriteBackHandler.verifyCentralBalance(ctx, idList, isArQtyGtSiSysParam);
        }
    }

    public static void verifyCentralBalance(Context ctx, String idList, boolean isArQtyGtSiSysParam) throws SQLException, EASBizException, BOSException {
        if (isArQtyGtSiSysParam) {
            StringBuffer saleOrderQuery = new StringBuffer();
            saleOrderQuery.append("SELECT 2 as FErrType,");
            saleOrderQuery.append(" OTHERBILLE.FSEQ AS FSEQ,OTHERBILL.FNUMBER AS FNUMBER,SALEISSUE.Fnumber as FWBNumber,SALEISSUERE.FSeq as FWBSeq ");
            saleOrderQuery.append(" FROM T_AR_OTHERBILL OTHERBILL INNER JOIN T_AR_OTHERBILLENTRY OTHERBILLE ON OTHERBILL.FID = OTHERBILLE.FPARENTID");
            saleOrderQuery.append(" LEFT OUTER JOIN T_IM_SALEISSUEENTRY SALEISSUERE ON SALEISSUERE.FID = OTHERBILLE.FSOURCEBILLENTRYID ");
            saleOrderQuery.append(" INNER JOIN T_IM_SALEISSUEBILL SALEISSUE ON SALEISSUE.FID=SALEISSUERE.FParentID");
            saleOrderQuery.append(" WHERE OTHERBILL.FID = ").append(idList);
            saleOrderQuery.append(" AND (ISNULL(SALEISSUERE.FQTY,0)-ISNULL(SALEISSUERE.FRETURNSQTY,0)-ISNULL(SALEISSUERE.FDREWQTY ,0) < 0) ");
            saleOrderQuery.append(" AND OTHERBILLE.FQUANTITY >= 0 ");
            saleOrderQuery.append(" order by SALEISSUERE.FSEQ ASC");
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)saleOrderQuery.toString());
            StringBuffer sql = new StringBuffer();
            String errorMsg = ResourceBase.getString((String)WBRESOURCE, (String)"WriteBackQtyErrorMsg", (Locale)ctx.getLocale());
            boolean isError = false;
            while (rowSet.next()) {
                isError = true;
                sql.append(ResourceBase.getString((String)WBRESOURCE, (String)"AR_SALEISSERROR", (Locale)ctx.getLocale())).append("\n");
                sql.append(MessageFormat.format(errorMsg, ResourceBase.getString((String)WBRESOURCE, (String)"ARNO", (Locale)ctx.getLocale()), rowSet.getString("FNUMBER"), rowSet.getInt("FSEQ"), ResourceBase.getString((String)WBRESOURCE, (String)"SALEISSUE", (Locale)ctx.getLocale()), rowSet.getString("FWBNumber"), rowSet.getInt("FWBSeq")));
                sql.append("\n");
            }
            if (isError) {
                throw new SCMBillException(SCMBillException.WRITE_BACE_ERROR, new Object[]{sql.toString()});
            }
        }
    }

    private void verifyAPWriteBack(Context ctx, IRowSet rs) throws SQLException, SCMBillException {
        StringBuffer sql = new StringBuffer();
        String errorMsg = ResourceBase.getString((String)WBRESOURCE, (String)"WriteBackQtyErrorMsg", (Locale)ctx.getLocale());
        boolean isError = false;
        while (rs.next()) {
            isError = true;
            switch (rs.getInt("FErrType")) {
                case 1: {
                    sql.append(ResourceBase.getString((String)WBRESOURCE, (String)"AR_SALEORDERERRO", (Locale)ctx.getLocale())).append("\n");
                    break;
                }
                case 2: {
                    sql.append(ResourceBase.getString((String)WBRESOURCE, (String)"AR_SIORDERERROR", (Locale)ctx.getLocale())).append("\n");
                }
            }
            sql.append(MessageFormat.format(errorMsg, ResourceBase.getString((String)WBRESOURCE, (String)"ARNO", (Locale)ctx.getLocale()), rs.getString("FNumber"), rs.getInt("FSeq"), ResourceBase.getString((String)WBRESOURCE, (String)"SALEORDER", (Locale)ctx.getLocale()), rs.getString("FWBNumber"), rs.getInt("FWBSeq")));
            sql.append("\n");
        }
        if (isError) {
            throw new SCMBillException(SCMBillException.WRITE_BACE_ERROR, new Object[]{sql.toString()});
        }
    }

    private void batchWriteBackSaleIssueBill(BizActionEnum bizAction, String idList, String tablename) throws SQLException, BOSException {
        PreparedStatement ps = null;
        if (bizAction == BizActionEnum.AUDIT) {
            ps = this.createPreparedStatement("WB_SI", WriteBackSQLHelper.createAR2SIWriteSQL(idList, tablename));
        } else if (bizAction == BizActionEnum.UNAUDIT) {
            ps = this.createPreparedStatement("WB_SI_UnAduit", WriteBackSQLHelper.createAR2SIWriteSQL(idList, tablename));
        }
        this.executeUpdate(ps, null);
    }

    private void batchWriteBackOrder(BizActionEnum bizAction, String idList, String tablename) throws SQLException {
        PreparedStatement ps = null;
        if (bizAction == BizActionEnum.AUDIT) {
            ps = this.createPreparedStatement("WB_SO", WriteBackSQLHelper.createAR2SOWriteSQL(bizAction, idList, tablename));
        } else if (bizAction == BizActionEnum.UNAUDIT) {
            ps = this.createPreparedStatement("WB_SO_UnAduit", WriteBackSQLHelper.createAR2SOWriteSQL(bizAction, idList, tablename));
        }
        this.executeUpdate(ps, null);
    }

    private void batchWriteBackPurReturns(BizActionEnum bizAction, String idList, String tablename) throws SQLException {
        PreparedStatement ps = null;
        if (bizAction == BizActionEnum.AUDIT) {
            ps = this.createPreparedStatement("WB_SR", WriteBackSQLHelper.createAR2SRWriteSQL(bizAction, idList, tablename));
        } else if (bizAction == BizActionEnum.UNAUDIT) {
            ps = this.createPreparedStatement("WB_SR_UnAduit", WriteBackSQLHelper.createAR2SRWriteSQL(bizAction, idList, tablename));
        }
        this.executeUpdate(ps, null);
    }

    private void batchWriteBackStockTransferBill(BizActionEnum bizAction, String idList, String tablename) throws SQLException {
        PreparedStatement ps = null;
        if (bizAction == BizActionEnum.AUDIT) {
            ps = this.createPreparedStatement("WB_ST", WriteBackSQLHelper.createAR2STWriteSQL(bizAction, idList, tablename));
        } else if (bizAction == BizActionEnum.UNAUDIT) {
            ps = this.createPreparedStatement("WB_ST_UnAduit", WriteBackSQLHelper.createAR2STWriteSQL(bizAction, idList, tablename));
        }
        this.executeUpdate(ps, null);
    }

    private void verify(String idList, boolean[] isWriteCore, String tablename, boolean isArQtyGtSoSysParam) throws SCMBillException, SQLException {
        String VERIFY = WriteBackSQLHelper.createARWriteBackVerifySQL(idList, isWriteCore, tablename, isArQtyGtSoSysParam, false);
        if (!StringUtils.isEmpty((String)VERIFY)) {
            PreparedStatement ps = this.createPreparedStatement("VERIFY", VERIFY);
            IRowSet rs = this.executeQuery(ps, null);
            WriteBackSQLHelper.verifyARWriteBack(rs);
        }
    }

    private String createTempTableCore(Context ctx, String idList) throws SQLException, BOSException {
        String CR_TEMP = WriteBackSQLHelper.getAR2SOTempTableSQL("xxx");
        String tablename = KsqlUtil.createTempTable(ctx, CR_TEMP);
        PreparedStatement ps = null;
        String WB_TEMP = WriteBackSQLHelper.getAR2SOInsertTempSQL(idList, tablename);
        ps = this.createPreparedStatement("WB_TEMP", WB_TEMP);
        this.executeUpdate(ps, null);
        if (ps != null) {
            ps.close();
        }
        return tablename;
    }

    private String createTempTableSource(Context ctx, BizActionEnum bizAction, String idList) throws SQLException, BOSException {
        String CR_TEMP_S = WriteBackSQLHelper.getAR2SITempTableSQL("xxx");
        String tablename = KsqlUtil.createTempTable(ctx, CR_TEMP_S);
        PreparedStatement ps = null;
        String WB_TEMP_S = WriteBackSQLHelper.getAR2SIInsertTempSQL(bizAction, idList, tablename);
        if (bizAction == BizActionEnum.AUDIT) {
            ps = this.createPreparedStatement("WB_TEMP_S", WB_TEMP_S);
        } else if (bizAction == BizActionEnum.UNAUDIT) {
            ps = this.createPreparedStatement("WB_TEMP_S_UnAduit", WB_TEMP_S);
        }
        this.executeUpdate(ps, null);
        return tablename;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doHandle(Context ctx, BizActionEnum bizAction, String[] billId, String[][] ids) throws EASBizException, BOSException, SQLException {
        String tablename_source;
        String tablename_core;
        String idList;
        LowTimer lt;
        block17: {
            lt = new LowTimer();
            boolean[] isWriteCore = new boolean[]{false, false, false, false};
            boolean coreBillIsPur = false;
            int size = ids.length;
            for (int i = 0; i < size; ++i) {
                BOSObjectType coreBosTypeObj;
                BOSObjectType bOSObjectType = coreBosTypeObj = ids[i][1] == null ? null : BOSUuid.read((String)ids[i][1]).getType();
                if (coreBosTypeObj == null) continue;
                String coreBosType = coreBosTypeObj.toString();
                if (coreBosType.equals("C48A423A")) {
                    isWriteCore[1] = true;
                } else if (coreBosType.equals("546F192F")) {
                    isWriteCore[2] = true;
                } else if (coreBosType.equals("2239F30A")) {
                    isWriteCore[3] = true;
                }
                if (!coreBosType.equals("3171BFAD")) continue;
                coreBillIsPur = true;
            }
            idList = WriteBackSQLHelper.getKeyIdList(billId);
            HashSet<String> sourceEntryIDSet = new HashSet<String>();
            HashSet<String> coreEntryIDSet = new HashSet<String>();
            String selectSql = "SELECT FSOURCEBILLENTRYID ,FCOREBILLENTRYID  FROM T_AR_OTHERBILLENTRY where FPARENTID in (" + idList + ")";
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)selectSql);
            String sourceEntryId = null;
            String coreEntryId = null;
            while (rowSet.next()) {
                sourceEntryId = rowSet.getString("FSOURCEBILLENTRYID");
                coreEntryId = rowSet.getString("FCOREBILLENTRYID");
                if (!StringUtils.isEmpty((String)sourceEntryId)) {
                    sourceEntryIDSet.add(sourceEntryId);
                }
                if (StringUtils.isEmpty((String)coreEntryId)) continue;
                coreEntryIDSet.add(coreEntryId);
            }
            if (!sourceEntryIDSet.isEmpty()) {
                SCMServerUtil.addSQLLock((Context)ctx, sourceEntryIDSet);
            }
            if ((isWriteCore[1] || isWriteCore[2]) && !coreEntryIDSet.isEmpty()) {
                SCMServerUtil.addSQLLock((Context)ctx, coreEntryIDSet);
            }
            tablename_core = null;
            tablename_source = null;
            try {
                tablename_core = this.createTempTableCore(ctx, idList);
                tablename_source = this.createTempTableSource(ctx, bizAction, idList);
                SCMServerUtil.addSQLLockByTmpTable((Context)ctx, (String)"T_IM_SaleIssueEntry", (String)tablename_source, (String)"FSourceBillEntryId");
                this.batchWriteBackSaleIssueBill(bizAction, idList, tablename_source);
                if (isWriteCore[1]) {
                    SCMServerUtil.addSQLLockByTmpTable((Context)ctx, (String)"T_SD_SaleOrderEntry", (String)tablename_core, (String)"FCoreBillEntryId");
                    this.batchWriteBackOrder(bizAction, idList, tablename_core);
                }
                if (isWriteCore[2]) {
                    SCMServerUtil.addSQLLockByTmpTable((Context)ctx, (String)"T_SD_SaleReturnsEntry", (String)tablename_core, (String)"FCoreBillEntryId");
                    this.batchWriteBackPurReturns(bizAction, idList, tablename_core);
                }
                if (bizAction != BizActionEnum.AUDIT) break block17;
                SelectorItemCollection sic = new SelectorItemCollection();
                sic.add(new SelectorItemInfo("id"));
                sic.add(new SelectorItemInfo("company.id"));
                IArApBillHeadInfo otherBillInfo = (IArApBillHeadInfo)BusinessProcessUtil.getValueByBosType((Context)ctx, (IObjectPK)new ObjectUuidPK(billId[0]), (SelectorItemCollection)sic);
                boolean isArQtyGtSoSysParam = WriteBackSQLHelper.getArQtyGtSoSysParam(ctx, otherBillInfo.getCompany());
                if (isWriteCore[3]) {
                    this.verify(idList, isWriteCore, tablename_core, isArQtyGtSoSysParam);
                }
                if (isWriteCore[1] || coreBillIsPur) {
                    boolean isArQtyGtSiSysParam = true;
                    if (otherBillInfo.getCompany() != null && otherBillInfo.getCompany().getId() != null) {
                        isArQtyGtSiSysParam = WriteBackSQLHelper.isSysParamValue(ctx, otherBillInfo.getCompany().getId().toString(), "AR_QTY_CANT_GT_SI", true);
                    }
                    this.verify(ctx, idList, isArQtyGtSoSysParam, isArQtyGtSiSysParam);
                }
            }
            catch (Throwable throwable) {
                KsqlUtil.releaseTempTable(ctx, tablename_source);
                KsqlUtil.releaseTempTable(ctx, tablename_core);
                throw throwable;
            }
        }
        KsqlUtil.releaseTempTable(ctx, tablename_source);
        KsqlUtil.releaseTempTable(ctx, tablename_core);
        logger.info((Object)("AR Writeback Total " + idList.length() + " Bills: " + lt.msValue()));
    }

    private void dropTempTable(Context ctx, String temptable) throws BOSException {
        KsqlUtil.releaseTempTable(ctx, temptable);
    }
}

