/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.common;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.basedata.assistant.ConvertModeEnum;
import com.kingdee.eas.basedata.assistant.MeasureUnitInfo;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.SysConstant;
import com.kingdee.eas.scm.common.app.SCMServerUtils;
import com.kingdee.eas.scm.common.util.CalculateUtils;
import com.kingdee.eas.scm.common.util.SCMConstant;
import java.math.BigDecimal;
import org.apache.log4j.Logger;

public abstract class AbstractAlgorithm {
    protected Context ctx = null;
    private static final Logger logger = CoreUIObject.getLogger(AbstractAlgorithm.class);

    public void calTotalFields() {
        this.calTotalAmount();
        this.calTotalLocalAmount();
        this.calTotalTax();
        this.calTotalLocalTax();
        this.calTotalTaxAmount();
        this.calTotallocalTaxAmount();
    }

    protected abstract void calTotallocalTaxAmount();

    protected abstract void calTotalLocalTax();

    protected abstract void calTotalLocalAmount();

    protected abstract void calByAmount(int var1);

    protected abstract void calByPrice(int var1);

    protected abstract void calByTaxAmount(int var1);

    protected abstract void calByTaxPrice(int var1);

    protected abstract void calTotalAmount();

    protected abstract void calTotalTax();

    protected abstract void calTotalTaxAmount();

    protected abstract BigDecimal getAmount(int var1);

    protected abstract int getAmountPrecision();

    protected abstract MeasureUnitInfo getAssistUnit(int var1);

    protected abstract MeasureUnitInfo getBaseUnit(int var1);

    protected abstract BigDecimal getBaseQty(int var1);

    protected abstract ConvertModeEnum getConvertMode();

    protected abstract BigDecimal getDiscountAmount(int var1);

    protected abstract BigDecimal getDiscountRate(int var1);

    protected abstract BigDecimal getExchangeRate();

    protected abstract int getLocalAmountPrecision();

    protected abstract MaterialInfo getMaterial(int var1);

    protected abstract BigDecimal getPrice(int var1);

    protected abstract int getPricePrecision(int var1);

    protected abstract BigDecimal getQty(int var1);

    protected BigDecimal getRealTaxRate(int i) {
        return this.getTaxRate(i).divide(SCMConstant.BIGDECIMAL_ONEHUNDRED, 10, 4);
    }

    protected abstract BigDecimal getTax(int var1);

    protected abstract BigDecimal getTaxAmount(int var1);

    protected abstract BigDecimal getTaxPrice(int var1);

    protected abstract BigDecimal getTaxRate(int var1);

    protected abstract MeasureUnitInfo getUnit(int var1);

    protected abstract boolean isInTax();

    protected abstract boolean isPriceInTax();

    protected BigDecimal nullToZero(BigDecimal value) {
        if (value == null) {
            return SysConstant.BIGZERO;
        }
        return value;
    }

    protected abstract void setActualPrice(BigDecimal var1, int var2);

    protected abstract void setActualTaxPrice(BigDecimal var1, int var2);

    protected abstract void setAmount(BigDecimal var1, int var2);

    protected abstract void setAssistQty(BigDecimal var1, int var2);

    protected abstract void setBaseQty(BigDecimal var1, int var2);

    protected abstract void setDiscountAmount(BigDecimal var1, int var2);

    protected abstract void setLocalAmount(BigDecimal var1, int var2);

    protected abstract void setLocalTax(BigDecimal var1, int var2);

    protected abstract void setLocalTaxAmount(BigDecimal var1, int var2);

    protected abstract void setPrice(BigDecimal var1, int var2);

    protected abstract void setTax(BigDecimal var1, int var2);

    protected abstract void setTaxAmount(BigDecimal var1, int var2);

    protected abstract void setTaxPrice(BigDecimal var1, int var2);

    protected abstract int getEntrySize();

    protected void reCalEntryFields() throws EASBizException, BOSException {
        for (int i = 0; i < this.getEntrySize(); ++i) {
            if (this.isInTax()) {
                logger.info((Object)"AbstractAlgorithm.isInTax()");
                if (SysConstant.BIGZERO.compareTo(this.getTaxPrice(i)) != 0) {
                    logger.info((Object)"AbstractAlgorithm.calByTaxPrice()");
                    this.setTaxPrice(this.getTaxPrice(i).abs().setScale(this.getPricePrecision(i), 4), i);
                    this.calByTaxPrice(i);
                    continue;
                }
                if (SysConstant.BIGZERO.compareTo(this.getTaxAmount(i)) != 0) {
                    logger.info((Object)"AbstractAlgorithm.calByTaxAmount()");
                    this.setTaxAmount(this.getTaxAmount(i).abs().setScale(this.getAmountPrecision(), 4), i);
                    this.calByTaxAmount(i);
                    continue;
                }
                logger.info((Object)"AbstractAlgorithm.calByTaxPrice()");
                this.setTaxPrice(SysConstant.BIGZERO.setScale(this.getPricePrecision(i)), i);
                this.calByTaxPrice(i);
                continue;
            }
            logger.info((Object)"AbstractAlgorithm.isNotInTax()");
            if (SysConstant.BIGZERO.compareTo(this.getPrice(i)) != 0) {
                logger.info((Object)"AbstractAlgorithm.calByPrice()");
                this.setPrice(this.getPrice(i).abs().setScale(this.getPricePrecision(i), 4), i);
                this.calByPrice(i);
                continue;
            }
            if (SysConstant.BIGZERO.compareTo(this.getAmount(i)) != 0) {
                logger.info((Object)"AbstractAlgorithm.calByAmount()");
                this.setAmount(this.getAmount(i).abs().setScale(this.getAmountPrecision(), 4), i);
                this.calByAmount(i);
                continue;
            }
            logger.info((Object)"AbstractAlgorithm.setPrice()");
            this.setPrice(SysConstant.BIGZERO.setScale(this.getPricePrecision(i)), i);
            this.calByPrice(i);
        }
    }

    protected void calPriceByAmount(int i) {
        BigDecimal amount = this.getAmount(i);
        BigDecimal qty = this.getQty(i);
        BigDecimal discountRate = this.getDiscountRate(i);
        int scale = this.getPricePrecision(i);
        BigDecimal price = CalculateUtils.calPrice(amount, qty, discountRate, scale);
        this.setPrice(price, i);
    }

    protected void calTaxPrice(int i) {
        if (this.isInTax()) {
            BigDecimal discountRate = this.getDiscountRate(i);
            BigDecimal qty = this.getQty(i);
            BigDecimal taxAmount = this.getTaxAmount(i);
            int scale = this.getPricePrecision(i);
            BigDecimal taxPrice = null;
            if (qty != null && qty.compareTo(SysConstant.BIGZERO) != 0) {
                if (discountRate == null) {
                    discountRate = SysConstant.BIGZERO;
                }
                discountRate = SCMConstant.BIGDECIMAL_ONE.subtract(discountRate.divide(SCMConstant.BIGDECIMAL_ONEHUNDRED, 10, 4));
                if (taxAmount != null && qty != null && SysConstant.BIGZERO.compareTo(qty) != 0 && SysConstant.BIGZERO.compareTo(discountRate) != 0) {
                    taxPrice = taxAmount.divide(qty, 10, 4);
                    taxPrice = taxPrice.divide(discountRate, scale, 4);
                }
                this.setTaxPrice(taxPrice, i);
            }
        } else {
            BigDecimal price = this.getPrice(i);
            BigDecimal taxRate = this.getTaxRate(i);
            int scale = this.getPricePrecision(i);
            BigDecimal taxPrice = CalculateUtils.calTaxPrice(price, taxRate, scale);
            this.setTaxPrice(taxPrice, i);
        }
    }

    protected void calTax(int i) {
        int scale = this.getAmountPrecision();
        if (this.isInTax()) {
            BigDecimal taxAmount = this.getTaxAmount(i);
            BigDecimal taxRate = this.getTaxRate(i);
            BigDecimal tax = SysConstant.BIGZERO;
            if (taxAmount != null && taxRate != null) {
                taxRate = taxRate.divide(SCMConstant.BIGDECIMAL_ONEHUNDRED, 10, 4);
                tax = taxAmount.divide(taxRate.add(SCMConstant.BIGDECIMAL_ONE), 10, 4).multiply(taxRate);
                if (!this.isPriceInTax()) {
                    tax = taxAmount.multiply(taxRate);
                }
                tax = tax.setScale(scale, 4);
            }
            this.setTax(tax, i);
        } else {
            BigDecimal taxRate;
            BigDecimal tax;
            BigDecimal amount = this.getAmount(i);
            if (amount == null) {
                amount = SysConstant.BIGZERO;
            }
            if ((tax = CalculateUtils.calTax(amount, taxRate = this.getTaxRate(i), scale)) != null) {
                this.setTax(tax, i);
            } else {
                this.setTax(SysConstant.BIGZERO, i);
            }
        }
    }

    protected void calTaxAmount(int i) {
        int scale = this.getAmountPrecision();
        if (this.isInTax()) {
            BigDecimal taxPrice = this.getTaxPrice(i);
            BigDecimal qty = this.getQty(i);
            BigDecimal discountAmount = this.getDiscountAmount(i);
            BigDecimal taxAmount = taxPrice.multiply(qty).subtract(discountAmount);
            taxAmount = taxAmount.setScale(scale, 4);
            this.setTaxAmount(taxAmount, i);
        } else {
            BigDecimal amount = this.getAmount(i);
            BigDecimal tax = this.getTax(i);
            BigDecimal taxAmount = amount.add(tax);
            taxAmount = taxAmount.setScale(scale, 4);
            this.setTaxAmount(taxAmount, i);
        }
    }

    protected void calDiscountAmount(int i) {
        int scale = this.getAmountPrecision();
        BigDecimal taxPrice = this.getTaxPrice(i);
        BigDecimal qty = this.getQty(i);
        BigDecimal discountRate = this.getDiscountRate(i);
        BigDecimal discountAmount = taxPrice.multiply(qty).multiply(discountRate.divide(SCMConstant.BIGDECIMAL_ONEHUNDRED, 10, 4)).setScale(scale, 4);
        this.setDiscountAmount(discountAmount, i);
    }

    protected void calActualTaxPrice(int i) {
        BigDecimal discountRate = this.getDiscountRate(i);
        int scale = this.getPricePrecision(i);
        if (SysConstant.BIGZERO.compareTo(discountRate) == 0) {
            BigDecimal taxPrice = this.getTaxPrice(i);
            this.setActualTaxPrice(taxPrice, i);
        } else {
            BigDecimal taxAmount = this.getTaxAmount(i);
            BigDecimal qty = this.getQty(i);
            BigDecimal actualTaxPrice = SysConstant.BIGZERO;
            if (taxAmount != null && qty != null && SysConstant.BIGZERO.compareTo(qty) != 0) {
                actualTaxPrice = taxAmount.divide(qty, scale, 4);
                this.setActualTaxPrice(actualTaxPrice, i);
            }
        }
    }

    protected void calActualPrice(int i) {
        int scale = this.getPricePrecision(i);
        BigDecimal amount = this.getAmount(i);
        BigDecimal qty = this.getQty(i);
        BigDecimal discountRate = this.getDiscountRate(i);
        if (discountRate == null || SysConstant.BIGZERO.compareTo(discountRate) == 0) {
            BigDecimal price = this.getPrice(i);
            this.setActualPrice(price, i);
        } else if (amount != null && qty != null && SysConstant.BIGZERO.compareTo(qty) != 0) {
            BigDecimal actualPrice = amount.divide(qty, scale, 4);
            this.setActualPrice(actualPrice, i);
        }
    }

    protected void calLocalAmount(int i) {
        int scale = this.getLocalAmountPrecision();
        BigDecimal amount = this.getAmount(i);
        BigDecimal exchangerate = this.getExchangeRate();
        if (SysConstant.BIGZERO.compareTo(exchangerate) != 0) {
            if (this.getConvertMode() != null && this.getConvertMode() == ConvertModeEnum.DIRECTEXCHANGERATE) {
                this.setLocalAmount(amount.multiply(exchangerate).setScale(scale, 4), i);
            } else if (SysConstant.BIGZERO.compareTo(exchangerate) != 0) {
                this.setLocalAmount(amount.divide(exchangerate, scale, 4), i);
            }
        } else {
            this.setLocalAmount(amount, i);
        }
    }

    protected void calLocalTax(int i) {
        int scale = this.getLocalAmountPrecision();
        BigDecimal tax = this.getTax(i);
        BigDecimal exchangerate = this.getExchangeRate();
        if (SysConstant.BIGZERO.compareTo(exchangerate) != 0) {
            if (this.getConvertMode() != null && this.getConvertMode() == ConvertModeEnum.DIRECTEXCHANGERATE) {
                this.setLocalTax(tax.multiply(exchangerate).setScale(scale, 4), i);
            } else if (SysConstant.BIGZERO.compareTo(exchangerate) != 0) {
                this.setLocalTax(tax.divide(exchangerate, scale, 4), i);
            }
        } else {
            this.setLocalTax(tax, i);
        }
    }

    protected void calLocalTaxAmount(int i) {
        int scale = this.getLocalAmountPrecision();
        BigDecimal taxAmount = this.getTaxAmount(i);
        BigDecimal exchangerate = this.getExchangeRate();
        if (SysConstant.BIGZERO.compareTo(this.getExchangeRate()) != 0) {
            if (this.getConvertMode() != null && this.getConvertMode() == ConvertModeEnum.DIRECTEXCHANGERATE) {
                this.setLocalTaxAmount(taxAmount.multiply(exchangerate).setScale(scale, 4), i);
            } else if (SysConstant.BIGZERO.compareTo(exchangerate) != 0) {
                this.setLocalTaxAmount(taxAmount.divide(exchangerate, scale, 4), i);
            }
        } else {
            this.setLocalTaxAmount(taxAmount, i);
        }
    }

    protected void calTaxPricebyPrice(int i) {
        BigDecimal price = this.getPrice(i);
        BigDecimal taxRate = this.getTaxRate(i);
        int scale = this.getPricePrecision(i);
        BigDecimal taxPrice = CalculateUtils.calTaxPrice(price, taxRate, scale);
        if (!this.isPriceInTax()) {
            taxPrice = CalculateUtils.calTaxPriceByPurchaseCost(price, taxRate, scale);
        }
        this.setTaxPrice(taxPrice, i);
    }

    protected void calAmount(int i) {
        int scale = this.getAmountPrecision();
        if (this.isInTax()) {
            BigDecimal taxAmount = this.getTaxAmount(i);
            BigDecimal tax = this.getTax(i);
            this.setAmount(SysConstant.BIGZERO, i);
            if (taxAmount != null && tax != null) {
                BigDecimal actualTaxPrice = taxAmount.subtract(tax);
                actualTaxPrice = actualTaxPrice.setScale(scale, 4);
                this.setAmount(actualTaxPrice, i);
            }
        } else {
            BigDecimal price = this.getPrice(i);
            BigDecimal discountRate = this.getDiscountRate(i);
            BigDecimal qty = this.getQty(i);
            BigDecimal amount = qty.multiply(price).multiply(SCMConstant.BIGDECIMAL_ONE.subtract(discountRate.divide(SCMConstant.BIGDECIMAL_ONEHUNDRED, 10, 4)));
            amount = amount.setScale(scale, 4);
            this.setAmount(amount, i);
        }
    }

    protected void calPriceByTaxPrice(int i) {
        BigDecimal taxPrice = this.getTaxPrice(i);
        BigDecimal taxRate = this.getTaxRate(i);
        int scale = this.getPricePrecision(i);
        BigDecimal price = SysConstant.BIGZERO;
        logger.info((Object)("AbstractAlgorithm.calPriceByTaxPrice.taxPrice:" + taxPrice));
        logger.info((Object)("AbstractAlgorithm.calPriceByTaxPrice.scale:" + scale));
        if (this.isPriceInTax()) {
            price = CalculateUtils.calPrice(taxPrice, taxRate, scale);
            logger.info((Object)("AbstractAlgorithm.calPriceByTaxPrice.price1:" + price));
        } else {
            price = CalculateUtils.calPriceIsPriceInTax(taxRate, taxPrice, scale);
            logger.info((Object)("AbstractAlgorithm.calPriceByTaxPrice.price2:" + price));
        }
        this.setPrice(price, i);
    }

    protected void calBaseQtyByQty(int i) throws EASBizException, BOSException {
        MaterialInfo materialInfo = this.getMaterial(i);
        BigDecimal qty = this.getQty(i);
        if (qty.compareTo(SysConstant.BIGZERO) <= 0) {
            return;
        }
        BigDecimal baseQty = SysConstant.BIGZERO;
        if (materialInfo != null && this.getUnit(i) != null && this.getUnit(i).getId() != null && this.getBaseUnit(i) != null && this.getBaseUnit(i).getId() != null) {
            baseQty = SCMServerUtils.getUnitQty((Context)this.ctx, (BigDecimal)qty, (String)materialInfo.getId().toString(), (String)this.getUnit(i).getId().toString(), (String)this.getBaseUnit(i).getId().toString());
            this.setBaseQty(baseQty, i);
        }
    }

    protected void calAssistQtyByQty(int i) throws EASBizException, BOSException {
        MaterialInfo materialInfo = this.getMaterial(i);
        BigDecimal qty = this.getQty(i);
        if (qty.compareTo(SysConstant.BIGZERO) <= 0) {
            return;
        }
        BigDecimal assistQty = SysConstant.BIGZERO;
        if (materialInfo != null && this.getUnit(i) != null && this.getUnit(i).getId() != null && this.getAssistUnit(i) != null && this.getAssistUnit(i).getId() != null) {
            assistQty = SCMServerUtils.getUnitQty((Context)this.ctx, (BigDecimal)qty, (String)materialInfo.getId().toString(), (String)this.getUnit(i).getId().toString(), (String)this.getAssistUnit(i).getId().toString());
            this.setAssistQty(assistQty, i);
        }
    }
}

