/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.common;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.ITableManagerFacade;
import com.kingdee.eas.common.TableManagerFacadeFactory;
import com.kingdee.eas.scm.common.AbstractWriteBackHandler;
import com.kingdee.eas.scm.common.BizActionEnum;
import com.kingdee.eas.scm.common.SCMBillException;
import com.kingdee.eas.scm.common.util.WriteBackFromCarryBillSQLHelper;
import com.kingdee.eas.scm.common.util.WriteBackSQLHelper;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.sql.PreparedStatement;
import java.sql.SQLException;

public class CB2PRQWriteBackHandler
extends AbstractWriteBackHandler {
    @Override
    protected boolean directlyInDB() {
        return true;
    }

    private void batchWriteBackPostRequisitionBill(BizActionEnum bizAction, String idList, String tablename) throws SQLException, BOSException {
        PreparedStatement ps = null;
        if (bizAction == BizActionEnum.AUDIT) {
            ps = this.createPreparedStatement("WB_PRQ_Audit", WriteBackFromCarryBillSQLHelper.createCB2PRQWriteSQL(bizAction, idList, tablename));
        } else if (bizAction == BizActionEnum.UNAUDIT) {
            ps = this.createPreparedStatement("WB_PRQ_UnAduit", WriteBackFromCarryBillSQLHelper.createCB2PRQWriteSQL(bizAction, idList, tablename));
        }
        this.executeUpdate(ps, null);
    }

    private void batchWriteBackSaleOrder(BizActionEnum bizAction, String idList, String tablename) throws SQLException {
        PreparedStatement ps = null;
        if (bizAction == BizActionEnum.AUDIT) {
            ps = this.createPreparedStatement("WB_SO_Audit", WriteBackFromCarryBillSQLHelper.createCB2SOWriteSQL4FromPRQ(bizAction, idList, tablename));
        } else if (bizAction == BizActionEnum.UNAUDIT) {
            ps = this.createPreparedStatement("WB_SO_UnAduit", WriteBackFromCarryBillSQLHelper.createCB2SOWriteSQL4FromPRQ(bizAction, idList, tablename));
        }
        this.executeUpdate(ps, null);
    }

    private void batchWriteBackStockTransfer(BizActionEnum bizAction, String idList, String tablename) throws SQLException {
        PreparedStatement ps = null;
        if (bizAction == BizActionEnum.AUDIT) {
            ps = this.createPreparedStatement("WB_ST_Audit", WriteBackFromCarryBillSQLHelper.createCB2STWriteSQL(bizAction, idList, tablename));
        } else if (bizAction == BizActionEnum.UNAUDIT) {
            ps = this.createPreparedStatement("WB_ST_UnAduit", WriteBackFromCarryBillSQLHelper.createCB2STWriteSQL(bizAction, idList, tablename));
        }
        this.executeUpdate(ps, null);
    }

    private void batchWriteBackPurOrder(BizActionEnum bizAction, String idList, String tablename) throws SQLException {
        PreparedStatement ps = null;
        if (bizAction == BizActionEnum.AUDIT) {
            ps = this.createPreparedStatement("WB_PO_Audit", WriteBackFromCarryBillSQLHelper.createCB2POWriteSQL(bizAction, idList, tablename));
        } else if (bizAction == BizActionEnum.UNAUDIT) {
            ps = this.createPreparedStatement("WB_PO_UnAduit", WriteBackFromCarryBillSQLHelper.createCB2POWriteSQL(bizAction, idList, tablename));
        }
        this.executeUpdate(ps, null);
    }

    private void batchWriteBackTransferOrder(BizActionEnum bizAction, String idList, String tablename) throws SQLException {
        PreparedStatement ps = null;
        if (bizAction == BizActionEnum.AUDIT) {
            ps = this.createPreparedStatement("WB_TO_Audit", WriteBackFromCarryBillSQLHelper.createCB2TOWriteSQL(bizAction, idList, tablename));
        } else if (bizAction == BizActionEnum.UNAUDIT) {
            ps = this.createPreparedStatement("WB_TO_UnAduit", WriteBackFromCarryBillSQLHelper.createCB2TOWriteSQL(bizAction, idList, tablename));
        }
        this.executeUpdate(ps, null);
    }

    private void verify(Context ctx, String idList, boolean[] isWriteCore, String tablename) throws SCMBillException, SQLException {
        String VERIFY = WriteBackFromCarryBillSQLHelper.createCBWriteBackVerifySQL(ctx, idList, isWriteCore, tablename, false);
        if (!StringUtils.isEmpty((String)VERIFY)) {
            PreparedStatement ps = this.createPreparedStatement("VERIFY", VERIFY);
            IRowSet rs = this.executeQuery(ps, null);
            WriteBackFromCarryBillSQLHelper.verifyCBWriteBack(rs);
        }
    }

    private String createTempTableCore(Context ctx, String idList) throws SQLException, BOSException {
        ITableManagerFacade iTableManager = TableManagerFacadeFactory.getLocalInstance((Context)ctx);
        String tablename = iTableManager.getTableName("WRITEBACK_CB2SO");
        String CR_TEMP = WriteBackFromCarryBillSQLHelper.getCB2SOTempTableSQL(tablename);
        iTableManager.createTempTable(CR_TEMP);
        PreparedStatement ps = null;
        String WB_TEMP = WriteBackFromCarryBillSQLHelper.getCB2SOInsertTempSQL(idList, tablename);
        ps = this.createPreparedStatement("WB_TEMP", WB_TEMP);
        this.executeUpdate(ps, null);
        return tablename;
    }

    private String createTempTableSource(Context ctx, BizActionEnum bizAction, String idList) throws SQLException, BOSException {
        ITableManagerFacade iTableManager = TableManagerFacadeFactory.getLocalInstance((Context)ctx);
        String tablename = iTableManager.getTableName("WRITEBACK_CB2PRQ");
        String CR_TEMP = WriteBackFromCarryBillSQLHelper.getCB2PRQTempTableSQL(tablename);
        iTableManager.createTempTable(CR_TEMP);
        String WB_TEMP = WriteBackFromCarryBillSQLHelper.getCB2PRQInsertTempSQL(idList, tablename);
        PreparedStatement ps = this.createPreparedStatement("WB_TEMP", WB_TEMP);
        this.executeUpdate(ps, null);
        return tablename;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doHandle(Context ctx, BizActionEnum bizAction, String[] billId, String[][] ids) throws EASBizException, BOSException, SQLException {
        boolean[] isWriteCore = new boolean[]{true, false, false, false, false};
        int size = ids.length;
        for (int i = 0; i < size; ++i) {
            String coreBosType;
            BOSObjectType coreBosTypeObj;
            BOSObjectType bOSObjectType = coreBosTypeObj = ids[i][1] == null ? null : BOSUuid.read((String)ids[i][1]).getType();
            if (coreBosTypeObj == null || (coreBosType = coreBosTypeObj.toString()) == null) continue;
            if (coreBosType.equals("C48A423A")) {
                isWriteCore[1] = true;
                continue;
            }
            if (coreBosType.equals("2239F30A")) {
                isWriteCore[2] = true;
                continue;
            }
            if (coreBosType.equals("3171BFAD")) {
                isWriteCore[3] = true;
                continue;
            }
            if (!coreBosType.equals("5C2A1F0C")) continue;
            isWriteCore[4] = true;
        }
        String idList = WriteBackSQLHelper.getKeyIdList(billId);
        String tablename_core = null;
        String tablename_source = null;
        try {
            ITableManagerFacade iTableManager = TableManagerFacadeFactory.getLocalInstance((Context)ctx);
            tablename_source = iTableManager.getTableName("WRITEBACK_CB2PRQ");
            String CR_TEMP = WriteBackFromCarryBillSQLHelper.getCB2PRQTempTableSQL(tablename_source);
            iTableManager.createTempTable(CR_TEMP);
            String WB_TEMP = WriteBackFromCarryBillSQLHelper.getCB2PRQInsertTempSQL(idList, tablename_source);
            PreparedStatement ps = this.createPreparedStatement("WB_TEMP", WB_TEMP);
            this.executeUpdate(ps, null);
            tablename_core = iTableManager.getTableName("WRITEBACK_CB2SO");
            String CR_TEMP2 = WriteBackFromCarryBillSQLHelper.getCB2SOTempTableSQL(tablename_core);
            iTableManager.createTempTable(CR_TEMP2);
            PreparedStatement ps2 = null;
            String WB_TEMP2 = WriteBackFromCarryBillSQLHelper.getCB2SOInsertTempSQL(idList, tablename_core);
            ps2 = this.createPreparedStatement("WB_TEMP2", WB_TEMP2);
            this.executeUpdate(ps2, null);
            if (isWriteCore[0]) {
                this.batchWriteBackPostRequisitionBill(bizAction, idList, tablename_source);
            }
            if (isWriteCore[1]) {
                this.batchWriteBackSaleOrder(bizAction, idList, tablename_core);
            }
            if (isWriteCore[2]) {
                this.batchWriteBackStockTransfer(bizAction, idList, tablename_core);
            }
            if (isWriteCore[3]) {
                this.batchWriteBackPurOrder(bizAction, idList, tablename_core);
            }
            if (isWriteCore[4]) {
                this.batchWriteBackTransferOrder(bizAction, idList, tablename_core);
            }
            if (bizAction == BizActionEnum.AUDIT) {
                this.verify(ctx, idList, isWriteCore, tablename_core);
            }
            this.dropTempTable(ctx, tablename_source);
            this.dropTempTable(ctx, tablename_core);
        }
        catch (Throwable throwable) {
            this.dropTempTable(ctx, tablename_source);
            this.dropTempTable(ctx, tablename_core);
            throw throwable;
        }
    }

    private void dropTempTable(Context ctx, String temptable) {
        if (temptable != null) {
            try {
                ITableManagerFacade iTableManager = TableManagerFacadeFactory.getLocalInstance((Context)ctx);
                iTableManager.releaseTemporaryTableName(temptable);
                iTableManager.dropReleasedTable();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

