/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.common;

import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.base.license.client.checker.AbstractLicenseChecker;
import com.kingdee.eas.basedata.assistant.IPeriod;
import com.kingdee.eas.basedata.assistant.PeriodCollection;
import com.kingdee.eas.basedata.assistant.PeriodFactory;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.PeriodTypeInfo;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolUtils;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.SystemEnum;
import java.util.Date;

public class LicenseChecker
extends AbstractLicenseChecker {
    public boolean isTrialPeriod() throws Exception {
        CompanyOrgUnitInfo companyUnitInfo = SysContext.getSysContext().getCurrentFIUnit();
        if (companyUnitInfo != null) {
            PeriodInfo startPeriodInfo = SystemStatusCtrolUtils.getStartPeriod(null, (SystemEnum)SystemEnum.INVENTORYMANAGEMENT, (CompanyOrgUnitInfo)companyUnitInfo);
            PeriodInfo currentPeriodInfo = SystemStatusCtrolUtils.getCurrentPeriod(null, (SystemEnum)SystemEnum.INVENTORYMANAGEMENT, (CompanyOrgUnitInfo)companyUnitInfo);
            if (currentPeriodInfo != null && startPeriodInfo != null) {
                Date startPeriodStartDate = startPeriodInfo.getBeginDate();
                Date currentPeriodStartDate = currentPeriodInfo.getBeginDate();
                IPeriod iPeriod = PeriodFactory.getRemoteInstance();
                startPeriodInfo = iPeriod.getPeriodInfo((IObjectPK)new ObjectUuidPK(startPeriodInfo.getId()));
                PeriodTypeInfo periodType = startPeriodInfo.getPeriodType();
                EntityViewInfo entityViewInfo = new EntityViewInfo();
                entityViewInfo.getSelector().add(new SelectorItemInfo("id"));
                FilterInfo filterInfo = new FilterInfo();
                filterInfo.getFilterItems().add(new FilterItemInfo("beginDate", (Object)startPeriodStartDate, CompareType.GREATER));
                filterInfo.getFilterItems().add(new FilterItemInfo("beginDate", (Object)currentPeriodStartDate, CompareType.LESS_EQUALS));
                filterInfo.getFilterItems().add(new FilterItemInfo("periodType", (Object)periodType.getId().toString(), CompareType.EQUALS));
                entityViewInfo.setFilter(filterInfo);
                PeriodCollection periodColl = iPeriod.getPeriodCollection(entityViewInfo);
                if (periodColl.size() > 3) {
                    return false;
                }
            }
        }
        return true;
    }
}

