/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.common;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.scm.common.AbstractWriteBackHandler;
import com.kingdee.eas.scm.common.BizActionEnum;
import com.kingdee.eas.scm.common.SCMBillException;
import com.kingdee.eas.scm.common.util.KsqlUtil;
import com.kingdee.eas.scm.common.util.WriteBackSQLHelper;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.db.SQLUtils;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;

public class PR2PLOWriteBackHandler
extends AbstractWriteBackHandler {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doHandle(Context ctx, BizActionEnum bizAction, String[] billId, String[][] ids) throws EASBizException, BOSException, SQLException {
        boolean[] isWriteCore = new boolean[]{false, true};
        String idList = WriteBackSQLHelper.getKeyIdList(billId);
        String tableName = null;
        PreparedStatement ps = null;
        try {
            String CR_TEMP = WriteBackSQLHelper.getSR2PLOTempTableSQL("xxx");
            tableName = KsqlUtil.createTempTable(ctx, CR_TEMP);
            String WB_TEMP = WriteBackSQLHelper.getPR2PLOInsertTempSQL(idList, tableName);
            ps = this.createPreparedStatement("WB_TEMP", WB_TEMP);
            this.executeUpdate(ps, null);
            if (bizAction == BizActionEnum.AUDIT) {
                ps = this.createPreparedStatement("WB_PR_Audit", WriteBackSQLHelper.createPR2PLOWriteSQL(bizAction, idList, tableName));
            } else if (bizAction == BizActionEnum.UNAUDIT) {
                ps = this.createPreparedStatement("WB_PR_UnAduit", WriteBackSQLHelper.createPR2PLOWriteSQL(bizAction, idList, tableName));
            }
            this.executeUpdate(ps, null);
            if (bizAction == BizActionEnum.AUDIT) {
                this.verify(ctx, idList, isWriteCore, tableName);
            }
        }
        catch (Throwable throwable) {
            this.dropTempTable(ctx, tableName);
            SQLUtils.cleanup(ps);
            throw throwable;
        }
        this.dropTempTable(ctx, tableName);
        SQLUtils.cleanup((Statement)ps);
    }

    @Override
    protected boolean directlyInDB() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void verify(Context ctx, String idList, boolean[] isWriteCore, String tablename) throws SCMBillException, SQLException {
        String VERIFY = WriteBackSQLHelper.createPLOWriteBackVerifySQL(idList, isWriteCore, tablename, false);
        PreparedStatement ps = null;
        try {
            ps = this.createPreparedStatement("VERIFY", VERIFY);
            IRowSet rs = this.executeQuery(ps, null);
            WriteBackSQLHelper.verifyPLOWriteBack(ctx, rs);
        }
        catch (Throwable throwable) {
            SQLUtils.cleanup(ps);
            throw throwable;
        }
        SQLUtils.cleanup((Statement)ps);
    }

    private void dropTempTable(Context ctx, String temptable) throws BOSException {
        KsqlUtil.releaseTempTable(ctx, temptable);
    }
}

