/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.common;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.ITableManagerFacade;
import com.kingdee.eas.common.TableManagerFacadeFactory;
import com.kingdee.eas.framework.CoreBillBaseInfo;
import com.kingdee.eas.scm.common.AbstractWriteBackHandler;
import com.kingdee.eas.scm.common.BizActionEnum;
import com.kingdee.eas.scm.common.SCMBillException;
import com.kingdee.eas.scm.common.util.WriteBack2SaleOrderSQLHelper;
import com.kingdee.eas.scm.common.util.WriteBackSQLHelper;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.PreparedStatement;
import java.sql.SQLException;

public class TO2SOWriteBackHandler
extends AbstractWriteBackHandler {
    public void handle(Context ctx, BizActionEnum bizAction, CoreBillBaseInfo billInfo) throws EASBizException, BOSException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doHandle(Context ctx, BizActionEnum bizAction, String[] billId, String[][] ids) throws EASBizException, BOSException, SQLException {
        String idList = WriteBackSQLHelper.getKeyIdList(billId);
        String tableName = null;
        try {
            tableName = this.createTempTable(ctx, idList);
            PreparedStatement ps = this.createPreparedStatement(bizAction.toString(), WriteBack2SaleOrderSQLHelper.getTO2SO4CentralSaleWriteSQL(bizAction, idList, tableName));
            this.executeUpdate(ps, null);
        }
        finally {
            if (tableName != null) {
                try {
                    ITableManagerFacade iTableManager = TableManagerFacadeFactory.getLocalInstance((Context)ctx);
                    iTableManager.releaseTemporaryTableName(tableName);
                    iTableManager.dropReleasedTable();
                }
                catch (Exception exception) {}
            }
        }
    }

    @Override
    protected boolean directlyInDB() {
        return true;
    }

    private void verify(String idList, boolean[] writeCore) throws SCMBillException, SQLException {
        String verifySql = WriteBackSQLHelper.createTOWriteBackVerifySQL(idList, writeCore);
        IRowSet rs = this.executeQuery(this.createPreparedStatement("verifySql", verifySql), null);
        WriteBackSQLHelper.verifyTOWriteBack(rs);
    }

    private String createTempTable(Context ctx, String idList) throws SQLException, BOSException {
        ITableManagerFacade iTabManager = TableManagerFacadeFactory.getLocalInstance((Context)ctx);
        String tableName = iTabManager.getTableName(this.getClass().getName());
        iTabManager.createTempTable(WriteBack2SaleOrderSQLHelper.getTO2SOTempTableSQL(tableName));
        PreparedStatement ps = this.createPreparedStatement("WB_TEMP", WriteBack2SaleOrderSQLHelper.getTO2SOInsertTempSQL(idList, tableName));
        this.executeUpdate(ps, null);
        return tableName;
    }
}

