/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.common.action;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.swing.KDTextField;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.framework.CoreBillBaseInfo;
import com.kingdee.eas.framework.batchaction.ActionLevelEnum;
import com.kingdee.eas.framework.batchaction.BatchActionEnum;
import com.kingdee.eas.framework.batchaction.BatchSelectionEntries;
import com.kingdee.eas.framework.batchaction.BatchSelectionEntry;
import com.kingdee.eas.framework.client.IIDList;
import com.kingdee.eas.scm.common.action.AbstractTableSelectionHelper;
import com.kingdee.eas.scm.common.action.ISupportBatchAction;

public class EditTableSelectionHelper
extends AbstractTableSelectionHelper {
    private KDTextField txtNumber;
    private IIDList idList;

    public void setIdList(IIDList idList) {
        this.idList = idList;
    }

    public String getMoveToId(BatchActionEnum batchAction) {
        if (batchAction.equals((Object)BatchActionEnum.NEXT)) {
            return this.idList.getNextID();
        }
        if (batchAction.equals((Object)BatchActionEnum.PREVIOUS)) {
            return this.idList.getPreviousID();
        }
        if (batchAction.equals((Object)BatchActionEnum.LAST)) {
            return this.idList.getLastID();
        }
        if (batchAction.equals((Object)BatchActionEnum.FIRST)) {
            return this.idList.getFirstID();
        }
        return null;
    }

    public String getMoveFromId(BatchActionEnum batchAction) {
        return this.idList.getCurrentID();
    }

    @Override
    protected BatchSelectionEntries getSelectedAllIDs(Context mainOrgContext, ActionLevelEnum actionLevel, int[] selectRows) throws BOSException {
        return this.getSelectedMultiIDs(mainOrgContext, actionLevel, selectRows);
    }

    public void setTableProperty(ISupportBatchAction supportBatchAction, KDTable tblMain, String entryIdColName, KDTextField txtNumber, String entrySeqColName) {
        this.iSupportBatchAction = supportBatchAction;
        this.tblMain = tblMain;
        this.entryIdColName = entryIdColName;
        this.txtNumber = txtNumber;
        this.entrySeqColName = entrySeqColName;
    }

    @Override
    protected BatchSelectionEntry getSelectionEntry(IRow row, ActionLevelEnum actionLevel) throws BOSException {
        OrgUnitInfo mainOrg;
        BatchSelectionEntry entry = new BatchSelectionEntry();
        IObjectValue objValue = null;
        if (this.iSupportBatchAction instanceof IUIObject) {
            objValue = ((IUIObject)this.iSupportBatchAction).getDataObject();
            if (objValue != null) {
                BOSUuid pk = (BOSUuid)objValue.get(objValue.getPKField());
                if (pk != null) {
                    entry.setId(pk.toString());
                } else {
                    entry.setId("NEWID");
                }
            } else if (actionLevel.equals((Object)ActionLevelEnum.HEAD)) {
                throw new IllegalArgumentException("Bill ID can't be null");
            }
        }
        entry.setNumber(this.txtNumber.getText());
        if (actionLevel.equals((Object)ActionLevelEnum.ENTRY)) {
            if (this.getCellValue(row.getCell(this.entryIdColName)) == null) {
                return null;
            }
            String entryId = ((BOSUuid)this.getCellValue(row.getCell(this.entryIdColName))).toString();
            if (entryId == null) {
                return null;
            }
            entry.setEntryId(entryId);
            entry.setSeq(row.getRowIndex() + 1);
            entry.setRowNum(row.getRowIndex());
        }
        if (objValue != null && objValue instanceof CoreBillBaseInfo && (mainOrg = (OrgUnitInfo)objValue.get(((CoreBillBaseInfo)objValue).getBizOrgPropertyName())) != null) {
            entry.setOrgId(mainOrg.getId().toString());
        }
        return entry;
    }

    @Override
    protected BatchSelectionEntries getSelectedMultiIDs(Context mainOrgContext, ActionLevelEnum actionLevel, int[] selectRows) throws BOSException {
        BatchSelectionEntries results = new BatchSelectionEntries(actionLevel, selectRows.length);
        for (int i = 0; i < selectRows.length; ++i) {
            IRow row = this.tblMain.getRow(selectRows[i]);
            BatchSelectionEntry entry = this.getSelectionEntry(row, actionLevel);
            if (entry == null) continue;
            results.add(entry);
        }
        return results;
    }

    @Override
    public BatchSelectionEntries getSelectedIDs(Context mainOrgContext, ActionLevelEnum actionLevel) throws BOSException {
        if (actionLevel.equals((Object)ActionLevelEnum.ENTRY)) {
            return super.getSelectedIDs(mainOrgContext, actionLevel);
        }
        return this.getSelectedOneID(null, actionLevel);
    }

    @Override
    public boolean hasSelectedRows(ActionLevelEnum actionLevel) {
        if (actionLevel.equals((Object)ActionLevelEnum.ENTRY)) {
            return super.hasSelectedRows(actionLevel);
        }
        IObjectValue objValue = ((IUIObject)this.iSupportBatchAction).getDataObject();
        return objValue != null;
    }

    @Override
    public void refresh(BatchActionEnum bizAction, BatchSelectionEntries selectionEntries, int countSuccess) throws Exception {
        this.iSupportBatchAction.refresh(bizAction, selectionEntries, countSuccess);
    }

    @Override
    public int getSelectedEntrySize(Context mainOrgContext, ActionLevelEnum actionLevel) throws BOSException {
        if (this.tblMain == null) {
            return 0;
        }
        return this.tblMain.getRowCount();
    }
}

