/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.common.botputils;

import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.metadata.bot.BOTMappingInfo;
import com.kingdee.bos.metadata.bot.BOTRuleCollection;
import com.kingdee.bos.metadata.bot.BOTRuleSegmentCollection;
import com.kingdee.bos.metadata.bot.BOTRuleSegmentInfo;
import com.kingdee.bos.metadata.entity.CardinalityType;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.LinkPropertyInfo;
import com.kingdee.bos.metadata.entity.PropertyCollection;
import com.kingdee.bos.metadata.entity.PropertyInfo;
import com.kingdee.bos.metadata.entity.RelationshipInfo;
import com.kingdee.bos.metadata.entity.RelationshipType;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.CoreBillBaseCollection;
import com.kingdee.eas.framework.CoreBillBaseInfo;
import com.kingdee.util.StringUtils;
import java.util.ArrayList;
import java.util.List;

public class SCMBotpUtils {
    public static List getBillPropertiesCannotModify(BOTMappingInfo mapping) {
        ArrayList<String> propertiesList = new ArrayList<String>();
        BOTRuleCollection botRuleCols = mapping.getRules();
        int count = botRuleCols.size();
        for (int i = 0; i < count; ++i) {
            BOTRuleSegmentCollection botRuleSegCols = botRuleCols.get(i).getRuleSegments();
            int size = botRuleSegCols.size();
            for (int j = 0; j < size; ++j) {
                BOTRuleSegmentInfo botRuleSegmentInfo = botRuleSegCols.get(j);
                if (botRuleSegmentInfo.isCanModify() || propertiesList.contains(botRuleSegmentInfo.getDestPropertyName())) continue;
                propertiesList.add(botRuleSegmentInfo.getDestPropertyName());
            }
        }
        return propertiesList;
    }

    public static List getBillPropertiesCanModify(BOTMappingInfo mapping) {
        ArrayList<String> propertiesList = new ArrayList<String>();
        BOTRuleCollection botRuleCols = mapping.getRules();
        int count = botRuleCols.size();
        for (int i = 0; i < count; ++i) {
            BOTRuleSegmentCollection botRuleSegCols = botRuleCols.get(i).getRuleSegments();
            int size = botRuleSegCols.size();
            for (int j = 0; j < size; ++j) {
                BOTRuleSegmentInfo botRuleSegmentInfo = botRuleSegCols.get(j);
                if (!botRuleSegmentInfo.isCanModify() || propertiesList.contains(botRuleSegmentInfo.getDestPropertyName())) continue;
                propertiesList.add(botRuleSegmentInfo.getDestPropertyName());
            }
        }
        return propertiesList;
    }

    public static List<String> getSelectEntryIDs(CoreBillBaseCollection srcBills, String entryName) {
        ArrayList<String> entryids = new ArrayList<String>();
        if (StringUtils.isEmpty((String)entryName)) {
            return entryids;
        }
        for (int i = 0; i < srcBills.size(); ++i) {
            CoreBillBaseInfo bills = srcBills.get(i);
            IObjectCollection entries = (IObjectCollection)bills.get(entryName);
            if (entries == null) {
                return entryids;
            }
            for (CoreBaseInfo cInfo : entries) {
                String ss = cInfo.getId().toString();
                entryids.add(ss);
            }
        }
        return entryids;
    }

    public static String getBillMainEntryName(EntityObjectInfo entity) {
        PropertyCollection props = entity.getInheritedNoDuplicatedProperties();
        for (PropertyInfo propInfo : props) {
            RelationshipInfo relation;
            if (!(propInfo instanceof LinkPropertyInfo) || (relation = ((LinkPropertyInfo)propInfo).getRelationship()).getType() != RelationshipType.COMPOSITION && !Boolean.TRUE.toString().equalsIgnoreCase(propInfo.getExtendedProperty("isEntries"))) continue;
            EntityObjectInfo relateEntity = null;
            if (relation.getClientObject().getFullName().equals(entity.getFullName()) && (relation.getSupplierCardinality() == CardinalityType.ONE_TO_UNBOUNDED || relation.getSupplierCardinality() == CardinalityType.ZERO_TO_UNBOUNDED)) {
                relateEntity = relation.getSupplierObject();
            } else if (relation.getSupplierObject().getFullName().equals(entity.getFullName()) && (relation.getClientCardinality() == CardinalityType.ONE_TO_UNBOUNDED || relation.getClientCardinality() == CardinalityType.ZERO_TO_UNBOUNDED)) {
                relateEntity = relation.getClientObject();
            }
            if (relateEntity == null) continue;
            return propInfo.getName();
        }
        return "entries";
    }
}

