/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.common.botputils.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.metadata.IMetaDataLoader;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.bot.BOTMappingCollection;
import com.kingdee.bos.metadata.bot.BOTMappingFactory;
import com.kingdee.bos.metadata.bot.BOTMappingInfo;
import com.kingdee.bos.metadata.bot.DefineSysEnum;
import com.kingdee.bos.metadata.bot.IBOTMapping;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.ui.face.IUIFactory;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.base.botp.BOTPException;
import com.kingdee.eas.base.botp.client.BOTMappingSelectUI;
import com.kingdee.eas.base.btp.client.BOTClientTools;
import com.kingdee.eas.base.btp.client.BTPBillEditImpl;
import com.kingdee.eas.basedata.common.perf.CreateJobFacadeFactory;
import com.kingdee.eas.basedata.common.perf.ICreateJobFacade;
import com.kingdee.eas.basedata.common.perf.JobConfig;
import com.kingdee.eas.basedata.common.perf.JobParam;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.framework.CoreBillBaseCollection;
import com.kingdee.eas.framework.CoreBillBaseInfo;
import com.kingdee.eas.framework.client.CoreBillEditUI;
import com.kingdee.eas.scm.common.action.MonitorObject;
import com.kingdee.eas.scm.common.action.SCMJobMonitor;
import com.kingdee.eas.scm.common.action.SCMProgressDialog;
import com.kingdee.eas.scm.common.action.SCMProgressDialogFactory;
import com.kingdee.eas.scm.common.action.SCMThreadPool;
import com.kingdee.eas.scm.common.botputils.SCMBotpParameter;
import com.kingdee.eas.scm.common.botputils.SCMBotpUtils;
import com.kingdee.eas.scm.common.util.SCMUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;

public class SCMBTPBillEditImpl
extends BTPBillEditImpl {
    private static final String SCMBILL_BOTP_JOBNUMBER = "SCMBillBotpJob";
    private static final String SCMBILL_ACTION_JOBNUMBER = "SCMBillActionJob";
    private CoreBillEditUI billEditUI = null;
    private OrgUnitInfo mainOrgUnit = null;

    public SCMBTPBillEditImpl(CoreBillEditUI billEditUI, OrgUnitInfo mainOrgUnit) {
        super(billEditUI);
        this.billEditUI = billEditUI;
        this.mainOrgUnit = mainOrgUnit;
    }

    public void CreateTo(CoreBillBaseInfo bill, String destBillBosType) throws Exception {
        if (this.isCanSubmitJob(bill)) {
            this.createToInJob(bill, destBillBosType);
        } else {
            super.CreateTo(bill, destBillBosType);
        }
    }

    private void createToInJob(CoreBillBaseInfo bill, String destBillBosType) {
        CoreBillBaseCollection srcBillInfos = new CoreBillBaseCollection();
        srcBillInfos.add(bill);
        this.billEditUI.beforeTransform((IObjectCollection)srcBillInfos, destBillBosType);
        try {
            BOTMappingInfo botMappingInfo = this.getBotMappingInfo(srcBillInfos, destBillBosType);
            if (botMappingInfo == null) {
                return;
            }
            if (!this.invokeReBuildControl(botMappingInfo, srcBillInfos, destBillBosType)) {
                return;
            }
            SelectorItemCollection botSelectors = null;
            if (botMappingInfo.getIsTempSave() == 2) {
                botSelectors = BOTClientTools.getBillEditUISelector((String)destBillBosType);
            }
            SCMBotpParameter parameter = this.createSCMBotpParameter(bill, destBillBosType, botMappingInfo.getId().toString(), botSelectors);
            this.submitTransferJob(bill, destBillBosType, parameter);
        }
        catch (Exception ex) {
            MsgBox.showWarning((String)(EASResource.getString((String)"com.kingdee.eas.base.btp.btpResource.transFailed") + "  " + ex.getMessage()));
        }
    }

    private BOTMappingInfo getBotMappingInfo(CoreBillBaseCollection srcBillInfos, String destBillBosType) throws BOSException, BOTPException {
        BOTMappingInfo botMappingInfo = null;
        IBOTMapping iBOTMapping = BOTMappingFactory.getRemoteInstance();
        BOTMappingCollection botMappingCol = iBOTMapping.getMappingCollectionForSelect(srcBillInfos, destBillBosType, DefineSysEnum.BTP);
        if (botMappingCol.size() == 0) {
            throw new BOTPException(BOTPException.MAPPINGNUMZERO);
        }
        if (botMappingCol.size() > 1) {
            botMappingCol = this.billEditUI.getRulesForBotp(destBillBosType, "CreateTo", botMappingCol);
            HashMap<String, Object> uiContext = new HashMap<String, Object>();
            uiContext.put("Owner", this.billEditUI);
            uiContext.put("BOTMappings", botMappingCol);
            IUIFactory uiFactory = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory");
            String mappingSelectUI = this.getCreateToMappingRuleSelUI();
            IUIWindow window = uiFactory.create(mappingSelectUI, uiContext, null);
            window.show();
            if (((BOTMappingSelectUI)window.getUIObject()).isCanceled() || ((BOTMappingSelectUI)window.getUIObject()).getSelectBotMappingInfo() == null) {
                return botMappingInfo;
            }
            botMappingInfo = ((BOTMappingSelectUI)window.getUIObject()).getSelectBotMappingInfo();
        } else {
            botMappingInfo = botMappingCol.get(0);
        }
        return botMappingInfo;
    }

    protected boolean isCanSubmitJob(CoreBillBaseInfo bill) {
        IObjectCollection coll = (IObjectCollection)bill.get("entry");
        if (coll == null) {
            coll = (IObjectCollection)bill.get("entries");
        }
        if (coll == null) {
            return false;
        }
        return SCMUtil.isEntryCountOverThreshold(coll.size());
    }

    private void submitTransferJob(CoreBillBaseInfo bill, String destBillBosType, SCMBotpParameter parameter) {
        JobConfig jobConfig = this.createJobConfig(bill, destBillBosType);
        try {
            String jobInstExtId;
            ICreateJobFacade iCreateJobfacade = CreateJobFacadeFactory.getRemoteInstance();
            Map jobMap = iCreateJobfacade.executeJob(new JobParam((Object)parameter), jobConfig);
            if (null != jobMap && null != (jobInstExtId = (String)jobMap.get("jobInstExtId"))) {
                SCMJobMonitor monitor = this.buildSCMJobMonitor(jobConfig.getTitle());
                monitor.addMonitorObject(jobInstExtId, this.getMonitorObject(bill));
                monitor.setTotalCount(1);
                monitor.setFinishedSubmit(true);
                SCMThreadPool.addMonitor(monitor);
            }
        }
        catch (Exception e) {
            this.billEditUI.handUIException((Throwable)e);
        }
    }

    private SCMJobMonitor buildSCMJobMonitor(String title) {
        SCMProgressDialog dialog = SCMProgressDialogFactory.getProgressDialog(this.billEditUI, title, true, false);
        return new SCMJobMonitor(title, dialog, null);
    }

    private MonitorObject getMonitorObject(CoreBillBaseInfo bill) {
        MonitorObject object = new MonitorObject();
        object.setId(bill.getId().toString());
        object.setName(bill.getNumber());
        object.setNumber(bill.getNumber());
        return object;
    }

    private JobConfig createJobConfig(CoreBillBaseInfo bill, String destBillBosType) {
        JobConfig jobConfig = new JobConfig();
        String title = this.buildTitle(bill, destBillBosType);
        jobConfig.setTitle(title);
        jobConfig.setNumber(SCMBILL_BOTP_JOBNUMBER);
        jobConfig.setTaskType("SCMBillActionJob_" + bill.getId());
        jobConfig.setDescription(title);
        jobConfig.setNeedCheckTaskType(true);
        return jobConfig;
    }

    private String buildTitle(CoreBillBaseInfo bill, String destBillBosType) {
        StringBuilder title = new StringBuilder();
        IMetaDataLoader loader = MetaDataLoaderFactory.getRemoteMetaDataLoader();
        EntityObjectInfo entity = loader.getEntity(bill.getBOSType());
        title.append(entity.getAlias());
        title.append(":\u3010").append(bill.getNumber()).append("\u3011");
        entity = loader.getEntity(BOSObjectType.create((String)destBillBosType));
        title.append(" --> ").append(entity.getAlias());
        return title.toString();
    }

    private SCMBotpParameter createSCMBotpParameter(CoreBillBaseInfo bill, String destBillBosType, String botMappingId, SelectorItemCollection botSelectors) {
        SCMBotpParameter parameter = new SCMBotpParameter();
        parameter.setSrcBillIDs(new String[]{bill.getId().toString()});
        parameter.setSrcBillBosType(bill.getBOSType().toString());
        EntityObjectInfo entity = MetaDataLoaderFactory.getRemoteMetaDataLoader().getEntity(bill.getBOSType());
        String entryName = SCMBotpUtils.getBillMainEntryName(entity);
        parameter.setSrcEntryNames(new String[]{entryName});
        CoreBillBaseCollection srcBillInfos = new CoreBillBaseCollection();
        srcBillInfos.add(bill);
        parameter.setSrcEntryIDs(SCMBotpUtils.getSelectEntryIDs(srcBillInfos, entryName));
        parameter.setDestBillBosType(destBillBosType);
        parameter.setBotMappingID(botMappingId);
        parameter.setBotSelectors(botSelectors);
        if (this.mainOrgUnit != null) {
            parameter.setMainOrgName(this.mainOrgUnit.getName());
        }
        return parameter;
    }

    private boolean invokeReBuildControl(BOTMappingInfo botMappingInfo, CoreBillBaseCollection srcBillInfos, String destBillTypeBOSType) throws Exception {
        Class<BTPBillEditImpl> clazz = BTPBillEditImpl.class;
        Method method = clazz.getDeclaredMethod("reBuildControl", BOTMappingInfo.class, CoreBillBaseCollection.class, String.class);
        method.setAccessible(true);
        Object result = method.invoke((Object)this, botMappingInfo, srcBillInfos, destBillTypeBOSType);
        return (Boolean)result;
    }
}

