/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.common.calculate;

import com.kingdee.bos.BOSException;
import com.kingdee.eas.basedata.assistant.ConvertModeEnum;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.SysConstant;
import com.kingdee.eas.scm.common.calculate.IAlgorithm;
import com.kingdee.eas.scm.common.util.CalculateUtils;
import com.kingdee.eas.scm.common.util.SCMConstant;
import java.math.BigDecimal;

public abstract class AbstractAlgorithm
implements IAlgorithm {
    private int amountPrecision = 2;
    private int localAmountPrecision = 2;

    @Override
    public void revalue() throws BOSException, EASBizException {
        this.reCalFields();
    }

    @Override
    public void calByAmount(int i) {
        this.calPriceByAmount(i);
        this.calTaxPrice(i);
        this.calTax(i);
        this.calTaxAmount(i);
        this.calDiscountAmount(i);
        this.calActualTaxPrice(i);
        this.calActualPrice(i);
        this.calLocalAmount(i);
        this.calLocalTaxAmount(i);
        this.calLocalTax(i);
        this.calTotalFields();
    }

    @Override
    public void calByPrice(int i) {
        this.calTaxPricebyPrice(i);
        this.calDiscountAmount(i);
        this.calAmount(i);
        this.calActualPrice(i);
        this.calTax(i);
        this.calTaxAmount(i);
        this.calActualTaxPrice(i);
        this.calLocalAmount(i);
        this.calLocalTaxAmount(i);
        this.calLocalTax(i);
        this.calTotalFields();
    }

    @Override
    public void calByTaxAmount(int i) {
        this.calTax(i);
        this.calAmount(i);
        this.calTaxPrice(i);
        this.calPriceByTaxPrice(i);
        this.calActualPrice(i);
        this.calActualTaxPrice(i);
        this.calDiscountAmount(i);
        this.calLocalAmount(i);
        this.calLocalTaxAmount(i);
        this.calLocalTax(i);
        this.calTotalFields();
    }

    @Override
    public void calByTaxPrice(int i) {
        this.calPriceByTaxPrice(i);
        this.calTaxAmount(i);
        this.calTax(i);
        this.calAmount(i);
        this.calActualPrice(i);
        this.calActualTaxPrice(i);
        this.calDiscountAmount(i);
        this.calLocalAmount(i);
        this.calLocalTaxAmount(i);
        this.calLocalTax(i);
        this.calTotalFields();
    }

    public void calTotalFields() {
        this.calTotalAmount();
        this.calTotalLocalAmount();
        this.calTotalTax();
        this.calTotalTaxAmount();
        this.calTotallocalTaxAmount();
    }

    @Override
    public void calTotalTaxAmount() {
        BigDecimal totalTaxAmount = SysConstant.BIGZERO;
        for (int i = 0; i < this.getEntrySize(); ++i) {
            totalTaxAmount = totalTaxAmount.add(this.getTaxAmount(i));
        }
        this.setTotalTaxAmount(totalTaxAmount);
    }

    @Override
    public void calTotallocalTaxAmount() {
        BigDecimal totalLocalTaxAmount = SysConstant.BIGZERO;
        for (int i = 0; i < this.getEntrySize(); ++i) {
            totalLocalTaxAmount = totalLocalTaxAmount.add(this.getLocalTaxAmount(i));
        }
        this.setTotalLocalTaxAmount(totalLocalTaxAmount);
    }

    @Override
    public void calTotalAmount() {
        BigDecimal totalAmount = SysConstant.BIGZERO;
        for (int i = 0; i < this.getEntrySize(); ++i) {
            totalAmount = totalAmount.add(this.getAmount(i));
        }
        this.setTotalAmount(totalAmount);
    }

    @Override
    public void calTotalLocalAmount() {
        BigDecimal totalLocalAmount = SysConstant.BIGZERO;
        for (int i = 0; i < this.getEntrySize(); ++i) {
            totalLocalAmount = totalLocalAmount.add(this.getLocalAmount(i));
        }
        this.setTotalLocalAmount(totalLocalAmount);
    }

    @Override
    public void calTotalTax() {
        BigDecimal totalTax = SysConstant.BIGZERO;
        for (int i = 0; i < this.getEntrySize(); ++i) {
            totalTax = totalTax.add(this.getTax(i));
        }
        this.setTotalTax(totalTax);
    }

    public BigDecimal nullToZero(BigDecimal value) {
        if (value == null) {
            return SysConstant.BIGZERO;
        }
        return value;
    }

    @Override
    public void reCalFields() {
        for (int i = 0; i < this.getEntrySize(); ++i) {
            if (this.isInTax()) {
                if (SysConstant.BIGZERO.compareTo(this.getTaxPrice(i)) != 0) {
                    this.setTaxPrice(this.getTaxPrice(i).abs().setScale(this.getPricePrecision(i), 4), i);
                    this.calByTaxPrice(i);
                    continue;
                }
                if (SysConstant.BIGZERO.compareTo(this.getTaxAmount(i)) != 0) {
                    this.setTaxAmount(this.getTaxAmount(i).abs().setScale(this.getAmountPrecision(), 4), i);
                    this.calByTaxAmount(i);
                    continue;
                }
                this.setTaxPrice(SysConstant.BIGZERO.setScale(this.getPricePrecision(i)), i);
                this.calByTaxPrice(i);
                continue;
            }
            if (SysConstant.BIGZERO.compareTo(this.getPrice(i)) != 0) {
                this.setPrice(this.getPrice(i).abs().setScale(this.getPricePrecision(i), 4), i);
                this.calByPrice(i);
                continue;
            }
            if (SysConstant.BIGZERO.compareTo(this.getAmount(i)) != 0) {
                this.setAmount(this.getAmount(i).abs().setScale(this.getAmountPrecision(), 4), i);
                this.calByAmount(i);
                continue;
            }
            this.setPrice(SysConstant.BIGZERO.setScale(this.getPricePrecision(i)), i);
            this.calByPrice(i);
        }
    }

    @Override
    public void calPriceByAmount(int i) {
        BigDecimal amount = this.getAmount(i);
        BigDecimal qty = this.getQty(i);
        BigDecimal discountRate = this.getDiscountRate(i);
        int scale = this.getPricePrecision(i);
        BigDecimal price = CalculateUtils.calPrice(amount, qty, discountRate, scale);
        this.setPrice(price, i);
    }

    @Override
    public void calTaxPrice(int i) {
        if (this.isInTax()) {
            BigDecimal discountRate = this.getDiscountRate(i);
            BigDecimal qty = this.getQty(i);
            BigDecimal taxAmount = this.getTaxAmount(i);
            int scale = this.getPricePrecision(i);
            BigDecimal taxPrice = null;
            if (qty != null && qty.compareTo(SysConstant.BIGZERO) != 0) {
                if (discountRate == null) {
                    discountRate = SysConstant.BIGZERO;
                }
                discountRate = SCMConstant.BIGDECIMAL_ONE.subtract(discountRate.divide(SCMConstant.BIGDECIMAL_ONEHUNDRED, 10, 4));
                if (taxAmount != null && qty != null && SysConstant.BIGZERO.compareTo(qty) != 0 && SysConstant.BIGZERO.compareTo(discountRate) != 0) {
                    taxPrice = taxAmount.divide(qty, 10, 4);
                    taxPrice = taxPrice.divide(discountRate, scale, 4);
                }
                this.setTaxPrice(taxPrice, i);
            }
        } else {
            BigDecimal price = this.getPrice(i);
            BigDecimal taxRate = this.getTaxRate(i);
            int scale = this.getPricePrecision(i);
            BigDecimal taxPrice = CalculateUtils.calTaxPrice(price, taxRate, scale);
            this.setTaxPrice(taxPrice, i);
        }
    }

    @Override
    public void calTax(int i) {
        int scale = this.getAmountPrecision();
        if (this.isInTax()) {
            BigDecimal taxAmount = this.getTaxAmount(i);
            BigDecimal taxRate = this.getTaxRate(i);
            BigDecimal tax = SysConstant.BIGZERO;
            if (taxAmount != null && taxRate != null) {
                taxRate = taxRate.divide(SCMConstant.BIGDECIMAL_ONEHUNDRED, 10, 4);
                tax = taxAmount.divide(taxRate.add(SCMConstant.BIGDECIMAL_ONE), 10, 4).multiply(taxRate);
                if (!this.isPriceInTax()) {
                    tax = taxAmount.multiply(taxRate);
                }
                tax = tax.setScale(scale, 4);
            }
            this.setTax(tax, i);
        } else {
            BigDecimal taxRate;
            BigDecimal tax;
            BigDecimal amount = this.getAmount(i);
            if (amount == null) {
                amount = SysConstant.BIGZERO;
            }
            if ((tax = CalculateUtils.calTax(amount, taxRate = this.getTaxRate(i), scale)) != null) {
                this.setTax(tax, i);
            } else {
                this.setTax(SysConstant.BIGZERO, i);
            }
        }
    }

    @Override
    public void calTaxAmount(int i) {
        int scale = this.getAmountPrecision();
        if (this.isInTax()) {
            BigDecimal taxPrice = this.getTaxPrice(i);
            BigDecimal qty = this.getQty(i);
            BigDecimal discountAmount = this.getDiscountAmount(i);
            BigDecimal taxAmount = taxPrice.multiply(qty).subtract(discountAmount);
            taxAmount = taxAmount.setScale(scale, 4);
            this.setTaxAmount(taxAmount, i);
        } else {
            BigDecimal amount = this.getAmount(i);
            BigDecimal tax = this.getTax(i);
            BigDecimal taxAmount = amount.add(tax);
            taxAmount = taxAmount.setScale(scale, 4);
            this.setTaxAmount(taxAmount, i);
        }
    }

    @Override
    public void calDiscountAmount(int i) {
        int scale = this.getAmountPrecision();
        BigDecimal taxPrice = this.getTaxPrice(i);
        BigDecimal qty = this.getQty(i);
        BigDecimal discountRate = this.getDiscountRate(i);
        BigDecimal discountAmount = taxPrice.multiply(qty).multiply(discountRate.divide(SCMConstant.BIGDECIMAL_ONEHUNDRED, 10, 4)).setScale(scale, 4);
        this.setDiscountAmount(discountAmount, i);
    }

    @Override
    public void calActualTaxPrice(int i) {
        BigDecimal discountRate = this.getDiscountRate(i);
        int scale = this.getPricePrecision(i);
        if (SysConstant.BIGZERO.compareTo(discountRate) == 0) {
            BigDecimal taxPrice = this.getTaxPrice(i);
            this.setActualTaxPrice(taxPrice, i);
        } else {
            BigDecimal taxAmount = this.getTaxAmount(i);
            BigDecimal qty = this.getQty(i);
            BigDecimal actualTaxPrice = SysConstant.BIGZERO;
            if (taxAmount != null && qty != null && SysConstant.BIGZERO.compareTo(qty) != 0) {
                actualTaxPrice = taxAmount.divide(qty, scale, 4);
                this.setActualTaxPrice(actualTaxPrice, i);
            }
        }
    }

    @Override
    public void calActualPrice(int i) {
        int scale = this.getPricePrecision(i);
        BigDecimal amount = this.getAmount(i);
        BigDecimal qty = this.getQty(i);
        BigDecimal discountRate = this.getDiscountRate(i);
        if (discountRate == null || SysConstant.BIGZERO.compareTo(discountRate) == 0) {
            BigDecimal price = this.getPrice(i);
            this.setActualPrice(price, i);
        } else if (amount != null && qty != null && SysConstant.BIGZERO.compareTo(qty) != 0) {
            BigDecimal actualPrice = amount.divide(qty, scale, 4);
            this.setActualPrice(actualPrice, i);
        }
    }

    @Override
    public void calLocalAmount(int i) {
        int scale = this.getLocalAmountPrecision();
        BigDecimal amount = this.getAmount(i);
        BigDecimal exchangerate = this.getExchangeRate();
        if (SysConstant.BIGZERO.compareTo(exchangerate) != 0) {
            if (this.getConvertMode() != null && this.getConvertMode() == ConvertModeEnum.DIRECTEXCHANGERATE) {
                this.setLocalAmount(amount.multiply(exchangerate).setScale(scale, 4), i);
            } else if (SysConstant.BIGZERO.compareTo(exchangerate) != 0) {
                this.setLocalAmount(amount.divide(exchangerate, scale, 4), i);
            }
        } else {
            this.setLocalAmount(amount, i);
        }
    }

    @Override
    public void calLocalTax(int i) {
        int scale = this.getLocalAmountPrecision();
        BigDecimal tax = this.getTax(i);
        BigDecimal exchangerate = this.getExchangeRate();
        if (SysConstant.BIGZERO.compareTo(exchangerate) != 0) {
            if (this.getConvertMode() != null && this.getConvertMode() == ConvertModeEnum.DIRECTEXCHANGERATE) {
                this.setLocalTax(tax.multiply(exchangerate).setScale(scale, 4), i);
            } else if (SysConstant.BIGZERO.compareTo(exchangerate) != 0) {
                this.setLocalTax(tax.divide(exchangerate, scale, 4), i);
            }
        } else {
            this.setLocalTax(tax, i);
        }
    }

    @Override
    public void calLocalTaxAmount(int i) {
        int scale = this.getLocalAmountPrecision();
        BigDecimal taxAmount = this.getTaxAmount(i);
        BigDecimal exchangerate = this.getExchangeRate();
        if (SysConstant.BIGZERO.compareTo(this.getExchangeRate()) != 0) {
            if (this.getConvertMode() != null && this.getConvertMode() == ConvertModeEnum.DIRECTEXCHANGERATE) {
                this.setLocalTaxAmount(taxAmount.multiply(exchangerate).setScale(scale, 4), i);
            } else if (SysConstant.BIGZERO.compareTo(exchangerate) != 0) {
                this.setLocalTaxAmount(taxAmount.divide(exchangerate, scale, 4), i);
            }
        } else {
            this.setLocalTaxAmount(taxAmount, i);
        }
    }

    @Override
    public void calTaxPricebyPrice(int i) {
        BigDecimal price = this.getPrice(i);
        BigDecimal taxRate = this.getTaxRate(i);
        int scale = this.getPricePrecision(i);
        BigDecimal taxPrice = CalculateUtils.calTaxPrice(price, taxRate, scale);
        if (!this.isPriceInTax()) {
            taxPrice = CalculateUtils.calTaxPriceByPurchaseCost(price, taxRate, scale);
        }
        this.setTaxPrice(taxPrice, i);
    }

    @Override
    public void calAmount(int i) {
        int scale = this.getAmountPrecision();
        if (this.isInTax()) {
            BigDecimal taxAmount = this.getTaxAmount(i);
            BigDecimal tax = this.getTax(i);
            this.setAmount(SysConstant.BIGZERO, i);
            if (taxAmount != null && tax != null) {
                BigDecimal actualTaxPrice = taxAmount.subtract(tax);
                actualTaxPrice = actualTaxPrice.setScale(scale, 4);
                this.setAmount(actualTaxPrice, i);
            }
        } else {
            BigDecimal price = this.getPrice(i);
            BigDecimal discountRate = this.getDiscountRate(i);
            BigDecimal qty = this.getQty(i);
            BigDecimal amount = qty.multiply(price).multiply(SCMConstant.BIGDECIMAL_ONE.subtract(discountRate.divide(SCMConstant.BIGDECIMAL_ONEHUNDRED, 10, 4)));
            amount = amount.setScale(scale, 4);
            this.setAmount(amount, i);
        }
    }

    @Override
    public void calPriceByTaxPrice(int i) {
        BigDecimal taxPrice = this.getTaxPrice(i);
        BigDecimal taxRate = this.getTaxRate(i);
        int scale = this.getPricePrecision(i);
        BigDecimal price = SysConstant.BIGZERO;
        price = this.isPriceInTax() ? CalculateUtils.calPrice(taxPrice, taxRate, scale) : CalculateUtils.calPriceIsPriceInTax(taxRate, taxPrice, scale);
        this.setPrice(price, i);
    }

    @Override
    public BigDecimal getRealTaxRate(int i) {
        return this.getTaxRate(i).divide(SCMConstant.BIGDECIMAL_ONEHUNDRED, 10, 4);
    }

    @Override
    public int getLocalAmountPrecision() {
        return this.localAmountPrecision;
    }

    @Override
    public int getAmountPrecision() {
        return this.amountPrecision;
    }

    protected void setAmountPrecision(int precision) {
        this.amountPrecision = precision;
    }

    protected void setLocalAmountPrecision(int precision) {
        this.localAmountPrecision = precision;
    }

    protected abstract void initPrecision() throws BOSException, EASBizException;
}

